/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.config;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.JLabeledCheckBox;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.GlobalIgnoreListArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.javatools.util.Pair;

public class GlobalIgnoreListPanel
extends DefaultTraversablePanel {
    private ExcludeNiceTable _ignoreListTable = new ExcludeNiceTable();
    private ExcludeListTableModel _tableModel;
    private JTextField _fldFilter = new JTextField();
    private JButton _btnAdd = new JButton();
    private JButton _btnRemove = new JButton();
    private JButton _btnRestore = new JButton();

    public GlobalIgnoreListPanel() {
        this.jbInit();
    }

    public void onEntry(TraversableContext tc) {
        GlobalIgnoreList ignoreList = this.getIgnoreList(tc);
        this._load(ignoreList);
    }

    private GlobalIgnoreList getIgnoreList(TraversableContext tc) {
        IdeSettings ideSettings;
        GlobalIgnoreList ignoreList = (GlobalIgnoreList)((Object)tc.find("global-ignore-list"));
        if (ignoreList == null && (ideSettings = (IdeSettings)tc.find("ide-options")) != null) {
            ignoreList = (GlobalIgnoreList)((Object)ideSettings.getData("global-ignore-list"));
        }
        return ignoreList;
    }

    public void onExit(TraversableContext tc) {
        GlobalIgnoreList ignoreList = this.getIgnoreList(tc);
        this._commit(ignoreList);
    }

    private void _commit(GlobalIgnoreList ignoreList) {
        Vector data = this._tableModel.getDataVector();
        ArrayList<Pair> pairList = new ArrayList<Pair>(data.size());
        for (int i = 0; i < data.size(); ++i) {
            Vector v = (Vector)data.get(i);
            pairList.add((Pair)v.get(0));
        }
        ignoreList.setList(pairList);
    }

    private void _load(GlobalIgnoreList ignoreList) {
        List data = ignoreList.getList();
        this._setExcludeList(data);
    }

    private void jbInit() {
        super.setHelpID("f1_idetaskglobalignore_html");
        JLabel lblFilter = new JLabel();
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this._ignoreListTable));
        this._fldFilter.getDocument().addDocumentListener(new AddButtonEnabler(this._btnAdd, this._fldFilter));
        ResourceUtils.resButton((AbstractButton)this._btnAdd, (String)GlobalIgnoreListArb.getString(0));
        ResourceUtils.resButton((AbstractButton)this._btnRemove, (String)GlobalIgnoreListArb.getString(1));
        ResourceUtils.resButton((AbstractButton)this._btnRestore, (String)GlobalIgnoreListArb.getString(2));
        ResourceUtils.resLabel((JLabel)lblFilter, (Component)this._fldFilter, (String)GlobalIgnoreListArb.getString(3));
        this._btnRemove.setEnabled(false);
        this._btnAdd.setEnabled(false);
        this._tableModel = new ExcludeListTableModel();
        this._ignoreListTable.setModel((TableModel)((Object)this._tableModel));
        this._ignoreListTable.setOpaque(false);
        this._ignoreListTable.setSortColumnBackgroundColor(this._ignoreListTable.getBackground());
        this._ignoreListTable.setSorted(true);
        this._ignoreListTable.setRolloverHighlightingEnabled(false);
        this._ignoreListTable.setDefaultRenderer(Object.class, (TableCellRenderer)new GenericTableCellRenderer((TableCellRenderer)new FilterTableCellRenderer()));
        this.addListeners();
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(437, 394));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.add(lblFilter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add(this._fldFilter, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add(this._btnAdd, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add(scrollPane, new GridBagConstraints(0, 2, 1, 0, 0.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add(buttonPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this._btnRemove, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 2, new Insets(2, 2, 2, 2), 0, 0));
        buttonPanel.add((Component)this._btnRestore, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 2, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void _setExcludeList(List<Pair> data) {
        this._tableModel.setData(data);
        this._ignoreListTable.setSortColumn(0, true);
    }

    private void addListeners() {
        this._btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filter = GlobalIgnoreListPanel.this._fldFilter.getText();
                if (filter.length() > 0 && !GlobalIgnoreListPanel.this.isFilterPresent(filter)) {
                    GlobalIgnoreListPanel.this._tableModel.addRow(filter);
                    int addedRow = GlobalIgnoreListPanel.this._tableModel.getRowCount() - 1;
                    GlobalIgnoreListPanel.this._ignoreListTable.reSort();
                    GlobalIgnoreListPanel.this._fldFilter.setText("");
                    GlobalIgnoreListPanel.this._ignoreListTable.setSelectedRowInModel(addedRow);
                    GlobalIgnoreListPanel.this._ignoreListTable.scrollToSelection();
                }
            }
        });
        this._btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = GlobalIgnoreListPanel.this._ignoreListTable.getSelectedRows();
                int firstSelectedViewRow = selected[0];
                GlobalIgnoreListPanel.this._ignoreListTable._editorCheckBox.stopCellEditing();
                GlobalIgnoreListPanel.this._ignoreListTable.clearSelection();
                for (int i = 0; i < selected.length; ++i) {
                    selected[i] = GlobalIgnoreListPanel.this._ignoreListTable.convertRowIndexToModel(selected[i]);
                }
                Arrays.sort(selected);
                int newSelectedViewRow = firstSelectedViewRow == 0 ? 0 : firstSelectedViewRow - 1;
                newSelectedViewRow = Math.max(newSelectedViewRow, 0);
                for (int row = selected.length - 1; row > -1; --row) {
                    Pair rowPair = (Pair)GlobalIgnoreListPanel.this._tableModel.getValueAt(selected[row], 0);
                    String rowString = (String)rowPair.getFirst();
                    if (GlobalIgnoreList.isExtensionRegisteredFilter(rowString)) {
                        MessageDialog.information((Component)((Object)GlobalIgnoreListPanel.this._ignoreListTable), (Object)GlobalIgnoreListArb.format(6, rowString), (String)GlobalIgnoreListArb.getString(5), null);
                        continue;
                    }
                    GlobalIgnoreListPanel.this._tableModel.remove(selected[row]);
                }
                if (GlobalIgnoreListPanel.this._tableModel.getRowCount() > 0) {
                    GlobalIgnoreListPanel.this._ignoreListTable.setSelectedRowInModel(GlobalIgnoreListPanel.this._ignoreListTable.convertRowIndexToModel(newSelectedViewRow));
                    GlobalIgnoreListPanel.this._ignoreListTable.scrollToSelection();
                }
                GlobalIgnoreListPanel.this._ignoreListTable.reSort();
                GlobalIgnoreListPanel.this._btnRemove.setEnabled(false);
            }
        });
        this._btnRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalIgnoreListPanel.this._setExcludeList(GlobalIgnoreList.createDefaults());
                GlobalIgnoreListPanel.this._ignoreListTable.reSort();
                GlobalIgnoreListPanel.this._btnRemove.setEnabled(false);
            }
        });
        this._ignoreListTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GlobalIgnoreListPanel.this._btnRemove.setEnabled(true);
            }
        });
    }

    private boolean isFilterPresent(String filter) {
        for (int r = 0; r < this._tableModel.getRowCount(); ++r) {
            Pair item = (Pair)this._tableModel.getValueAt(r, 0);
            if (!item.getFirst().equals(filter)) continue;
            return true;
        }
        return false;
    }

    private static class ExcludeNiceTable
    extends GenericTable
    implements KeyListener,
    MouseListener {
        private ExcludeCellEditor _editorCheckBox = new ExcludeCellEditor();

        public ExcludeNiceTable() {
            super.addKeyListener((KeyListener)this);
            super.addMouseListener((MouseListener)this);
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == ' ') {
                this._editorCheckBox.toggleCheckbox();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int checkWidth;
            TableCellRenderer renderer;
            Component comp;
            Point point = e.getPoint();
            int row = this.rowAtPoint(point);
            if (row != -1 && (comp = (renderer = this.getCellRenderer(row, 0)).getTableCellRendererComponent((JTable)((Object)this), this.getModel().getValueAt(this.convertRowIndexToModel(row), 0), this.isCellSelected(row, 0), false, row, 0)) instanceof JLabeledCheckBox && point.x < (checkWidth = ((JLabeledCheckBox)comp).checkBox.getWidth())) {
                this.setEditingRow(row);
                this.setEditingColumn(0);
                this._editorCheckBox.toggleCheckbox();
                Rectangle rect = this.getCellRect(row, 0, true);
                this.repaint(rect);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        public void toggleCheckbox() {
            int modelRow;
            TableModel model = this.getModel();
            Pair data = (Pair)model.getValueAt(modelRow = this.getEditingRow(), 0);
            Boolean checkboxValue = (Boolean)data.getSecond();
            checkboxValue = checkboxValue.equals(Boolean.TRUE) ? Boolean.FALSE : Boolean.TRUE;
            data.setSecond((Object)checkboxValue);
            model.setValueAt(data, this.getSelectedRow(), 0);
            FilterTableCellRenderer renderer = (FilterTableCellRenderer)this.getCellRenderer(this.getEditingRow(), 0);
            Component comp = renderer.getTableCellRendererComponent((JTable)((Object)this), data, this.isCellSelected(this.getEditingRow(), 0), false, this.getEditingRow(), 0);
            if (comp instanceof JLabeledCheckBox) {
                Rectangle rect = this.getCellRect(this.getEditingRow(), 0, true);
                this.repaint(rect);
            }
        }

        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 0) {
                return this._editorCheckBox;
            }
            return super.getCellEditor(row, column);
        }

        private class ExcludeCellEditor
        extends DefaultCellEditor
        implements TableCellEditor {
            private JLabeledCheckBox _component;

            public ExcludeCellEditor() {
                super(new JTextField());
                this._component = new JLabeledCheckBox();
            }

            @Override
            public Object getCellEditorValue() {
                return new Pair((Object)this._component.getText(), (Object)this._component.checkBox.isSelected());
            }

            @Override
            public Component getComponent() {
                return this._component;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                if (value instanceof Pair) {
                    Pair item = (Pair)value;
                    this._component.checkBox.setSelected((Boolean)item.getSecond());
                    this._component.label.setText((String)item.getFirst());
                    this._component.label.setSelected(true);
                }
                return this._component;
            }

            public void toggleCheckbox() {
                int modelRow;
                TableModel model = ExcludeNiceTable.this.getModel();
                Pair data = (Pair)model.getValueAt(modelRow = ExcludeNiceTable.this.convertRowIndexToModel(ExcludeNiceTable.this.getEditingRow()), 0);
                Boolean checkboxValue = (Boolean)data.getSecond();
                checkboxValue = checkboxValue.equals(Boolean.TRUE) ? Boolean.FALSE : Boolean.TRUE;
                data.setSecond((Object)checkboxValue);
                model.setValueAt(data, modelRow, 0);
                this._component.checkBox.setSelected(checkboxValue);
            }
        }
    }

    private static class ExcludeListTableModel
    extends GenericBaseTableModel {
        public void setData(List<Pair> data) {
            this.getDataVector().clear();
            ArrayList vectorList = new ArrayList(data.size());
            for (Pair p : data) {
                Vector<Pair> v = new Vector<Pair>(1);
                v.add(p);
                vectorList.add(v);
            }
            this.getDataVector().addAll(vectorList);
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int column) {
            return GlobalIgnoreListArb.getString(4);
        }

        public void addRow(Object aValue) {
            Vector<Pair> rowVector = new Vector<Pair>(1);
            rowVector.add(new Pair(aValue, (Object)true));
            this.insertRow(this.getRowCount(), rowVector);
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public void remove(int row) {
            this.removeRow(row);
        }

        public int getColumnAlignment(int column) {
            return 2;
        }

        public Comparator getColumnSortComparator(int column) {
            return new IgnoreListComparator();
        }
    }

    private static final class AddButtonEnabler
    implements DocumentListener {
        private JButton _addButton;
        private JTextField _addField;

        public AddButtonEnabler(JButton addButton, JTextField addField) {
            this._addButton = addButton;
            this._addField = addField;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleButton();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleButton();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleButton();
        }

        private void handleButton() {
            if (this._addField.getText() == null || this._addField.getText().length() == 0) {
                this._addButton.setEnabled(false);
            } else {
                this._addButton.setEnabled(true);
            }
        }
    }

    private static class FilterTableCellRenderer
    extends DefaultTableCellRenderer {
        private JLabeledCheckBox _check = new JLabeledCheckBox();

        private FilterTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column > 0) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            if (value instanceof Pair) {
                Pair info = (Pair)value;
                this._check.label.setEnabled(true);
                this._check.checkBox.setEnabled(true);
                this._check.checkBox.setSelected((Boolean)info.getSecond());
                this._check.label.setSelected(isSelected);
                this._check.label.setText((String)info.getFirst());
                this._check.label.setHasFocus(hasFocus);
                this._check.checkBox.setOpaque(false);
                this._check.label.setOpaque(false);
            }
            return this._check;
        }
    }

    private static class IgnoreListComparator
    implements Comparator {
        private IgnoreListComparator() {
        }

        public int compare(Object o1, Object o2) {
            String str1 = (String)((Pair)o1).getFirst();
            String str2 = (String)((Pair)o2).getFirst();
            return str1.compareTo(str2);
        }
    }
}

