/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.adapters;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.extension.ElementName;
import oracle.ide.adapters.AbstractCachingAdapterFactory;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.extension.HashStructureHookAggregator;
import oracle.ide.feedback.FeedbackManager;
import oracle.ideimpl.adapters.AdapterFactoryHookListener;
import oracle.javatools.util.ClassHierarchy;
import oracle.javatools.util.Pair;

public class AdapterManagerImpl
implements AdapterManager {
    private static final String HOOK_ID = "adapter-factory-hook";
    private static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "adapter-factory-hook");
    private static final Map<Class<? extends AdapterFactory>, String> ADAPTER_METHOD_NAMES_BY_TYPE = new HashMap<Class<? extends AdapterFactory>, String>();
    private Map<Class<?>, Map<Class<?>, AdapterFactory>> factoriesByTargetTypeAndAdaptableType = Collections.synchronizedMap(new HashMap());
    private final AdapterFactoryHookListener hookListener = new AdapterFactoryHookListener();
    private final HashStructureHookAggregator aggregator = new HashStructureHookAggregator(HOOK_NAME, this.hookListener);

    @Override
    public <T> T adapt(Object adaptable, Class<T> targetType) {
        if (null == adaptable) {
            throw new IllegalArgumentException("Adaptable object must not be null");
        }
        if (null == targetType) {
            throw new IllegalArgumentException("Target class must not be null");
        }
        if (targetType.isInstance(adaptable)) {
            return targetType.cast(adaptable);
        }
        Pair<Integer, AdapterFactory> registeredFactoryAndRank = this.getAdapterFactory(adaptable, targetType);
        Pair<Integer, AdapterFactory> unregisteredFactoryAndRank = this.hookListener.getUnresolvedAdapterFactory(adaptable, targetType);
        AdapterFactory factory = null;
        if ((Integer)registeredFactoryAndRank.first <= (Integer)unregisteredFactoryAndRank.first) {
            factory = (AdapterFactory)registeredFactoryAndRank.second;
        } else {
            factory = (AdapterFactory)unregisteredFactoryAndRank.second;
            if (null != factory) {
                this.registerFactory(factory);
            }
        }
        if (null != factory) {
            try {
                return targetType.cast(factory.adapt(adaptable));
            }
            catch (Throwable t) {
                FeedbackManager.reportException(t);
            }
        }
        return null;
    }

    @Override
    public void registerFactory(AdapterFactory factory) {
        if (null == factory) {
            throw new IllegalArgumentException("Adapter factory must not be null");
        }
        Class<?> targetType = AdapterManagerImpl.getTargetType(factory);
        if (null == targetType) {
            throw new IllegalArgumentException("Unable to determine adapter factory target type");
        }
        Class<?> adaptableType = AdapterManagerImpl.getAdaptableType(factory);
        if (null == adaptableType) {
            throw new IllegalArgumentException("Unable to determine adapter factory adaptable type");
        }
        this.registerFactory(targetType, adaptableType, factory);
    }

    private void registerFactory(Class<?> targetType, Class<?> adaptableType, AdapterFactory factory) {
        Map factoriesByAdaptableType = this.factoriesByTargetTypeAndAdaptableType.get(targetType);
        if (null == factoriesByAdaptableType) {
            factoriesByAdaptableType = Collections.synchronizedMap(new HashMap());
            this.factoriesByTargetTypeAndAdaptableType.put(targetType, factoriesByAdaptableType);
        }
        factoriesByAdaptableType.put(adaptableType, factory);
    }

    @Override
    public void unregisterFactory(AdapterFactory factory) {
        AdapterFactory registered;
        if (null == factory) {
            throw new IllegalArgumentException("Adapter factory must not be null");
        }
        Class<?> targetType = AdapterManagerImpl.getTargetType(factory);
        if (null == targetType) {
            throw new IllegalArgumentException("Unable to determine adapter factory target type");
        }
        Class<?> adaptableType = AdapterManagerImpl.getAdaptableType(factory);
        if (null == adaptableType) {
            throw new IllegalArgumentException("Unable to determine adapter factory adaptable type");
        }
        Map<Class<?>, AdapterFactory> factoriesByAdaptableType = this.factoriesByTargetTypeAndAdaptableType.get(targetType);
        if (null != factoriesByAdaptableType && factory.equals(registered = factoriesByAdaptableType.get(adaptableType))) {
            factoriesByAdaptableType.remove(adaptableType);
        }
    }

    private static Class<?> getTargetType(AdapterFactory factory) {
        Method method = AdapterManagerImpl.getAdapterMethod(factory);
        return null != method ? method.getReturnType() : null;
    }

    private static Method getAdapterMethod(AdapterFactory factory) {
        Class<?> factoryClass = factory.getClass();
        String adaptMethodName = AdapterManagerImpl.getAdaptMethodName(factoryClass);
        Method method = AdapterManagerImpl.getAdapterMethod(adaptMethodName, factoryClass.getDeclaredMethods());
        if (null == method) {
            method = AdapterManagerImpl.getAdapterMethod(adaptMethodName, factoryClass.getMethods());
        }
        return method;
    }

    private static Method getAdapterMethod(String adaptMethodName, Method[] methods) {
        Method best = null;
        int rank = 0;
        for (Method method : methods) {
            List classOrder;
            if (!adaptMethodName.equals(method.getName()) || 1 != method.getParameterTypes().length || (classOrder = ClassHierarchy.getClassOrder(method.getReturnType())).size() <= rank) continue;
            rank = classOrder.size();
            best = method;
        }
        return best;
    }

    private static Class<?> getAdaptableType(AdapterFactory factory) {
        Method method = AdapterManagerImpl.getAdapterMethod(factory);
        return null != method ? method.getParameterTypes()[0] : null;
    }

    private static String getAdaptMethodName(Class<? extends AdapterFactory> c) {
        List classes = ClassHierarchy.getClassOrder(c);
        for (Class t : classes) {
            String methodName = ADAPTER_METHOD_NAMES_BY_TYPE.get(t);
            if (null == methodName) continue;
            return methodName;
        }
        return ADAPTER_METHOD_NAMES_BY_TYPE.get(AdapterFactory.class);
    }

    private Pair<Integer, AdapterFactory> getAdapterFactory(Object adaptable, Class<?> targetType) {
        this.aggregator.initialize();
        Map<Class<?>, AdapterFactory> factoriesByAdaptableType = this.factoriesByTargetTypeAndAdaptableType.get(targetType);
        if (null == factoriesByAdaptableType) {
            return new Pair((Object)Integer.MAX_VALUE, null);
        }
        Class<?> adaptableType = adaptable.getClass();
        AdapterFactory factory = factoriesByAdaptableType.get(adaptableType);
        if (null != factory) {
            return new Pair((Object)Integer.MIN_VALUE, (Object)factory);
        }
        int current = Integer.MAX_VALUE;
        List classOrder = ClassHierarchy.getClassOrder(adaptableType);
        for (Map.Entry<Class<?>, AdapterFactory> entry : factoriesByAdaptableType.entrySet()) {
            int rank;
            Class<?> _class = entry.getKey();
            if (!_class.isInstance(adaptable) || (rank = classOrder.indexOf(_class)) >= current) continue;
            current = rank;
            factory = entry.getValue();
        }
        return new Pair((Object)current, (Object)factory);
    }

    static {
        ADAPTER_METHOD_NAMES_BY_TYPE.put(AdapterFactory.class, "adapt");
        ADAPTER_METHOD_NAMES_BY_TYPE.put(AbstractCachingAdapterFactory.class, "adaptImpl");
    }
}

