/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.refactoring.ActionHandlerUtil;
import oracle.ide.refactoring.SimpleDeleteActionHandler;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ide.util.Assert;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.dialogs.MessageDialog;

public abstract class DeleteElementActionHandler<T extends Element>
extends SimpleDeleteActionHandler<T> {
    private CopyOnWriteArrayList<URL> m_nondeleted = new CopyOnWriteArrayList();

    public DeleteElementActionHandler(Context context) {
        super(context);
    }

    protected boolean delete(T element) {
        if (element instanceof Node) {
            return DeleteElementActionHandler.deleteNode((Node)element);
        }
        return false;
    }

    @Override
    protected final boolean doDelete() {
        boolean res = true;
        UpdateMessage update = this.createUpdateMessage();
        final CloseNodeCommand clsCmd = new CloseNodeCommand(update);
        clsCmd.setContext(this.getContext());
        clsCmd.setNeedConfirm(false);
        final List<T> nodes = this.getNodesToDelete();
        if (!this.checkReadOnlyFiles(nodes)) {
            return false;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int status = clsCmd.close(nodes, false, false);
                if (status != 0) {
                    Assert.println((String)("Closing the nodes returned " + status + ". Continuing ..."));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException e) {
                Assert.println((String)"Close node operation interrupted.");
            }
            catch (InvocationTargetException e) {
                Assert.println((String)"Exception occured during closing nodes.");
            }
        }
        for (Element element : nodes) {
            if (this.delete(element)) continue;
            res = false;
            if (!(element instanceof Node)) continue;
            this.m_nondeleted.add(((Node)element).getURL());
        }
        ActionHandlerUtil.reportNonDeletedURLs(this.m_nondeleted, this.isSilentMode());
        return res;
    }

    protected List<T> getNodesToDelete() {
        return this.getNodes();
    }

    private boolean checkReadOnlyFiles(List<T> elements) {
        Element element;
        Iterator<T> iterator = elements.iterator();
        while (iterator.hasNext() && (element = (Element)iterator.next()) instanceof Node) {
            URL url = ((Node)element).getURL();
            if (!URLFileSystem.isReadOnly((URL)url) || VCSManager.getVCSManager().isVersioned(url)) continue;
            return MessageDialog.confirm(null, (Object)DeleteDialogArb.getString(50), (String)DeleteDialogArb.getString(49), null);
        }
        return true;
    }

    private UpdateMessage createUpdateMessage() {
        UpdateMessage message = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
        message.setProperty("Message.COMMAND_ID_PROP", 21);
        return message;
    }

    protected final CopyOnWriteArrayList<URL> getNondeleted() {
        return this.m_nondeleted;
    }
}

