/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.ide.model.ContentSetProviderReference;
import oracle.ide.model.LazyLoadEvent;
import oracle.ide.model.LazyLoadListener;
import oracle.ide.model.LazyTraversable;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.ApplyNotifier;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ProjectPropertiesArb;
import oracle.ide.util.ResourceUtils;

class OnDemandTraversable
extends ProjectSettingsTraversablePanel
implements LazyTraversable {
    private JPanel basePanel = new JPanel();
    private JPanel notLoadedPanel = new JPanel();
    private final ContentSetProviderReference contentSetProviderRef;
    private final JButton loadButton;
    private ProjectSettingsTraversablePanel wrapped;
    private ApplyNotifier applyNotifier;
    private static final GridBagConstraints c = new GridBagConstraints();
    private TraversableContext traversableContext;
    private transient ArrayList _lazyLoadListeners = new ArrayList(2);

    public OnDemandTraversable(ContentSetProviderReference contentSetProvider, ApplyNotifier applyNotifier) {
        this.loadButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.loadButton, (String)ProjectPropertiesArb.getString(7));
        this.contentSetProviderRef = contentSetProvider;
        this.notLoadedPanel.add(this.loadButton);
        this.basePanel.setLayout(new GridBagLayout());
        this.basePanel.add((Component)this.notLoadedPanel, c);
        this.applyNotifier = applyNotifier;
        this.setUpUI();
    }

    private void setUpUI() {
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    if (OnDemandTraversable.this.wrapped == null) {
                        Navigable navigable = OnDemandTraversable.this.contentSetProviderRef.contentSetProvider().getNavigable();
                        OnDemandTraversable.this.wrapped = (ProjectSettingsTraversablePanel)navigable.newTraversable(OnDemandTraversable.this.applyNotifier);
                        if (OnDemandTraversable.this.traversableContext != null) {
                            OnDemandTraversable.this.wrapped.onEntry(OnDemandTraversable.this.traversableContext);
                        }
                    }
                }
                catch (Exception e) {
                    String msg = "Unable to instantiate traversable";
                    throw new RuntimeException(msg, e);
                }
                Component wrappedComponent = OnDemandTraversable.this.wrapped.getComponent();
                OnDemandTraversable.this.basePanel.remove(OnDemandTraversable.this.notLoadedPanel);
                OnDemandTraversable.this.basePanel.add(wrappedComponent, c);
                OnDemandTraversable.this.fireTraversableLoaded(new LazyLoadEvent(OnDemandTraversable.this, (Traversable)OnDemandTraversable.this.wrapped));
                OnDemandTraversable.this.basePanel.revalidate();
                OnDemandTraversable.this.basePanel.repaint();
            }
        });
    }

    @Override
    public Component getComponent() {
        return this.basePanel;
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (this.wrapped != null) {
            this.wrapped.onExit(dataContext);
        }
    }

    public Object getExitTransition() {
        return this.wrapped == null ? null : this.wrapped.getExitTransition();
    }

    public String getHelpID() {
        return this.wrapped == null ? "f1_loadextension_html" : this.wrapped.getHelpID();
    }

    @Override
    public boolean isActingLazy() {
        return this.wrapped == null;
    }

    @Override
    public void onProjectPanelEntry(TraversableContext traversableContext) {
        if (this.wrapped == null) {
            this.traversableContext = traversableContext;
            return;
        }
        this.wrapped.onProjectPanelEntry(traversableContext);
    }

    @Override
    public String getDataKey() {
        return this.wrapped == null ? null : this.wrapped.getDataKey();
    }

    @Override
    public String[] getPropertyKeys() {
        return this.wrapped == null ? new String[]{} : this.wrapped.getPropertyKeys();
    }

    @Override
    public boolean isUserOnly() {
        return this.wrapped == null ? super.isUserOnly() : this.wrapped.isUserOnly();
    }

    @Override
    public synchronized void addLazyLoadListener(LazyLoadListener listener) {
        if (listener == null) {
            return;
        }
        if (this._lazyLoadListeners == null) {
            this._lazyLoadListeners = new ArrayList(2);
        }
        this._lazyLoadListeners.add(listener);
    }

    @Override
    public synchronized void removeLazyLoadListener(LazyLoadListener listener) {
        if (listener != null && this._lazyLoadListeners != null) {
            this._lazyLoadListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTraversableLoaded(LazyLoadEvent lazyLoadEvent) {
        List list;
        OnDemandTraversable onDemandTraversable = this;
        synchronized (onDemandTraversable) {
            if (this._lazyLoadListeners == null) {
                return;
            }
            list = (List)this._lazyLoadListeners.clone();
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ((LazyLoadListener)list.get(i)).traversableLoaded(lazyLoadEvent);
        }
    }

    @Override
    @Deprecated
    public void addHierarchyListenerForLoading(HierarchyListener listener) {
    }

    @Override
    @Deprecated
    public void removeHierarchyListenerForLoading(HierarchyListener listener) {
    }

    static {
        OnDemandTraversable.c.gridy = 0;
        OnDemandTraversable.c.gridx = 0;
        OnDemandTraversable.c.gridheight = 1;
        OnDemandTraversable.c.gridwidth = 1;
        OnDemandTraversable.c.anchor = 18;
        OnDemandTraversable.c.weighty = 1.0;
        OnDemandTraversable.c.weightx = 1.0;
        OnDemandTraversable.c.fill = 1;
    }
}

