/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.text.Collator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.ide.model.PseudoTechnologyCallback;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.util.Assert;

public final class TechId
implements Comparable {
    private Set<TechId> _dependencies;
    private final PseudoTechnologyCallback _callback;
    private final String _name;
    private final String _description;
    private final String _key;
    private int _refCount;
    private final boolean _obsolete;

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public String getKey() {
        return this._key;
    }

    public boolean addDependency(TechId dependency) {
        boolean changed;
        if (dependency == null || dependency == this) {
            return false;
        }
        if (this._dependencies == null) {
            this._dependencies = new HashSet<TechId>();
        }
        if (changed = this._dependencies.add(dependency)) {
            TechnologyRegistry.getInstance()._techIdDependencies.clear();
        }
        return changed;
    }

    public boolean removeDependency(TechId dependency) {
        boolean changed;
        boolean bl = changed = this._dependencies != null ? this._dependencies.remove(dependency) : false;
        if (changed) {
            TechnologyRegistry.getInstance()._techIdDependencies.clear();
        }
        return changed;
    }

    public Set getDependencies() {
        if (this._dependencies == null || this._dependencies.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return new HashSet<TechId>(this._dependencies);
    }

    public boolean isVisible() {
        return !this.isObsolete() && this._callback == null;
    }

    public boolean isObsolete() {
        return this._obsolete;
    }

    public boolean isInScope(TechnologyScope scope) {
        if (scope.contains(this)) {
            return true;
        }
        return this._callback != null && this._callback.isInScope(scope);
    }

    public boolean dependsOn(TechId techId) {
        return this.dependsOn(techId, new HashSet<TechId>());
    }

    private boolean dependsOn(TechId techId, Set<TechId> seen) {
        if (this._dependencies != null && seen.add(this)) {
            for (TechId dependency : this._dependencies) {
                if (dependency != techId && !dependency.dependsOn(techId, seen)) continue;
                return true;
            }
        }
        return false;
    }

    public int compareTo(Object object) {
        return Collator.getInstance().compare(this._name, ((TechId)object)._name);
    }

    public String toString() {
        return this.getName();
    }

    public static TechId createTechId(String key, String name, String description) {
        return new TechId(key, name, description, false);
    }

    public static TechId createTechId(String key, String name, String description, boolean obsolete) {
        return new TechId(key, name, description, obsolete);
    }

    static TechId createPseudoTechId(String key, PseudoTechnologyCallback callback) {
        return new TechId(key, callback);
    }

    PseudoTechnologyCallback getCallback() {
        return this._callback;
    }

    void addRef() {
        ++this._refCount;
    }

    void release() {
        Assert.check((this._refCount > 0 ? 1 : 0) != 0);
        --this._refCount;
    }

    int refCount() {
        return this._refCount;
    }

    private TechId(String key, String name, String description, boolean obsolete) {
        this._key = key;
        this._name = name;
        this._description = description;
        this._dependencies = null;
        this._callback = null;
        this._obsolete = obsolete;
    }

    private TechId(String key, PseudoTechnologyCallback callback) {
        this._key = key;
        this._name = key;
        this._description = null;
        this._dependencies = null;
        this._callback = callback;
        this._obsolete = false;
    }
}

