/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.model.AbstractFileContentRecognizerTemplate;
import oracle.ide.model.ContentType;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.FileContentLowPriorityRecognizer;
import oracle.ide.model.FileContentPatternRecognizer;
import oracle.ide.model.FileContentRecognizer;
import oracle.ide.model.Node;
import oracle.ide.model.RecognizerException;
import oracle.ide.model.RecognizersHook;
import oracle.ide.model.UnrecognizedTextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.xml.XMLRecognizer;
import oracle.ideimpl.model.RecognizerClassForURLClosure;

public abstract class Recognizer {
    private static final MetaClass<UnrecognizedTextNode> UNRECOGNIZED_META = MetaClass.newMetaClass(UnrecognizedTextNode.class);
    private static final HashSet _extensionsForXML = new HashSet();
    private static final HashMap _customRecognizerMap = new HashMap();
    private static final ArrayList _lowPriorityRecognizers = new ArrayList();
    private static final Logger LOG = Logger.getLogger(Recognizer.class.getName());
    private static Recognizer _defaultRecognizer = new Recognizer(){

        public Class recognize(URL url) {
            return null;
        }

        @Override
        public MetaClass<? extends Node> recognizeAsMeta(URL url) {
            return null;
        }
    };
    private static final Map<File, MetaClass> _extensionToClassMap;
    private static final HashMap _extensionToContentTypeMap;
    private static final HashMap _documentInfoMap;
    private static final HashMap _validNodeClassConversionsMap;
    private static final ForURL _urlRecognizer;
    private static final FileContentPatternRecognizer PATTERN_RECOGNIZER;
    private static final FileContentRecognizer CONTENT_RECOGNIZER;
    private static final FileContentLowPriorityRecognizer LOW_PRIORITY_CONTENT_RECOGNIZER;

    public Class<? extends Node> recognize(URL url) {
        MetaClass<? extends Node> metaClass = null;
        try {
            metaClass = this.recognizeAsMeta(url);
            if (metaClass != null) {
                return metaClass.toClass(true);
            }
        }
        catch (Throwable thrown) {
            Recognizer.getLogger().log(Level.SEVERE, "Failed while classloading " + metaClass, thrown);
        }
        return null;
    }

    public MetaClass<? extends Node> recognizeAsMeta(URL url) {
        return UNRECOGNIZED_META;
    }

    public Node create(URL url, Class nodeType) throws IllegalAccessException, InstantiationException {
        if (nodeType != null) {
            Node node = (Node)nodeType.newInstance();
            node.setURL(url);
            return node;
        }
        return null;
    }

    public URL validate(URL newURL, URL oldURL) throws RecognizerException {
        return newURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canConvert(URL oldURL, URL newURL) {
        if (oldURL != null && newURL != null) {
            Class<? extends Node> oldClass = Recognizer.recognizeURL(oldURL);
            Class<? extends Node> newClass = this.recognize(newURL);
            if (oldClass != null && newClass != null) {
                HashSet validConversions;
                Map<String, Set<String>> conversions;
                Set<String> conversionSet;
                if (oldClass == newClass) {
                    return true;
                }
                RecognizersHook hook = RecognizersHook.getHook();
                if (hook != null && (conversionSet = (conversions = hook.nodeConversions()).get(oldClass.getName())) != null && conversionSet.contains(newClass.getName())) {
                    return true;
                }
                HashMap hashMap = _validNodeClassConversionsMap;
                synchronized (hashMap) {
                    validConversions = (HashSet)_validNodeClassConversionsMap.get(oldClass);
                }
                if (validConversions != null) {
                    return validConversions.contains(newClass);
                }
            }
        }
        return false;
    }

    @Deprecated
    public static void mapExtensionToClass(String extension, Class cls) {
        Recognizer.mapExtensionToMetaClass(extension, MetaClass.newMetaClass((Class)cls));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapExtensionToMetaClass(String extension, MetaClass cls) {
        if (extension == null || cls == null || extension.length() <= 0) {
            throw new IllegalArgumentException();
        }
        File fileExtension = Recognizer.sanitizeExtension(extension);
        Map<File, MetaClass> map = _extensionToClassMap;
        synchronized (map) {
            _extensionToClassMap.put(fileExtension, cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapExtensionToXML(String extension) {
        if (extension != null) {
            HashSet hashSet = _extensionsForXML;
            synchronized (hashSet) {
                _extensionsForXML.add(Recognizer.sanitizeExtension(extension));
            }
        }
    }

    public static void registerRecognizer(String fileExtension, Recognizer recognizer) {
        if (recognizer != null && fileExtension != null && fileExtension.length() > 0) {
            Recognizer[] newRecognizers;
            File ext = Recognizer.sanitizeExtension(fileExtension);
            Object recognizersObj = _customRecognizerMap.get(ext);
            if (recognizersObj != null) {
                Recognizer[] recognizers = (Recognizer[])recognizersObj;
                int n = recognizers.length;
                newRecognizers = new Recognizer[n + 1];
                System.arraycopy(recognizers, 0, newRecognizers, 0, n);
                newRecognizers[n] = recognizer;
            } else {
                newRecognizers = new Recognizer[]{recognizer};
            }
            _customRecognizerMap.put(ext, newRecognizers);
        }
    }

    public static void registerRecognizer(String[] fileExtensions, Recognizer recognizer) {
        if (fileExtensions != null && recognizer != null) {
            int n = fileExtensions.length;
            for (int i = 0; i < n; ++i) {
                Recognizer.registerRecognizer(fileExtensions[i], recognizer);
            }
        }
    }

    public static void registerLowPriorityRecognizer(Recognizer recognizer) {
        if (recognizer != null && !_lowPriorityRecognizers.contains(recognizer)) {
            _lowPriorityRecognizers.add(recognizer);
        }
    }

    public static Recognizer getDefaultRecognizer() {
        return _defaultRecognizer;
    }

    public static void setDefaultRecognizer(Recognizer recognizer) {
        if (recognizer != null) {
            _defaultRecognizer = recognizer;
        }
    }

    public static Class<? extends Node> getDefaultNodeType() {
        return UnrecognizedTextNode.class;
    }

    public static MetaClass<? extends Node> getDefaultNodeTypeAsMeta() {
        return UNRECOGNIZED_META;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isXmlExtension(String extension) {
        if (extension != null) {
            HashSet hashSet = _extensionsForXML;
            synchronized (hashSet) {
                return _extensionsForXML.contains(Recognizer.sanitizeExtension(extension));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void registerConversion(Class<? extends Node> oldNodeType, Class<? extends Node> newNodeType) {
        if (oldNodeType == null || newNodeType == null) {
            throw new IllegalArgumentException();
        }
        HashMap hashMap = _validNodeClassConversionsMap;
        synchronized (hashMap) {
            HashSet validConversions = (HashSet)_validNodeClassConversionsMap.get(oldNodeType);
            if (validConversions != null) {
                validConversions.add(newNodeType);
            } else {
                HashSet<Class<? extends Node>> newValidConversions = new HashSet<Class<? extends Node>>();
                newValidConversions.add(newNodeType);
                _validNodeClassConversionsMap.put(oldNodeType, newValidConversions);
            }
        }
    }

    public static Recognizer findRecognizer(URL url) {
        if (url != null) {
            Iterator iter = Recognizer.getRecognizerIterator(url);
            while (iter.hasNext()) {
                Recognizer recognizer = (Recognizer)iter.next();
                Class<? extends Node> nodeType = recognizer.recognize(url);
                if (nodeType == null) continue;
                return recognizer;
            }
        }
        return null;
    }

    public static Class<? extends Node> recognizeURL(URL url) {
        return Recognizer.recognizeURL(url, Recognizer.getDefaultNodeType());
    }

    public static MetaClass<? extends Node> recognizeURLAsMeta(URL url) {
        return Recognizer.recognizeURLAsMeta(url, Recognizer.getDefaultNodeTypeAsMeta());
    }

    public static Class<? extends Node> recognizeURL(URL url, Class<? extends Node> defaultNodeType) {
        if (url != null) {
            Iterator iter = Recognizer.getRecognizerIterator(url);
            while (iter.hasNext()) {
                Recognizer recognizer = (Recognizer)iter.next();
                Class<? extends Node> nodeType = recognizer.recognize(url);
                if (nodeType == null) continue;
                return nodeType;
            }
        }
        return defaultNodeType;
    }

    public static MetaClass<? extends Node> recognizeURLAsMeta(URL url, MetaClass<? extends Node> defaultNodeType) {
        if (url != null) {
            Iterator iter = Recognizer.getRecognizerIterator(url);
            while (iter.hasNext()) {
                Recognizer recognizer = (Recognizer)iter.next();
                MetaClass<? extends Node> nodeType = recognizer.recognizeAsMeta(url);
                if (nodeType == null) continue;
                return nodeType;
            }
        }
        return defaultNodeType;
    }

    @Deprecated
    public static final Map getExtensionToClassMap() {
        HashMap<File, Class> m = new HashMap<File, Class>();
        for (Map.Entry<File, MetaClass> entry : _extensionToClassMap.entrySet()) {
            try {
                m.put(entry.getKey(), entry.getValue().toClass());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Map<File, MetaClass> getExtensionToMetaClassMap() {
        Map<File, MetaClass> map = _extensionToClassMap;
        synchronized (map) {
            return new HashMap<File, MetaClass>(_extensionToClassMap);
        }
    }

    public static final Map<File, MetaClass<?>> getDeclarativeExtensionToClassMap() {
        HashMap map = new HashMap();
        RecognizersHook hook = RecognizersHook.getHook();
        if (hook != null) {
            Map<File, MetaClass<Node>> mappings = hook.fileExtensionMappings();
            map.putAll(mappings);
        }
        return map;
    }

    public static final Map getExtensionToContentTypeMap() {
        HashMap<File, ContentType> m = new HashMap<File, ContentType>(_extensionToContentTypeMap);
        RecognizersHook hook = RecognizersHook.getHook();
        if (hook != null) {
            Map<File, ContentType> declarative = hook.extensionToContentTypes();
            m.putAll(declarative);
        }
        return m;
    }

    public static final Map<File, ContentType> getDeclarativeExtensionToContentTypeMap() {
        HashMap<File, ContentType> map = new HashMap<File, ContentType>();
        RecognizersHook hook = RecognizersHook.getHook();
        if (hook != null) {
            Map<File, ContentType> mappings = hook.extensionToContentTypes();
            map.putAll(mappings);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DocumentInfo getDocumentInfo(Class nodeClass) {
        DocumentInfo info = Recognizer.getDocumentInfoForDeclarativeEntries(nodeClass.getName());
        if (info != null) {
            return info;
        }
        HashMap hashMap = _documentInfoMap;
        synchronized (hashMap) {
            return (DocumentInfo)_documentInfoMap.get(nodeClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DocumentInfo getDocumentInfo(String nodeClassName) {
        DocumentInfo info = Recognizer.getDocumentInfoForDeclarativeEntries(nodeClassName);
        if (info != null) {
            return info;
        }
        HashMap hashMap = _documentInfoMap;
        synchronized (hashMap) {
            for (Map.Entry entry : _documentInfoMap.entrySet()) {
                if (!((Class)entry.getKey()).getName().equals(nodeClassName)) continue;
                return (DocumentInfo)entry.getValue();
            }
            return null;
        }
    }

    public static final DocumentInfo getDocumentInfoForDeclarativeEntries(String nodeClassName) {
        Map<String, DeclarativeDocumentInfo> mappings;
        DeclarativeDocumentInfo info;
        RecognizersHook hook = RecognizersHook.getHook();
        if (hook != null && (info = (mappings = hook.documentInfoMappings()).get(nodeClassName)) != null) {
            return info.docInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static final Class getClassForExtension(String extension) {
        if (extension == null || extension.length() <= 0) {
            throw new IllegalArgumentException();
        }
        File fileExtension = Recognizer.sanitizeExtension(extension);
        MetaClass metaClass = null;
        Map<File, MetaClass> map = _extensionToClassMap;
        synchronized (map) {
            metaClass = _extensionToClassMap.get(fileExtension);
        }
        if (metaClass != null) {
            try {
                return metaClass.toClass();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static ContentType getContentTypeForExtension(String extension) {
        ContentType contentType;
        if (extension == null || extension.length() <= 0) {
            throw new IllegalArgumentException();
        }
        File fileExtension = Recognizer.sanitizeExtension(extension);
        RecognizersHook hook = RecognizersHook.getHook();
        if (hook != null && (contentType = hook.extensionToContentTypes().get(fileExtension)) != null) {
            return contentType;
        }
        HashMap hashMap = _extensionToContentTypeMap;
        synchronized (hashMap) {
            return (ContentType)_extensionToContentTypeMap.get(fileExtension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static final void mapExtensionToContentType(String extension, ContentType contentType) {
        if (extension == null || contentType == null || extension.length() <= 0) {
            throw new IllegalArgumentException();
        }
        File fileExtension = Recognizer.sanitizeExtension(extension);
        HashMap hashMap = _extensionToContentTypeMap;
        synchronized (hashMap) {
            _extensionToContentTypeMap.put(fileExtension, contentType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static final void registerDocumentInfo(Class nodeClass, DocumentInfo info) {
        HashMap hashMap = _documentInfoMap;
        synchronized (hashMap) {
            _documentInfoMap.put(nodeClass, info);
        }
    }

    public static final File sanitizeExtension(String extension) {
        if (((String)extension).charAt(0) != '.') {
            extension = "." + (String)extension;
        }
        return new File((String)extension);
    }

    static Iterator getRecognizerIterator(final URL url) {
        String fileName = URLFileSystem.getFileName((URL)url);
        int firstDot = fileName != null ? fileName.indexOf(".") : -1;
        final String initialSuffix = firstDot >= 0 ? fileName.substring(firstDot) : "";
        return new Iterator(){
            private String _suffix;
            private LinkedList _cur;
            private boolean _triedLowPriorityRecognizers;
            {
                this._suffix = initialSuffix;
                this._cur = new LinkedList();
                this._triedLowPriorityRecognizers = false;
            }

            @Override
            public boolean hasNext() {
                this.maybePrepare();
                return this._cur != null;
            }

            public Object next() {
                this.maybePrepare();
                return this._cur.removeFirst();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void maybePrepare() {
                RecognizersHook hook = RecognizersHook.getHook();
                if (this._cur != null && this._cur.size() <= 0) {
                    if (hook != null && hook.protocolMappings().containsKey(url.getProtocol())) {
                        this._cur.add(_urlRecognizer);
                    }
                    while (this._suffix.length() > 0) {
                        Map<File, MetaClass<Node>> extensionMappings;
                        Object customRecognizersObj;
                        File ext = Recognizer.sanitizeExtension(this._suffix);
                        int nextDot = this._suffix.indexOf(".", 1);
                        String string = this._suffix = nextDot >= 1 ? this._suffix.substring(nextDot) : "";
                        if (hook != null) {
                            if (hook.patternMappings().containsKey(ext)) {
                                this._cur.add(PATTERN_RECOGNIZER);
                            }
                            if (hook.contentMappings().containsKey(ext)) {
                                this._cur.add(CONTENT_RECOGNIZER);
                            }
                            if (hook.protocolMappings().containsKey(url.getProtocol())) {
                                this._cur.add(_urlRecognizer);
                            }
                        }
                        if ((customRecognizersObj = _customRecognizerMap.get(ext)) != null) {
                            Object[] array = (Object[])customRecognizersObj;
                            int n = array.length;
                            for (int i = 0; i < n; ++i) {
                                this._cur.add(array[i]);
                            }
                        }
                        if (_extensionsForXML.contains(ext)) {
                            this._cur.add(XMLRecognizer.getInstance());
                        }
                        if (hook != null && (extensionMappings = hook.fileExtensionMappings()).containsKey(ext) && !this._cur.contains(_urlRecognizer)) {
                            this._cur.add(_urlRecognizer);
                        }
                        if (_extensionToClassMap.containsKey(ext) && !this._cur.contains(_urlRecognizer)) {
                            this._cur.add(_urlRecognizer);
                        }
                        if (this._cur.size() <= 0) continue;
                        return;
                    }
                    if (!this._triedLowPriorityRecognizers) {
                        Collection<AbstractFileContentRecognizerTemplate.FileContentRule> contentMappings;
                        this._triedLowPriorityRecognizers = true;
                        this._cur.addAll(_lowPriorityRecognizers);
                        this._cur.add(_defaultRecognizer);
                        if (hook != null && !(contentMappings = hook.lowPriorityContentMappings()).isEmpty()) {
                            this._cur.add(LOW_PRIORITY_CONTENT_RECOGNIZER);
                        }
                        return;
                    }
                    this._cur = null;
                }
            }
        };
    }

    protected static Logger getLogger() {
        return LOG;
    }

    static {
        Recognizer.registerLowPriorityRecognizer(new FileTypesRecognizer());
        _extensionToClassMap = new HashMap<File, MetaClass>();
        _extensionToContentTypeMap = new HashMap();
        _documentInfoMap = new HashMap();
        _validNodeClassConversionsMap = new HashMap();
        _urlRecognizer = new ForURL();
        PATTERN_RECOGNIZER = new FileContentPatternRecognizer();
        CONTENT_RECOGNIZER = new FileContentRecognizer();
        LOW_PRIORITY_CONTENT_RECOGNIZER = new FileContentLowPriorityRecognizer();
    }

    public static class DeclarativeDocumentInfo {
        final DocumentInfo docInfo;
        final MetaClass<?> nodeType;

        DeclarativeDocumentInfo(DocumentInfo docInfo, MetaClass<?> nodeType) {
            this.docInfo = docInfo;
            this.nodeType = nodeType;
        }
    }

    private static final class ForURL
    extends Recognizer {
        private ForURL() {
        }

        public Class recognize(URL url) {
            Class cls = null;
            MetaClass metaCls = this._recognize(url);
            if (metaCls != null) {
                try {
                    cls = metaCls.toClass();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (cls != null) {
                    RecognizerClassForURLClosure.recordClass(cls);
                }
            }
            return cls;
        }

        public MetaClass recognizeAsMeta(URL url) {
            return this._recognize(url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MetaClass _recognize(URL url) {
            Map<String, MetaClass<Node>> protocolMappings;
            MetaClass<Node> cls;
            RecognizersHook hook = RecognizersHook.getHook();
            if (hook != null && (cls = (protocolMappings = hook.protocolMappings()).get(url.getProtocol())) != null) {
                return cls;
            }
            String extension = URLFileSystem.getSuffix((URL)url);
            File fileExtension = new File(extension);
            if (extension != null && extension.length() > 0) {
                MetaClass classFromExtension;
                Map<File, MetaClass> extensionToClassMap;
                Map<File, MetaClass<Node>> mappings;
                MetaClass<Node> nodeType;
                if (hook != null && (nodeType = (mappings = hook.fileExtensionMappings()).get(fileExtension)) != null) {
                    return nodeType;
                }
                Map<File, MetaClass> map = extensionToClassMap = ForURL.getExtensionToMetaClassMap();
                synchronized (map) {
                    classFromExtension = extensionToClassMap.get(fileExtension);
                }
                if (classFromExtension != null) {
                    return classFromExtension;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URL validate(URL newURL, URL oldURL) throws RecognizerException {
            String extension = URLFileSystem.getSuffix((URL)newURL);
            File fileExtension = new File(extension);
            RecognizersHook hook = RecognizersHook.getHook();
            if (hook != null) {
                Map<File, MetaClass> extensionToClassMap;
                Map<File, MetaClass<Node>> mappings = hook.fileExtensionMappings();
                if (mappings.containsKey(fileExtension)) {
                    return newURL;
                }
                Map<File, MetaClass> map = extensionToClassMap = ForURL.getExtensionToMetaClassMap();
                synchronized (map) {
                    if (extensionToClassMap.containsKey(fileExtension)) {
                        return newURL;
                    }
                }
            }
            if (this.recognize(oldURL) != null) {
                String oldExtension = URLFileSystem.getSuffix((URL)oldURL);
                try {
                    String newPath = newURL.getPath() + oldExtension;
                    return URLFactory.replacePathPart((URL)newURL, (String)newPath);
                }
                catch (Exception e) {
                    throw new RecognizerException("Internal exception: Unable to build new URL: " + e.getLocalizedMessage());
                }
            }
            throw new RecognizerException("Internal exception: Old URL not recognized.");
        }
    }
}

