/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.Iterator;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.model.HashStructureNodeMigrator;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.HashStructure;

public final class HeadlessMigratorUtil {
    private static final String DO_NOMIGRATION_FLAG = "doNoMigration";
    private static final String IDE_SKIPMIGRATION_FLAG = "ide.skipmigration";
    private static final boolean skipmigration = Boolean.getBoolean("ide.skipmigration");
    private static String _failFastIfMigrationNeededProperty = System.getProperty("ide.failFastIfMigrationNeeded");
    private static boolean _failFastIfMigrationNeeded = _failFastIfMigrationNeededProperty != null ? !_failFastIfMigrationNeededProperty.equalsIgnoreCase("false") : true;

    private HeadlessMigratorUtil() {
    }

    public static boolean nodeNeedsMigration(Node node) {
        boolean skipMigration = Boolean.getBoolean(IDE_SKIPMIGRATION_FLAG);
        if (!skipMigration) {
            NodeMigrator migrator = NodeMigrator.getNodeMigrator(NodeMigrator.getLookupKey(node));
            if (migrator != null && migrator instanceof HashStructureNodeMigrator) {
                MigrationInfo mi = migrator.getMigrationInfo(node);
                if (mi.getVersionStatus() == MigrationInfo.VERSION_NEWER) {
                    return true;
                }
                if (mi instanceof HashStructureNodeMigrator.HSNodeMigrationInfo) {
                    HashStructureNodeMigrator.HSNodeMigrationInfo hsmi = (HashStructureNodeMigrator.HSNodeMigrationInfo)mi;
                    if (mi.getVersionDirectly() == null) {
                        hsmi.ensureVersionInfoImpl(false);
                    }
                }
                Iterator<MigrationInfo.ErrorInformation> errors = mi.getErrors();
                MigrationInfo.MigrationStatus migrationStatus = mi.getMigrationStatusDirectly();
                return !errors.hasNext() && migrationStatus != MigrationInfo.MIGRATION_NOT_POSSIBLE && migrationStatus != MigrationInfo.MIGRATION_NOT_NEEDED;
            }
            return false;
        }
        return false;
    }

    public static String getNodeNeedsMigrationError(Node node) {
        return IdeArb.format(389, node.getLongLabel());
    }

    public static boolean failFastIfNodeNeedsMigration(Node node) {
        if (IdeUtil.isHeadless() && _failFastIfMigrationNeeded) {
            return HeadlessMigratorUtil.nodeNeedsMigration(node);
        }
        return false;
    }

    public static boolean isDoNoMigrationFlagSet(Node node) {
        try {
            if (node instanceof Workspace) {
                Workspace workspace = (Workspace)node;
                HashStructure hash = workspace.getProperties();
                return hash.getBoolean(DO_NOMIGRATION_FLAG);
            }
            if (node instanceof Project) {
                Project project = (Project)node;
                HashStructure hash = project.getProperties();
                return hash.getBoolean(DO_NOMIGRATION_FLAG);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static void checkAndSetSysPropForDoNoMigration(Node node) {
        if (!skipmigration && HeadlessMigratorUtil.isDoNoMigrationFlagSet(node)) {
            System.setProperty(IDE_SKIPMIGRATION_FLAG, "true");
        }
    }

    public static void checkAndUnunSetSysPropForDoNoMigration(Node node) {
        if (!skipmigration && HeadlessMigratorUtil.isDoNoMigrationFlagSet(node)) {
            System.clearProperty(IDE_SKIPMIGRATION_FLAG);
        }
    }
}

