/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.controller.ActionFilter;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.RadioToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.ToolbarGroup;
import oracle.ide.controls.ToolbarItem;
import oracle.ide.editor.Editor;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.view.View;
import oracle.javatools.ui.plaf.theme.ThemedToolBar;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.StringUtil;

public class Toolbar
extends JToolBar
implements ThemedToolBar {
    private ToolButton _trackButton;
    private ToolButton _overButton;
    private Action[] _actions;
    private ChangeListener _changeListener;
    private boolean _isPrimaryViewToolbar = false;
    private Boolean _isPrimaryViewToolbarOverride = null;
    private static final List<ActionFilter> ACTION_FILTERS = new ArrayList<ActionFilter>();

    public Toolbar() {
        this.setFloatable(false);
        this.setRollover(true);
        if (Themes.isThemed()) {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
    }

    public void forcePrimaryViewToolbar(boolean primaryViewToolbar) {
        if (this._isPrimaryViewToolbarOverride == null || this._isPrimaryViewToolbarOverride != primaryViewToolbar) {
            this._isPrimaryViewToolbarOverride = primaryViewToolbar;
            this.putClientProperty("isPrimary", primaryViewToolbar ? Boolean.TRUE : Boolean.FALSE);
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!Themes.isThemed() && this.getClientProperty("isPrimary") == Boolean.FALSE) {
            return;
        }
        super.paintComponent(g);
    }

    public void setPrimaryViewToolbar(boolean primaryViewToolbar) {
        if (this._isPrimaryViewToolbar != primaryViewToolbar) {
            this._isPrimaryViewToolbar = primaryViewToolbar;
            if (this._isPrimaryViewToolbarOverride == null) {
                this.putClientProperty("isPrimary", this._isPrimaryViewToolbar ? Boolean.TRUE : Boolean.FALSE);
            }
            this.repaint();
        }
    }

    public void setSecondaryViewToolbar(boolean secondaryViewToolbar) {
        this.putClientProperty("isSecondary", secondaryViewToolbar ? Boolean.TRUE : Boolean.FALSE);
    }

    public final ToolButton add(ToggleAction action) {
        ToolButton btn = new ToolButton(action);
        if (this.isActionAccepted(action)) {
            this.add(btn);
        }
        return btn;
    }

    @Override
    public Component add(Component comp, int index) {
        return super.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        super.add(comp, constraints, index);
    }

    public final ToggleToolButton addToggleButton(ToggleAction action) {
        ToggleToolButton btn = new ToggleToolButton(action);
        if (this.isActionAccepted(action)) {
            this.add(btn);
        }
        return btn;
    }

    public final RadioToolButton addRadioButton(ToggleAction action, ButtonGroup bgroup) {
        RadioToolButton btn = new RadioToolButton(action);
        if (this.isActionAccepted(action)) {
            this.add(btn);
            bgroup.add(btn);
        }
        return btn;
    }

    public final MenuToolButton addMenuButton(ToggleAction[] actions) {
        ArrayList<ToggleAction> filteredActions = new ArrayList<ToggleAction>(actions.length);
        for (ToggleAction a : actions) {
            if (!this.isActionAccepted(a)) continue;
            filteredActions.add(a);
        }
        int subActions = filteredActions.size();
        MenuToolButton btn = new MenuToolButton(filteredActions.toArray(new ToggleAction[subActions]));
        if (subActions > 0) {
            this.add(btn);
        }
        return btn;
    }

    public final ActionMenuToolButton addActionMenuButton(Action action) {
        ActionMenuToolButton btn = new ActionMenuToolButton(action);
        if (this.isActionAccepted(action)) {
            this.add(btn);
        }
        return btn;
    }

    public final JToolBar.Separator newSeparator() {
        JToolBar.Separator s = new JToolBar.Separator();
        s.setOrientation(this.getOrientation() == 1 ? 0 : 1);
        s.setMinimumSize(s.getPreferredSize());
        return s;
    }

    public final Component newFiller() {
        Component filler = this.getOrientation() == 0 ? Box.createHorizontalStrut(6) : Box.createVerticalStrut(6);
        filler.setFocusable(false);
        return filler;
    }

    @Override
    public final void addSeparator() {
        this.add(this.newSeparator());
    }

    public final void addFiller() {
        this.add(this.newFiller());
    }

    public Component addComponent(Component component, int index) {
        return this.add(component, index);
    }

    @Deprecated
    public void setLabelVisible(boolean labelVisible) {
        int i = this.getComponentCount();
        while (i-- > 0) {
            Component child = this.getComponent(i);
            if (!(child instanceof ToolButton)) continue;
            ToolButton b = (ToolButton)child;
            b.putClientProperty("hideActionText", labelVisible);
            b.repaint();
        }
        this.validate();
    }

    @Deprecated
    public boolean isLabelVisible() {
        return false;
    }

    public Action[] getActions() {
        if (this._actions != null) {
            return this._actions;
        }
        int count = this.getComponentCount();
        ArrayList<Action> actions = new ArrayList<Action>(count);
        int i = count;
        while (i-- > 0) {
            Component child = this.getComponent(i);
            if (child instanceof ToolbarGroup) {
                Action[] childActions = ((ToolbarGroup)((Object)child)).getActions();
                for (int j = 0; j < childActions.length; ++j) {
                    actions.add(childActions[j]);
                }
                continue;
            }
            if (child instanceof ToolbarItem) {
                actions.add(((ToolbarItem)((Object)child)).getAction());
                continue;
            }
            if (!(child instanceof AbstractButton)) continue;
            actions.add(((AbstractButton)child).getAction());
        }
        this._actions = actions.toArray(new Action[actions.size()]);
        return this._actions;
    }

    public void dispose() {
        Toolbar.disposeImpl(this);
    }

    @Override
    public void remove(Component comp) {
        this._actions = null;
        super.remove(comp);
    }

    @Override
    public void remove(int index) {
        this._actions = null;
        super.remove(index);
    }

    @Override
    public void removeAll() {
        this._actions = null;
        super.removeAll();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        Action action = null;
        if (comp instanceof AbstractButton) {
            action = ((AbstractButton)comp).getAction();
        } else if (comp instanceof ToolbarGroup) {
            Action[] actions = ((ToolbarGroup)((Object)comp)).getActions();
            if (actions.length > 0) {
                action = actions[0];
            }
        } else if (comp instanceof ToolbarItem) {
            action = ((ToolbarItem)((Object)comp)).getAction();
        }
        if (action != null && comp instanceof JComponent) {
            JComponent button = (JComponent)comp;
            if (button.getClientProperty("declarative-button") == null && Boolean.TRUE.equals(action.getValue("declarative-button"))) {
                button.putClientProperty("declarative-button", Boolean.TRUE);
            }
            if (button.getClientProperty("cmdId") == null) {
                button.putClientProperty("cmdId", action.getValue("cmdId"));
            }
            if (button.getName() == null) {
                String cmdId = (String)button.getClientProperty("cmdId");
                if (cmdId != null) {
                    button.setName(cmdId);
                } else if (action instanceof IdeAction) {
                    String cmdName = Ide.findCmdName(((IdeAction)action).getCommandId());
                    button.setName(cmdName);
                }
            }
        }
        this.addImpl2(comp, constraints, index);
    }

    protected void addImpl2(Component comp, Object constraints, int index) {
        this._actions = null;
        if (comp instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)comp;
            Action action = button.getAction();
            if (action == null && comp instanceof ToolbarGroup) {
                Action[] actions;
                boolean accepted = false;
                for (Action a : actions = ((ToolbarGroup)((Object)comp)).getActions()) {
                    if (!this.isActionAccepted(a)) continue;
                    accepted = true;
                    break;
                }
                if (!accepted) {
                    return;
                }
            } else if (!this.isActionAccepted(action)) {
                return;
            }
            button.setOpaque(false);
        }
        super.addImpl(comp, constraints, index);
    }

    void setTrack(ToolButton trackButton) {
        if (trackButton == null) {
            if (this._trackButton != null) {
                this._trackButton.repaint();
            }
            if (this._overButton != null && this._trackButton != this._overButton) {
                this._overButton.getModel().setRollover(true);
            }
        }
        this._trackButton = trackButton;
    }

    ToolButton getTrack() {
        return this._trackButton;
    }

    void setOver(ToolButton overButton) {
        this._overButton = overButton;
    }

    ToolButton getOver() {
        return this._overButton;
    }

    private static void disposeImpl(Component component) {
        AbstractButton abstractButton;
        Action action;
        if (component instanceof AbstractButton && (action = (abstractButton = (AbstractButton)component).getAction()) != null) {
            abstractButton.setAction(null);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int i = container.getComponentCount();
            while (i-- > 0) {
                Toolbar.disposeImpl(container.getComponent(i));
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        FocusTraversalPolicy focusTraversalPolicy;
        Component component;
        Container rootAncestor;
        super.processMouseEvent(e);
        if (e.getID() == 501 && (rootAncestor = this.getFocusCycleRootAncestor()) != null && !GraphicsUtils.isAncestorOfFocusedComponent((Component)rootAncestor) && (component = (focusTraversalPolicy = rootAncestor.getFocusTraversalPolicy()).getComponentAfter(rootAncestor, this)) != null) {
            component.requestFocus();
        }
    }

    public boolean isActiveToolbar() {
        return this.isActiveViewToolbar();
    }

    public boolean isPrimaryToolbar() {
        if (this._isPrimaryViewToolbarOverride != null) {
            return this._isPrimaryViewToolbarOverride;
        }
        return this._isPrimaryViewToolbar;
    }

    protected boolean isActiveViewToolbar() {
        View view = Ide.getMainWindow().getLastActiveView();
        if (view.getToolbar() == this) {
            return true;
        }
        if (view instanceof Editor) {
            Editor editor = (Editor)view;
            return editor.getScrollableTopMargin() == this;
        }
        return false;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        if (keyStrokeOptions != null) {
            this._changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Component[] components;
                    for (Component child : components = Toolbar.this.getComponents()) {
                        if (!(child instanceof AbstractButton)) continue;
                        Toolbar.setButtonTooltip((AbstractButton)child);
                    }
                }
            };
            keyStrokeOptions.addChangeListener(this._changeListener);
        }
    }

    private static void setButtonTooltip(AbstractButton button) {
        String existingTip = button.getToolTipText();
        String newTip = Toolbar.buildToolTip(button.getAction());
        if (existingTip == null || existingTip.isEmpty()) {
            button.setToolTipText(newTip);
            return;
        }
        if (existingTip.equals(newTip)) {
            return;
        }
        Toolbar.maybeUdpateButtonTooltip(button, existingTip, newTip);
    }

    private static void maybeUdpateButtonTooltip(AbstractButton button, String originalTipText, String newTipText) {
        if (originalTipText == null) {
            button.setToolTipText(newTipText);
            return;
        }
        if (newTipText == null) {
            return;
        }
        String newTipSuffix = Toolbar.acceleratorSuffix(newTipText);
        String currentAccelSuffix = Toolbar.acceleratorSuffix(originalTipText);
        if (newTipSuffix != null) {
            if (!newTipSuffix.equals(currentAccelSuffix)) {
                Object tip;
                if (currentAccelSuffix == null || currentAccelSuffix.isEmpty()) {
                    tip = newTipText;
                } else {
                    int index = originalTipText.indexOf(currentAccelSuffix);
                    tip = originalTipText.substring(0, index) + newTipSuffix;
                }
                button.setToolTipText((String)tip);
            }
        } else if (currentAccelSuffix != null) {
            int index = originalTipText.indexOf(currentAccelSuffix);
            button.setToolTipText(originalTipText.substring(0, index));
        }
    }

    private static String acceleratorSuffix(String tooltip) {
        int index;
        if (tooltip != null && tooltip.length() > 6 && (index = tooltip.lastIndexOf(40)) > 0 && tooltip.endsWith(")") && (tooltip.indexOf(43, index) != -1 || tooltip.indexOf(45, index) != -1)) {
            return tooltip.substring(index, tooltip.length());
        }
        return null;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._changeListener != null) {
            KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            if (keyStrokeOptions != null) {
                keyStrokeOptions.removeChangeListener(this._changeListener);
            }
            this._changeListener = null;
        }
    }

    public static synchronized void addToolbarFilter(ActionFilter filter) {
        if (filter == null) {
            throw new NullPointerException("ActionFilter is null");
        }
        ACTION_FILTERS.add(filter);
    }

    public static synchronized void removeToolbarFilter(ActionFilter filter) {
        ACTION_FILTERS.remove(filter);
    }

    protected final boolean isActionAccepted(Action action) {
        if (ACTION_FILTERS.size() > 0 && action instanceof IdeAction) {
            IdeAction ia = (IdeAction)action;
            String cmd = Ide.findCmdName(ia.getCommandId());
            for (ActionFilter filter : ACTION_FILTERS) {
                if (filter.accept(cmd)) continue;
                return false;
            }
        }
        return true;
    }

    public static String buildToolTip(Action action) {
        if (action == null) {
            return null;
        }
        Object tip = (String)action.getValue("ShortDescription");
        Object tipSuffixObj = action.getValue("last-tooltip-suffix");
        if (tip == null || ((String)tip).isEmpty() || tipSuffixObj != null) {
            tip = StringUtil.textWithoutMnemonic((Action)action);
        }
        if (tip != null && !((String)tip).isEmpty()) {
            if (action instanceof IdeAction) {
                int nCmdID = ((IdeAction)action).getCommandId();
                String acceleratorTooltip = KeyUtil.getAcceleratorTooltip(nCmdID);
                if (acceleratorTooltip != null && !acceleratorTooltip.isEmpty()) {
                    tip = (String)tip + " (" + acceleratorTooltip + ")";
                }
            } else {
                KeyStroke k = (KeyStroke)action.getValue("Accelerator");
                if (null != k) {
                    String keyText = KeyUtil.toString(k);
                    tip = (String)tip + " (" + keyText + ")";
                }
            }
        }
        if (tipSuffixObj != null) {
            tip = tip != null ? (String)tip + tipSuffixObj : tipSuffixObj.toString();
        }
        return StringUtil.stripMnemonic((String)tip);
    }
}

