/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;

public class OverlayIcon
implements Icon {
    private Collection m_icons;
    private int m_width = -1;
    private int m_height = -1;

    public OverlayIcon(Icon lower, Icon upper) {
        this.m_icons = new ArrayList(2);
        this.m_icons.add(lower);
        this.m_icons.add(upper);
    }

    public OverlayIcon(Collection icons) {
        this.m_icons = icons;
    }

    public OverlayIcon(Icon[] icons) {
        this.m_icons = new ArrayList(icons.length);
        for (int i = 0; i < icons.length; ++i) {
            this.m_icons.add(icons[i]);
        }
    }

    public void addIcon(Icon icon) {
        this.m_icons.add(icon);
    }

    public void removeIcon(Icon icon) {
        this.m_icons.remove(icon);
    }

    public void setIcons(Collection icons) {
        this.m_icons = icons;
    }

    public Collection getIcons() {
        return Collections.unmodifiableCollection(this.m_icons);
    }

    private void calculateWidthAndHeight() {
        for (Icon icon : this.m_icons) {
            if (icon == null) continue;
            if (icon.getIconWidth() > this.m_width) {
                this.m_width = icon.getIconWidth();
            }
            if (icon.getIconHeight() <= this.m_height) continue;
            this.m_height = icon.getIconHeight();
        }
    }

    @Override
    public int getIconWidth() {
        if (this.m_width == -1) {
            this.calculateWidthAndHeight();
        }
        return this.m_width;
    }

    @Override
    public int getIconHeight() {
        if (this.m_height == -1) {
            this.calculateWidthAndHeight();
        }
        return this.m_height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        for (Icon icon : this.m_icons) {
            if (icon == null) continue;
            icon.paintIcon(c, g, x, y);
        }
    }
}

