/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import oracle.dbtools.raptor.datatypes.ui.control.FlatButton;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.ByClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Date;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Month;

public class ByClauseButtonPanel
extends ByClause
implements ActionListener {
    public static final String NO_CHECKBOX = null;
    public static final String[] NO_DROPVALUES = null;
    public static final Object[] NO_INITVAL = null;
    protected static final int BUTTON_PIXELS = 20;
    protected static final int CHAR_PIXELS = 12;
    protected static final Color LIGHT_GRAY = new Color(221, 219, 219);
    protected final int minVal;
    protected final int maxVal;
    protected final int buttons;
    protected final int cols;
    protected final String clause;
    protected String checkBox = NO_CHECKBOX;
    protected int buttonPanelLayers = 1;
    protected String[] dropValues = NO_DROPVALUES;
    protected int defIdx;
    protected JPanel buttonPanel;
    protected JCheckBox countBackwards = null;
    protected JComboBox dropDown = new JComboBox();
    protected ComboBoxModel dropDownModel;
    protected JMenuItem selectedMenuItem = null;
    protected String dropToolTip;
    protected JButton clearAll;
    protected boolean[] isSelected;
    protected EventListenerList actionListeners;
    protected Object[] initVal = NO_INITVAL;

    protected ByClauseButtonPanel(Properties properties, int n, int n2, int n3, String string, Object[] objectArray) {
        super(properties);
        this.minVal = n;
        this.maxVal = n2;
        this.cols = n3;
        this.clause = string.toUpperCase();
        this.initVal = objectArray;
        this.buttons = n2 - n + 1;
    }

    public ByClauseButtonPanel(Properties properties, int n, int n2, int n3, String string, String string2, Object[] objectArray) {
        this(properties, n, n2, n3, string, objectArray);
        this.buttonPanelLayers = string2 == null ? 1 : 2;
        this.dropValues = null;
        this.checkBox = string2;
        this.createPanel();
    }

    public ByClauseButtonPanel(int n, int n2, int n3, String string, String string2, Object[] objectArray) {
        this(null, n, n2, n3, string, string2, objectArray);
    }

    public ByClauseButtonPanel(Properties properties, int n, int n2, int n3, String string) {
        this(properties, n, n2, n3, string, NO_CHECKBOX, NO_INITVAL);
    }

    public ByClauseButtonPanel(int n, int n2, int n3, String string) {
        this(null, n, n2, n3, string);
    }

    public ByClauseButtonPanel(Properties properties, int n, int n2, int n3, String string, String[] stringArray, int n4, String string2, Object[] objectArray) {
        this(properties, n, n2, n3, string, objectArray);
        this.buttonPanelLayers = stringArray.length;
        this.dropValues = new String[this.buttonPanelLayers];
        System.arraycopy(stringArray, 0, this.dropValues, 0, this.buttonPanelLayers);
        this.checkBox = null;
        this.defIdx = n4;
        this.dropToolTip = string2;
        this.createPanel();
    }

    public ByClauseButtonPanel(int n, int n2, int n3, String string, String[] stringArray, int n4, String string2, Object[] objectArray) {
        this(null, n, n2, n3, string, stringArray, n4, string2, objectArray);
    }

    protected void createPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        int n = -1;
        if (this.dropValues != null) {
            this.dropDown = new JComboBox();
            this.dropDownModel = new DefaultComboBoxModel<String>(this.dropValues);
            this.dropDown.setModel(this.dropDownModel);
            this.dropDown.setToolTipText(SchedulerArb.get(this.getToolTipId(this.dropToolTip)));
            this.dropDown.setFont(this.dropDown.getFont().deriveFont(1, 10.0f));
            this.dropDown.setActionCommand("dropDown");
            this.dropDown.addActionListener(this);
            gridBagConstraints.gridy = ++n;
            this.add((Component)this.dropDown, gridBagConstraints);
            gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        }
        this.createButtonPanel();
        ++n;
        gridBagConstraints.gridy = n++;
        this.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        if (this.checkBox != null) {
            this.countBackwards = new JCheckBox(this.checkBox);
            this.countBackwards.addActionListener(this);
            gridBagConstraints.gridy = n;
            this.add((Component)this.countBackwards, gridBagConstraints);
            gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        }
        this.clearAll = new JButton(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL"));
        this.clearAll.setActionCommand("Clear");
        this.clearAll.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL_TOOLTIP"));
        this.clearAll.setFont(this.clearAll.getFont().deriveFont(10.0f));
        this.clearAll.addActionListener(this);
        if (!this.hideActionButtons()) {
            gridBagConstraints.gridy = ++n;
            this.add((Component)this.clearAll, gridBagConstraints);
        }
        this.isSelected = new boolean[this.buttons * this.buttonPanelLayers];
        this.actionListeners = new EventListenerList();
        this.reset();
    }

    protected void createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(0, this.cols));
        FlatButton flatButton = new FlatButton("00");
        Dimension dimension = flatButton.getPreferredSize();
        Dimension dimension2 = new Dimension(dimension.width + 8, dimension.height + 8);
        for (int i = 0; i < this.buttons; ++i) {
            FlatButton flatButton2 = new FlatButton(Integer.toString(this.minVal + i));
            flatButton2.setFont(flatButton2.getFont().deriveFont(9.0f));
            flatButton2.setPreferredSize(dimension2);
            flatButton2.setMinimumSize(dimension2);
            flatButton2.setMaximumSize(dimension2);
            flatButton2.setActionCommand(this.clause);
            flatButton2.addActionListener((ActionListener)this);
            if (i / this.cols % 2 == 0) {
                flatButton2.setBackground(Color.WHITE);
            } else {
                flatButton2.setBackground(LIGHT_GRAY);
            }
            this.buttonPanel.add((Component)flatButton2);
        }
    }

    @Override
    public void reset() {
        if (this.initVal != null) {
            this.reset(this.initVal);
            this.initVal = null;
        } else {
            this.reset(null);
        }
    }

    public void reset(Object[] objectArray) {
        int n;
        for (n = 0; n < this.isSelected.length; ++n) {
            this.isSelected[n] = false;
        }
        this.setSelection(objectArray);
        if (this.buttonPanelLayers > 1 && this.dropValues != null) {
            n = this.defIdx;
            if (this.initVal != null) {
                for (int i = 0; i < this.isSelected.length; ++i) {
                    if (!this.isSelected[i]) continue;
                    n = i / this.buttons;
                    break;
                }
            }
            this.dropDownModel.setSelectedItem(this.dropValues[n]);
        } else {
            if (this.buttonPanelLayers > 1) {
                this.countBackwards.setSelected(false);
            }
            this.switchLayer();
        }
    }

    protected boolean setSelection(Object object) {
        return this.setSelection(object, true, false);
    }

    protected boolean setSelection(Object object, boolean bl, boolean bl2) {
        Integer n;
        boolean bl3 = false;
        if (object != null && (n = this.getButtonIndex(object)) != null) {
            FlatButton flatButton;
            this.isSelected[n.intValue()] = bl;
            bl3 = true;
            if (bl2 && (flatButton = this.getVisibileButton(n)) != null) {
                this.paintButtonSelection(flatButton, bl);
            }
        }
        return bl3;
    }

    protected boolean setSelection(Object[] objectArray) {
        return this.setSelection(objectArray, true, false);
    }

    protected boolean setSelection(Object[] objectArray, boolean bl, boolean bl2) {
        Boolean bl3 = null;
        if (objectArray != null) {
            for (Object object : objectArray) {
                boolean bl4 = this.setSelection(object, bl, bl2);
                if (bl3 != null && !bl3.booleanValue()) continue;
                bl3 = bl4;
            }
        }
        return bl3 == null ? false : bl3;
    }

    protected void switchLayer() {
        Component[] componentArray = this.buttonPanel.getComponents();
        int n = this.getOffset();
        for (int i = 0; i < componentArray.length; ++i) {
            FlatButton flatButton = (FlatButton)componentArray[i];
            this.paintButtonSelection(flatButton, this.isSelected[i + n]);
            if (!this.clause.equals("BYDATE")) continue;
            int n2 = this.getDropDownIndex() + 1;
            if (i + 1 == 30 && n2 == 2 || i + 1 == 31 && (n2 == 2 || n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11)) {
                flatButton.setEnabled(false);
                flatButton.setVisible(false);
                continue;
            }
            flatButton.setEnabled(true);
            flatButton.setVisible(true);
        }
    }

    protected int getOffset() {
        int n = 0;
        if (this.buttonPanelLayers > 1) {
            n = this.dropValues == null ? (this.countBackwards.isSelected() ? this.buttons : 0) : this.getDropDownIndex() * this.buttons;
        }
        return n;
    }

    protected int getDropDownIndex() {
        int n;
        for (n = 0; n < this.dropValues.length && !this.dropValues[n].equals(this.dropDown.getSelectedItem()); ++n) {
        }
        return n;
    }

    protected Integer getButtonIndex(FlatButton flatButton) {
        int n = this.getOffset();
        int n2 = 0;
        try {
            n2 = Integer.parseInt(flatButton.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        int n3 = n2 + n - this.minVal;
        return n3;
    }

    protected Integer getButtonIndex(Object object) {
        if (object != null) {
            int n;
            int n2 = 0;
            if (this.clause.equals("BYDATE")) {
                Date date = (Date)object;
                n2 = date.getMonth().ordinal() * this.buttons;
                object = date.getDay();
            }
            if ((n = ((Integer)object).intValue()) < 0) {
                n2 = this.buttons;
                n *= -1;
            }
            return n - this.minVal + n2;
        }
        return null;
    }

    protected FlatButton getVisibileButton(Integer n) {
        if (n != null) {
            int n2;
            int n3 = n;
            int n4 = n2 = this.getOffset();
            int n5 = n2 + this.buttons;
            if (n3 >= n4 && n3 <= n5) {
                return (FlatButton)this.buttonPanel.getComponents()[n3 - n4];
            }
            return null;
        }
        return null;
    }

    protected Boolean isButtonSelected(FlatButton flatButton) {
        Integer n = this.getButtonIndex(flatButton);
        if (n != null) {
            return this.isSelected[n];
        }
        return null;
    }

    protected Boolean isButtonSelected(Integer n) {
        if (n != null) {
            return this.isSelected[n];
        }
        return null;
    }

    protected void paintButtonSelection(FlatButton flatButton, boolean bl) {
        Color color;
        Color color2 = flatButton.getForeground();
        Color color3 = color = bl ? Color.RED : Color.BLACK;
        if (color != color2) {
            flatButton.setForeground(color);
        }
    }

    protected void changeButtonSelection(Object object, boolean bl) {
        this.setSelection(object, bl, true);
    }

    protected void resetButtonSelections(Object[] objectArray) {
        this.reset();
        for (int i = 0; i < objectArray.length; ++i) {
            this.changeButtonSelection(objectArray[i], true);
        }
    }

    protected void resetButtonSelections() {
        this.reset();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.clause)) {
            FlatButton flatButton = (FlatButton)actionEvent.getSource();
            Integer n = this.getButtonIndex(flatButton);
            if (n != null) {
                this.isSelected[n.intValue()] = !this.isSelected[n];
                this.paintButtonSelection(flatButton, this.isSelected[n]);
                this.fireAction(new ActionEvent(this, 1001, this.clause));
            }
        } else if (string.equals(this.checkBox)) {
            this.switchLayer();
        } else if (string.equals("dropDown")) {
            this.switchLayer();
        } else if (string.equals("Clear")) {
            this.reset();
            this.fireAction(new ActionEvent(this, 1001, this.clause));
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(ActionListener.class, actionListener);
    }

    protected void fireAction(ActionEvent actionEvent) {
        Object[] objectArray = this.actionListeners.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    protected Object getClauseElement(int n) {
        Object object = null;
        if (this.dropValues != null) {
            int n2 = n / this.buttons;
            int n3 = n % this.buttons + this.minVal;
            object = this.clause.equals("BYDATE") ? new Date(n3, Month.values()[n2]) : this.dropValues[n2] + n3;
        } else {
            object = n < this.buttons ? Integer.valueOf(this.minVal + n) : Integer.valueOf((this.minVal + n - this.buttons) * -1);
        }
        return object;
    }

    protected Object getClauseElement(FlatButton flatButton) {
        Integer n = this.getButtonIndex(flatButton);
        if (n != null) {
            return this.getClauseElement(n);
        }
        return null;
    }

    public boolean anyItemSelected() {
        for (int i = 0; i < this.isSelected.length; ++i) {
            if (!this.isSelected[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.countBackwards != null) {
            this.countBackwards.setEnabled(bl);
        }
        if (this.dropDown != null) {
            this.dropDown.setEnabled(bl);
        }
        this.clearAll.setEnabled(bl);
        Component[] componentArray = this.buttonPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof AbstractButton)) continue;
            ((AbstractButton)componentArray[i]).setEnabled(bl);
        }
    }

    protected String getToolTipId(String string) {
        return "REPEAT_INTERVAL_CLAUSE_SELECT_" + string.toUpperCase() + "_TOOLTIP";
    }

    protected boolean hideActionButtons() {
        return Boolean.parseBoolean(this.getProperty("repeatinterval.component.ByClauseButtonPanel.hideActionButtons", "false"));
    }
}

