/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.StackedAreaChart;
import javafx.scene.chart.XYChart;
import oracle.dbtools.raptor.metrics.facet.GraphicalChartMonitor;
import oracle.dbtools.raptor.metrics.facet.PointAxisProperties;
import oracle.dbtools.raptor.metrics.panel.Context;

@DefaultProperty(value="item")
public class PointChartMonitor
extends GraphicalChartMonitor<Number, Number, Double, Double> {
    private PointAxisProperties xAxisProperties;
    private PointAxisProperties yAxisProperties;
    private boolean stacked;

    public PointChartMonitor() {
        this.init(new Listener());
    }

    @Override
    protected void initializeAxes(Context context, XYChart<Number, Number> xYChart) {
        this.xAxisProperties = this.findAndInitializeAxisProperties(PointAxisProperties.class, context, (NumberAxis)xYChart.getXAxis());
        this.yAxisProperties = this.findAndInitializeAxisProperties(PointAxisProperties.class, context, (NumberAxis)xYChart.getYAxis());
        this.stacked = xYChart instanceof StackedAreaChart;
    }

    @Override
    protected Double getXValue(ObservableValue<?> observableValue) {
        return this.xAxisProperties != null ? this.xAxisProperties.convertValueToDouble(observableValue.getValue()) : 0.0;
    }

    @Override
    protected Double getXValue(Number number) {
        return number.doubleValue();
    }

    @Override
    protected Double getYValue(ObservableValue<?> observableValue) {
        return this.yAxisProperties != null ? this.yAxisProperties.convertValueToDouble(observableValue.getValue()) : 0.0;
    }

    @Override
    protected void updateBounds(List<ObservableList<XYChart.Data<Number, Number>>> list) {
        int n = list.get(0).size();
        if (n > 0) {
            double d = ((Number)((XYChart.Data)list.get(0).get(0)).getXValue()).doubleValue();
            double d2 = ((Number)((XYChart.Data)list.get(0).get(n - 1)).getXValue()).doubleValue();
            double d3 = Double.MAX_VALUE;
            double d4 = Double.MIN_VALUE;
            int n2 = list.size();
            if (this.stacked) {
                for (int i = 0; i < n; ++i) {
                    double d5 = 0.0;
                    for (int j = 0; j < n2; ++j) {
                        d5 += ((Number)((XYChart.Data)list.get(j).get(i)).getYValue()).doubleValue();
                    }
                    if (d5 < d3) {
                        d3 = d5;
                    }
                    if (!(d5 > d4)) continue;
                    d4 = d5;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    List list2 = (List)list.get(i);
                    for (int j = 0; j < n; ++j) {
                        double d6 = ((Number)((XYChart.Data)list2.get(j)).getYValue()).doubleValue();
                        if (d6 > d4) {
                            d4 = d6;
                        }
                        if (!(d6 < d3)) continue;
                        d3 = d6;
                    }
                }
            }
            if (this.xAxisProperties != null) {
                this.xAxisProperties.update(d, d2);
            }
            if (this.yAxisProperties != null) {
                this.yAxisProperties.update(d3, d4);
            }
        }
    }

    protected class Listener
    extends GraphicalChartMonitor.Listener {
        protected Listener() {
        }
    }
}

