/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import oracle.aurora.util.AuroraRuntimeExtensions;
import oracle.aurora.util.JDKRuntimeExtensions;

public abstract class RuntimeExtensions {
    public final int byteSize;
    public final int booleanSize;
    public final int charSize;
    public final int shortSize;
    public final int intSize;
    public final int longSize;
    public final int floatSize;
    public final int doubleSize;
    public final int referenceSize;
    public final int classTypeOverhead;
    public final int arrayTypeOverhead;
    private static RuntimeExtensions extensions;

    public static RuntimeExtensions getExtensions() {
        if (extensions == null) {
            String vendor = System.getProperty("java.vendor");
            if (vendor.startsWith("Sun")) {
                extensions = new JDKRuntimeExtensions();
            } else if (vendor.startsWith("Oracle Corporation")) {
                extensions = new AuroraRuntimeExtensions();
            } else {
                throw new RuntimeException("No extensions installed for vendor: " + vendor + ", version: " + System.getProperty("java.version"));
            }
        }
        return extensions;
    }

    protected RuntimeExtensions(int byteSize, int booleanSize, int charSize, int shortSize, int intSize, int longSize, int floatSize, int doubleSize, int referenceSize, int classTypeOverhead, int arrayTypeOverhead) {
        this.byteSize = byteSize;
        this.booleanSize = booleanSize;
        this.charSize = charSize;
        this.shortSize = shortSize;
        this.intSize = intSize;
        this.longSize = longSize;
        this.floatSize = floatSize;
        this.doubleSize = doubleSize;
        this.referenceSize = referenceSize;
        this.classTypeOverhead = classTypeOverhead;
        this.arrayTypeOverhead = arrayTypeOverhead;
    }
}

