/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import oracle.aurora.util.Assertion;
import oracle.aurora.util.DynaHash;
import oracle.aurora.util.HashBucket;
import oracle.aurora.util.Identifier;
import oracle.aurora.util.Locator;

class DynaHashTest {
    DynaHashTest() {
    }

    public static void main(String[] args) throws IOException {
        int tt;
        DynaHash.oassert.setSuppressionLevel(2);
        StreamTokenizer str = DynaHashTest.scan(args[0]);
        int bp = 8;
        if (args.length > 1) {
            bp = Integer.valueOf(args[1]);
        }
        DynaHash dht = new DynaHash(new Identifier(){

            public int hash(Object obj) {
                return ((Locator)obj).ident.hashCode();
            }

            public boolean identify(Object obj1, Object obj2) {
                return ((Locator)obj1).ident.equals(((Locator)obj2).ident);
            }
        }, bp);
        int ctr = 0;
        while (true) {
            Locator probe;
            Locator hres;
            tt = str.nextToken();
            if (tt == -1) break;
            if (tt != -3) continue;
            if (ctr % 1000 == 0) {
                System.out.print(ctr + " ");
            }
            if ((hres = (Locator)dht.insert(probe = new Locator(str.sval))) == null) {
                probe.addHit(ctr);
            } else {
                hres.addHit(ctr);
            }
            ++ctr;
        }
        System.out.println("");
        dht.checkIntegrity();
        PrintWriter out = new PrintWriter(System.out);
        dht.getStats().print(out);
        out.flush();
        System.out.println("Sizes:");
        HashBucket hb = dht.first;
        while (hb != null) {
            System.out.print(hb.size + " ");
            hb = hb.next;
        }
        System.out.println("");
        System.out.println("Deleting...");
        str = DynaHashTest.scan(args[0]);
        ctr = 0;
        while (true) {
            tt = str.nextToken();
            if (tt == -1) break;
            if (tt != -3) continue;
            if (ctr % 1000 == 0) {
                System.out.print(ctr + " ");
                dht.checkIntegrity();
            }
            ++ctr;
            Locator probe = new Locator(str.sval);
            Locator hres = (Locator)dht.remove(probe);
            if (hres == null) continue;
            Assertion.oassert(hres.equals(probe));
        }
        Assertion.oassert(dht.size() == 0);
        dht.getStats().print(out);
        out.flush();
    }

    static StreamTokenizer scan(String fname) throws IOException {
        StreamTokenizer str = new StreamTokenizer(new FileReader(fname));
        str.wordChars(97, 122);
        str.wordChars(65, 90);
        str.wordChars(95, 95);
        str.wordChars(45, 45);
        str.wordChars(39, 39);
        return str;
    }
}

