/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import oracle.aurora.compiler.ClassFinder;
import oracle.aurora.compiler.ClassFinderBase;
import oracle.aurora.compiler.CompilerInterface;
import oracle.aurora.compiler.Destination;
import oracle.aurora.compiler.ErrorReporter;
import oracle.aurora.compiler.ExternalEntity;
import oracle.aurora.compiler.FinderFactory;
import oracle.aurora.compiler.QName;
import oracle.aurora.compiler.SimpleErrorReporter;
import oracle.aurora.compiler.TaggingErrorReporter;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.ExternalEntityClassHandle;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.InvalidResolverPatternException;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.Resolver;
import oracle.aurora.rdbms.ResolverTerm;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SchemaNotFoundException;

public class DbmsCompilerInterface
implements CompilerInterface {
    Resolver resolver;
    PrintWriter log;
    FinderFactory factory;
    ErrorReporter errorReporter;
    boolean forCompiler;

    public DbmsCompilerInterface(Resolver resolver, OutputStream out) {
        this.resolver = resolver;
        this.log = new PrintWriter((Writer)new OutputStreamWriter(out), true);
    }

    private static final Resolver mkResolver(Schema baseSchema) {
        Resolver r = null;
        try {
            ResolverTerm t = new ResolverTerm("*", baseSchema);
            r = new Resolver(new ResolverTerm[]{t});
        }
        catch (InvalidResolverPatternException ex) {
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            // empty catch block
        }
        return r;
    }

    public DbmsCompilerInterface(Schema baseSchema, OutputStream out) {
        this(DbmsCompilerInterface.mkResolver(baseSchema), out);
    }

    public DbmsCompilerInterface(OutputStream out) {
        this(Schema.currentSchema(), out);
    }

    public Writer getLog() {
        return this.log;
    }

    public FinderFactory getFinderFactory() {
        if (this.factory == null) {
            this.factory = new DbmsFinderFactory();
        }
        return this.factory;
    }

    public ErrorReporter getReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = new SimpleErrorReporter(this.getLog(), true);
            String[] tags = new String[]{"Info: ", "Warning: ", "", "ABORT: "};
            this.errorReporter = new TaggingErrorReporter(this.errorReporter, tags);
        }
        return this.errorReporter;
    }

    public Destination getDestination(ExternalEntity source, QName name, int kind) throws FileNotFoundException {
        throw new FileNotFoundException("DbmsCompilerInterface.getDestination not implemented");
    }

    public int interpretArg(String[] argv, int argc, Vector sources) {
        return argc;
    }

    public void close() {
    }

    static String libUnitName(QName className) {
        String name = className.getName();
        name = name.replace('.', '/');
        return name;
    }

    public void setForCompiler(boolean forCompiler) {
        this.forCompiler = forCompiler;
    }

    class DbmsTopFinder
    extends ClassFinderBase
    implements ClassFinder {
        DbmsTopFinder() {
        }

        public ExternalEntity find(QName className) {
            String name = DbmsCompilerInterface.libUnitName(className);
            ClassHandle h = Handle.lookupClass(name, DbmsCompilerInterface.this.resolver);
            return h != null ? new ExternalEntityClassHandle(h, className, DbmsCompilerInterface.this.forCompiler) : null;
        }

        public ExternalEntity find(QName className, int kind) {
            ExternalEntity result = null;
            if (kind == 1) {
                result = this.find(className);
            }
            return result;
        }

        public int hashCode() {
            return DbmsCompilerInterface.this.resolver.hashCode();
        }

        public boolean equals(Object rhs) {
            if (rhs instanceof DbmsTopFinder) {
                return DbmsCompilerInterface.this.resolver.equals(((DbmsTopFinder)rhs).getResolver());
            }
            return super.equals(rhs);
        }

        Resolver getResolver() {
            return DbmsCompilerInterface.this.resolver;
        }
    }

    class DbmsFinder
    extends ClassFinderBase
    implements ClassFinder {
        ClassHandle handle;
        ClassHandle[] referencedHandles;

        DbmsFinder(ClassHandle handle) {
            this.handle = handle;
            try {
                this.referencedHandles = handle.referencedClassHandles();
            }
            catch (ObjectTypeChangedException ehe) {
                ehe.printStackTrace();
                System.err.println(ehe.getMessage());
            }
        }

        public ExternalEntity find(QName className) {
            String name = DbmsCompilerInterface.libUnitName(className);
            ClassHandle found = null;
            if (name.equals(this.handle.name())) {
                found = this.handle;
            }
            for (int x = 0; x < this.referencedHandles.length && found == null; ++x) {
                if (this.referencedHandles[x] == null || !name.equals(this.referencedHandles[x].name())) continue;
                found = this.referencedHandles[x];
            }
            if (found == null && name.startsWith("java/lang/")) {
                found = Handle.lookupClass(name, Schema.systemSchema);
            }
            return found != null ? new ExternalEntityClassHandle(found, className, DbmsCompilerInterface.this.forCompiler) : null;
        }

        public ExternalEntity find(QName className, int kind) {
            ExternalEntity result = null;
            if (kind == 1) {
                result = this.find(className);
            }
            return result;
        }

        public int hashCode() {
            return this.handle.hashCode();
        }

        public boolean equals(Object rhs) {
            if (rhs instanceof DbmsFinder) {
                return this.handle.equals(((DbmsFinder)rhs).handle);
            }
            return super.equals(rhs);
        }
    }

    class DbmsFinderFactory
    implements FinderFactory {
        DbmsFinderFactory() {
        }

        public ClassFinder finder(ExternalEntity source) {
            if (source == null) {
                return new DbmsTopFinder();
            }
            if (source instanceof ExternalEntityClassHandle) {
                return new DbmsFinder(((ExternalEntityClassHandle)source).getHandle());
            }
            return null;
        }

        public void close() {
        }
    }
}

