/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.ui.EventStatusModel;
import oracle.dbtools.migration.workbench.core.ui.FullMigrationPreRequisiteChecker;
import oracle.dbtools.migration.workbench.core.ui.PreReqListener;
import oracle.dbtools.migration.workbench.core.ui.SimpleTablePanel;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.Messages;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;

public class MigrationCheck
extends DefaultTraversablePanel {
    private PreReqResultsPanel m_testResultsPanel = new PreReqResultsPanel();
    private JButton m_btnTest = new JButton();
    private JTextPane m_txtTestDesc = new JTextPane();
    private FullMigrationPreRequisiteChecker m_checker = null;
    private String m_sourceConnectionName;
    private String m_targetConnectionName;
    private String m_repoName;
    private int m_result = 1;
    private TraversableContext m_dataContext;
    private static final String HTMLCONTENT = "text/html";

    public MigrationCheck() {
        Font font = this.m_txtTestDesc.getFont();
        String string = MigrationUtils.fontToCSSString(font);
        Dimension dimension = new Dimension(72, 22);
        this.m_btnTest.setMinimumSize(dimension);
        this.m_btnTest.setMaximumSize(dimension);
        this.m_btnTest.setPreferredSize(dimension);
        this.m_btnTest.setMnemonic(StringUtils.getMnemonicKeyCode((String)"MNEM_QUICKMIGRATE_BUTTON_VERIFY"));
        this.m_btnTest.setText(MigrationAddinArb.getString("QUICKMIGRATE_BUTTON_VERIFY"));
        this.m_btnTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MigrationCheck.this.performTest();
            }
        });
        this.m_txtTestDesc.setContentType(HTMLCONTENT);
        this.m_txtTestDesc.setText(MigrationAddinArb.format("QUICKMIGRATE_VERIFY_DESC", string));
        this.m_txtTestDesc.setEditable(false);
        this.m_txtTestDesc.setOpaque(false);
        this.m_txtTestDesc.setRequestFocusEnabled(false);
        this.m_txtTestDesc.setFocusable(false);
        this.setLayout(new GridBagLayout());
        this.add(this.m_txtTestDesc, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.m_btnTest, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.m_testResultsPanel.getPanel(), new GridBagConstraints(0, 2, 3, 1, 1.0, 2.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void performTest() {
        if (this.m_checker != null) {
            this.m_checker.allDone();
        }
        this.m_checker = new FullMigrationPreRequisiteChecker(this.m_sourceConnectionName, this.m_targetConnectionName, this.m_repoName);
        this.m_testResultsPanel.reset();
        this.m_checker.addListener(this.m_testResultsPanel);
        this.m_result = this.m_checker.runTests();
        if (this.m_result == 2) {
            StringBuffer stringBuffer = new StringBuffer(MigrationAddinArb.getString("QM_MULTI_WARN"));
            stringBuffer.append(Messages.getString("MigrationCheck.1"));
            stringBuffer.append(this.m_checker.getPrivWarning());
            MessageDialog.information((Component)((Object)this), (Object)stringBuffer.toString(), (String)MigrationAddinArb.getString("QM_MULTI_WARN_TITLE"), (String)Messages.getString("MigrationCheck.2"));
        }
        this.setWizardButtons();
    }

    private void setWizardButtons() {
        if (this.m_result == 2 || this.m_result == 0) {
            this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        } else {
            this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_dataContext = traversableContext;
        this.m_sourceConnectionName = (String)traversableContext.get(Messages.getString("MigrationCheck.3"));
        this.m_targetConnectionName = (String)traversableContext.get(Messages.getString("MigrationCheck.4"));
        this.m_repoName = (String)traversableContext.get(Messages.getString("MigrationCheck.5"));
        this.m_btnTest.setEnabled(true);
        this.setWizardButtons();
    }

    private MigrationPlugin getPlugin() {
        if (this.m_checker == null) {
            return null;
        }
        return this.m_checker.getPlugin();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        traversableContext.put(Messages.getString("MigrationCheck.6"), (Object)this.m_result);
        traversableContext.put(Messages.getString("MigrationCheck.7"), (Object)this.getPlugin());
    }

    private static class PreReqResultsPanel
    implements PreReqListener {
        private EventStatusModel m_model = new EventStatusModel(new String[]{MigrationAddinArb.getString("QUICKMIGRATE_PREREQ_CHECK_HEADING_TESTNAME"), MigrationAddinArb.getString("QUICKMIGRATE_PREREQ_CHECK_HEADING_STATUS"), MigrationAddinArb.getString("QUICKMIGRATE_PREREQ_CHECK_HEADING_INFORMATION")});
        private SimpleTablePanel m_eventPanel = new SimpleTablePanel(600, null, this.m_model);

        public SimpleTablePanel getPanel() {
            return this.m_eventPanel;
        }

        @Override
        public void testCompleted(String string, boolean bl, String string2) {
            String[] stringArray = new String[]{string, bl ? MigrationAddinArb.getString("QUICKMIGRATE_PREREQ_TEST_SUCCESS") : MigrationAddinArb.getString("QUICKMIGRATE_PREREQ_TEST_FAIL"), string2};
            this.m_eventPanel.updateProgress(stringArray);
        }

        @Override
        public void testStarted(String string, String string2) {
            String[] stringArray = new String[]{string, MigrationAddinArb.getString("QUICKMIGRATE_PREREQ_TEST_STARTED"), string2};
            this.m_eventPanel.updateProgress(stringArray);
        }

        public void reset() {
            this.m_model.clear();
        }
    }
}

