/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.text.MessageFormat;
import oracle.dbtools.migration.convert.DataTypeConversionMap;
import oracle.dbtools.migration.convert.DataTypeMappingRule;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.convert.ValidDataTypeSpecification;
import oracle.dbtools.migration.workbench.core.ui.Messages;

public class DataMapValidator {
    public static String validate(DataTypeConversionMap dataTypeConversionMap, SupportedDataTypesMap supportedDataTypesMap) {
        if (dataTypeConversionMap == null || dataTypeConversionMap.values().size() <= 0) {
            return Messages.getString("DataMapValidator.0");
        }
        String string = DataMapValidator.validateDuplication(dataTypeConversionMap);
        if (string != null) {
            return string;
        }
        string = DataMapValidator.validateName(dataTypeConversionMap, supportedDataTypesMap);
        if (string != null) {
            return string;
        }
        string = DataMapValidator.validateRange(dataTypeConversionMap, supportedDataTypesMap);
        if (string != null) {
            return string;
        }
        return null;
    }

    private static String validateRange(DataTypeConversionMap dataTypeConversionMap, SupportedDataTypesMap supportedDataTypesMap) {
        DataTypeMappingRule[] dataTypeMappingRuleArray = dataTypeConversionMap.values().toArray(new DataTypeMappingRule[0]);
        for (int i = 0; i < dataTypeMappingRuleArray.length; ++i) {
            DataTypeSpecification dataTypeSpecification = dataTypeMappingRuleArray[i].getSourceDataType();
            for (ValidDataTypeSpecification validDataTypeSpecification : supportedDataTypesMap.getValidDataTypes()) {
                if (!validDataTypeSpecification.getName().equals(dataTypeSpecification.getName())) continue;
                if (validDataTypeSpecification.isPrecisionMandatory() && dataTypeSpecification.getPrecision() == null) {
                    return MessageFormat.format(Messages.getString("DataMapValidator.1"), dataTypeSpecification);
                }
                if (dataTypeSpecification.getPrecision() != null) {
                    if (validDataTypeSpecification.getMaxPrecision() != null && dataTypeSpecification.getPrecision() > validDataTypeSpecification.getMaxPrecision()) {
                        return MessageFormat.format(Messages.getString("DataMapValidator.2"), dataTypeSpecification, validDataTypeSpecification.getMinPrecision(), validDataTypeSpecification.getMaxPrecision());
                    }
                    if (validDataTypeSpecification.getMinPrecision() != null && dataTypeSpecification.getPrecision() < validDataTypeSpecification.getMinPrecision()) {
                        return MessageFormat.format(Messages.getString("DataMapValidator.3"), dataTypeSpecification, validDataTypeSpecification.getMinPrecision(), validDataTypeSpecification.getMaxPrecision());
                    }
                }
                if (validDataTypeSpecification.isScaleMandatory() && dataTypeSpecification.getScale() == null) {
                    return MessageFormat.format(Messages.getString("DataMapValidator.4"), dataTypeSpecification);
                }
                if (dataTypeSpecification.getScale() == null) continue;
                if (validDataTypeSpecification.getMaxScale() != null && dataTypeSpecification.getScale() > validDataTypeSpecification.getMaxScale()) {
                    return MessageFormat.format(Messages.getString("DataMapValidator.5"), dataTypeSpecification, validDataTypeSpecification.getMinScale(), validDataTypeSpecification.getMaxScale());
                }
                if (validDataTypeSpecification.getMinScale() == null || dataTypeSpecification.getScale() >= validDataTypeSpecification.getMinScale()) continue;
                return MessageFormat.format(Messages.getString("DataMapValidator.6"), dataTypeSpecification, validDataTypeSpecification.getMinScale(), validDataTypeSpecification.getMaxScale());
            }
        }
        return null;
    }

    private static String validateDuplication(DataTypeConversionMap dataTypeConversionMap) {
        DataTypeMappingRule[] dataTypeMappingRuleArray = dataTypeConversionMap.values().toArray(new DataTypeMappingRule[0]);
        for (int i = 0; i < dataTypeMappingRuleArray.length; ++i) {
            DataTypeSpecification dataTypeSpecification = dataTypeMappingRuleArray[i].getSourceDataType();
            for (int j = i + 1; j < dataTypeMappingRuleArray.length; ++j) {
                if (!dataTypeSpecification.toString().equals(dataTypeMappingRuleArray[j].toString())) continue;
                return MessageFormat.format(Messages.getString("DataMapValidator.7"), dataTypeSpecification.toString());
            }
        }
        return null;
    }

    private static String validateName(DataTypeConversionMap dataTypeConversionMap, SupportedDataTypesMap supportedDataTypesMap) {
        DataTypeMappingRule[] dataTypeMappingRuleArray = dataTypeConversionMap.values().toArray(new DataTypeMappingRule[0]);
        for (int i = 0; i < dataTypeMappingRuleArray.length; ++i) {
            DataTypeSpecification dataTypeSpecification = dataTypeMappingRuleArray[i].getSourceDataType();
            boolean bl = false;
            for (DataTypeSpecification dataTypeSpecification2 : supportedDataTypesMap.getSourceDataTypes()) {
                if (!dataTypeSpecification2.getName().equals(dataTypeSpecification.getName())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return MessageFormat.format(Messages.getString("DataMapValidator.8"), dataTypeSpecification);
        }
        return null;
    }
}

