/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.objectviewer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.controls.display.EditableGridInfo;
import oracle.dbtools.raptor.controls.grid.GridCellUpdateInfo;
import oracle.dbtools.raptor.controls.grid.IRaptorGridCellUpdated;
import oracle.dbtools.raptor.controls.grid.IRaptorGridDelete;
import oracle.dbtools.raptor.controls.grid.IRaptorGridInsert;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdate;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.javatools.db.DBException;
import oracle.sql.DATE;
import oracle.sql.NUMBER;

public abstract class PersistentObjectUpdateActions
implements IRaptorGridCellUpdated,
IRaptorGridDelete,
IRaptorGridInsert,
IRaptorGridUpdate {
    protected static final Logger LOGGER = Logger.getLogger(PersistentObjectUpdateActions.class.getName());
    private Map<Integer, String> sColNumToAccessorNameMap = new HashMap<Integer, String>();
    private List<String> _log;

    protected abstract void initColNumToAccessorNameMap(Map<Integer, String> var1);

    protected abstract Class<? extends PersistableObject> getPersistableObjectClass();

    public GridCellUpdateInfo cellUpdated(String string, RaptorGridRowModel raptorGridRowModel, int n, int n2, Object object) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
        try {
            this.setExternalLog(list2);
            for (RaptorGridRowModel raptorGridRowModel : list) {
                if (!raptorGridRowModel.isDeleted()) continue;
                iRaptorTaskProgressUpdater.checkCanProceed();
                PersistableObject persistableObject = this.getPersistableObject(raptorGridRowModel);
                try {
                    persistableObject.delete(this.getPersistenceManager());
                }
                catch (PersistenceException persistenceException) {
                    this.log(persistenceException);
                    throw new ExecutionException(persistenceException);
                    return 0;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.log(runtimeException);
            throw new ExecutionException(runtimeException);
        }
        finally {
            this.setExternalLog(null);
        }
    }

    public int insertRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
        try {
            this.setExternalLog(list2);
            for (RaptorGridRowModel raptorGridRowModel : list) {
                if (!raptorGridRowModel.isUpdated()) continue;
                iRaptorTaskProgressUpdater.checkCanProceed();
                PersistableObject persistableObject = this.getPersistableObject(raptorGridRowModel);
                int n = raptorGridRowModel.getColumnCount();
                List list3 = raptorGridRowModel.getRow();
                for (int i = 0; i < n; ++i) {
                    RaptorGridCell raptorGridCell = (RaptorGridCell)list3.get(i);
                    if (!raptorGridCell.isUpdated()) continue;
                    String string2 = this.getAccessorName(i);
                    this.callAccessorForCell(persistableObject, string2, raptorGridCell);
                }
                try {
                    persistableObject.save(this.getPersistenceManager());
                }
                catch (PersistenceException persistenceException) {
                    this.log(persistenceException);
                    throw new ExecutionException(persistenceException);
                    return 0;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.log(runtimeException);
            throw new ExecutionException(runtimeException);
        }
        finally {
            this.setExternalLog(null);
        }
    }

    protected DBObjectId getId(RaptorGridRowModel raptorGridRowModel) throws SQLException {
        return this.getId(raptorGridRowModel, 0);
    }

    private PersistableObject getPersistableObject(RaptorGridRowModel raptorGridRowModel) throws ExecutionException {
        PersistableObject persistableObject = null;
        try {
            Method method = this.getAccessor(this.getPersistableObjectClass(), "retrieveExistingInstance");
            persistableObject = (PersistableObject)method.invoke(null, this.getPersistenceManager(), this.getId(raptorGridRowModel));
        }
        catch (Exception exception) {
            this.log(exception);
            throw new ExecutionException(exception);
        }
        return persistableObject;
    }

    private PersistenceManager getPersistenceManager() {
        return MigrationAddin.getPersistenceManager();
    }

    private DBObjectId getId(RaptorGridRowModel raptorGridRowModel, int n) throws SQLException {
        DBObjectId dBObjectId = null;
        dBObjectId = new DBObjectId(((NUMBER)((RaptorGridCell)raptorGridRowModel.getRow().get(n)).getCellData()).longValue());
        return dBObjectId;
    }

    private Map<Integer, String> getColNumToAccessorNameMap() {
        if (this.sColNumToAccessorNameMap.isEmpty()) {
            this.initColNumToAccessorNameMap(this.sColNumToAccessorNameMap);
        }
        return this.sColNumToAccessorNameMap;
    }

    private String getAccessorName(int n) {
        return this.getColNumToAccessorNameMap().get(n);
    }

    private void callAccessorForCell(PersistableObject persistableObject, String string, RaptorGridCell raptorGridCell) throws SQLException, ExecutionException {
        Throwable throwable;
        Method method = this.getAccessor(persistableObject, string);
        Object object = null;
        Class<?> clazz = method.getParameterTypes()[0];
        if (String.class == clazz) {
            object = raptorGridCell.getDisplayValue(Integer.MAX_VALUE);
        } else if (Integer.class == clazz) {
            var7_7 = raptorGridCell.getCellData();
            object = var7_7 instanceof NUMBER ? Integer.valueOf(((NUMBER)var7_7).intValue()) : (var7_7 instanceof String ? Integer.valueOf((String)var7_7) : var7_7);
        } else if (Date.class == clazz) {
            var7_7 = raptorGridCell.getCellData();
            if (var7_7 == null || var7_7.toString().equals("")) {
                object = null;
            } else if (var7_7 instanceof DATE) {
                object = ((DATE)var7_7).dateValue();
            } else {
                throwable = null;
                try {
                    throwable = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.getConnection())).getOraDATEFormat();
                    object = throwable.parse(var7_7.toString(), new ParsePosition(0)).dateValue();
                }
                catch (Exception exception) {
                    this.log(exception);
                    throw new ExecutionException(exception);
                }
            }
        } else if (DBObjectId.class == clazz) {
            object = new DBObjectId(((NUMBER)raptorGridCell.getCellData()).longValue());
        }
        try {
            method.invoke((Object)persistableObject, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log(illegalAccessException);
            throw new ExecutionException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getCause();
            this.log(throwable);
            throw new ExecutionException(throwable);
        }
    }

    private Method getAccessor(PersistableObject persistableObject, String string) {
        return this.getAccessor(persistableObject.getClass(), string);
    }

    private Method getAccessor(Class clazz, String string) {
        Method method = null;
        for (Method method2 : clazz.getDeclaredMethods()) {
            if (!string.equals(method2.getName())) continue;
            method = method2;
            break;
        }
        return method;
    }

    private void setExternalLog(List<String> list) {
        this._log = list;
    }

    protected void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
        if (this._log != null) {
            this._log.add(string);
        }
    }

    private Connection getConnection() {
        return this.getPersistenceManager().getConn();
    }

    public void setGridInfo(EditableGridInfo editableGridInfo) {
    }
}

