/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphTypeConverter;
import oracle.dss.graph.GraphUtils;
import oracle.dss.graph.Type;
import oracle.dss.graph.UIGraphType;
import oracle.dss.graph.gui.BasePanel;
import oracle.dss.graph.gui.GraphStandardStyles;
import oracle.dss.graph.gui.GraphTypeConverterAdapter;
import oracle.dss.graph.gui.StyleList;
import oracle.dss.graph.gui.StyleListEntry;
import oracle.dss.util.CustomStyle;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.persistence.CustomObjectManager;
import oracle.dss.util.persistence.ObjectBinding;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;

public class GraphStylePanel
extends BasePanel
implements ItemListener,
HelpContext {
    private ResourceBundle rBundle = null;
    private boolean isSetFocus = true;
    private boolean propertyChnageFlag = true;
    protected Graph m_Graph;
    protected StyleList m_styleList1;
    protected int m_iInitToIndex;
    protected Locale m_locale;
    protected Graph m_sampleGraph = new Graph();
    protected String m_applicationName;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh = null;
    protected JPanel m_samplePanel;
    protected JComboBox m_styleList;
    protected Vector m_styleVector = new Vector();
    protected Vector m_UIStyleVector = new Vector();
    protected CustomObjectManager m_customObjectManager = null;
    protected String m_strHelpContextID;
    protected CustomStyle m_customStyle = null;
    protected HelpProvider m_helpProvider;
    protected int m_graphType = -1;
    protected boolean isThreeDSetting = false;
    protected JCheckBox m_3DEffect;
    protected JCheckBox m_gradientEffect;
    private JPanel samplePanel;
    private JPanel superRightPanel;
    private FocusListener m_focusListener;
    private ListCellRenderer m_styleListCellRenderer;
    private ComponentAdapter m_compListener;
    private AncestorListener m_ancestorListener;
    private boolean m_b3DEffectChanged = false;
    private boolean m_bGradientEffectChanged = false;
    private boolean m_bStyleChanged = false;

    public GraphStylePanel(Graph graph) {
        super(graph);
        this.m_Graph = graph;
        this._initialize(graph);
    }

    @Override
    public void setGraph(Graph graph) {
        super.setGraph(graph);
        this.m_mainPanel.removeAll();
        this._initialize(graph);
    }

    public Graph getGraph() {
        return this.m_Graph;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_styleList.removeFocusListener(this.m_focusListener);
        this.m_focusListener = null;
        this.removeComponentListener(this.m_compListener);
        this.m_compListener = null;
        this.removeAncestorListener(this.m_ancestorListener);
        this.m_ancestorListener = null;
        this.m_samplePanel.removeAll();
    }

    public StyleList getStandardStyleList() {
        return GraphStandardStyles.getStandardStyleList();
    }

    private void _initSampleGraph() {
        this.m_sampleGraph.setEnabled(false);
        this.m_sampleGraph.setGroupTooltipLabelType(0);
        this.m_sampleGraph.setSeriesTooltipLabelType(0);
        this.m_sampleGraph.setMarkerTooltipType(0);
        this.m_sampleGraph.getTitle().setText(this.rBundle.getString("sampleTitle"));
        this.m_sampleGraph.getSubtitle().setText(this.rBundle.getString("sampleSubtitle"));
        this.m_sampleGraph.getFootnote().setText(this.rBundle.getString("sampleFootnote"));
        this.m_sampleGraph.getO1Title().setText(this.rBundle.getString("sampleO1AxisTitle"));
        this.m_sampleGraph.getX1Title().setText(this.rBundle.getString("sampleX1AxisTitle"));
        this.m_sampleGraph.getY1Title().setText(this.rBundle.getString("sampleY1AxisTitle"));
        this.m_sampleGraph.getY2Title().setText(this.rBundle.getString("sampleY2AxisTitle"));
        this.m_sampleGraph.getTitle().setVisible(true);
        this.m_sampleGraph.getSubtitle().setVisible(true);
        this.m_sampleGraph.getFootnote().setVisible(true);
        this.m_sampleGraph.getO1Title().setVisible(true);
        this.m_sampleGraph.getX1Title().setVisible(true);
        this.m_sampleGraph.getY1Title().setVisible(true);
        this.m_sampleGraph.getY2Title().setVisible(true);
        if (this.m_graph.getGraphTypeConverter() == null) {
            GraphTypeConverterAdapter graphTypeConverterAdapter = new GraphTypeConverterAdapter();
            this.m_graph.setGraphTypeConverter((GraphTypeConverter)graphTypeConverterAdapter);
            graphTypeConverterAdapter.setLocale(this.m_graph.getLocale());
        }
        this.m_graph.getGraphTypeConverter().setTypeAndSubtype((UIGraphType)this.m_sampleGraph, this.m_graph.getGraphTypeConverter().getTypeAndSubtype((UIGraphType)this.m_graph));
    }

    private void _initialize(Graph graph) {
        this.m_mainPanel.removeAll();
        if (graph != null) {
            this.setLocale(graph.getLocale());
        } else {
            this.updateResourceBundle(null);
        }
        this._initSampleGraph();
        this.m_styleList1 = this.getCustomStyleList();
        this._initStyleVectors(this.m_styleList1);
        this.m_iInitToIndex = this.m_styleList1.getStyleIndex(graph.getStylePath());
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        String translatedText = this.rBundle.getString("base title");
        this.setTitleText(translatedText);
        int iPanelWidth = this.getPreferredSize().width;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setAlignmentX(0.0f);
        JPanel stylePanel = new JPanel();
        stylePanel.setLayout(new BoxLayout(stylePanel, 0));
        stylePanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("style");
        JLabel styleLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        styleLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        styleLabel.setAlignmentX(0.0f);
        this.m_styleList = new JComboBox(this.m_styleVector);
        this.m_styleList.setName("Style");
        this.m_styleList.setSelectedIndex(this.m_iInitToIndex);
        this.m_styleList.setAlignmentX(0.0f);
        styleLabel.setLabelFor(this.m_styleList);
        this.m_styleList.setMinimumSize(this.m_styleList.getPreferredSize());
        this.m_styleList.setMaximumSize(this.m_styleList.getPreferredSize());
        this.m_styleList.addItemListener(this);
        stylePanel.add(styleLabel);
        stylePanel.add(Box.createHorizontalStrut(5));
        stylePanel.add(this.m_styleList);
        this.samplePanel = new JPanel();
        this.samplePanel.setAlignmentX(0.0f);
        this.samplePanel.setLayout(new BoxLayout(this.samplePanel, 0));
        translatedText = this.rBundle.getString("styleSample");
        JLabel sampleLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        JPanel sampleLabelPanel = new JPanel();
        sampleLabelPanel.setAlignmentX(0.0f);
        sampleLabelPanel.setLayout(new BoxLayout(sampleLabelPanel, 1));
        sampleLabelPanel.add(sampleLabel);
        sampleLabelPanel.add(Box.createVerticalGlue());
        int width = Math.max(styleLabel.getPreferredSize().width, sampleLabel.getPreferredSize().width);
        styleLabel.setPreferredSize(new Dimension(width, styleLabel.getPreferredSize().height));
        styleLabel.setMinimumSize(styleLabel.getPreferredSize());
        styleLabel.setMaximumSize(styleLabel.getPreferredSize());
        sampleLabel.setPreferredSize(new Dimension(width, sampleLabel.getPreferredSize().height));
        sampleLabel.setMinimumSize(sampleLabel.getPreferredSize());
        sampleLabel.setMaximumSize(sampleLabel.getPreferredSize());
        this.m_samplePanel = new JPanel();
        this.m_samplePanel.setAlignmentX(0.0f);
        this.m_samplePanel.setLayout(new BorderLayout());
        this.m_samplePanel.setBackground(Color.white);
        this.m_samplePanel.add((Component)this.m_sampleGraph, "Center");
        this.samplePanel.add(sampleLabelPanel);
        this.samplePanel.add(Box.createHorizontalStrut(5));
        this.samplePanel.add(this.m_samplePanel);
        mainPanel.add(stylePanel);
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(this.samplePanel);
        JPanel tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        tmpPanel.add(Box.createHorizontalStrut(width + 5));
        tmpPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Gradient Effect");
        this.m_gradientEffect = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_gradientEffect.setName("GradientEffect");
        this.m_gradientEffect.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_gradientEffect.setAlignmentX(0.0f);
        if (this.m_graph.getSeriesEffect() == 0) {
            this.m_gradientEffect.setSelected(false);
        } else {
            this.m_gradientEffect.setSelected(true);
        }
        this.m_gradientEffect.setVisible(!GraphUtils.isGradientDisabled((Graph)this.m_graph));
        this.m_gradientEffect.addItemListener(this);
        this.m_styleList.setNextFocusableComponent(this.m_gradientEffect);
        tmpPanel.add(this.m_gradientEffect);
        mainPanel.add(tmpPanel);
        tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        tmpPanel.add(Box.createHorizontalStrut(width + 5));
        tmpPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("3D Effect");
        this.m_3DEffect = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_3DEffect.setName("3DEffect");
        this.m_3DEffect.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_3DEffect.setAlignmentX(0.0f);
        this.m_3DEffect.setSelected(this.m_graph.is3DEffect());
        int type = this.m_graph.getGraphTypeConverter().getTypeAndSubtype((UIGraphType)this.m_graph).type;
        Type graphType = ((GraphTypeConverterAdapter)this.m_graph.getGraphTypeConverter()).getType(type);
        if (graphType.supports3D && graphType.supportsNon3D && this.m_graph.getGraphType() != 67 && this.m_graph.getGraphType() != 69) {
            this.m_3DEffect.setVisible(true);
        } else {
            this.m_3DEffect.setVisible(false);
        }
        this.m_b3DEffectChanged = false;
        this.m_3DEffect.addItemListener(this);
        tmpPanel.add(this.m_3DEffect);
        mainPanel.add(tmpPanel);
        this.m_mainPanel.add(mainPanel);
        this._init();
        this.m_compListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GraphStylePanel.this.setScaledFontSizes();
            }
        };
        this.addComponentListener(this.m_compListener);
        this.m_ancestorListener = new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                GraphStylePanel.this.setScaledFontSizes();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                GraphStylePanel.this.setScaledFontSizes();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        };
        this.addAncestorListener(this.m_ancestorListener);
    }

    protected void setScaledFontSizes() {
        float fontRatio = (float)this.m_samplePanel.getSize().height / 400.0f;
        this.m_sampleGraph.applyFontSizes(fontRatio);
    }

    private void updateResourceBundle(Locale loc) {
        this.m_locale = loc;
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    private void _init() {
        if (!this.m_UIStyleVector.isEmpty()) {
            Style tmpStyle = (Style)this.m_UIStyleVector.elementAt(this.m_iInitToIndex < 0 ? 0 : this.m_iInitToIndex);
            CustomStyle customStyle = tmpStyle.style;
            this.updateSampleGraph(customStyle);
        }
    }

    private void _initStyleVectors(StyleList styleList) {
        if (styleList == null) {
            return;
        }
        this.m_UIStyleVector.removeAllElements();
        this.m_styleVector.removeAllElements();
        for (int i = 0; i < styleList.size(); ++i) {
            String strName = "";
            String strPath = "";
            StyleListEntry entry = styleList.getStyleListEntry(i);
            CustomStyle cusStyle = new CustomStyle();
            strName = entry.getStyleName();
            cusStyle.setTitle(strName);
            strPath = entry.getStylePath();
            cusStyle.setXMLAsString(strPath);
            this.m_UIStyleVector.addElement(new Style(cusStyle, 0));
            this.m_styleVector.addElement(strName);
        }
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
        this.m_sampleGraph.setLocale(loc);
    }

    @Override
    public void apply() {
        try {
            boolean threeDEffect = this.m_Graph.is3DEffect();
            int gradientEffect = this.m_Graph.getSeriesEffect();
            if (this.m_bStyleChanged && !this.m_UIStyleVector.isEmpty()) {
                Style tmpStyle = (Style)this.m_UIStyleVector.elementAt(this.m_styleList.getSelectedIndex());
                CustomStyle customStyle = tmpStyle.style;
                String strPath = customStyle.getXMLAsString();
                this.m_Graph.setStylePath(strPath);
            }
            if (this.m_b3DEffectChanged) {
                this.m_Graph.set3DEffect(this.m_3DEffect.isSelected());
            } else if (this.m_bStyleChanged && this.m_Graph.is3DEffect() != threeDEffect) {
                this.m_Graph.set3DEffect(threeDEffect);
            }
            if (this.m_bGradientEffectChanged) {
                if (this.m_gradientEffect.isSelected()) {
                    this.m_Graph.setSeriesEffect(2);
                } else {
                    this.m_Graph.setSeriesEffect(0);
                }
            } else if (this.m_bStyleChanged && this.m_Graph.getSeriesEffect() != gradientEffect) {
                this.m_Graph.setSeriesEffect(gradientEffect);
            }
        }
        catch (IOException z) {
            System.out.println("error " + z.toString());
        }
        catch (BIParseException bpxp) {
            System.out.println("LineNumber " + bpxp.getLineNumber());
            System.out.println("ColumnNumber " + bpxp.getColumnNumber());
            System.out.println("error " + bpxp.toString());
        }
        catch (BIIOException bxp) {
            System.out.println("error " + bxp.toString());
        }
        catch (BISAXException bsxp) {
            System.out.println("SAX error in the XML " + bsxp.toString());
        }
    }

    private void addStyleToList(CustomStyle style) {
        this.addStyleToList(style, 0);
    }

    private void addStyleToList(CustomStyle style, int type) {
        if (style == null) {
            return;
        }
        this.m_UIStyleVector.addElement(new Style(style, type));
        this.m_styleVector.addElement(style.getTitle());
        this.m_styleList.addItem(style.getTitle());
    }

    private void insertStyleInList(CustomStyle style, int index) {
        if (style == null) {
            return;
        }
        this.m_UIStyleVector.insertElementAt(new Style(style, 0), index);
        this.m_styleVector.insertElementAt(style.getTitle(), index);
        this.m_styleList.insertItemAt(style.getTitle(), index);
    }

    private void removeStyleFromList(int index) {
        if (index >= this.m_UIStyleVector.size()) {
            return;
        }
        this.m_UIStyleVector.removeElementAt(index);
        this.m_styleVector.removeElementAt(index);
        this.m_styleList.removeItemAt(index);
    }

    private CustomStyle getStyleFromList(int index) {
        if (index >= this.m_UIStyleVector.size()) {
            return null;
        }
        Style tmpStyle = (Style)this.m_UIStyleVector.elementAt(index);
        CustomStyle customStyle = tmpStyle.style;
        return customStyle;
    }

    public void setCustomObjectManager(CustomObjectManager customObjectManager) {
        block8: {
            block7: {
                this.m_customObjectManager = customObjectManager;
                if (this.m_customStyle == null) break block7;
                Vector vector = customObjectManager.listAllObjects("GraphStyle");
                if (vector == null) break block8;
                for (int i = 0; i < vector.size(); ++i) {
                    CustomStyle tmpUIStyle = (CustomStyle)((ObjectBinding)vector.elementAt(i)).getObject();
                    String objectName = ((ObjectBinding)vector.elementAt(i)).getLabelName();
                    if (objectName.indexOf("/") != -1) {
                        tmpUIStyle.setTitle(objectName.substring(objectName.lastIndexOf("/") + 1, objectName.length()));
                    } else {
                        tmpUIStyle.setTitle(objectName);
                    }
                    this.addStyleToList(tmpUIStyle);
                }
                break block8;
            }
            Vector vector = customObjectManager.listAllObjects("GraphStyle");
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    CustomStyle tmpUIStyle = (CustomStyle)((ObjectBinding)vector.elementAt(i)).getObject();
                    String objectName = ((ObjectBinding)vector.elementAt(i)).getLabelName();
                    if (objectName.indexOf("/") != -1) {
                        tmpUIStyle.setTitle(objectName.substring(objectName.lastIndexOf("/") + 1, objectName.length()));
                    } else {
                        tmpUIStyle.setTitle(objectName);
                    }
                    this.addStyleToList(tmpUIStyle);
                }
            }
        }
    }

    public CustomObjectManager getCustomObjectManager() {
        return this.m_customObjectManager;
    }

    @Override
    public Dimension getPreferredSize() {
        int width = Integer.parseInt(this.rBundle.getString("GraphStylePanelWidth"));
        int height = Integer.parseInt(this.rBundle.getString("GraphStylePanelHeight"));
        return new Dimension(width, height);
    }

    public void setApplicationName(String name) {
        this.m_applicationName = name;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_styleList) {
            this.m_bStyleChanged = true;
            int i = this.m_styleList.getSelectedIndex();
            if (!this.m_UIStyleVector.isEmpty()) {
                CustomStyle customStyle;
                Style tmpStyle = (Style)this.m_UIStyleVector.elementAt(i);
                this.m_customStyle = customStyle = tmpStyle.style;
                if (customStyle == null) {
                    this.m_samplePanel.removeAll();
                    JLabel tmpLabel = new JLabel(this.rBundle.getString("No Sample"));
                    this.m_samplePanel.add((Component)tmpLabel, "Center");
                } else {
                    this.updateSampleGraph(customStyle);
                }
            } else {
                this.m_samplePanel.removeAll();
                JLabel tmpLabel = new JLabel(this.rBundle.getString("No Sample"));
                this.m_samplePanel.add((Component)tmpLabel, "Center");
            }
        } else if (e.getSource() == this.m_3DEffect) {
            this.m_b3DEffectChanged = true;
            this.m_sampleGraph.set3DEffect(this.m_3DEffect.isSelected());
        } else {
            this.m_bGradientEffectChanged = true;
            if (this.m_gradientEffect.isSelected()) {
                this.m_sampleGraph.setSeriesEffect(2);
            } else {
                this.m_sampleGraph.setSeriesEffect(0);
            }
        }
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    @Override
    public String getHelpContextID() {
        return "oracle.dss.graph.gui.GraphStylePanel";
    }

    @Override
    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public StyleList getCustomStyleList() {
        if (this.m_styleList1 == null) {
            this.m_styleList1 = GraphStandardStyles.getStandardStyleList();
        }
        this.updateCustomStyleList();
        return this.m_styleList1;
    }

    public void setCustomStyleList(StyleList map) {
        this.m_styleList1 = new StyleList(map);
        this.m_styleList1.addRequiredStyles();
        this.updateCustomStyleList();
    }

    private void updateCustomStyleList() {
        if (this.m_styleList1 != null) {
            this.m_styleList1.setLocale(this.m_locale);
        }
    }

    private void updateSampleGraph(CustomStyle customStyle) {
        try {
            String strPath = customStyle.getXMLAsString();
            this.m_sampleGraph.setStylePath(strPath);
            this.setScaledFontSizes();
            if (this.m_sampleGraph.getGraphType() != this.m_graphType) {
                this.m_graphType = this.m_Graph.getGraphType();
                this.m_sampleGraph.setGraphType(this.m_graphType);
            }
            this._initSampleGraph();
            this.m_sampleGraph.set3DEffect(this.m_3DEffect.isSelected());
            if (this.m_gradientEffect.isSelected()) {
                this.m_sampleGraph.setSeriesEffect(2);
            } else {
                this.m_sampleGraph.setSeriesEffect(0);
            }
            boolean visible = true;
            if (this.m_graphType >= 0 && this.m_graphType <= 14) {
                visible = false;
            }
            this.m_sampleGraph.getY1Title().setVisible(visible);
        }
        catch (IOException z) {
            System.out.println("error " + z.toString());
        }
        catch (BIParseException bpxp) {
            System.out.println("LineNumber " + bpxp.getLineNumber());
            System.out.println("ColumnNumber " + bpxp.getColumnNumber());
            System.out.println("error " + bpxp.toString());
        }
        catch (BIIOException bxp) {
            System.out.println("error " + bxp.toString());
        }
        catch (BISAXException bsxp) {
            System.out.println("SAX error in the XML " + bsxp.toString());
        }
    }

    class Style {
        CustomStyle style;
        int type = 0;

        public Style(CustomStyle s, int t) {
            this.style = s;
            this.type = t;
        }
    }

    class StyleListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private JLabel m_label = new JLabel();

        public StyleListCellRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.m_label);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setPreferredSize(new Dimension(this.getToolkit().getFontMetrics(this.m_label.getFont()).stringWidth((String)value) + 20, 18));
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.m_label.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.m_label.setForeground(list.getForeground());
            }
            this.m_label.setText((String)value);
            this.getAccessibleContext().setAccessibleName((String)value);
            return this;
        }
    }
}

