/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.adf.share.mt.util.MultiTenantStorage;
import oracle.adfdtinternal.model.dvt.util.gui.BIFontPane;
import oracle.adfdtinternal.model.dvt.util.gui.FontButton;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.olaf.BrowserLookAndFeel;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.gui.FormatPreviewArea;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphUtils;
import oracle.dss.graph.gui.GraphNumberFormatPanel;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public class FormatButtonDialog
extends JDialog
implements ActionListener,
PropertyChangeListener,
ItemListener,
HelpContext {
    protected JPanel m_formatPanel;
    protected BIFontPane m_fontPane;
    protected GraphNumberFormatPanel m_numberPanel;
    protected GraphNumberFormatPanel m_x1NumberPanel;
    protected GraphNumberFormatPanel m_y2NumberPanel;
    protected JCheckBox m_y2CheckBox;
    protected JTabbedPane m_tabbedPane;
    protected FormatPreviewArea m_preview = null;
    protected FormatPreviewArea m_y2Preview = null;
    protected FormatPreviewArea m_x1Preview = null;
    protected Graph m_graph;
    protected int m_component;
    protected Color m_foreground = Color.black;
    protected Color m_background = Color.white;
    protected Font m_font = null;
    protected boolean m_underline = false;
    protected boolean m_y1SameAsY2 = false;
    protected int m_horizontalAlignment;
    protected int m_verticalAlignment;
    protected int m_textRotation = 0;
    protected int m_textRotationMask = 0;
    protected Locale m_locale = null;
    protected HelpProvider m_helpProvider;
    protected boolean m_customColorsEnabled = false;
    public static final String PROPERTY_CANCELLED = "fontDialogCancelled";
    private static MultiTenantStorage<ArrayTwoDModel> m_colorPalette = new MultiTenantStorage();
    @CodeSharingSafe(value="StaticField")
    private static Color[][] m_defaultColorArray = null;
    private static MultiTenantStorage<AtomicInteger> m_currentColumn = new MultiTenantStorage<AtomicInteger>(){

        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    };
    private Color[][] m_colors;
    private static MultiTenantStorage<ArrayTwoDModel> m_cPalette = new MultiTenantStorage();
    private boolean m_bColorPaletteSet = false;
    private boolean m_isOK = false;
    private boolean m_bHelpEnabled = true;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    protected int m_initialWidth;
    protected int m_initialHeight;
    protected String m_strHelpContextID;
    protected int m_visibleStyle = 15;
    protected int m_visibleAlignment = 479;
    protected int m_visibleColor = 7;
    private final Border _sBorder = new EmptyBorder(6, 6, 8, 5);
    private final Border _sBorderButtons = new EmptyBorder(8, 10, 0, 10);
    private ResourceBundle rBundle = null;

    public FormatButtonDialog(Frame parentFrame, Graph graph, int component) {
        super(parentFrame);
        this.m_graph = graph;
        this.m_component = component;
        if (parentFrame != null) {
            this.updateResourceBundle(parentFrame.getLocale());
        } else {
            this.updateResourceBundle(graph.getLocale());
        }
        this.setModal(true);
        this._initialize();
        this.init();
        this.pack();
        this.m_initialWidth = this.getWidth();
        this.m_initialHeight = this.getHeight();
    }

    private void _initialize() {
        String tab;
        this.m_formatPanel = new JPanel();
        this.m_tabbedPane = new JTabbedPane();
        this.m_fontPane = new BIFontPane();
        this.m_fontPane.addPropertyChangeListener(this);
        this.m_fontPane.setPreviewAreaVisible(false);
        this.m_tabbedPane.add(this.rBundle.getString("TabFont"), (Component)((Object)this.m_fontPane));
        switch (this.m_component) {
            case 41: {
                this.m_numberPanel = new GraphNumberFormatPanel(this.m_graph.getX1Axis().getViewFormat());
                break;
            }
            case 46: {
                this.m_numberPanel = new GraphNumberFormatPanel((ViewFormat)this.m_graph.getY1Axis().getViewFormat().clone());
                break;
            }
            case 51: {
                this.m_numberPanel = new GraphNumberFormatPanel(this.m_graph.getY2Axis().getViewFormat());
                break;
            }
            case 33: {
                this.m_numberPanel = new GraphNumberFormatPanel(this.m_graph.getSliceLabel().getViewFormat());
                break;
            }
            case 21: {
                this.m_numberPanel = new GraphNumberFormatPanel(this.m_graph.getMarkerText().getViewFormat(1));
                if (GraphUtils.isScatterGraph((int)this.m_graph.getGraphType())) {
                    this.m_x1NumberPanel = new GraphNumberFormatPanel(this.m_graph.getMarkerText().getViewFormat(0));
                }
                if (!this.m_graph.isDualY()) break;
                this.m_y2NumberPanel = new GraphNumberFormatPanel(this.m_graph.getMarkerText().getViewFormat(2));
                this.m_y2CheckBox = new JCheckBox("Format Labels Same as Y1");
            }
        }
        if (this.m_x1NumberPanel != null) {
            this.m_x1NumberPanel.setGraphFormatType();
            tab = this.rBundle.getString("TabX1Number");
            this.m_tabbedPane.add(tab, this.m_x1NumberPanel);
            this.m_x1Preview = new FormatPreviewArea(this.m_fontPane, this.m_x1NumberPanel);
        }
        if (this.m_numberPanel != null) {
            this.m_numberPanel.setGraphFormatType();
            tab = this.rBundle.getString("TabNumber");
            if (this.m_x1NumberPanel != null || this.m_y2NumberPanel != null) {
                tab = this.rBundle.getString("TabY1Number");
            }
            this.m_tabbedPane.add(tab, this.m_numberPanel);
            this.m_preview = new FormatPreviewArea(this.m_fontPane, this.m_numberPanel);
        }
        if (this.m_y2NumberPanel != null) {
            JPanel y2Panel = new JPanel();
            y2Panel.setLayout(new BoxLayout(y2Panel, 1));
            y2Panel.add(this.m_y2CheckBox);
            y2Panel.add(this.m_y2NumberPanel);
            this.m_y2NumberPanel.setGraphFormatType();
            this.m_tabbedPane.add(this.rBundle.getString("TabY2Number"), y2Panel);
            this.m_y2Preview = new FormatPreviewArea(this.m_fontPane, this.m_y2NumberPanel);
            this.m_y2CheckBox.addItemListener(this);
            this.m_y2CheckBox.setAlignmentX(0.0f);
            this.m_y2NumberPanel.setAlignmentX(0.0f);
        }
        this.m_formatPanel.setLayout(new BoxLayout(this.m_formatPanel, 1));
        this.m_formatPanel.add(this.m_tabbedPane);
        this.m_formatPanel.add(Box.createVerticalStrut(10));
        this.m_formatPanel.add(new JLabel(this.rBundle.getString("Sample")));
        if (this.m_y2Preview == null && this.m_x1Preview == null) {
            this.m_formatPanel.add((Component)((Object)this.m_preview));
        } else {
            JPanel previewPanel = new JPanel();
            previewPanel.setLayout(new BoxLayout(previewPanel, 0));
            if (this.m_x1Preview != null) {
                previewPanel.add((Component)((Object)this.m_x1Preview));
            }
            previewPanel.add((Component)((Object)this.m_preview));
            if (this.m_y2Preview != null) {
                previewPanel.add((Component)((Object)this.m_y2Preview));
            }
            this.m_formatPanel.add(previewPanel);
        }
        this.m_tabbedPane.setAlignmentX(0.0f);
    }

    private void init() {
        this.m_initialWidth = -1;
        this.m_initialHeight = -1;
        JComponent content = (JComponent)this.getContentPane();
        content.setLayout(new BoxLayout(content, 1));
        content.setBorder(this._sBorder);
        if (UIManager.getLookAndFeel() instanceof BrowserLookAndFeel) {
            content.setBackground(UIManager.getColor("MenuBar.background"));
        } else if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
            content.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
        }
        GrayPane gp = new GrayPane((Component)this.m_formatPanel);
        content.add((Component)gp);
        DialogButtonBar buttonPanel = new DialogButtonBar();
        buttonPanel.setBorder(this._sBorderButtons);
        if (this.m_bHelpEnabled) {
            String translatedText = this.rBundle.getString("Help");
            this.helpButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            buttonPanel.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
            this.helpButton.addActionListener(this);
            this.helpButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(112, 0), 2);
        }
        JPanel buttonPanel_east = new JPanel();
        this.okButton = new JButton(this.rBundle.getString("OK"));
        buttonPanel.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
        this.okButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton(this.rBundle.getString("Cancel"));
        buttonPanel.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
        this.cancelButton.addActionListener(this);
        this.cancelButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
        this.getContentPane().add((Component)buttonPanel);
        this.setResizable(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int originalHeight;
                int originalWidth;
                int width = originalWidth = FormatButtonDialog.this.getWidth();
                int height = originalHeight = FormatButtonDialog.this.getHeight();
                if (FormatButtonDialog.this.m_initialWidth != -1) {
                    width = Math.max(FormatButtonDialog.this.m_initialWidth, width);
                }
                if (FormatButtonDialog.this.m_initialHeight != -1) {
                    height = Math.max(FormatButtonDialog.this.m_initialHeight, height);
                }
                if (originalWidth != width || originalHeight != height) {
                    FormatButtonDialog.this.setSize(width, height);
                }
                FormatButtonDialog.this.validate();
            }
        });
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_y2CheckBox) {
            this.m_y1SameAsY2 = this.m_y2CheckBox.isSelected();
            if (this.m_y1SameAsY2) {
                this.m_y2Preview.setNumberFormatPanel(this.m_numberPanel);
            } else {
                this.m_y2Preview.setNumberFormatPanel(this.m_y2NumberPanel);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.applyFontPane();
            this.firePropertyChange(PROPERTY_CANCELLED, Boolean.TRUE, Boolean.FALSE);
            this.m_isOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.cancelButton) {
            this.firePropertyChange(PROPERTY_CANCELLED, Boolean.FALSE, Boolean.TRUE);
            this.m_isOK = false;
            this.setVisible(false);
        } else if (e.getSource() == this.helpButton) {
            try {
                Component _selected = this.m_tabbedPane.getSelectedComponent();
                if (_selected != null && _selected instanceof Component) {
                    if (this.getHelpProvider() != null) {
                        this.getHelpProvider().showHelp(_selected);
                    } else if (HelpUtils.getDefaultHelpProvider() != null) {
                        HelpUtils.getDefaultHelpProvider().showHelp(_selected);
                    }
                }
            }
            catch (HelpUnavailableException helpUnavailableException) {
                // empty catch block
            }
        }
    }

    public void applyViewFormat() {
        if (!this.m_isOK) {
            return;
        }
        switch (this.m_component) {
            case 41: {
                this.m_graph.getX1Axis().setViewFormat(this.m_numberPanel.apply());
                break;
            }
            case 46: {
                this.m_graph.getY1Axis().setViewFormat(this.m_numberPanel.apply());
                break;
            }
            case 51: {
                this.m_graph.getY2Axis().setViewFormat(this.m_numberPanel.apply());
                break;
            }
            case 33: {
                this.m_graph.getSliceLabel().setViewFormat(this.m_numberPanel.apply());
                break;
            }
            case 21: {
                ViewFormat vf = this.m_numberPanel.apply();
                this.m_graph.getMarkerText().setViewFormat(vf, 1);
                if (this.m_x1NumberPanel != null) {
                    this.m_graph.getMarkerText().setViewFormat(this.m_x1NumberPanel.apply(), 0);
                }
                if (!this.m_graph.isDualY()) break;
                if (this.m_y1SameAsY2) {
                    this.m_graph.getMarkerText().setViewFormat((ViewFormat)vf.clone(), 2);
                    break;
                }
                this.m_graph.getMarkerText().setViewFormat(this.m_y2NumberPanel.apply(), 2);
            }
        }
    }

    public void cleanUp() {
        this.m_numberPanel.cleanUp();
        if (this.m_x1NumberPanel != null) {
            this.m_x1NumberPanel.cleanUp();
        }
        if (this.m_y2NumberPanel != null) {
            this.m_y2NumberPanel.cleanUp();
        }
        m_colorPalette.set(null);
        m_cPalette.set(null);
        this.m_fontPane = null;
        if (this.m_y2CheckBox != null) {
            this.m_y2CheckBox.removeItemListener(this);
        }
        this.okButton.removeActionListener(this);
        this.cancelButton.removeActionListener(this);
        this.helpButton.removeActionListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName == "fontHorizontalAlignment") {
            int oldAlignment = (Integer)e.getOldValue();
            int newAlignment = (Integer)e.getNewValue();
            this.firePropertyChange(propertyName, (Object)this.convertBaliHAlignmentToSwing(oldAlignment), (Object)this.convertBaliHAlignmentToSwing(newAlignment));
        } else if (propertyName == "fontVerticalAlignment") {
            int oldAlignment = (Integer)e.getOldValue();
            int newAlignment = (Integer)e.getNewValue();
            this.firePropertyChange(propertyName, (Object)this.convertBaliVAlignmentToSwing(oldAlignment), (Object)this.convertBaliVAlignmentToSwing(newAlignment));
        } else {
            this.firePropertyChange(propertyName, e.getOldValue(), e.getNewValue());
        }
    }

    public void setCustomColorsEnabled(boolean enabled) {
        this.m_customColorsEnabled = enabled;
    }

    public void setColorPalette(Color[][] colors) {
        this.m_colors = colors;
        if (this.m_colors != null) {
            m_cPalette.set((Object)FormatButtonDialog.getArrayTwoDModel(colors));
            this.m_bColorPaletteSet = true;
        } else {
            this.m_bColorPaletteSet = false;
            m_cPalette.set(null);
        }
        if (this.m_fontPane != null) {
            this.setColorPaletteOnChoices();
        }
    }

    public Color[][] getColorPalette() {
        if (this.m_colors != null) {
            return this.m_colors;
        }
        if (this.m_fontPane != null) {
            return FormatButtonDialog.getColorArray(this.m_fontPane.getFontColorChoice().getColorPalette());
        }
        return FormatButtonDialog.getDefaultColorArray();
    }

    public void setColorPalette(ArrayTwoDModel model) {
        this.m_bColorPaletteSet = model != null;
        m_cPalette.set((Object)model);
        if (this.m_fontPane != null) {
            this.setColorPaletteOnChoices();
        }
    }

    public static ArrayTwoDModel getArrayTwoDModel(Color[][] colors) {
        int rows = colors.length;
        int columns = colors[0].length;
        ArrayTwoDModel cp = new ArrayTwoDModel(columns, rows);
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < columns; ++i) {
                cp.setData(i, j, (Object)colors[j][i]);
            }
        }
        return cp;
    }

    public static Color[][] getColorArray(TwoDModel model) {
        Color[][] colors = new Color[model.getRowCount()][model.getColumnCount()];
        for (int i = 0; i < model.getRowCount(); ++i) {
            for (int j = 0; j < model.getColumnCount(); ++j) {
                colors[i][j] = (Color)model.getData(j, i);
            }
        }
        return colors;
    }

    public static Color[][] getDefaultColorArray() {
        if (m_defaultColorArray == null) {
            ColorChoice choice = new ColorChoice();
            m_defaultColorArray = FormatButtonDialog.getColorArray(choice.getColorPalette());
            Object var0 = null;
        }
        return m_defaultColorArray;
    }

    private void setColorPaletteOnChoices() {
        ColorChoice fChoice = this.m_fontPane.getFontColorChoice();
        if (this.m_foreground != null) {
            fChoice.setSelectedColor((Color)fChoice.getColorPalette().getData(0, 0));
            fChoice.setColorPalette((TwoDModel)m_cPalette.get());
            if (!this.m_bColorPaletteSet) {
                if (!ColorChoice.isColorInPalette((TwoDModel)fChoice.getColorPalette(), (Color)this.m_foreground)) {
                    fChoice.setColorPalette(FontButton.getNewColorPalette(fChoice.getColorPalette(), this.m_foreground, this.m_bColorPaletteSet));
                }
                fChoice.setSelectedColor(this.m_foreground);
            } else {
                fChoice.setSelectedColor(fChoice.getClosestColor(this.m_foreground));
            }
        } else {
            fChoice.setColorPalette((TwoDModel)m_cPalette.get());
        }
        ColorChoice bChoice = this.m_fontPane.getFontBackgroundColorChoice();
        if (this.m_background != null) {
            bChoice.setSelectedColor((Color)bChoice.getColorPalette().getData(0, 0));
            bChoice.setColorPalette((TwoDModel)m_cPalette.get());
            if (!this.m_bColorPaletteSet) {
                if (!ColorChoice.isColorInPalette((TwoDModel)bChoice.getColorPalette(), (Color)this.m_background)) {
                    bChoice.setColorPalette(FontButton.getNewColorPalette(bChoice.getColorPalette(), this.m_background, this.m_bColorPaletteSet));
                }
                bChoice.setSelectedColor(this.m_background);
            } else {
                bChoice.setSelectedColor(bChoice.getClosestColor(this.m_background));
            }
        } else {
            bChoice.setColorPalette((TwoDModel)m_cPalette.get());
        }
    }

    public static TwoDModel getNewColorPalette(TwoDModel model, Color c, boolean createNew) {
        int j;
        int rowCount = model.getRowCount();
        int columnCount = model.getColumnCount();
        if (m_colorPalette.get() == null || createNew) {
            ArrayTwoDModel colorPalette = new ArrayTwoDModel(columnCount, rowCount + 1);
            for (j = 0; j < rowCount; ++j) {
                for (int i = 0; i < columnCount; ++i) {
                    colorPalette.setData(i, j, model.getData(i, j));
                }
            }
            for (int k = 0; k < columnCount; ++k) {
                colorPalette.setData(k, rowCount, (Object)Color.white);
            }
            if (createNew) {
                colorPalette.setData(0, colorPalette.getRowCount() - 1, (Object)c);
                return colorPalette;
            }
            m_colorPalette.set((Object)colorPalette);
        }
        for (j = 0; j < ((ArrayTwoDModel)m_colorPalette.get()).getColumnCount(); ++j) {
            if (!c.equals(((ArrayTwoDModel)m_colorPalette.get()).getData(j, ((ArrayTwoDModel)m_colorPalette.get()).getRowCount() - 1))) continue;
            return (TwoDModel)m_colorPalette.get();
        }
        if (((AtomicInteger)m_currentColumn.get()).get() == columnCount) {
            m_currentColumn.set((Object)new AtomicInteger(0));
        }
        int count = ((AtomicInteger)m_currentColumn.get()).get();
        ((ArrayTwoDModel)m_colorPalette.get()).setData(count++, ((ArrayTwoDModel)m_colorPalette.get()).getRowCount() - 1, (Object)c);
        m_currentColumn.set((Object)new AtomicInteger(count));
        return (TwoDModel)m_colorPalette.get();
    }

    public void initFontPane() {
        this.m_fontPane.setCustomColorsEnabled(this.m_customColorsEnabled);
        if (this.m_bColorPaletteSet) {
            this.setColorPaletteOnChoices();
        }
        ColorChoice choice = this.m_fontPane.getFontBackgroundColorChoice();
        if (!this.m_bColorPaletteSet) {
            if (!ColorChoice.isColorInPalette((TwoDModel)choice.getColorPalette(), (Color)this.m_background)) {
                choice.setColorPalette(FormatButtonDialog.getNewColorPalette(choice.getColorPalette(), this.m_background, this.m_bColorPaletteSet));
            }
            choice.setSelectedColor(this.m_background);
        } else {
            choice.setSelectedColor(choice.getClosestColor(this.m_background));
        }
        if (!this.m_bColorPaletteSet) {
            choice = this.m_fontPane.getFontColorChoice();
            if (!ColorChoice.isColorInPalette((TwoDModel)choice.getColorPalette(), (Color)this.m_foreground)) {
                choice.setColorPalette(FormatButtonDialog.getNewColorPalette(choice.getColorPalette(), this.m_foreground, this.m_bColorPaletteSet));
            }
            choice.setSelectedColor(this.m_foreground);
        } else {
            choice.setSelectedColor(choice.getClosestColor(this.m_foreground));
        }
        this.m_fontPane.setStyleButtonMask(this.m_visibleStyle);
        this.m_fontPane.setAlignmentButtonMask(this.m_visibleAlignment);
        this.m_fontPane.setColorComponentMask(this.m_visibleColor);
        this.m_fontPane.setRotationButtonMask(this.m_textRotationMask);
        if (this.m_font != null) {
            try {
                this.m_fontPane.setFontName(this.m_font.getName());
            }
            catch (IllegalArgumentException iae) {
                String[] oldFontNames = this.m_fontPane.getFontNames();
                String[] newFontNames = new String[oldFontNames.length + 1];
                boolean bDoneSorting = false;
                int i = 0;
                for (int j = 0; j < newFontNames.length; ++j) {
                    if (bDoneSorting || i < oldFontNames.length && this.m_font.getName().compareTo(oldFontNames[i]) > 0) {
                        newFontNames[j] = oldFontNames[i];
                        ++i;
                        continue;
                    }
                    newFontNames[j] = this.m_font.getName();
                    bDoneSorting = true;
                }
                this.m_fontPane.setFontNames(newFontNames);
                this.m_fontPane.setFontName(this.m_font.getName());
            }
            this.m_fontPane.setFontStyle(this.m_font.getStyle());
            if (this.m_underline) {
                this.m_fontPane.setFontStyle(this.m_fontPane.getFontStyle() | 4);
            }
            this.m_fontPane.setFontSize(this.m_font.getSize());
        }
        if (this.m_foreground != null) {
            this.m_fontPane.setFontColor(this.m_foreground);
        }
        if (this.m_background != null) {
            this.m_fontPane.setFontBackgroundColor(this.m_background);
        }
        int alignment = switch (this.m_horizontalAlignment) {
            case 2 -> 2;
            case 4 -> 4;
            case 10 -> 10;
            default -> 0;
        };
        this.m_fontPane.setFontHorizontalAlignment(alignment);
        switch (this.m_verticalAlignment) {
            case 1: {
                alignment = 1;
                break;
            }
            case 3: {
                alignment = 3;
                break;
            }
            default: {
                alignment = 0;
            }
        }
        this.m_fontPane.setFontVerticalAlignment(alignment);
        this.m_fontPane.setTextRotation(this.m_textRotation);
    }

    public void applyFontPane() {
        if (!this.m_foreground.equals(this.m_fontPane.getFontColor())) {
            this.m_foreground = this.m_fontPane.getFontColor();
        }
        if (!this.m_background.equals(this.m_fontPane.getFontBackgroundColor())) {
            this.m_background = this.m_fontPane.getFontBackgroundColor();
        }
        if (!this.m_font.equals(this.m_fontPane.getCurrentFont())) {
            this.m_font = this.m_fontPane.getCurrentFont();
        }
        if (this.m_textRotation != this.m_fontPane.getTextRotation()) {
            this.m_textRotation = this.m_fontPane.getTextRotation();
        }
        this.m_horizontalAlignment = this.convertBaliHAlignmentToSwing(this.m_fontPane.getFontHorizontalAlignment());
        this.m_verticalAlignment = this.convertBaliVAlignmentToSwing(this.m_fontPane.getFontVerticalAlignment());
        this.m_underline = this.m_fontPane.getFontStyle() - this.m_font.getStyle() == 4;
        if (this.m_fontPane.getFontStyle() - this.m_font.getStyle() == 12) {
            this.m_underline = true;
        }
    }

    public void setRotationButtonMask(int buttonMask) {
        this.m_textRotationMask = buttonMask;
    }

    public void setStyleButtonMask(int style) {
        this.m_visibleStyle = style;
    }

    public void setAlignmentButtonMask(int alignment) {
        this.m_visibleAlignment = alignment;
    }

    public void setColorComponentMask(int buttons) {
        this.m_visibleColor = buttons;
    }

    public boolean isUnderlineStyle() {
        return this.m_underline;
    }

    public void setUnderlineStyle(boolean yesNo) {
        this.m_underline = yesNo;
    }

    public int getTextRotation() {
        return this.m_textRotation;
    }

    public void setTextRotation(int rotation) {
        this.m_textRotation = rotation;
    }

    public Font getComponentFont() {
        return this.m_font;
    }

    public void setComponentFont(Font f) {
        this.m_font = f;
    }

    public int getPaneHorizontalAlignment() {
        return this.m_horizontalAlignment;
    }

    public void setPaneHorizontalAlignment(int alignment) {
        this.m_horizontalAlignment = alignment;
    }

    public int getPaneVerticalAlignment() {
        return this.m_verticalAlignment;
    }

    public void setPaneVerticalAlignment(int alignment) {
        this.m_verticalAlignment = alignment;
    }

    public Color getComponentForeground() {
        return this.m_foreground;
    }

    public void setComponentForeground(Color c) {
        if (this.m_fontPane != null) {
            ColorChoice choice = this.m_fontPane.getFontColorChoice();
            if (!this.m_bColorPaletteSet) {
                if (!ColorChoice.isColorInPalette((TwoDModel)choice.getColorPalette(), (Color)c)) {
                    choice.setColorPalette(FormatButtonDialog.getNewColorPalette(choice.getColorPalette(), c, this.m_bColorPaletteSet));
                }
                choice.setSelectedColor(c);
            } else {
                this.m_foreground = choice.getClosestColor(c);
                choice.setSelectedColor(this.m_foreground);
            }
        }
        this.m_foreground = c;
    }

    public Color getComponentBackground() {
        return this.m_background;
    }

    public void setComponentBackground(Color c) {
        if (this.m_fontPane != null) {
            ColorChoice choice = this.m_fontPane.getFontBackgroundColorChoice();
            if (!this.m_bColorPaletteSet) {
                if (!ColorChoice.isColorInPalette((TwoDModel)choice.getColorPalette(), (Color)c)) {
                    choice.setColorPalette(FormatButtonDialog.getNewColorPalette(choice.getColorPalette(), c, this.m_bColorPaletteSet));
                }
                choice.setSelectedColor(c);
            } else {
                this.m_background = choice.getClosestColor(c);
                choice.setSelectedColor(this.m_background);
            }
        }
        this.m_background = c;
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    @Override
    public String getHelpContextID() {
        return this.getClass().getName();
    }

    @Override
    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    protected int convertBaliHAlignmentToSwing(int fPane) {
        int alignment = 0;
        switch (fPane) {
            case 2: {
                alignment = 2;
                break;
            }
            case 4: {
                alignment = 4;
                break;
            }
            case 10: {
                alignment = 10;
                break;
            }
            default: {
                alignment = 0;
            }
        }
        return alignment;
    }

    protected int convertBaliVAlignmentToSwing(int fPane) {
        int alignment = 0;
        switch (fPane) {
            case 1: {
                alignment = 1;
                break;
            }
            case 3: {
                alignment = 3;
                break;
            }
            default: {
                alignment = 0;
            }
        }
        return alignment;
    }
}

