/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.awt.Window;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dmt.dataminer.core.utils.Strings;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.ApplyChainNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.preferences.ColumnFilterPreferencesPanel;
import oracle.dmt.dataminer.workflow.xmlschema.AttrImportantSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterReasonEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.DataQualitySettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Version;

public final class ColumnFilterNode
extends AbstractTransformNode
implements ApplyChainNode,
DataConsumer {
    public static final String COLUMN_FILTER_SETTINGS = "ColumnFilterSettings";
    public static final String COLUMN_FILTER_ATTRIBUTES = "ColumnFilterAttributes";
    public static final String AUTO_FILTERING = "autoFiltering";
    public static final String AUTO_REMOVE = "autoRemoveAttrs";
    public static final String ATTR_FILTERING = "attrFiltering";
    public static final String ATTR_OUTPUT = "attrOutput";
    public static final String ATTR_OUTPUTS = "attrOutputs";
    public static final String NULL_PERCENT = "nullPercent";
    public static final String UNIQUE_PERCENT = "uniquePercent";
    public static final String CONSTANT_PERCENT = "constantPercent";
    public static final String TARGET = "target";
    public static final String IMPORTANCE = "importance";
    public static final String RANK = "rank";
    public static final String SAMPLE_SIZE = "sampleSize";
    public static final String SAMPLING_TYPE = "samplingType";
    public static final String STRATIFIED_CUTOFF = "stratifiedCutoff";
    public static final String AI_TABLE = "AttrImportanceTable";
    public static final String AI_TABLE_GEN = "GenImportanceTable";
    public static final String AI_TABLE_NULL = "NULL";
    public static final String SAMPLE_ENABLED = "sampleEnabled";
    public static final String ATTR_DEPENDENCY = "AttrDependency";
    public static final String FILTER_RESULTS = "FILTER_RESULTS";
    private Map<String, String> ouputCopyLookupMap = new HashMap<String, String>();
    private Map<String, String> reasonHintsLookupMap = new HashMap<String, String>();
    private Map<String, Statistics> statisticLookupMap = new HashMap<String, Statistics>();

    public ColumnFilterNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadResults() throws Exception {
        try (SQLHelper sQLHelper = new SQLHelper();){
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
            ColumnFilterResultType columnFilterResultType = columnFilterNodeType.getColumnFilterResults();
            if (columnFilterResultType != null) {
                Statistics statistics;
                Double d;
                Integer n;
                String string;
                String string2;
                this.statisticLookupMap.clear();
                String string3 = columnFilterResultType.getAttrImportanceOutput();
                String string4 = columnFilterResultType.getDataQualityOutput();
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
                String string5 = connectionFolder.getUserAccountName();
                if (string3 != null && DatabaseMetadataUtils.dataSourceExists(connectionFolder, string5, string3)) {
                    string2 = "SELECT ATTRIBUTE_NAME, IMPORTANCE_VALUE, RANK FROM " + string3 + " ORDER BY ATTRIBUTE_NAME";
                    sQLHelper.conn = ConnectionFolder.getConnection(this.getContext());
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string2);
                    sQLHelper.pstmt.setFetchSize(100);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    string = null;
                    n = null;
                    d = null;
                    while (sQLHelper.rs.next()) {
                        string = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                        n = sQLHelper.rs.getInt("RANK");
                        d = sQLHelper.rs.getDouble("IMPORTANCE_VALUE");
                        statistics = new Statistics();
                        statistics.setRank(n);
                        statistics.setImportance(d);
                        this.statisticLookupMap.put(string, statistics);
                    }
                    sQLHelper.close();
                }
                if (string4 != null && DatabaseMetadataUtils.dataSourceExists(connectionFolder, string5, string4)) {
                    string2 = "SELECT ATTR, DATA_TYPE, NULL_PERCENT, CONSTANT_PERCENT, DISTINCT_PERCENT FROM " + string4 + " ORDER BY ATTR";
                    sQLHelper.conn = ConnectionFolder.getConnection(this.getContext());
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string2);
                    sQLHelper.pstmt.setFetchSize(100);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    string = null;
                    n = null;
                    d = null;
                    statistics = null;
                    Statistics statistics2 = null;
                    while (sQLHelper.rs.next()) {
                        string = sQLHelper.rs.getString("ATTR");
                        Object object = sQLHelper.rs.getObject("NULL_PERCENT");
                        n = object != null ? Double.valueOf(((BigDecimal)object).doubleValue()) : null;
                        object = sQLHelper.rs.getObject("CONSTANT_PERCENT");
                        d = object != null ? Double.valueOf(((BigDecimal)object).doubleValue()) : null;
                        object = sQLHelper.rs.getObject("DISTINCT_PERCENT");
                        statistics = object != null ? Double.valueOf(((BigDecimal)object).doubleValue()) : null;
                        statistics2 = this.statisticLookupMap.containsKey(string) ? this.statisticLookupMap.get(string) : new Statistics();
                        statistics2.setNulls((Double)((Object)n));
                        statistics2.setUnique((Double)((Object)statistics));
                        statistics2.setConstant(d);
                        this.statisticLookupMap.put(string, statistics2);
                    }
                }
            }
        }
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        ColumnFilterPreferencesPanel.ColumnFilterPreferenceSettings columnFilterPreferenceSettings = ColumnFilterPreferencesPanel.ColumnFilterPreferenceSettings.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        ColumnFilterAttributeType columnFilterAttributeType = new ColumnFilterAttributeType();
        columnFilterAttributeType.setAutomaticFilterEnable(bl ? AutoSpecType.YES : AutoSpecType.NO);
        columnFilterAttributeType.setAutoSpec(bl2 ? AutoSpecType.YES : AutoSpecType.NO);
        columnFilterNodeType.setColumnFilterAttributes(columnFilterAttributeType);
        columnFilterNodeType.setSQLExpression("");
        ColumnFilterSettingsType columnFilterSettingsType = new ColumnFilterSettingsType();
        columnFilterSettingsType.setSamplingEnabled(Boolean.valueOf(columnFilterPreferenceSettings.getUseSampling()));
        columnFilterSettingsType.setNumberOfRows(BigInteger.valueOf(columnFilterPreferenceSettings.getSamplingNumberOfRows()));
        DataQualitySettingsType dataQualitySettingsType = new DataQualitySettingsType();
        dataQualitySettingsType.setNullsPercent(columnFilterPreferenceSettings.getUseNullsPercent() ? Double.valueOf(columnFilterPreferenceSettings.getNullsPercentValue()) : null);
        dataQualitySettingsType.setUniquePercent(columnFilterPreferenceSettings.getUseUniquePercent() ? Double.valueOf(columnFilterPreferenceSettings.getUniquePercentValue()) : null);
        dataQualitySettingsType.setConstantPercent(columnFilterPreferenceSettings.getUseConstantPercent() ? Double.valueOf(columnFilterPreferenceSettings.getConstantPercentValue()) : null);
        columnFilterSettingsType.setDataQualitySettings(dataQualitySettingsType);
        AttrImportantSettingsType attrImportantSettingsType = new AttrImportantSettingsType();
        attrImportantSettingsType.setTargetAttribute(null);
        attrImportantSettingsType.setCutOff(columnFilterPreferenceSettings.getUseCuttoff() ? Double.valueOf(columnFilterPreferenceSettings.getCutOffValue()) : null);
        attrImportantSettingsType.setTopN(columnFilterPreferenceSettings.getUseTopN() ? BigInteger.valueOf(columnFilterPreferenceSettings.getTopNValue()) : null);
        attrImportantSettingsType.setAttributeDependency(Boolean.valueOf(columnFilterPreferenceSettings.getUseAttrDependency()));
        columnFilterSettingsType.setAttrImportantSettings(attrImportantSettingsType);
        columnFilterNodeType.setColumnFilterSettings(columnFilterSettingsType);
        ColumnFilterResultType columnFilterResultType = new ColumnFilterResultType();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        if (DbVersionHelper.isDB122Up((Version)connectionFolder.getDbVersion())) {
            columnFilterResultType.setGenerateImportanceOutput(columnFilterPreferenceSettings.getUse122AttrImportance());
        } else {
            columnFilterResultType.setGenerateImportanceOutput(columnFilterPreferenceSettings.getUseOriginalAttrImportance());
        }
        columnFilterNodeType.setColumnFilterResults(columnFilterResultType);
        columnFilterNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_COLUMN_FILTER_NODE_NAME");
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        for (ColumnFilterAttributeType.Attribute attribute : columnFilterNodeType.getColumnFilterAttributes().getAttribute()) {
            if (!"Yes".equals(attribute.getOutput())) continue;
            AttributeType attributeType = new AttributeType();
            attributeType.setName(attribute.getAlias() != null && !attribute.getAlias().trim().isEmpty() ? attribute.getAlias() : attribute.getName());
            attributeType.setAlias(null);
            attributeType.setDataType(attribute.getDataType());
            attributeType.setDataTypeQualifier(attribute.getDataTypeQualifier());
            attributeType.setStatus(attribute.getStatus());
            attributes.getAttribute().add(attributeType);
        }
        return attributes;
    }

    public List<AttributeType> getTargetAttributes() {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            DataProvider dataProvider = (DataProvider)((Object)abstractNode);
            for (AttributeType attributeType : dataProvider.getAttributes().getAttribute()) {
                try {
                    if (!DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this.getContext(), DatabaseMetadataUtils.getJSONDataType(attributeType.getDataType(), attributeType.getDataTypeQualifier()))) continue;
                    arrayList.add(attributeType);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                    return Collections.emptyList();
                }
            }
        }
        return arrayList;
    }

    @Override
    public boolean validate(boolean bl) {
        Object object4;
        Object object2;
        Object object32;
        boolean bl2 = super.validate(bl);
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        boolean bl3 = columnFilterNodeType.getColumnFilterAttributes().getAutomaticFilterEnable().equals((Object)AutoSpecType.YES);
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        ColumnFilterAttributeType columnFilterAttributeType = (ColumnFilterAttributeType)MetaDataHelper.copyMetadataObject(columnFilterNodeType.getColumnFilterAttributes());
        AttributeType attributeType = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute();
        HashMap<CallSite, Object> hashMap = new HashMap<CallSite, Object>();
        List<AbstractNode> list = this.findDataNodes();
        for (AbstractNode object52 : list) {
            if (!(object52 instanceof DataProvider)) continue;
            for (Object object32 : ((DataProvider)((Object)object52)).getAttributes().getAttribute()) {
                String string = object32.getAlias();
                object2 = (string != null && string.trim().length() > 0 ? string : object32.getName()) + "." + object32.getDataType();
                hashMap.put((CallSite)object2, object32);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Object object4 : columnFilterAttributeType.getAttribute()) {
            object32 = object4.getName() + "." + object4.getDataType();
            AttributeType attributeType2 = (AttributeType)hashMap.get(object32);
            if (attributeType2 == null) {
                if (!list.isEmpty()) {
                    if (attributeType != null && attributeType.getName().equals(object4.getName()) && attributeType.getDataType().equals(object4.getDataType())) {
                        attributeType.setStatus(AttributeStatus.INVALID);
                        if (!bl5) {
                            this.addMessage("COLUMN_FILTER_INVAL_TARGET_COLUMN", MessageEnumType.WARNING, new String[0]);
                            bl5 = true;
                        }
                        object4.setStatus(AttributeStatus.INVALID);
                        if (!bl4) {
                            this.addMessage("COLUMN_FILTER_INVAL_COLUMN", MessageEnumType.WARNING, new String[0]);
                            bl4 = true;
                        }
                        bl2 = false;
                    } else {
                        arrayList.add(object4);
                        bl = true;
                    }
                } else {
                    object4.setStatus(AttributeStatus.INVALID);
                    if (!bl4) {
                        this.addMessage("COLUMN_FILTER_INVAL_COLUMN", MessageEnumType.WARNING, new String[0]);
                        bl4 = true;
                    }
                    if (attributeType != null && attributeType.getName().equals(object4.getName()) && attributeType.getDataType().equals(object4.getDataType())) {
                        attributeType.setStatus(AttributeStatus.INVALID);
                        if (!bl5) {
                            this.addMessage("COLUMN_FILTER_INVAL_TARGET_COLUMN", MessageEnumType.WARNING, new String[0]);
                            bl5 = true;
                        }
                    }
                    bl2 = false;
                }
                bl6 = true;
                continue;
            }
            if (!object4.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
            object4.setStatus(AttributeStatus.VALID);
            bl6 = true;
            if (attributeType == null || !attributeType.getName().equals(object4.getName()) || !attributeType.getDataType().equals(object4.getDataType()) || !attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
            attributeType.setStatus(AttributeStatus.VALID);
        }
        if (arrayList.size() > 0) {
            columnFilterAttributeType.getAttribute().removeAll(arrayList);
        }
        HashMap<CallSite, Object> hashMap2 = new HashMap<CallSite, Object>();
        for (Object object32 : columnFilterAttributeType.getAttribute()) {
            String string = object32.getName() + "." + object32.getDataType();
            hashMap2.put((CallSite)((Object)string), object32);
        }
        object4 = new ArrayList();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            for (AttributeType attributeType3 : ((DataProvider)((Object)abstractNode)).getAttributes().getAttribute()) {
                String string = attributeType3.getName() + "." + attributeType3.getDataType();
                ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)hashMap2.get(string);
                if (attribute != null) continue;
                ColumnFilterAttributeType.Attribute attribute2 = new ColumnFilterAttributeType.Attribute();
                attribute2.setAlias(attributeType3.getAlias());
                attribute2.setDataType(attributeType3.getDataType());
                attribute2.setDataTypeQualifier(attributeType3.getDataTypeQualifier());
                attribute2.setName(attributeType3.getName());
                attribute2.setStatus(attributeType3.getStatus());
                attribute2.setAutomaticFiltering(bl3);
                attribute2.setOutput(bl3 ? "System" : "Yes");
                object4.add(attribute2);
            }
        }
        if (object4.size() > 0) {
            columnFilterAttributeType.getAttribute().addAll(object4);
            bl = true;
            bl6 = true;
        }
        object32 = new ArrayList();
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        if (bl6) {
            object2 = new ComplexProperty(COLUMN_FILTER_ATTRIBUTES, columnFilterAttributeType);
            ((ComplexProperty)object2).setOldData(columnFilterNodeType.getColumnFilterAttributes());
            object32.add(object2);
        }
        object2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        ((ComplexProperty)object2).setOldData(this.getSQLExpression());
        object32.add(object2);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object32);
        if (bl2) {
            bl2 = this.validateNode();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    public boolean validateNode() {
        boolean bl = true;
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        List<AbstractNode> list = this.findDataNodes();
        if (list.size() < 1) {
            this.addMessage("COLUMN_FILTER_NO_DATA", MessageEnumType.ERROR, new String[0]);
            bl = false;
        }
        if (columnFilterNodeType.getColumnFilterAttributes().getAttribute().size() == 0) {
            this.addMessage("COLUMN_FILTER_NO_OUTPUT", MessageEnumType.ERROR, new String[0]);
            bl = false;
        } else {
            boolean bl2 = false;
            for (ColumnFilterAttributeType.Attribute attribute : columnFilterNodeType.getColumnFilterAttributes().getAttribute()) {
                if (!"Yes".equals(attribute.getOutput())) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.addMessage("COLUMN_FILTER_NO_OUTPUT", MessageEnumType.ERROR, new String[0]);
                bl = false;
            }
        }
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        if (!(columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getCutOff() == null && columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTopN() == null || DbVersionHelper.isDB122Up((Version)connectionFolder.getDbVersion()) || columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute() != null)) {
            this.addMessage("COLUMN_FILTER_NO_TARGET", MessageEnumType.ERROR, new String[0]);
            bl = false;
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(true);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validateNodeRemoval(node, true);
    }

    public boolean validateNodeRemoval(Node node, boolean bl) {
        return this.validate(bl);
    }

    @Override
    public String generateSQLExpression() {
        StringBuilder stringBuilder = new StringBuilder(1000);
        StringBuilder stringBuilder2 = new StringBuilder(1000);
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        for (ColumnFilterAttributeType.Attribute attribute : columnFilterNodeType.getColumnFilterAttributes().getAttribute()) {
            if (!"Yes".equals(attribute.getOutput())) continue;
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(",");
                stringBuilder.append(Strings.NEW_LINE);
            }
            stringBuilder2.append("\"");
            stringBuilder2.append(attribute.getName());
            stringBuilder2.append("\"");
            if (attribute.getAlias() == null) continue;
            stringBuilder2.append(" \"");
            stringBuilder2.append(attribute.getAlias());
            stringBuilder2.append("\"");
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder.append("SELECT ");
            stringBuilder.append(SQLHelper.generateSQLInlineHint(this.getContext()) ? "/* + inline */" : "");
            stringBuilder.append(Strings.NEW_LINE);
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append(Strings.NEW_LINE);
            stringBuilder.append("FROM ");
            stringBuilder.append("{INPUT_SOURCE}");
            stringBuilder.append(Strings.NEW_LINE);
        }
        return this.wrapExpressionInWithClause(stringBuilder.toString());
    }

    private String generateAIResult(Context context) {
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        AbstractNode abstractNode = this.findParentNode();
        StringBuffer stringBuffer = new StringBuffer();
        Object object = null;
        String string = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        if (columnFilterNodeType.getColumnFilterResults().isGenerateImportanceOutput()) {
            String string2 = null;
            if (columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute() != null) {
                string2 = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute().getName();
            }
            object = "  \n  -- Target \n  v_target := '" + string2 + "'; \n  \n  -- input view \n  v_caseid := generateUniqueName; \n  v_input_data := generateUniqueName; \n  v_sql := \n  'CREATE VIEW '||v_input_data||' AS SELECT <PARALLEL_HINT> * FROM ( \n    SELECT ROWNUM '||v_caseid||', t.* \n    FROM '||getInputSource('" + abstractNode.getMetadataId() + "')||' t \n  )'; \n  execSQL(v_sql); \n  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_input_data, 'VIEW', NULL, 'Temp Data'); \n";
            object = StringUtils.getReplacedString((String)object, "<PARALLEL_HINT>", string);
            stringBuffer.append((String)object);
            stringBuffer.append("\n");
            BigInteger bigInteger = columnFilterNodeType.getColumnFilterSettings().getNumberOfRows();
            String string3 = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getSamplingType();
            object = "  v_sample_data := generateUniqueName; \n";
            stringBuffer.append((String)object);
            if (bigInteger != null) {
                object = string3 == null || "Stratified".equals(string3) ? "  -- stratified sample \n  v_caseid_alias := generateUniqueName; \n  v_num_row_alias := generateUniqueName; \n  v_sql := \n    'CREATE VIEW '||v_sample_data||' AS SELECT <PARALLEL_HINT> * FROM ( \n    WITH \n    \"A\" as (SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + "    * FROM '||v_input_data||'), \n    \"B.1\" as (SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + "    row_number() OVER(partition by \"'||v_target||'\" ORDER BY ORA_HASH('||v_caseid||')) '||v_caseid_alias||', '||v_caseid||' FROM \"A\" t), \n    \"B.2\" as (SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + "    t.*, p.'||v_caseid_alias||' FROM \"A\" t, \"B.1\" p WHERE t.'||v_caseid||' = p.'||v_caseid||'), \n    \"B.3\" as (SELECT \"'||v_target||'\", COUNT(*) '||v_num_row_alias||' FROM \"A\" GROUP BY \"'||v_target||'\"), \n    \"B\" as ( \n      SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + "      v1.* FROM \"B.2\" v1 ,\"B.3\" v2 \n      WHERE v1.\"'||v_target||'\" = v2.\"'||v_target||'\" \n      AND ORA_HASH(v1.'||v_caseid_alias||', v2.'||v_num_row_alias||'-1, 0) <= (v2.'||v_num_row_alias||' * (" + bigInteger.intValue() + "    / (SELECT COUNT(*) FROM '||v_input_data||') * 100) / 100) \n    ) \n    SELECT * from \"B\" \n    )'; \n" : "  -- random sample \n  v_sql := \n    'CREATE VIEW '||v_sample_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      WITH A AS (SELECT COUNT(*) CNT FROM '||v_input_data||') \n      SELECT * FROM '||v_input_data||', A  \n      WHERE ORA_HASH('||v_caseid||', LEAST(A.CNT, 4294967295)-1, 0) <= (GREATEST (1, (" + bigInteger.intValue() + "      * LEAST (A.CNT, 4294967295) / A.CNT))) \n    )'; \n";
                object = StringUtils.getReplacedString((String)object, "<PARALLEL_HINT>", string);
            } else {
                object = "  -- use source data \n  v_sample_data := v_view_name; \n";
            }
            stringBuffer.append((String)object);
            object = "  execSQL(v_sql); \n  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>',  NULL, NULL, NULL, v_sample_data, 'VIEW', NULL, 'Sample Data'); \n";
            stringBuffer.append((String)object);
            stringBuffer.append("\n");
            StringBuffer stringBuffer2 = new StringBuffer(32000);
            stringBuffer2.append("                              \"'||v_target||'\" \n");
            for (ColumnFilterAttributeType.Attribute attribute : columnFilterNodeType.getColumnFilterAttributes().getAttribute()) {
                if (!DatabaseMetadataUtils.isSupervisedBinningDataTypeSupported(version, attribute.getDataType()) || attribute.getName().equals(string2)) continue;
                stringBuffer2.append("                               , \"" + attribute.getName() + "\"");
                if (attribute.getAlias() == null) {
                    stringBuffer2.append("\n");
                    continue;
                }
                stringBuffer2.append(" \"" + attribute.getAlias() + "\"\n");
            }
            object = !DbVersionHelper.isDB122Up((Version)version) ? "  v_ai_table := generateUniqueName; \n  v_sql := \n    'CREATE TABLE '||v_ai_table||' AS SELECT <PARALLEL_HINT> * FROM \n    (SELECT PREDNAME as \"ATTRIBUTE_NAME\", nvl(trunc(MAX(jointprob), 9), 0) \"IMPORTANCE_VALUE\", \n           dense_rank() over (order by nvl(trunc(MAX(jointprob), 9), 0) desc) \"RANK\" \n    FROM TABLE (ora_fi_supervised_binning( \n                        CURSOR(SELECT \n" + stringBuffer2 + "                               FROM '||v_sample_data||'), \n                          100, 2) ) WHERE binnumber IS NULL GROUP BY PREDNAME)'; \n" : "  v_ai_table := generateUniqueName; \n  v_sql := \n    'CREATE TABLE '||v_ai_table||' AS SELECT <PARALLEL_HINT> * FROM \n    (SELECT PREDNAME as \"ATTRIBUTE_NAME\", nvl(trunc(MAX(jointprob), 9), 0) \"IMPORTANCE_VALUE\", \n           dense_rank() over (order by nvl(trunc(MAX(jointprob), 9), 0) desc) \"RANK\" \n    FROM TABLE (ora_fi_supervised_binning( \n                 CURSOR(SELECT * \n                        FROM TABLE (ora_dm_build( \n                        CURSOR(SELECT \n" + stringBuffer2 + "                               FROM '||v_sample_data||'), \n                               to_clob(''''''ATTRIBUTE_IMPORTANCE'''',,''''\"'||v_target||'\"'''',''''1'''',''''PREP_AUTO'''',''''ON'''',''''0'''','')))\n                               ),NULL,NULL,NULL)) WHERE binnumber IS NULL GROUP BY PREDNAME)'; \n";
            object = (String)object + "  execSQL(v_sql); \n";
            object = (String)object + "  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_ai_table, 'TABLE', NULL, 'AI Output'); \n";
            object = StringUtils.getReplacedString((String)object, "<PARALLEL_HINT>", string);
            stringBuffer.append((String)object);
        }
        return stringBuffer.toString();
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        String string2 = super.generateCode(context, parameterizedSourceDefinitions, string);
        string2 = CodeTemplate.updateBodyTemplate(string2, "<AI_RESULT>", this.generateAIResult(context));
        return string2;
    }

    @Override
    public void setProperty(String string, Object object) {
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        if (COLUMN_FILTER_SETTINGS.equals(string)) {
            columnFilterNodeType.setColumnFilterSettings((ColumnFilterSettingsType)object);
        } else if (COLUMN_FILTER_ATTRIBUTES.equals(string)) {
            columnFilterNodeType.setColumnFilterAttributes((ColumnFilterAttributeType)object);
        } else if (AUTO_FILTERING.equals(string)) {
            columnFilterNodeType.getColumnFilterAttributes().setAutomaticFilterEnable((AutoSpecType)object);
        } else if (AUTO_REMOVE.equals(string)) {
            columnFilterNodeType.getColumnFilterAttributes().setAutoSpec((AutoSpecType)object);
        } else if (NULL_PERCENT.equals(string)) {
            columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().setNullsPercent((Double)object);
        } else if (UNIQUE_PERCENT.equals(string)) {
            columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().setUniquePercent((Double)object);
        } else if (CONSTANT_PERCENT.equals(string)) {
            columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().setConstantPercent((Double)object);
        } else if (IMPORTANCE.equals(string)) {
            columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().setCutOff((Double)object);
        } else if (RANK.equals(string)) {
            columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().setTopN((BigInteger)object);
        } else if (SAMPLE_SIZE.equals(string)) {
            columnFilterNodeType.getColumnFilterSettings().setNumberOfRows((BigInteger)object);
        } else if (SAMPLE_ENABLED.equals(string)) {
            columnFilterNodeType.getColumnFilterSettings().setSamplingEnabled((Boolean)object);
        } else if (FILTER_RESULTS.equals(string)) {
            columnFilterNodeType.setColumnFilterResults((ColumnFilterResultType)object);
        } else if (SAMPLING_TYPE.equals(string)) {
            columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().setSamplingType((String)object);
        } else if (STRATIFIED_CUTOFF.equals(string)) {
            columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().setStratifiedCutoff((BigInteger)object);
        } else if (ATTR_DEPENDENCY.equals(string)) {
            columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().setAttributeDependency((Boolean)object);
        } else if ("SQL_EXPRESSION".equals(string)) {
            if (object != null && "SQL_EXPRESSION_GENERATE".equals(object)) {
                columnFilterNodeType.setSQLExpression(this.generateSQLExpression());
            } else {
                columnFilterNodeType.setSQLExpression((String)object);
            }
        } else if (TARGET.equals(string)) {
            columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().setTargetAttribute((AttributeType)object);
        } else if (AI_TABLE.equals(string)) {
            if (object != null) {
                if (AI_TABLE_NULL.equals(object)) {
                    columnFilterNodeType.getColumnFilterResults().setGenerateImportanceOutput(false);
                    columnFilterNodeType.getColumnFilterResults().setAttrImportanceOutput(null);
                } else {
                    columnFilterNodeType.getColumnFilterResults().setGenerateImportanceOutput(true);
                    if (columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput() == null) {
                        columnFilterNodeType.getColumnFilterResults().setAttrImportanceOutput((String)object);
                    }
                }
            }
        } else if (ATTR_OUTPUTS.equals(string)) {
            Map map = (Map)object;
            List list = columnFilterNodeType.getColumnFilterAttributes().getAttribute();
            for (ColumnFilterAttributeType.Attribute attribute : list) {
                String string2 = (String)map.get(attribute.getName());
                if (string2 == null) continue;
                attribute.setOutput(string2);
            }
        } else if (ATTR_FILTERING.equals(string)) {
            List list = columnFilterNodeType.getColumnFilterAttributes().getAttribute();
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)object;
            for (ColumnFilterAttributeType.Attribute attribute2 : list) {
                if (!attribute2.getName().equals(attribute.getName())) continue;
                attribute2.setAutomaticFiltering(attribute.isAutomaticFiltering());
                break;
            }
        } else if (ATTR_OUTPUT.equals(string)) {
            List list = columnFilterNodeType.getColumnFilterAttributes().getAttribute();
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)object;
            for (ColumnFilterAttributeType.Attribute attribute3 : list) {
                if (!attribute3.getName().equals(attribute.getName())) continue;
                attribute3.setOutput(attribute.getOutput());
                break;
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (COLUMN_FILTER_SETTINGS.equals(complexProperty.getPropertyName()) || COLUMN_FILTER_ATTRIBUTES.equals(complexProperty.getPropertyName()) || AUTO_FILTERING.equals(complexProperty.getPropertyName()) || AI_TABLE.equals(complexProperty.getPropertyName()) || ATTR_DEPENDENCY.equals(complexProperty.getPropertyName()) || AUTO_REMOVE.equals(complexProperty.getPropertyName()) || ATTR_OUTPUTS.equals(complexProperty.getPropertyName()) || NULL_PERCENT.equals(complexProperty.getPropertyName()) || UNIQUE_PERCENT.equals(complexProperty.getPropertyName()) || CONSTANT_PERCENT.equals(complexProperty.getPropertyName()) || TARGET.equals(complexProperty.getPropertyName()) || IMPORTANCE.equals(complexProperty.getPropertyName()) || RANK.equals(complexProperty.getPropertyName()) || SAMPLE_SIZE.equals(complexProperty.getPropertyName()) || SAMPLING_TYPE.equals(complexProperty.getPropertyName()) || STRATIFIED_CUTOFF.equals(complexProperty.getPropertyName()) || "SQL_EXPRESSION".equals(complexProperty.getPropertyName()) || FILTER_RESULTS.equals(complexProperty.getPropertyName()) || SAMPLE_ENABLED.equals(complexProperty.getPropertyName())) {
            return complexProperty.getOldData();
        }
        if (ATTR_FILTERING.equals(complexProperty.getPropertyName()) || ATTR_OUTPUT.equals(complexProperty.getPropertyName())) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)complexProperty.getOldData();
            boolean bl = false;
            List list = columnFilterNodeType.getColumnFilterAttributes().getAttribute();
            for (ColumnFilterAttributeType.Attribute attribute2 : list) {
                attribute = (ColumnFilterAttributeType.Attribute)complexProperty.getOldData();
                if (!attribute2.getName().equals(attribute.getName())) continue;
                bl = true;
                break;
            }
            return bl ? attribute : null;
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public Object getProperty(String string) {
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        Object object = null;
        if (COLUMN_FILTER_SETTINGS.equals(string)) {
            object = columnFilterNodeType.getColumnFilterSettings();
        } else if (COLUMN_FILTER_ATTRIBUTES.equals(string)) {
            object = columnFilterNodeType.getColumnFilterAttributes();
        } else if (NULL_PERCENT.equals(string)) {
            object = columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().getNullsPercent();
        } else if (UNIQUE_PERCENT.equals(string)) {
            object = columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().getUniquePercent();
        } else if (CONSTANT_PERCENT.equals(string)) {
            object = columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().getConstantPercent();
        } else if (TARGET.equals(string)) {
            object = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute();
        } else if (IMPORTANCE.equals(string)) {
            object = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getCutOff();
        } else if (RANK.equals(string)) {
            object = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTopN();
        } else if (SAMPLE_SIZE.equals(string)) {
            object = columnFilterNodeType.getColumnFilterSettings().getNumberOfRows();
        } else if (SAMPLE_ENABLED.equals(string)) {
            object = columnFilterNodeType.getColumnFilterSettings().isSamplingEnabled();
        } else if (AI_TABLE.equals(string)) {
            object = columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput();
        } else if (ATTR_DEPENDENCY.equals(string)) {
            object = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().isAttributeDependency();
        } else if (AI_TABLE_GEN.equals(string)) {
            object = columnFilterNodeType.getColumnFilterResults().isGenerateImportanceOutput();
        } else if ("SQL_EXPRESSION".equals(string)) {
            object = this.getSQLExpression();
        } else if (FILTER_RESULTS.equals(string)) {
            object = columnFilterNodeType.getColumnFilterResults();
        } else if (SAMPLING_TYPE.equals(string)) {
            object = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getSamplingType();
        } else if (STRATIFIED_CUTOFF.equals(string)) {
            object = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getStratifiedCutoff();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    public List<AbstractNode> findDataNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    public Map<String, String> getOuputCopyLookupMap() {
        this.ouputCopyLookupMap.clear();
        if (!this.isNew()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
            for (ColumnFilterAttributeType.Attribute attribute : columnFilterNodeType.getColumnFilterAttributes().getAttribute()) {
                this.ouputCopyLookupMap.put(attribute.getName(), attribute.getOutput());
            }
        }
        return this.ouputCopyLookupMap;
    }

    public Map<String, String> getReasonHintsLookupMap() {
        ColumnFilterNodeType columnFilterNodeType;
        ColumnFilterResultType columnFilterResultType;
        this.reasonHintsLookupMap.clear();
        if (!this.isNew() && (columnFilterResultType = (columnFilterNodeType = (ColumnFilterNodeType)this.getData()).getColumnFilterResults()) != null) {
            for (ColumnFilterResultType.Attribute attribute : columnFilterResultType.getAttribute()) {
                if (attribute.getReason() == null || attribute.getReason().size() <= 0) continue;
                StringBuffer stringBuffer = new StringBuffer();
                for (ColumnFilterResultType.Attribute.Reason reason : attribute.getReason()) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    if (reason.getType().equals((Object)ColumnFilterReasonEnumType.NULL_LIMIT)) {
                        stringBuffer.append(DialogsLrb.get("COLUMN_FILTER_NULL_LIMIT_ERROR"));
                        continue;
                    }
                    if (reason.getType().equals((Object)ColumnFilterReasonEnumType.CONSTANT_LIMIT)) {
                        stringBuffer.append(DialogsLrb.get("COLUMN_FILTER_CONSTANT_LIMIT_ERROR"));
                        continue;
                    }
                    if (reason.getType().equals((Object)ColumnFilterReasonEnumType.UNIQUE_LIMIT)) {
                        stringBuffer.append(DialogsLrb.get("COLUMN_FILTER_UNIQUE_LIMIT_ERROR"));
                        continue;
                    }
                    if (reason.getType().equals((Object)ColumnFilterReasonEnumType.TOPN_LIMIT)) {
                        stringBuffer.append(DialogsLrb.get("COLUMN_FILTER_TOPN_LIMIT_ERROR"));
                        continue;
                    }
                    if (!reason.getType().equals((Object)ColumnFilterReasonEnumType.CUTOFF_LIMIT)) continue;
                    stringBuffer.append(DialogsLrb.get("COLUMN_FILTER_CUTOFF_LIMIT_ERROR"));
                }
                this.reasonHintsLookupMap.put(attribute.getName(), stringBuffer.toString());
            }
        }
        return this.reasonHintsLookupMap;
    }

    public Map<String, Statistics> getStatisticLookupMap() {
        return this.statisticLookupMap;
    }

    public boolean isNew() {
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        String string = columnFilterNodeType.getColumnFilterResults().getDataQualityOutput();
        String string2 = columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput();
        return string == null && string2 == null;
    }

    @Override
    public String getHelpTopic() {
        return "columnfilter_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_COLUMN_FILTER_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_COLUMN_FILTER_ICON"));
    }

    @Override
    public void refactor(Node node, boolean bl) {
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ColumnFilterResultType columnFilterResultType = columnFilterNodeType.getColumnFilterResults();
        if (columnFilterResultType.getAttribute() != null || columnFilterResultType.getAttribute().size() > 0) {
            ColumnFilterResultType columnFilterResultType2 = new ColumnFilterResultType();
            columnFilterResultType2.setGenerateImportanceOutput(columnFilterResultType.isGenerateImportanceOutput());
            columnFilterResultType2.setAttrImportanceOutput(columnFilterResultType.getAttrImportanceOutput());
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), FILTER_RESULTS, columnFilterResultType2);
        }
        super.refactor(node, bl);
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        String string;
        Object object;
        ColumnFilterAttributeType.Attribute attribute2;
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        ColumnFilterAttributeType columnFilterAttributeType = columnFilterNodeType.getColumnFilterAttributes();
        ColumnFilterAttributeType columnFilterAttributeType2 = (ColumnFilterAttributeType)MetaDataHelper.copyMetadataObject(columnFilterAttributeType);
        List list = columnFilterAttributeType2.getAttribute();
        for (ColumnFilterAttributeType.Attribute attribute2 : list) {
            object = map.get(attribute2.getName());
            if (object == null || attribute2.getName().equals(object.getName()) && attribute2.getDataType().equals(object.getDataType())) continue;
            string = attribute2.getName();
            attribute2.setName(object.getName());
            attribute2.setDataType(object.getDataType());
            attribute2.setDataTypeQualifier(object.getDataTypeQualifier());
            hashMap.put(string, (AttributeType)attribute2);
        }
        AttributeType attributeType = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute();
        attribute2 = null;
        if (!(attributeType == null || (object = map.get(attributeType.getName())) == null || attributeType.getName().equals(object.getName()) && attributeType.getDataType().equals(object.getDataType()))) {
            attribute2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            string = attributeType.getName();
            attribute2.setName(object.getName());
            attribute2.setDataType(object.getDataType());
            hashMap.put(string, (AttributeType)attribute2);
        }
        if (!hashMap.isEmpty()) {
            object = (OdmrSDMUndoFilter)this.getUndoFilter();
            ((OdmrSDMUndoFilter)((Object)object)).prepareUndo(this, this.getContext(), COLUMN_FILTER_ATTRIBUTES, columnFilterAttributeType2);
            if (attribute2 != null) {
                ((OdmrSDMUndoFilter)((Object)object)).prepareUndo(this, this.getContext(), TARGET, attribute2);
            }
            this.refactorChildrenAttributes(this, hashMap);
        }
    }

    @Override
    public void refactorForApply() {
    }

    public static class Statistics {
        Integer rank;
        Double importance;
        Double nulls;
        Double unique;
        Double constant;

        public Statistics() {
            this(null, null, null, null, null);
        }

        public Statistics(Integer n, Double d, Double d2, Double d3, Double d4) {
            this.rank = n;
            this.importance = d;
            this.nulls = d2;
            this.unique = d3;
            this.constant = d4;
        }

        public void setRank(Integer n) {
            this.rank = n;
        }

        public Integer getRank() {
            return this.rank;
        }

        public void setImportance(Double d) {
            this.importance = d;
        }

        public Double getImportance() {
            return this.importance;
        }

        public void setNulls(Double d) {
            this.nulls = d;
        }

        public Double getNulls() {
            return this.nulls;
        }

        public void setUnique(Double d) {
            this.unique = d;
        }

        public Double getUnique() {
            return this.unique;
        }

        public void setConstant(Double d) {
            this.constant = d;
        }

        public Double getConstant() {
            return this.constant;
        }
    }
}

