/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.UnsupervisedBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionModelType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public final class AnomalyDetectionBuildNode
extends UnsupervisedBuildNode {
    public static final String SVMSETTINGS = "svmSettings";
    public static final String SVMS_KERNEL_FUNCTION = "SVMS_KERNEL_FUNCTION";
    public static final String SVMS_CONV_TOLERANCE = "SVMS_CONV_TOLERANCE";
    public static final String SVMS_COMPLEXITY_FACTOR = "SVMS_COMPLEXITY_FACTOR";
    public static final String SVMS_ACTIVE_LEARNING = "SVMS_ACTIVE_LEARNING";
    public static final String SVMS_STD_DEV = "SVMS_STD_DEV";
    public static final String SVMS_KERNEL_CACHE_SIZE = "SVMS_KERNEL_CACHE_SIZE";
    public static final String SVMS_OUTLIER_RATE = "SVMS_OUTLIER_RATE";

    public AnomalyDetectionBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
        AnomalyDetectionBuildNodeType.Models models = new AnomalyDetectionBuildNodeType.Models();
        anomalyDetectionBuildNodeType.setModels(models);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ALGO_SUPPORT_VECTOR_MACHINES");
        List<String> list = WorkflowUtils.getNewModelNames(context, "ANOMALY_DETECTION", arrayList);
        int n = 0;
        ModelType modelType = null;
        modelType = this.createNewAnomalyModel(list.get(n), "", (String)arrayList.get(n++));
        modelType.setUseForOutput(true);
        this.addSVMOModel((AnomalyDetectionModelType)modelType);
        anomalyDetectionBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    public void addSVMOModel(AnomalyDetectionModelType anomalyDetectionModelType) {
        AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
        AnomalyDetectionBuildNodeType.Models models = anomalyDetectionBuildNodeType.getModels();
        List list = models.getAnomalyDetectionModel();
        list.add(anomalyDetectionModelType);
    }

    public ModelType createNewAnomalyModel(String string, String string2, String string3) {
        ModelType modelType = super.createNewModel(string, string2, "ANOMALY_DETECTION", string3);
        return modelType;
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_ANOM_BUILD_NODE_NAME");
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
        if (anomalyDetectionBuildNodeType.getModels().getAnomalyDetectionModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            AnomalyDetectionBuildNodeType.Models models;
            if (bl2) {
                this.setNodeReady();
            }
            if (!this.validateModels((models = anomalyDetectionBuildNodeType.getModels()).getAnomalyDetectionModel())) {
                bl3 = false;
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    public void setProperty(String string, Object object) {
        AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
        if (string.equals(SVMSETTINGS)) {
            AnomalyDetectionBuildNodeType.Models models = anomalyDetectionBuildNodeType.getModels();
            List list = models.getAnomalyDetectionModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list2 = (List)object;
            if (list2.isEmpty()) {
                return;
            }
            String string2 = ((Property)list2.get(0)).getId();
            for (AnomalyDetectionModelType anomalyDetectionModelType : list) {
                if (!anomalyDetectionModelType.getId().equals(string2)) continue;
                AnomalyDetectionAlgoType anomalyDetectionAlgoType = anomalyDetectionModelType.getAnomalyDetectionAlgo();
                for (Property property : list2) {
                    if (property.getDescription().equals(SVMS_KERNEL_FUNCTION)) {
                        anomalyDetectionAlgoType.setSVMSKERNELFUNCTION((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_CONV_TOLERANCE)) {
                        anomalyDetectionAlgoType.setSVMSCONVTOLERANCE(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_COMPLEXITY_FACTOR)) {
                        anomalyDetectionAlgoType.setSVMSCOMPLEXITYFACTOR((Double)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_ACTIVE_LEARNING)) {
                        anomalyDetectionAlgoType.setSVMSACTIVELEARNING((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_STD_DEV)) {
                        anomalyDetectionAlgoType.setSVMSSTDDEV((Double)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_KERNEL_CACHE_SIZE)) {
                        Object object2 = property.getValue();
                        if (object2 == null) {
                            anomalyDetectionAlgoType.setSVMSKERNELCACHESIZE(null);
                            continue;
                        }
                        BigInteger bigInteger = new BigInteger(object2.toString());
                        anomalyDetectionAlgoType.setSVMSKERNELCACHESIZE(bigInteger);
                        continue;
                    }
                    if (!property.getDescription().equals(SVMS_OUTLIER_RATE)) continue;
                    anomalyDetectionAlgoType.setSVMSOUTLIERRATE((Double)property.getValue());
                }
                break;
            }
        } else if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list3 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)anomalyDetectionBuildNodeType, modelType);
                if (list3.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)anomalyDetectionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list4 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)anomalyDetectionBuildNodeType, modelType);
                if (!list4.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)anomalyDetectionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelsRerun")) {
            if (!(object instanceof Map)) {
                return;
            }
            Map map = (Map)object;
            AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType2 = (AnomalyDetectionBuildNodeType)this.getData();
            for (Map.Entry entry : map.entrySet()) {
                String string3 = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)anomalyDetectionBuildNodeType2, string3);
                modelType.setStatus((ModelStatusType)entry.getValue());
            }
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType3 = (AnomalyDetectionBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)anomalyDetectionBuildNodeType3, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(SVMSETTINGS)) {
            List list = (List)complexProperty.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
            for (Property property : list) {
                String string = property.getId();
                String string2 = property.getDescription();
                Object object = this.getOldPropertyValue(string, string2);
                Property property2 = new Property(string, null, object, string2, null);
                arrayList.add(property2);
            }
            return arrayList;
        }
        if (complexProperty.getPropertyName().equals("modelsRerun")) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)anomalyDetectionBuildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelUseForOutput")) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)anomalyDetectionBuildNodeType, string);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        return super.getProperty(complexProperty);
    }

    private Object getOldPropertyValue(String string, String string2) {
        AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
        ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)anomalyDetectionBuildNodeType, string);
        if (modelType == null) {
            return null;
        }
        if (modelType instanceof AnomalyDetectionModelType) {
            AnomalyDetectionAlgoType anomalyDetectionAlgoType = ((AnomalyDetectionModelType)modelType).getAnomalyDetectionAlgo();
            if (string2.equals(SVMS_KERNEL_FUNCTION)) {
                return anomalyDetectionAlgoType.getSVMSKERNELFUNCTION();
            }
            if (string2.equals(SVMS_CONV_TOLERANCE)) {
                return anomalyDetectionAlgoType.getSVMSCONVTOLERANCE();
            }
            if (string2.equals(SVMS_COMPLEXITY_FACTOR)) {
                return anomalyDetectionAlgoType.getSVMSCOMPLEXITYFACTOR();
            }
            if (string2.equals(SVMS_ACTIVE_LEARNING)) {
                return anomalyDetectionAlgoType.getSVMSACTIVELEARNING();
            }
            if (string2.equals(SVMS_STD_DEV)) {
                return anomalyDetectionAlgoType.getSVMSSTDDEV();
            }
            if (string2.equals(SVMS_KERNEL_CACHE_SIZE)) {
                return anomalyDetectionAlgoType.getSVMSKERNELCACHESIZE();
            }
            if (string2.equals(SVMS_OUTLIER_RATE)) {
                return anomalyDetectionAlgoType.getSVMSOUTLIERRATE();
            }
        }
        return null;
    }

    @Override
    public Object getProperty(String string) {
        return super.getProperty(string);
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.ANOMALY_DETECTION;
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.ANOMALY_DETECTION;
    }

    @Override
    public List<RefModelType> getSVMLinearModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
        List list = anomalyDetectionBuildNodeType.getModels().getAnomalyDetectionModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.ANOMALY_DETECTION;
        String string = anomalyDetectionBuildNodeType.getId();
        String string2 = ConnectionFolder.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        List<RefModelType> list2 = MetaDataHelper.createRefModelTypeCollection(miningFunctionType, list, string, string2);
        for (AnomalyDetectionModelType anomalyDetectionModelType : list) {
            String string3 = anomalyDetectionModelType.getAnomalyDetectionAlgo().getSVMSKERNELFUNCTION();
            if (string3 == null || string3.compareTo("SVMS_LINEAR") != 0) continue;
            for (RefModelType refModelType : list2) {
                if (refModelType.getName().compareTo(anomalyDetectionModelType.getName()) != 0 || refModelType.getSchema().compareTo(string2) != 0) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    @Override
    public String getHelpTopic() {
        return "anomaly_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_ANOMALY_DETECTION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_ANOMALY_DETECTION_ICON"));
    }

    @Override
    protected String generateSpecificModelSettingsCode(ModelType modelType, Version version) {
        StringBuilder stringBuilder = new StringBuilder();
        if (modelType instanceof AnomalyDetectionModelType) {
            AnomalyDetectionModelType anomalyDetectionModelType = (AnomalyDetectionModelType)modelType;
            if (anomalyDetectionModelType.getAnomalyDetectionAlgo().getSVMSACTIVELEARNING() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_ACTIVE_LEARNING||''', ''" + anomalyDetectionModelType.getAnomalyDetectionAlgo().getSVMSACTIVELEARNING() + "'')'); \n");
            }
            if (anomalyDetectionModelType.getAnomalyDetectionAlgo().getSVMSCOMPLEXITYFACTOR() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_COMPLEXITY_FACTOR||''', ''" + anomalyDetectionModelType.getAnomalyDetectionAlgo().getSVMSCOMPLEXITYFACTOR() + "'')'); \n");
            }
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_CONV_TOLERANCE||''', ''" + anomalyDetectionModelType.getAnomalyDetectionAlgo().getSVMSCONVTOLERANCE() + "'')'); \n");
            if (anomalyDetectionModelType.getAnomalyDetectionAlgo().getSVMSKERNELCACHESIZE() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_KERNEL_CACHE_SIZE||''', ''" + anomalyDetectionModelType.getAnomalyDetectionAlgo().getSVMSKERNELCACHESIZE() + "'')'); \n");
            }
            if (anomalyDetectionModelType.getAnomalyDetectionAlgo().getSVMSKERNELFUNCTION() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_KERNEL_FUNCTION||''', ''" + anomalyDetectionModelType.getAnomalyDetectionAlgo().getSVMSKERNELFUNCTION() + "'')'); \n");
            }
            if (anomalyDetectionModelType.getAnomalyDetectionAlgo().getSVMSOUTLIERRATE() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_OUTLIER_RATE||''', ''" + anomalyDetectionModelType.getAnomalyDetectionAlgo().getSVMSOUTLIERRATE() + "'')'); \n");
            }
            if (anomalyDetectionModelType.getAnomalyDetectionAlgo().getSVMSSTDDEV() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_STD_DEV||''', ''" + anomalyDetectionModelType.getAnomalyDetectionAlgo().getSVMSSTDDEV() + "'')'); \n");
            }
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_SUPPORT_VECTOR_MACHINES||''')'); \n");
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getCodeGenerationMiningFunction() {
        return "DBMS_DATA_MINING.CLASSIFICATION";
    }

    @Override
    public List<? extends ModelType> getModels() {
        ArrayList arrayList = new ArrayList();
        AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
        AnomalyDetectionBuildNodeType.Models models = anomalyDetectionBuildNodeType.getModels();
        if (models != null) {
            arrayList.addAll(models.getAnomalyDetectionModel());
        }
        return arrayList;
    }
}

