/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.GenerateCode;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.codegen.SQLDefinition;
import oracle.dmt.dataminer.workflow.codegen.SourceDefinition;
import oracle.dmt.dataminer.workflow.dialog.WorkflowDialogLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.CodeProvider;
import oracle.dmt.dataminer.workflow.model.CreateTableNode;
import oracle.dmt.dataminer.workflow.model.DataGuideProvider;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.preferences.TransformNodeSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.CacheSettings;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideType;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.ExceptionDialog;

public abstract class AbstractDataNode
extends AbstractNode
implements DataProvider,
CodeProvider,
DataGuideProvider {
    private static final Logger theLogger = Logger.getLogger(AbstractDataNode.class.getName());
    public static final String CACHE_SETTINGS = "CACHE_SETTINGS";
    public static final String SQL_EXPRESSION = "SQL_EXPRESSION";
    public static final String SQL_EXPRESSION_GENERATE = "SQL_EXPRESSION_GENERATE";
    public static final String DATA_SOURCE_TABLE = "dataSourceTable";
    public static final String JSON_DATA_GUIDE = "jsonDataGuideSettings";
    public static final String JSON_COLUMNS = "JSONColumnsType";
    public static final String INCLUDE_ALL_COLUMNS = "INCLUDE_ALL_COLUMNS";
    public static final String CACHE_SETTINGS_PERCENT = NodeMessagesLrb.get("CACHE_SETTINGS_PERCENT");
    public static final String CACHE_SETTINGS_NUMBER_OF_ROWS = NodeMessagesLrb.get("CACHE_SETTINGS_NUMBER_OF_ROWS");
    public static final String CACHE_SETTINGS_SEED = NodeMessagesLrb.get("CACHE_SETTINGS_SEED");
    public static final String CACHE_SETTINGS_TARGET = NodeMessagesLrb.get("CACHE_SETTINGS_TARGET");
    public static final String CACHE_SETTINGS_RANDOM = NodeMessagesLrb.get("CACHE_SETTINGS_RANDOM");
    public static final String CACHE_SETTINGS_STRATIFIED = NodeMessagesLrb.get("CACHE_SETTINGS_STRATIFIED");
    public static final String CACHE_SETTINGS_TOPN = NodeMessagesLrb.get("CACHE_SETTINGS_TOPN");
    public static final String INPUT_SOURCE = "{INPUT_SOURCE}";
    public static final String INPUT_SOURCE_WITH_PARENTID = "{INPUT_SOURCE:<NodeId>}";
    public static final String SQL_PREFIX_FOR_WITH_NAME = "N$";

    public AbstractDataNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        DataNodeType dataNodeType = (DataNodeType)this.getData();
        CacheSettings cacheSettings = new CacheSettings();
        cacheSettings.setUseFullData(Boolean.valueOf(false));
        cacheSettings.setNumberOfRows(Long.valueOf(2000L));
        CacheSettings.Method method = new CacheSettings.Method();
        CacheSettings.Method.TopN topN = new CacheSettings.Method.TopN();
        method.setTopN(topN);
        cacheSettings.setMethod(method);
        TransformNodeSettings.TransformPreferenceSettings transformPreferenceSettings = TransformNodeSettings.TransformPreferenceSettings.getInstance();
        cacheSettings.setGenerateCache(transformPreferenceSettings.getGenerateCache());
        cacheSettings.setUseFullData(Boolean.valueOf(false));
        dataNodeType.setCacheSettings(cacheSettings);
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(CACHE_SETTINGS_PERCENT) || complexProperty.getPropertyName().equals(CACHE_SETTINGS_NUMBER_OF_ROWS) || complexProperty.getPropertyName().equals(CACHE_SETTINGS_SEED) || complexProperty.getPropertyName().equals(CACHE_SETTINGS_TARGET) || complexProperty.getPropertyName().equals(CACHE_SETTINGS_RANDOM) || complexProperty.getPropertyName().equals(CACHE_SETTINGS_STRATIFIED) || complexProperty.getPropertyName().equals(CACHE_SETTINGS_TOPN)) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public Object getProperty(String string) {
        CacheSettings cacheSettings;
        DataNodeType dataNodeType = (DataNodeType)this.getData();
        CacheSettings cacheSettings2 = null;
        if (!(string.equals(CACHE_SETTINGS_PERCENT) || string.equals(CACHE_SETTINGS_NUMBER_OF_ROWS) || string.equals(CACHE_SETTINGS_SEED) || string.equals(CACHE_SETTINGS_TARGET) || string.equals(CACHE_SETTINGS_RANDOM) || string.equals(CACHE_SETTINGS_STRATIFIED) || string.equals(CACHE_SETTINGS_TOPN))) {
            return super.getProperty(string);
        }
        cacheSettings2 = cacheSettings = dataNodeType.getCacheSettings();
        return cacheSettings2;
    }

    @Override
    public void setProperty(String string, Object object) {
        DataNodeType dataNodeType = (DataNodeType)this.getData();
        if (string.equals(CACHE_SETTINGS_PERCENT) || string.equals(CACHE_SETTINGS_NUMBER_OF_ROWS) || string.equals(CACHE_SETTINGS_SEED) || string.equals(CACHE_SETTINGS_TARGET) || string.equals(CACHE_SETTINGS_RANDOM) || string.equals(CACHE_SETTINGS_STRATIFIED) || string.equals(CACHE_SETTINGS_TOPN)) {
            if (object instanceof CacheSettings) {
                dataNodeType.setCacheSettings((CacheSettings)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public void refactor(Node node, boolean bl) {
        ++this.refactorInvokeCount;
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        List<Object> list = new ArrayList();
        if (node != null) {
            list = node.getModel().findLinksToNode((IlvSDMNode)this);
        }
        if (this.refactorInvokeCount == list.size() || list.size() == 0) {
            DataNodeType dataNodeType = (DataNodeType)this.getData();
            CacheSettings cacheSettings = dataNodeType.getCacheSettings();
            CacheSettings cacheSettings2 = MetaDataHelper.copyCacheSettings(cacheSettings);
            cacheSettings2.setOutputTable(null);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), CACHE_SETTINGS_NUMBER_OF_ROWS, cacheSettings2);
            List<AbstractNode> list2 = this.findChildNodes();
            for (AbstractNode abstractNode : list2) {
                abstractNode.refactor(this, bl);
            }
        }
    }

    public String getSQLExpression() {
        return ((DataNodeType)this.getData()).getSQLExpression();
    }

    public abstract String generateSQLExpression();

    public void setSQLExpression(String string) {
        ((DataNodeType)this.getData()).setSQLExpression(string);
    }

    @Override
    public String getInputSQL() {
        WorkflowModel workflowModel = this.getModel();
        return this.getStackedSQL(true, workflowModel, true);
    }

    public String getInputSQL(boolean bl) {
        WorkflowModel workflowModel = this.getModel();
        return this.getStackedSQL(bl, workflowModel, true);
    }

    public String getInputSQL(boolean bl, boolean bl2) {
        WorkflowModel workflowModel = this.getModel();
        return this.getStackedSQL(bl, workflowModel, bl2);
    }

    public String getStackedSQL(WorkflowModel workflowModel) {
        return this.getStackedSQL(true, workflowModel, true);
    }

    public String getStackedSQL(WorkflowModel workflowModel, boolean bl) {
        String string;
        String string2 = "";
        if (bl) {
            string2 = ";";
        }
        if ((string = this.getStackedSQL(true, workflowModel, true)) != null) {
            return string + string2;
        }
        return null;
    }

    public String getStackedSQL(boolean bl, WorkflowModel workflowModel) {
        return this.getStackedSQL(bl, workflowModel, true);
    }

    public String getStackedSQL(boolean bl, WorkflowModel workflowModel, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(32000);
        if (workflowModel == null) {
            return null;
        }
        if (this.parentContainsIncompleteModel(workflowModel)) {
            return null;
        }
        if (bl) {
            stringBuilder.append(this.getSQLNodeComment(this, true) + this.getSQLExpression() + this.getSQLNodeComment(this, false));
            this.getInternalStackedSQL(this, stringBuilder);
            if (bl2) {
                stringBuilder.append("select * from " + this.getNodeNameForSQLExpression(true));
            }
        } else {
            this.getInternalStackedSQL(this, stringBuilder);
            int n = stringBuilder.lastIndexOf(",\n");
            stringBuilder.trimToSize();
            if (n != -1 && n == stringBuilder.length() - 2) {
                stringBuilder.replace(n, stringBuilder.length() + 1, "");
            }
            if (bl2) {
                stringBuilder.append("select * from " + this.getParentNodeNameForSQLExpression(true));
            }
        }
        if (bl2) {
            stringBuilder.insert(0, "WITH ");
        }
        return StringUtils.removeBlankLines(stringBuilder.toString());
    }

    protected String getCodeGenSQL() {
        boolean bl;
        WorkflowModel workflowModel = this.getModel();
        StringBuilder stringBuilder = new StringBuilder(32000);
        if (workflowModel == null) {
            return null;
        }
        if (this.parentContainsIncompleteModel(workflowModel)) {
            return null;
        }
        boolean bl2 = bl = this.getState().equals((Object)NodeStatusType.COMPLETE) || this.getState().equals((Object)NodeStatusType.READY) || !this.getState().equals((Object)NodeStatusType.FAILURE) || !this.getState().equals((Object)NodeStatusType.INVALID) || this.getState().equals((Object)NodeStatusType.WARNING);
        if (!bl) {
            return null;
        }
        stringBuilder.append(this.getSQLNodeComment(this, true) + StringUtils.escapeSingleQuotesForSQL(this.getSQLExpression()) + this.getSQLNodeComment(this, false));
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof AbstractDataNode)) continue;
            AbstractDataNode abstractDataNode = (AbstractDataNode)abstractNode;
            String string = "'||getInputSource('" + abstractDataNode.getMetadataId() + "')||'";
            n2 = stringBuilder.indexOf(INPUT_SOURCE, n);
            while (n2 > 0) {
                n3 = n2 + INPUT_SOURCE.length();
                stringBuilder.replace(n2, n3, string);
                n = n2 + string.length();
                n2 = stringBuilder.indexOf(INPUT_SOURCE, n);
            }
            String string2 = INPUT_SOURCE_WITH_PARENTID.replace("<NodeId>", abstractDataNode.getMetadataId());
            while (stringBuilder.indexOf(string2) > 0) {
                n = stringBuilder.indexOf(string2);
                int n4 = n + string2.length();
                stringBuilder.replace(n, n4, string);
            }
        }
        stringBuilder.append("SELECT * FROM " + this.getNodeNameForSQLExpression(true));
        stringBuilder.insert(0, "WITH ");
        return stringBuilder.toString();
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        String string2 = CodeTemplate.updateBodyTemplate(string, "<SQL_EXPRESSION>", StringUtils.removeBlankLines(this.getCodeGenSQL()));
        string2 = CodeTemplate.updateBodyTemplate(string2, "<PARALLEL_HINT>", this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true));
        return string2;
    }

    protected boolean parentContainsIncompleteModel(WorkflowModel workflowModel) {
        boolean bl = false;
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (abstractNode instanceof AbstractBuildNode && (abstractNode.getState().equals((Object)NodeStatusType.FAILURE) || abstractNode.getState().equals((Object)NodeStatusType.INVALID) || abstractNode.getState().equals((Object)NodeStatusType.READY))) {
                return true;
            }
            if (!(abstractNode instanceof AbstractDataNode) || !((AbstractDataNode)abstractNode).parentContainsIncompleteModel(workflowModel)) continue;
            return true;
        }
        return bl;
    }

    protected String getSQLNodeComment(AbstractDataNode abstractDataNode, boolean bl) {
        String string = GenerateCode.cleanUpNodeNameForSQLComments(abstractDataNode.getData().getName());
        String string2 = bl ? "/* " + MessageFormat.format(NodeMessagesLrb.get("SQL_EXPRESSION_BEGIN"), string) + " */\n" : "\n/* " + MessageFormat.format(NodeMessagesLrb.get("SQL_EXPRESSION_END"), string) + " */\n";
        return string2;
    }

    protected StringBuilder getSQLExpressionWithNodeNameOLD(AbstractDataNode abstractDataNode) {
        StringBuilder stringBuilder = new StringBuilder(abstractDataNode.getSQLExpression());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n2 = stringBuilder.indexOf(INPUT_SOURCE, n);
        while (n2 > 0) {
            n3 = n2 + INPUT_SOURCE.length();
            String string = abstractDataNode.getNodeNameForSQLExpression(true);
            stringBuilder.replace(n2, n3, string);
            n = n2 + string.length();
            n2 = stringBuilder.indexOf(INPUT_SOURCE, n);
        }
        return stringBuilder;
    }

    protected void replaceSQLExpressionWithNodeName(AbstractDataNode abstractDataNode, StringBuilder stringBuilder) {
        String string;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n2 = stringBuilder.indexOf(INPUT_SOURCE, n);
        while (n2 > 0) {
            n3 = n2 + INPUT_SOURCE.length();
            string = abstractDataNode.getNodeNameForSQLExpression(true);
            stringBuilder.replace(n2, n3, string);
            n = n2 + string.length();
            n2 = stringBuilder.indexOf(INPUT_SOURCE, n);
        }
        string = INPUT_SOURCE_WITH_PARENTID.replace("<NodeId>", abstractDataNode.getMetadataId());
        while (stringBuilder.indexOf(string) > 0) {
            n = stringBuilder.indexOf(string);
            int n4 = n + string.length();
            String string2 = abstractDataNode.getNodeNameForSQLExpression(true);
            stringBuilder.replace(n, n4, string2);
        }
    }

    protected void getInternalStackedSQL(AbstractDataNode abstractDataNode, StringBuilder stringBuilder) {
        boolean bl;
        boolean bl2 = bl = this.getState().equals((Object)NodeStatusType.COMPLETE) || this.getState().equals((Object)NodeStatusType.READY) || !this.getState().equals((Object)NodeStatusType.FAILURE) || !this.getState().equals((Object)NodeStatusType.INVALID) || this.getState().equals((Object)NodeStatusType.WARNING);
        if (!bl) {
            return;
        }
        List<AbstractNode> list = abstractDataNode.findParentNodes();
        for (AbstractNode abstractNode : list) {
            String string;
            if (!(abstractNode instanceof AbstractDataNode) || stringBuilder.indexOf(string = INPUT_SOURCE_WITH_PARENTID.replace("<NodeId>", abstractNode.getMetadataId())) <= 0 && stringBuilder.indexOf(INPUT_SOURCE) <= 0 && stringBuilder.length() != 0) continue;
            AbstractDataNode abstractDataNode2 = (AbstractDataNode)abstractNode;
            String string2 = abstractDataNode2.getSQLExpression();
            this.replaceSQLExpressionWithNodeName(abstractDataNode2, stringBuilder);
            if (abstractDataNode2 instanceof CreateTableNode) {
                string2 = string2.replace(INPUT_SOURCE, "INPUT_TABLE");
            }
            stringBuilder.insert(0, "\n" + this.getSQLNodeComment(abstractDataNode2, true) + string2 + this.getSQLNodeComment(abstractDataNode2, false) + ",\n");
            abstractDataNode2.getInternalStackedSQL(abstractDataNode2, stringBuilder);
        }
    }

    public ArrayList<SourceDefinition> getLineageSources() throws Exception {
        ArrayList<SourceDefinition> arrayList = new ArrayList<SourceDefinition>();
        return arrayList;
    }

    public boolean isSourceContained(ArrayList<SourceDefinition> arrayList, SourceDefinition sourceDefinition) {
        boolean bl = false;
        for (SourceDefinition sourceDefinition2 : arrayList) {
            if (!sourceDefinition2.getDbObjectType().equals((Object)sourceDefinition.getDbObjectType()) || sourceDefinition2.getQualifiedObjectName().compareTo(sourceDefinition.getQualifiedObjectName()) != 0) continue;
            bl = true;
        }
        return bl;
    }

    protected String wrapExpressionInWithClause(String string) {
        String string2 = this.getNodeNameForSQLExpression(true) + " as (" + string + " )";
        return string2;
    }

    @Override
    public SQLDefinition getLineageSQLDefinition() throws Exception {
        WorkflowModel workflowModel = this.getModel();
        SQLDefinition sQLDefinition = new SQLDefinition();
        if (workflowModel == null) {
            throw new Exception(NodeMessagesLrb.get("CODE_GEN_ERROR_NODE_STATE_INVALID"));
        }
        if (!this.canGenerateLineageSQL()) {
            throw new Exception(NodeMessagesLrb.get("CODE_GEN_ERROR_NODE_STATE_INVALID"));
        }
        List list = this.getLineageSources();
        sQLDefinition.addSourceDefinitions((ArrayList<SourceDefinition>)list);
        StringBuilder stringBuilder = sQLDefinition.getSql();
        String string = StringUtils.escapeCharacterForSQLScript(this.getSQLExpression(), "&");
        if (((ArrayList)list).size() > 0) {
            string = sQLDefinition.replaceSourceNamesWithParms(string, this);
        }
        stringBuilder.append(this.getSQLNodeComment(this, true) + string + this.getSQLNodeComment(this, false));
        sQLDefinition.setSql(stringBuilder.toString());
        sQLDefinition = this.getLineageSQLDefinition(this, sQLDefinition);
        stringBuilder = sQLDefinition.getSql();
        stringBuilder.append("select " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */ " : "") + " * from " + this.getNodeNameForSQLExpression(true));
        stringBuilder.insert(0, "WITH ");
        sQLDefinition.setSql(stringBuilder.toString());
        return sQLDefinition;
    }

    @Override
    public SQLDefinition getLineageSQLDefinition(AbstractNode abstractNode, SQLDefinition sQLDefinition) throws Exception {
        if (!this.canGenerateLineageSQL()) {
            throw new Exception(NodeMessagesLrb.get("CODE_GEN_ERROR_NODE_STATE_INVALID"));
        }
        List<AbstractNode> list = abstractNode.findParentNodes();
        boolean bl = false;
        for (AbstractNode abstractNode2 : list) {
            if (!(abstractNode2 instanceof AbstractDataNode)) continue;
            AbstractDataNode abstractDataNode = (AbstractDataNode)abstractNode2;
            bl = abstractDataNode.canGenerateLineageSQL();
            if (!bl) {
                throw new Exception(NodeMessagesLrb.get("CODE_GEN_ERROR_NODE_STATE_INVALID"));
            }
            StringBuilder stringBuilder = sQLDefinition.getSql();
            this.replaceSQLExpressionWithNodeName(abstractDataNode, stringBuilder);
            List list2 = abstractDataNode.getLineageSources();
            sQLDefinition.addSourceDefinitions((ArrayList<SourceDefinition>)list2);
            String string = StringUtils.escapeCharacterForSQLScript(abstractDataNode.getSQLExpression(), "&");
            if (((ArrayList)list2).size() > 0) {
                string = sQLDefinition.replaceSourceNamesWithParms(string, abstractDataNode);
            }
            stringBuilder.insert(0, "\n" + this.getSQLNodeComment(abstractDataNode, true) + string + this.getSQLNodeComment(abstractDataNode, false) + ",\n");
            abstractDataNode.getLineageSQLDefinition(abstractDataNode, sQLDefinition);
        }
        return sQLDefinition;
    }

    @Override
    protected boolean canGenerateLineageSQL() {
        boolean bl;
        boolean bl2 = bl = this.getData().getStatus() != NodeStatusType.INVALID;
        return bl;
    }

    @Override
    public String getCacheTableName() {
        DataNodeType dataNodeType = (DataNodeType)this.getData();
        CacheSettings cacheSettings = dataNodeType.getCacheSettings();
        if (cacheSettings == null) {
            return null;
        }
        ResultType resultType = cacheSettings.getOutputTable();
        if (resultType == null) {
            return null;
        }
        return resultType.getName();
    }

    @Override
    public CacheSettings getCacheSettings() {
        DataNodeType dataNodeType = (DataNodeType)this.getData();
        return dataNodeType.getCacheSettings();
    }

    public String getRefactorTableName(String string, Context context) {
        return this.getRefactorTableName(string, context, false, null);
    }

    public String getRefactorTableName(final String string, final Context context, final boolean bl, final AbstractNode abstractNode) {
        class Loader
        extends ProgressRunnable {
            private String newName;

            Loader() {
            }

            protected Object doWork() throws Exception {
                this.newName = WorkflowUtils.getNewOutputTableNameWfidRefactor(string, context, bl, abstractNode);
                return this.newName;
            }
        }
        Loader loader = new Loader();
        loader.setCancelable(false);
        loader.setTitle(NodeMessagesLrb.get("PASTE_OPERATION_TITLE"));
        loader.setMessage(NodeMessagesLrb.get("PASTE_OPERATION_TITLE_MSG"));
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                loader.start(true);
            } else {
                loader.doWork();
            }
            return loader.newName;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowDialogLrb.get("SYSTEM_FAILURE"), (String)WorkflowDialogLrb.get("SYSTEM_FAILURE"), null);
            throw new DataMinerException(exception);
        }
    }

    @Override
    public DataGuideType getJSONAttrDataGuide(AttributeType attributeType, Integer n) {
        DataGuideType dataGuideType = null;
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            DataGuideProvider dataGuideProvider;
            if (abstractNode instanceof DataGuideProvider && (dataGuideType = (dataGuideProvider = (DataGuideProvider)((Object)abstractNode)).getJSONAttrDataGuide(attributeType, n)) != null) break;
        }
        return dataGuideType;
    }

    @Override
    public DataGuideInfoType getJSONAttrDataGuideInfoType(AttributeType attributeType) {
        DataGuideInfoType dataGuideInfoType = null;
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            DataGuideProvider dataGuideProvider;
            if (abstractNode instanceof DataGuideProvider && (dataGuideInfoType = (dataGuideProvider = (DataGuideProvider)((Object)abstractNode)).getJSONAttrDataGuideInfoType(attributeType)) != null) break;
        }
        return dataGuideInfoType;
    }
}

