/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Component;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.model.common.build.TextAttribute;
import oracle.dmt.dataminer.core.model.common.build.TextAttributes;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.Strings;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.expressionbuilder2.SQLContext;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.ModelConsumer;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.SubNodeProperty;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.preferences.BuildTextPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.preferences.ModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.ASSOAGGREGATES;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriModelType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitFeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningData;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.LexerType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.OClusterModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.RBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public abstract class AbstractBuildNode
extends AbstractNode
implements ModelProvider,
DataConsumer {
    public static final String TARGET_ATTRIBUTE = "targetAttribute";
    public static final String MODEL_NAME = "modelName";
    public static final String MODEL_IDS = "modelIds";
    public static final String MODEL_STATUSES = "modelStatuses";
    public static final String MODEL_BUILD_DATES = "modelBuildDates";
    public static final String MODEL_ADDED_REMOVED = "modelAddedorRemoved";
    public static final String MODEL_ADDED = "modelAdded";
    public static final String MODEL_REMOVED = "modelRemoved";
    public static final String MODELS_RERUN = "modelsRerun";
    public static final String TESTS_RERUN = "testsRerun";
    public static final String MODEL_ANNOTATION = "modelAnnotation";
    public static final String ALL_TESTS_REMOVED = "alltestsRemoved";
    public static final String ALL_TESTS_RESTORED = "alltestsRestored";
    public static final String TESTS_REMOVED = "testsRemoved";
    public static final String TESTS_RESTORED = "testsRestored";
    public static final String ALL_TESTS_FOR_TUNING_REMOVED = "alltestsForTuningRemoved";
    public static final String ALL_TESTS_FOR_TUNING_RESTORED = "alltestsForTuningRestored";
    public static final String TESTS_FOR_TUNING_REMOVED = "testsForTuningRemoved";
    public static final String TESTS_FOR_TUNING_RESTORED = "testsForTuningRestored";
    public static final String MODEL_USE_FOR_OUTPUT = "modelUseForOutput";
    public static final String ALG_SETTINGS = "algTreeSettings";
    public static final String TEST_OPTIONS_CHANGED = "testOptionsChanged";
    public static final String TEST_SETTINGS_CHANGED = "testSettingsChanged";
    public static final String SPLIT_VALUE_CHANGED = "splitValueChanged";
    public static final String SPLIT_DATA_FORMAT = "splitDataFormat";
    public static final String MINING_ATTRIBUTE_SETTINGS = "miningAttributeSettings";
    public static final String PARTITIONS_EXPRESSION_EDIT = "PARTITIONS_EXPRESSION_EDIT";
    public static final String PARTITIONS_MAX_NUM = "PARTITIONS_MAX_NUM";
    public static final String ODMS_PARTITION_BUILD_TYPE = "ODMS_PARTITION_BUILD_TYPE";
    public static final String ODMS_SAMPLING = "ODMS_SAMPLING";
    public static final String ODMS_SAMPLE_SIZE = "ODMS_SAMPLE_SIZE";
    public static final String GEN_ACCURACY_METRICS = "genAccuracyMetrics";
    public static final String GEN_CONFUSION_MATRIX = "genConfusionMatrix";
    public static final String GEN_ROC_CURVE = "genROC";
    public static final String GEN_LIFT_AND_PROFIT = "genLiftProfit";
    public static final String GEN_RESIDUALS = "genResiduals";
    public static final String CLAS_TEST_RESULTS = "classTestResults";
    public static final String REGR_TEST_RESULTS = "regrTestResults";
    public static final String CASE_ATTRIBUTES = "caseAttributes";
    public static final int MAX_NUM_PARTITIONS = 1000000;
    public static final int MAX_NUM_PARTITION_KEY = 16;
    protected static final String TARGET_INVALID = "targetAttributeInvalid";
    protected static final String RESULT_STATUS = "resultStatus";
    protected static final String TEST_DATA = "testData";
    public static final String BUILD_DATA_SOURCE = "buildDataSource";
    private static final String ALL_ATTRIBUTES = "allAttributes";
    private static final String NODE_ATTRIBUTES = "nodeAttributes";
    private static final String MODELS_ATTRIBUTES = "modelsAttributes";
    private static final String MODEL_ATTRIBUTES = "modelAttributes";
    private static final String MODEL_STATUS = "modelStatus";
    private static final String TEXT_ATTRIBUTES = "textAttributes";
    private static final String CASE_ID_ATTRIBUTES = "caseAttributesInternal";
    private static final Logger theLogger = Logger.getLogger(AbstractBuildNode.class.getName());
    private ModelBuildPreferencesPanelSettings buildPref = ModelBuildPreferencesPanelSettings.getInstance();
    private Long lastBuildNodeId = 1L;
    protected Version dbVersion;

    public AbstractBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
        BuildNodeType buildNodeType;
        this.dbVersion = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        this.initMaxModelId();
        if (DbVersionHelper.isDB121Up((Version)this.dbVersion) && !(this instanceof AssociationBuildNode)) {
            this.initStoplistInstance(context);
            this.initTextSettingsInstance();
        }
        if (DbVersionHelper.isDB122Up((Version)this.dbVersion) && (buildNodeType = this.getBuildNodeType()) != null && buildNodeType.getMaxNumPartitions() == null) {
            buildNodeType.setMaxNumPartitions(BigInteger.valueOf(this.buildPref.getMaxNumPartition()));
        }
    }

    private BuildNodeType getBuildNodeType() {
        return (BuildNodeType)this.getData();
    }

    private void initMaxModelId() {
        List<ModelType> list = MetaDataHelper.getModelsCollection(this.getBuildNodeType());
        for (ModelType modelType : list) {
            Long l = Long.valueOf(modelType.getId());
            if (this.lastBuildNodeId == null) {
                this.lastBuildNodeId = l;
                continue;
            }
            if (this.lastBuildNodeId.compareTo(l) >= 0) continue;
            this.lastBuildNodeId = l;
        }
    }

    @Override
    public List<AttributeType> getModelInputAttributes() {
        return this.getBuildNodeType().getMiningAttributes().getMiningAttribute().stream().filter(miningAttributeType -> "Yes".equals(miningAttributeType.getInput())).collect(Collectors.toList());
    }

    public String getNextModelId() {
        this.lastBuildNodeId = this.lastBuildNodeId + 1L;
        return this.lastBuildNodeId.toString();
    }

    @Override
    protected void initNewInstance(Context context) {
        BuildNodeType buildNodeType;
        super.initNewInstance(context);
        this.initMiningAttributesInstance();
        this.initCaseAttributesInstance();
        if (DbVersionHelper.isDB121Up((Version)this.dbVersion) && !(this instanceof AssociationBuildNode)) {
            this.initStoplistInstance(context);
            this.initTextSettingsInstance();
        }
        if (DbVersionHelper.isDB122Up((Version)this.dbVersion) && (buildNodeType = this.getBuildNodeType()) != null && buildNodeType.getMaxNumPartitions() == null) {
            buildNodeType.setMaxNumPartitions(BigInteger.valueOf(this.buildPref.getMaxNumPartition()));
        }
    }

    @Override
    public abstract String getDefaultName();

    public ModelType createNewModel(String string, String string2, String string3, String string4) {
        NaiveBayesModelType naiveBayesModelType = null;
        String string5 = this.getModel().getNextNewIdString();
        Version version = ConfigUtils.getDatabaseVersion(this.getContext());
        boolean bl = DbVersionHelper.isDB122Up((Version)version);
        InputMiningData inputMiningData = new InputMiningData();
        MiningAttributes miningAttributes = new MiningAttributes();
        List list = miningAttributes.getMiningAttribute();
        inputMiningData.setMiningAttributes(miningAttributes);
        if ("ASSOCIATION".equals(string3)) {
            inputMiningData.setDataUsage(InputMiningDataType.MANUAL);
            inputMiningData.setMiningUsage(InputMiningDataType.MANUAL);
        } else {
            inputMiningData.setDataUsage(InputMiningDataType.AUTO);
            inputMiningData.setMiningUsage(InputMiningDataType.AUTO);
        }
        List list2 = this.getBuildNodeType().getMiningAttributes().getMiningAttribute();
        for (MiningAttributeType miningAttributeType : list2) {
            MiningAttributeType miningAttributeType2 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(miningAttributeType);
            list.add(miningAttributeType2);
        }
        if ("ALGO_NAIVE_BAYES".equals(string4)) {
            naiveBayesModelType = MetaDataHelper.createNaiveBayesModel();
        } else if ("ALGO_DECISION_TREE".equals(string4)) {
            naiveBayesModelType = MetaDataHelper.createDecisionTreeModel();
        } else if ("ALGO_SUPPORT_VECTOR_MACHINES".equals(string4)) {
            if ("CLASSIFICATION".equals(string3)) {
                naiveBayesModelType = MetaDataHelper.createSVMClassificationModel();
            } else if ("REGRESSION".equals(string3)) {
                naiveBayesModelType = MetaDataHelper.createSVMRegressionModel();
            } else if ("ANOMALY_DETECTION".equals(string3)) {
                naiveBayesModelType = MetaDataHelper.createSVMAnomalyModel();
            }
        } else if ("ALGO_GENERALIZED_LINEAR_MODEL".equals(string4)) {
            if ("CLASSIFICATION".equals(string3)) {
                naiveBayesModelType = MetaDataHelper.createGLMClassificationModel(this.dbVersion);
                if (DbVersionHelper.isDB121Up((Version)this.dbVersion)) {
                    ((CGeneralizedLinearModelType)naiveBayesModelType).getCGeneralizedLinearAlgo().setGLMSFTRSELECTION("GLMS_FTR_SELECTION_DISABLE");
                }
            } else if ("REGRESSION".equals(string3)) {
                naiveBayesModelType = MetaDataHelper.createGLMRegressionModel(this.dbVersion);
                if (DbVersionHelper.isDB121Up((Version)this.dbVersion)) {
                    ((RGeneralizedLinearModelType)naiveBayesModelType).getRGeneralizedLinearModelAlgo().setGLMSFTRSELECTION("GLMS_FTR_SELECTION_DISABLE");
                }
            }
        } else if ("ALGO_KMEANS".equals(string4)) {
            naiveBayesModelType = MetaDataHelper.createKMeansModel(this.getContext());
        } else if ("ALGO_O_CLUSTER".equals(string4)) {
            naiveBayesModelType = MetaDataHelper.createOClusterModel();
        } else if ("ALGO_EXPECTATION_MAXIMIZATION".equals(string4)) {
            naiveBayesModelType = MetaDataHelper.createEMModel();
        } else if ("ALGO_APRIORI_ASSOCIATION_RULES".equals(string4)) {
            naiveBayesModelType = MetaDataHelper.createAprioriModel(bl);
        } else if ("ALGO_NONNEGATIVE_MATRIX_FACTOR".equals(string4)) {
            naiveBayesModelType = MetaDataHelper.createNMFModel();
        } else if ("ALGO_SINGULAR_VALUE_DECOMP".equals(string4)) {
            naiveBayesModelType = MetaDataHelper.createSVDModel(bl);
        } else if ("ALGO_PRINCIPAL_COMPONENT_ANALYSIS".equals(string4)) {
            naiveBayesModelType = MetaDataHelper.createPCAModel(bl);
        } else if ("ALGO_EXPLICIT_SEMANTIC_ANALYS".equals(string4)) {
            naiveBayesModelType = MetaDataHelper.createExplicitSemanticAnalysisModel();
        } else if ("ALGO_R_USER_DEFINED".equals(string4)) {
            naiveBayesModelType = MetaDataHelper.createRModel();
        }
        naiveBayesModelType.setName(string);
        naiveBayesModelType.setAnnotation(string2);
        naiveBayesModelType.setInputMiningData(inputMiningData);
        naiveBayesModelType.setStatus(ModelStatusType.READY);
        naiveBayesModelType.setId(string5);
        this.initMiningAttributeInputs(miningAttributes, (ModelType)naiveBayesModelType);
        return naiveBayesModelType;
    }

    public abstract MiningFunctionType getMiningFunctionType();

    @Override
    public List<PartitionExpressionType> getPartitionAttributes(RefModelType refModelType) {
        List<Object> list = new ArrayList<PartitionExpressionType>();
        PartitionExpressions partitionExpressions = this.getBuildNodeType().getPartitionExpressions();
        if (partitionExpressions != null) {
            list = partitionExpressions.getPartitionExpression();
        }
        return list;
    }

    public AbstractDataNode findBuildDataNode(WorkflowModel workflowModel) {
        AbstractDataNode abstractDataNode = null;
        BuildDataSource buildDataSource = this.getBuildNodeType().getBuildDataSource();
        if (buildDataSource == null) {
            return null;
        }
        List<GeneralLink> list = workflowModel.findLinksToNode((IlvSDMNode)this);
        for (GeneralLink generalLink : list) {
            AbstractDataNode abstractDataNode2 = (AbstractDataNode)generalLink.getFrom();
            if (!abstractDataNode2.getMetadataId().equals(buildDataSource.getSourceId())) continue;
            abstractDataNode = abstractDataNode2;
            break;
        }
        return abstractDataNode;
    }

    @Override
    public List<RefModelType> getOutputModels() {
        ArrayList<RefModelType> arrayList = new ArrayList();
        try {
            arrayList = MetaDataHelper.getModelsCollection(this.getBuildNodeType(), this.getContext());
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)NodeMessagesLrb.get("ERROR_TITLE"), (String)NodeMessagesLrb.get("ERROR_MODEL_LOADING_UNEXPECTED"), null);
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return arrayList;
    }

    @Override
    public Object getProperty(String string) {
        BuildNodeType buildNodeType = this.getBuildNodeType();
        if (CASE_ATTRIBUTES.equals(string)) {
            return buildNodeType.getCaseAttributes();
        }
        if (BUILD_DATA_SOURCE.equals(string)) {
            return buildNodeType.getBuildDataSource();
        }
        if (NODE_ATTRIBUTES.equals(string)) {
            return buildNodeType.getMiningAttributes();
        }
        if (TEXT_ATTRIBUTES.equals(string)) {
            return buildNodeType.getTextAttributes();
        }
        if (PARTITIONS_MAX_NUM.equals(string)) {
            return buildNodeType.getMaxNumPartitions();
        }
        if (PARTITIONS_EXPRESSION_EDIT.equals(string)) {
            return buildNodeType.getPartitionExpressions();
        }
        if (ODMS_PARTITION_BUILD_TYPE.equals(string)) {
            return buildNodeType.getODMSPARTITIONBUILDTYPE();
        }
        if (ODMS_SAMPLING.equals(string)) {
            return buildNodeType.isODMSSAMPLING();
        }
        if (ODMS_SAMPLE_SIZE.equals(string)) {
            return buildNodeType.getODMSSAMPLESIZE();
        }
        return super.getProperty(string);
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        BuildNodeType buildNodeType = this.getBuildNodeType();
        if (ALL_ATTRIBUTES.equals(complexProperty.getPropertyName()) || CASE_ID_ATTRIBUTES.equals(complexProperty.getPropertyName()) || MODELS_ATTRIBUTES.equals(complexProperty.getPropertyName()) || MODEL_ATTRIBUTES.equals(complexProperty.getPropertyName()) || MODEL_STATUS.equals(complexProperty.getPropertyName()) || PARTITIONS_MAX_NUM.equals(complexProperty.getPropertyName()) || ODMS_PARTITION_BUILD_TYPE.equals(complexProperty.getPropertyName()) || ODMS_SAMPLE_SIZE.equals(complexProperty.getPropertyName()) || ODMS_SAMPLING.equals(complexProperty.getUndoPropertyName()) || PARTITIONS_EXPRESSION_EDIT.equals(complexProperty.getPropertyName())) {
            return complexProperty.getOldData();
        }
        if (MODEL_ANNOTATION.equals(complexProperty.getPropertyName())) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
            Set set = map.keySet();
            for (String string : set) {
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string);
                hashMap.put(string, modelType.getAnnotation());
            }
            return hashMap;
        }
        if (MODEL_NAME.equals(complexProperty.getPropertyName())) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
            Set set = map.keySet();
            for (String string : set) {
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string);
                hashMap.put(string, modelType.getName());
            }
            return hashMap;
        }
        if (MODEL_IDS.equals(complexProperty.getPropertyName())) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
            Set set = map.keySet();
            for (String string : set) {
                ModelType modelType = MetaDataHelper.findModelByName(buildNodeType, string);
                hashMap.put(string, modelType.getId());
            }
            return hashMap;
        }
        if (MODEL_STATUSES.equals(complexProperty.getPropertyName())) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            for (String string : set) {
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (MODEL_BUILD_DATES.equals(complexProperty.getPropertyName())) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, XMLGregorianCalendar> hashMap = new HashMap<String, XMLGregorianCalendar>(map.size());
            Set set = map.keySet();
            for (String string : set) {
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string);
                hashMap.put(string, modelType.getCreationDate());
            }
            return hashMap;
        }
        if (MINING_ATTRIBUTE_SETTINGS.equals(complexProperty.getPropertyName())) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, Pair> hashMap = new HashMap<String, Pair>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string);
                Pair pair = (Pair)entry.getValue();
                MiningAttributeType miningAttributeType = MetaDataHelper.findModelAttribute((String)pair.getFirst(), modelType);
                MiningAttributeType miningAttributeType2 = miningAttributeType != null ? MetaDataHelper.createMiningAttributeFrom((AttributeType)miningAttributeType) : null;
                hashMap.put(string, new Pair((Object)(miningAttributeType != null ? miningAttributeType2.getName() : (String)pair.getFirst()), (Object)miningAttributeType2));
            }
            return hashMap;
        }
        return this.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public void setProperty(String string, Object object) {
        BuildNodeType buildNodeType = this.getBuildNodeType();
        if (CASE_ATTRIBUTES.equals(string)) {
            buildNodeType.setCaseAttributes((CaseAttributes)object);
        } else if (ALL_ATTRIBUTES.equals(string)) {
            List list = (List)object;
            BuildNodeType buildNodeType2 = (BuildNodeType)this.getData();
            MiningAttributes miningAttributes = buildNodeType2.getMiningAttributes();
            List list2 = miningAttributes.getMiningAttribute();
            list2.clear();
            list2.addAll(list);
        } else if (BUILD_DATA_SOURCE.equals(string)) {
            buildNodeType.setBuildDataSource((BuildDataSource)object);
        } else if (NODE_ATTRIBUTES.equals(string)) {
            buildNodeType.setMiningAttributes((MiningAttributes)object);
        } else if (TEXT_ATTRIBUTES.equals(string)) {
            buildNodeType.setTextAttributes((TransformedAttributesType)object);
        } else if (PARTITIONS_MAX_NUM.equals(string)) {
            buildNodeType.setMaxNumPartitions((BigInteger)object);
        } else if (PARTITIONS_EXPRESSION_EDIT.equals(string)) {
            PartitionExpressions partitionExpressions = (PartitionExpressions)object;
            buildNodeType.setPartitionExpressions(partitionExpressions);
        } else if (ODMS_PARTITION_BUILD_TYPE.equals(string)) {
            buildNodeType.setODMSPARTITIONBUILDTYPE(object.toString());
        } else if (ODMS_SAMPLING.equals(string)) {
            buildNodeType.setODMSSAMPLING(Boolean.valueOf(Boolean.getBoolean(object.toString())));
        } else if (ODMS_SAMPLE_SIZE.equals(string)) {
            BigInteger bigInteger = BigInteger.valueOf(Long.getLong(object.toString()));
            buildNodeType.setODMSSAMPLESIZE(bigInteger);
        } else if (MODELS_ATTRIBUTES.equals(string)) {
            if (!(object instanceof Map)) {
                return;
            }
            HashMap hashMap = (HashMap)object;
            if (hashMap.isEmpty()) {
                return;
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                ModelType modelType = (ModelType)entry.getKey();
                List list = modelType.getInputMiningData().getMiningAttributes().getMiningAttribute();
                list.clear();
                list.addAll((Collection)entry.getValue());
            }
        } else if (CASE_ID_ATTRIBUTES.equals(string)) {
            List list = (List)object;
            CaseAttributes caseAttributes = buildNodeType.getCaseAttributes();
            List list3 = caseAttributes.getAttribute();
            list3.clear();
            list3.addAll(list);
        } else if (MODEL_STATUS.equals(string)) {
            this.setModelStatus(object);
        } else if (MODEL_ATTRIBUTES.equals(string)) {
            this.setModelAttributes(object);
        } else if (MODEL_ANNOTATION.equals(string)) {
            if (!(object instanceof Map)) {
                return;
            }
            HashMap hashMap = (HashMap)object;
            if (hashMap.isEmpty()) {
                return;
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                String string2 = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string2);
                if (modelType == null) continue;
                modelType.setAnnotation((String)entry.getValue());
            }
        } else if (MODEL_NAME.equals(string)) {
            if (!(object instanceof Map)) {
                return;
            }
            Map map = (Map)object;
            if (map.isEmpty()) {
                return;
            }
            for (Map.Entry entry : map.entrySet()) {
                String string3 = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string3);
                if (modelType == null) continue;
                modelType.setName((String)entry.getValue());
            }
        } else if (MODEL_IDS.equals(string)) {
            if (!(object instanceof Map)) {
                return;
            }
            Map map = (Map)object;
            if (map.isEmpty()) {
                return;
            }
            for (Map.Entry entry : map.entrySet()) {
                String string4 = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelByName(buildNodeType, string4);
                if (modelType == null) continue;
                modelType.setId((String)entry.getValue());
            }
        } else if (MODEL_STATUSES.equals(string)) {
            if (!(object instanceof Map)) {
                return;
            }
            Map map = (Map)object;
            if (map.isEmpty()) {
                return;
            }
            for (Map.Entry entry : map.entrySet()) {
                String string5 = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string5);
                if (modelType == null) continue;
                modelType.setStatus((ModelStatusType)entry.getValue());
            }
        } else if (MODEL_BUILD_DATES.equals(string)) {
            if (!(object instanceof Map)) {
                return;
            }
            Map map = (Map)object;
            if (map.isEmpty()) {
                return;
            }
            for (Map.Entry entry : map.entrySet()) {
                String string6 = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string6);
                if (modelType == null) continue;
                modelType.setCreationDate((XMLGregorianCalendar)entry.getValue());
            }
        } else if (MINING_ATTRIBUTE_SETTINGS.equals(string)) {
            if (!(object instanceof Map)) {
                return;
            }
            Map map = (Map)object;
            if (map.isEmpty()) {
                return;
            }
            for (Map.Entry entry : map.entrySet()) {
                String string7 = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string7);
                Pair pair = (Pair)entry.getValue();
                MiningAttributeType miningAttributeType = MetaDataHelper.findModelAttribute(((MiningAttributeType)pair.getSecond()).getName(), modelType);
                if (miningAttributeType == null) continue;
                miningAttributeType.setAutoPrep(((MiningAttributeType)pair.getSecond()).getAutoPrep());
                miningAttributeType.setInput(((MiningAttributeType)pair.getSecond()).getInput());
            }
        } else {
            super.setProperty(string, object);
        }
    }

    public static void applyRefactoredModels(Map<String, RefModelType> map, List<ModelType> list) {
        for (ModelType modelType : list) {
            RefModelType refModelType = map.get(modelType.getName());
            if (refModelType == null) continue;
            modelType.setName(refModelType.getName());
            modelType.setId(refModelType.getModelId());
            modelType.setCreationDate(null);
            modelType.setStatus(ModelStatusType.READY);
        }
    }

    private void setModelAttributes(Object object) {
        SubNodeProperty subNodeProperty = (SubNodeProperty)object;
        ModelType modelType = MetaDataHelper.findModelById(this.getBuildNodeType(), subNodeProperty.getId());
        InputMiningData inputMiningData = modelType.getInputMiningData();
        inputMiningData.setMiningAttributes((MiningAttributes)subNodeProperty.getValue());
    }

    private void setModelStatus(Object object) {
        SubNodeProperty subNodeProperty = (SubNodeProperty)object;
        ModelType modelType = MetaDataHelper.findModelById(this.getBuildNodeType(), subNodeProperty.getId());
        modelType.setStatus((ModelStatusType)subNodeProperty.getValue());
    }

    private void initMiningAttributesInstance() {
        MiningAttributes miningAttributes = new MiningAttributes();
        miningAttributes.setAutoSpec(AutoSpecType.fromValue((String)AutoSpecType.YES.value()));
        this.getBuildNodeType().setMiningAttributes(miningAttributes);
    }

    private void initCaseAttributesInstance() {
        CaseAttributes caseAttributes = new CaseAttributes();
        this.getBuildNodeType().setCaseAttributes(caseAttributes);
    }

    private void initStoplistInstance(Context context) {
        BuildNodeType buildNodeType = this.getBuildNodeType();
        if (buildNodeType != null && buildNodeType.getStoplists() == null) {
            Preferences preferences = Preferences.getPreferences();
            BuildTextPreferencesPanelSettings buildTextPreferencesPanelSettings = BuildTextPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
            ArrayList<String> arrayList = buildTextPreferencesPanelSettings.getTokenLanguages();
            StoplistType stoplistType = AbstractTextNode.generateDefaultStoplist(context, arrayList);
            BuildNodeType.Stoplists stoplists = new BuildNodeType.Stoplists();
            stoplists.getStoplist().add(stoplistType);
            this.getBuildNodeType().setStoplists(stoplists);
        }
    }

    private void initTextSettingsInstance() {
        BuildNodeType buildNodeType = this.getBuildNodeType();
        if (buildNodeType != null && buildNodeType.getTextSettings() == null) {
            String string2;
            Preferences preferences = Preferences.getPreferences();
            BuildTextPreferencesPanelSettings buildTextPreferencesPanelSettings = BuildTextPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
            BuildNodeType.TextSettings textSettings = new BuildNodeType.TextSettings();
            textSettings.setTransformType(buildTextPreferencesPanelSettings.getTransformType());
            textSettings.setCategoricalCutOffValue(buildTextPreferencesPanelSettings.getCategoricalCutoffValue());
            TransformationTokenType.Token token = new TransformationTokenType.Token();
            token.setPolicy("");
            TransformationTokenType.Token.Languages languages = new TransformationTokenType.Token.Languages();
            TransformationTokenType.Token.Languages.Language language = null;
            ArrayList<String> arrayList = buildTextPreferencesPanelSettings.getTokenLanguages();
            for (String string2 : arrayList) {
                if (ServerConstants.StoplistLanguage.isALL((String)string2) || ServerConstants.StoplistLanguage.isNone((String)string2)) continue;
                language = new TransformationTokenType.Token.Languages.Language();
                language.setName(string2);
                if (ServerConstants.StoplistLanguage.isTraditionalChinese((String)string2) || ServerConstants.StoplistLanguage.isSimplifiedChinese((String)string2) || ServerConstants.StoplistLanguage.isJapanese((String)string2) || ServerConstants.StoplistLanguage.isKorean((String)string2)) {
                    language.setType("MultiByte");
                } else {
                    language.setType("SingleByte");
                }
                languages.getLanguage().add(language);
            }
            token.setLanguages(languages);
            LexerType lexerType = new LexerType();
            lexerType.setName("");
            string2 = null;
            if (languages.getLanguage().size() <= 1) {
                lexerType.setType("Basic");
                if (buildTextPreferencesPanelSettings.useStemming()) {
                    string2 = new LexerType.Settings.Attribute();
                    string2.setName("index_stems");
                    string2.setType("String");
                    string2.setValueString(((TransformationTokenType.Token.Languages.Language)languages.getLanguage().get(0)).getName());
                }
            } else {
                lexerType.setType("Auto");
                if (buildTextPreferencesPanelSettings.useStemming()) {
                    string2 = new LexerType.Settings.Attribute();
                    string2.setName("index_stems");
                    string2.setType("String");
                    string2.setValueString("TRUE");
                }
            }
            token.setLexer(lexerType);
            LexerType.Settings settings = new LexerType.Settings();
            if (string2 != null) {
                settings.getAttribute().add(string2);
            }
            lexerType.setSettings(settings);
            token.setStoplistId(null);
            String string3 = buildTextPreferencesPanelSettings.getTokenStoplist();
            if (string3 != null && ServerConstants.StoplistLanguage.isDefault((String)string3)) {
                token.setStoplistId("1");
            }
            Integer n = buildTextPreferencesPanelSettings.getTokenMaxNumAllDocs();
            token.setMaxNumberAllDocs(BigInteger.valueOf(n.intValue()));
            n = buildTextPreferencesPanelSettings.getTokenMaxNumPerDoc();
            token.setMaxNumberPerDoc(BigInteger.valueOf(n.intValue()));
            token.setFrequency("IDF");
            TransformationTokenType transformationTokenType = new TransformationTokenType();
            transformationTokenType.setToken(token);
            textSettings.setToken(transformationTokenType);
            token = new TransformationTokenType.Token();
            token.setPolicy("");
            languages = new TransformationTokenType.Token.Languages();
            language = null;
            String string4 = buildTextPreferencesPanelSettings.getThemeLanguages().get(0);
            language = new TransformationTokenType.Token.Languages.Language();
            language.setName(string4);
            language.setType("SingleByte");
            languages.getLanguage().add(language);
            token.setLanguages(languages);
            lexerType = new LexerType();
            lexerType.setName("");
            lexerType.setType("Basic");
            token.setLexer(lexerType);
            settings = new LexerType.Settings();
            string2 = new LexerType.Settings.Attribute();
            string2.setName("index_themes");
            string2.setType("String");
            string2.setValueString("YES");
            settings.getAttribute().add(string2);
            string2 = new LexerType.Settings.Attribute();
            string2.setName("theme_language");
            string2.setType("String");
            string2.setValueString("ENGLISH");
            settings.getAttribute().add(string2);
            lexerType.setSettings(settings);
            token.setStoplistId(null);
            string3 = buildTextPreferencesPanelSettings.getThemeStoplist();
            if (string3 != null && ServerConstants.StoplistLanguage.isDefault((String)string3)) {
                token.setStoplistId("1");
            }
            n = buildTextPreferencesPanelSettings.getThemeMaxNumAllDocs();
            token.setMaxNumberAllDocs(BigInteger.valueOf(n.intValue()));
            n = buildTextPreferencesPanelSettings.getThemeMaxNumPerDoc();
            token.setMaxNumberPerDoc(BigInteger.valueOf(n.intValue()));
            token.setFrequency("IDF");
            BuildNodeType.TextSettings.Theme theme = new BuildNodeType.TextSettings.Theme();
            theme.setToken(token);
            theme.setType("Single");
            textSettings.setTheme(theme);
            if (DbVersionHelper.isDB122Up((Version)this.dbVersion)) {
                textSettings.setSynonym(this.initSynonym(buildTextPreferencesPanelSettings));
            }
            buildNodeType.setTextSettings(textSettings);
            buildNodeType.setTextAttributes(new TransformedAttributesType());
        }
    }

    private BuildNodeType.TextSettings.Synonym initSynonym(BuildTextPreferencesPanelSettings buildTextPreferencesPanelSettings) {
        String string2;
        BuildNodeType.TextSettings.Synonym synonym = new BuildNodeType.TextSettings.Synonym();
        TransformationTokenType.Token token = new TransformationTokenType.Token();
        token.setPolicy("");
        TransformationTokenType.Token.Languages languages = new TransformationTokenType.Token.Languages();
        TransformationTokenType.Token.Languages.Language language = null;
        ArrayList<String> arrayList = buildTextPreferencesPanelSettings.getTokenLanguages();
        for (String string2 : arrayList) {
            if (ServerConstants.StoplistLanguage.isALL((String)string2) || ServerConstants.StoplistLanguage.isNone((String)string2)) continue;
            language = new TransformationTokenType.Token.Languages.Language();
            language.setName(string2);
            if (ServerConstants.StoplistLanguage.isTraditionalChinese((String)string2) || ServerConstants.StoplistLanguage.isSimplifiedChinese((String)string2) || ServerConstants.StoplistLanguage.isJapanese((String)string2) || ServerConstants.StoplistLanguage.isKorean((String)string2)) {
                language.setType("MultiByte");
            } else {
                language.setType("SingleByte");
            }
            languages.getLanguage().add(language);
        }
        token.setLanguages(languages);
        LexerType lexerType = new LexerType();
        lexerType.setName("");
        string2 = null;
        if (languages.getLanguage().size() <= 1) {
            lexerType.setType("Basic");
            if (buildTextPreferencesPanelSettings.useStemming()) {
                string2 = new LexerType.Settings.Attribute();
                string2.setName("index_stems");
                string2.setType("String");
                string2.setValueString(((TransformationTokenType.Token.Languages.Language)languages.getLanguage().get(0)).getName());
            }
        } else {
            lexerType.setType("Auto");
            if (buildTextPreferencesPanelSettings.useStemming()) {
                string2 = new LexerType.Settings.Attribute();
                string2.setName("index_stems");
                string2.setType("String");
                string2.setValueString("TRUE");
            }
        }
        token.setLexer(lexerType);
        LexerType.Settings settings = new LexerType.Settings();
        if (string2 != null) {
            settings.getAttribute().add(string2);
        }
        lexerType.setSettings(settings);
        token.setStoplistId(null);
        String string3 = buildTextPreferencesPanelSettings.getTokenStoplist();
        if (string3 != null && ServerConstants.StoplistLanguage.isDefault((String)string3)) {
            token.setStoplistId("1");
        }
        Integer n = buildTextPreferencesPanelSettings.getTokenMaxNumAllDocs();
        token.setMaxNumberAllDocs(BigInteger.valueOf(n.intValue()));
        n = buildTextPreferencesPanelSettings.getTokenMaxNumPerDoc();
        token.setMaxNumberPerDoc(BigInteger.valueOf(n.intValue()));
        token.setFrequency("IDF");
        synonym.setToken(token);
        return synonym;
    }

    private MiningAttributes createMiningAttributesFrom(List<? extends AttributeType> list) {
        MiningAttributes miningAttributes = new MiningAttributes();
        List list2 = miningAttributes.getMiningAttribute();
        for (AttributeType attributeType : list) {
            MiningAttributeType miningAttributeType = MetaDataHelper.createMiningAttributeFrom(attributeType);
            list2.add(miningAttributeType);
        }
        return miningAttributes;
    }

    protected void initMiningAttributeInputs(MiningAttributes miningAttributes, ModelType modelType) {
        List list = miningAttributes.getMiningAttribute();
        for (MiningAttributeType miningAttributeType : list) {
            if (AbstractBuildNode.isInputAllowed(miningAttributeType, modelType, this.dbVersion)) continue;
            miningAttributeType.setInput("No");
        }
    }

    public static boolean isInputAllowed(MiningAttributeType miningAttributeType, ModelType modelType, Version version) {
        assert (version != null);
        String string = miningAttributeType.getDataTypeQualifier();
        if (string != null && string.equalsIgnoreCase("JSON")) {
            return false;
        }
        String string2 = miningAttributeType.getDataType();
        if (string2.equals("NCHAR") || string2.equals("NVARCHAR2")) {
            return false;
        }
        if (DbVersionHelper.isDB112((Version)version) && (string2.equals("CLOB") || string2.equals("BLOB") || string2.equals("NCLOB") || string2.equals("BFILE"))) {
            return false;
        }
        if (DbVersionHelper.isDB121Up((Version)version) && DatabaseMetadataUtils.isTypeSupportedAsText(string2) && (modelType instanceof OClusterModelType || modelType instanceof AprioriModelType)) {
            if (DatabaseMetadataUtils.isLOBType(string2) || string2.equals("BFILE") || miningAttributeType.getMiningType().equals("Text")) {
                return false;
            }
            return !string2.equals("VARCHAR2") && !string2.equals("CHAR") || !(modelType instanceof SVDModelType) && (!(modelType instanceof PCAModelType) || !miningAttributeType.getMiningType().equals("Categorical"));
        }
        if (miningAttributeType.getMiningType().equals("Categorical") && (modelType instanceof PCAModelType || modelType instanceof SVDModelType)) {
            return DbVersionHelper.isDB121Up((Version)version);
        }
        if (string2.equals("VARCHAR2") || string2.equals("CHAR")) {
            if ((modelType instanceof SVDModelType || modelType instanceof PCAModelType) && miningAttributeType.getMiningType().equals("Categorical")) {
                return DbVersionHelper.isDB122Up((Version)version);
            }
            return true;
        }
        if (DatabaseMetadataUtils.isNumericType(string2) || DatabaseMetadataUtils.isLOBType(string2) || string2.equals("BFILE")) {
            return true;
        }
        if (DatabaseMetadataUtils.isBinaryNumericType(string2) && DbVersionHelper.isDB121Up((Version)version)) {
            return true;
        }
        if (DatabaseMetadataUtils.isNestedType(string2)) {
            if (DatabaseMetadataUtils.isNestedBinaryNumericType(string2) && !DbVersionHelper.isDB121Up((Version)version)) {
                return false;
            }
            if (modelType instanceof OClusterModelType) {
                return false;
            }
            if (modelType instanceof DecisionTreeModelType) {
                return DbVersionHelper.isDB121Up((Version)version);
            }
            if (modelType instanceof SVDModelType || modelType instanceof PCAModelType) {
                return DatabaseMetadataUtils.isNestedNumericType(string2);
            }
            return true;
        }
        if (string2.equals("DATE")) {
            return false;
        }
        return false;
    }

    protected boolean validateBuildAttributes(List<AttributeType> list) {
        boolean bl = true;
        if (list.isEmpty()) {
            bl = false;
            this.addMessage("BUILD_NO_BUILD_ATTR", MessageEnumType.INCOMPLETE, new String[0]);
        }
        return bl;
    }

    protected boolean validateTestAttributes(List<AttributeType> list) {
        CaseAttributes caseAttributes;
        AttributeType attributeType;
        NodeType nodeType = this.getData();
        assert (nodeType instanceof SuperviseBuildNodeType || nodeType instanceof ExtensibleBuildNodeType) : "Build Node Not Compatible With The Operation";
        boolean bl = true;
        if (list.isEmpty()) {
            this.addMessage("BUILD_NO_TEST_ATTR", MessageEnumType.INCOMPLETE, new String[0]);
            bl = false;
        }
        if (nodeType instanceof SuperviseBuildNodeType) {
            SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)nodeType;
            attributeType = superviseBuildNodeType.getTargetAttribute();
            caseAttributes = superviseBuildNodeType.getCaseAttributes();
        } else {
            ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)nodeType;
            attributeType = extensibleBuildNodeType.getTargetAttribute();
            caseAttributes = extensibleBuildNodeType.getCaseAttributes();
        }
        if (attributeType != null && null == this.findCompatibleAttribute(attributeType, list)) {
            this.addMessage("BUILD_TEST_NO_TARGET", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        if (caseAttributes != null && !caseAttributes.getAttribute().isEmpty() && null == this.findCompatibleAttribute((AttributeType)caseAttributes.getAttribute().get(0), list)) {
            this.addMessage("BUILD_TEST_NO_CASEID", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        return bl;
    }

    protected boolean validateCaseAttributes(List<AttributeType> list) {
        AttributeType attributeType;
        boolean bl = true;
        BuildNodeType buildNodeType = this.getBuildNodeType();
        CaseAttributes caseAttributes = buildNodeType.getCaseAttributes();
        List list2 = caseAttributes.getAttribute();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>(list2.size());
        ArrayList<AttributeType> arrayList2 = new ArrayList<AttributeType>(list2.size());
        for (Object object2 : list2) {
            AttributeType object3 = (AttributeType)MetaDataHelper.copyMetadataObject(object2);
            arrayList.add(object3);
            attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(object2);
            arrayList2.add(attributeType);
        }
        boolean bl2 = false;
        for (AttributeType attributeType2 : arrayList) {
            if (list == null) {
                attributeType2.setStatus(AttributeStatus.INVALID);
                bl = false;
                continue;
            }
            attributeType = this.findCompatibleAttribute(attributeType2, list);
            if (null == attributeType) {
                attributeType2.setStatus(AttributeStatus.INVALID);
                this.addMessage("BUILD_INVALID_CASEIDS", MessageEnumType.INCOMPLETE, new String[0]);
                bl = false;
                continue;
            }
            if (!bl2) {
                bl2 = attributeType2.getStatus().equals((Object)AttributeStatus.INVALID);
            }
            attributeType2.setStatus(AttributeStatus.VALID);
        }
        if (!bl || bl2) {
            Object object2;
            object2 = new ComplexProperty(CASE_ID_ATTRIBUTES, arrayList);
            ((ComplexProperty)object2).setOldData(arrayList2);
            ((ComplexProperty)object2).setForceUpdate(true);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), (ComplexProperty)object2);
        }
        return bl;
    }

    protected boolean validateTarget(List<AttributeType> list) {
        AttributeStatus attributeStatus;
        NodeType nodeType = this.getData();
        assert (nodeType instanceof SuperviseBuildNodeType || nodeType instanceof ExtensibleBuildNodeType) : "Build Node Not Compatible With The Operation";
        boolean bl = true;
        AttributeType attributeType = nodeType instanceof SuperviseBuildNodeType ? ((SuperviseBuildNodeType)this.getData()).getTargetAttribute() : ((ExtensibleBuildNodeType)this.getData()).getTargetAttribute();
        AttributeStatus attributeStatus2 = attributeStatus = attributeType == null ? null : attributeType.getStatus();
        if (attributeType != null) {
            if (list != null) {
                if (null == this.findCompatibleAttribute(attributeType, list)) {
                    attributeType.setStatus(AttributeStatus.INVALID);
                    this.addMessage("BUILD_INVALID_TARGET", MessageEnumType.WARNING, new String[0]);
                    bl = false;
                } else {
                    attributeType.setStatus(AttributeStatus.VALID);
                }
            } else {
                attributeType.setStatus(AttributeStatus.INVALID);
                bl = false;
            }
        } else {
            this.addMessage("BUILD_NO_TARGET", MessageEnumType.INCOMPLETE, new String[0]);
            bl = false;
        }
        if (!bl) {
            ComplexProperty complexProperty = new ComplexProperty(TARGET_INVALID, AttributeStatus.INVALID);
            complexProperty.setOldData(attributeStatus);
            complexProperty.setForceUpdate(true);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
        }
        return bl;
    }

    protected boolean validatePartitionColumns(List<AttributeType> list) {
        boolean bl = true;
        BuildNodeType buildNodeType = this.getBuildNodeType();
        if (buildNodeType.getPartitionExpressions() != null) {
            Object object3;
            PartitionExpressions partitionExpressions = new PartitionExpressions();
            PartitionExpressions partitionExpressions2 = new PartitionExpressions();
            for (Object object2 : buildNodeType.getPartitionExpressions().getPartitionExpression()) {
                object3 = (PartitionExpressionType)MetaDataHelper.copyMetadataObject(object2);
                partitionExpressions.getPartitionExpression().add(object3);
                partitionExpressions2.getPartitionExpression().add(object3);
            }
            boolean bl2 = false;
            for (Object object3 : partitionExpressions.getPartitionExpression()) {
                if (list == null) {
                    if (object3.getSQLExpression() == null) {
                        object3.getPartitionAttribute().setStatus(AttributeStatus.INVALID);
                    }
                    bl = false;
                    continue;
                }
                if (object3.getSQLExpression() != null) continue;
                AttributeType attributeType = this.findCompatibleAttribute(object3.getPartitionAttribute(), list);
                if (null == attributeType) {
                    object3.getPartitionAttribute().setStatus(AttributeStatus.INVALID);
                    this.addMessage("BUILD_INVALID_PARTITION_ATTRS", MessageEnumType.INCOMPLETE, new String[0]);
                    bl = false;
                    continue;
                }
                if (!bl2) {
                    bl2 = object3.getPartitionAttribute().getStatus().equals((Object)AttributeStatus.INVALID);
                }
                object3.getPartitionAttribute().setStatus(AttributeStatus.VALID);
            }
            if (!bl || bl2) {
                Object object2;
                object2 = new ComplexProperty(PARTITIONS_EXPRESSION_EDIT, partitionExpressions);
                ((ComplexProperty)object2).setOldData(partitionExpressions2);
                ((ComplexProperty)object2).setForceUpdate(true);
                object3 = (OdmrSDMUndoFilter)this.getUndoFilter();
                ((OdmrSDMUndoFilter)((Object)object3)).prepareUndo(this, this.getContext(), (ComplexProperty)object2);
            }
        }
        return bl;
    }

    protected AbstractDataNode findTestDataNode(WorkflowModel workflowModel) {
        NodeType nodeType = this.getData();
        assert (nodeType instanceof SuperviseBuildNodeType || nodeType instanceof ExtensibleBuildNodeType) : "Build Node Not Compatible With The Operation";
        TestDataSource testDataSource = this.getTestDataSource();
        if (testDataSource == null) {
            return null;
        }
        if (testDataSource.getTestData() == null) {
            return null;
        }
        AbstractDataNode abstractDataNode = null;
        List<GeneralLink> list = workflowModel.findLinksToNode((IlvSDMNode)this);
        for (GeneralLink generalLink : list) {
            AbstractDataNode abstractDataNode2 = (AbstractDataNode)generalLink.getFrom();
            if (!abstractDataNode2.getMetadataId().equals(testDataSource.getTestData().getSourceId())) continue;
            abstractDataNode = abstractDataNode2;
            break;
        }
        return abstractDataNode;
    }

    protected TestDataSource getTestDataSource() {
        TestDataSource testDataSource = null;
        BuildNodeType buildNodeType = this.getBuildNodeType();
        testDataSource = buildNodeType instanceof SuperviseBuildNodeType ? ((SuperviseBuildNodeType)this.getData()).getTestDataSource() : ((ExtensibleBuildNodeType)this.getData()).getTestDataSource();
        return testDataSource;
    }

    protected void setResultStatus(Object object) {
        BuildNodeType buildNodeType = this.getBuildNodeType();
        assert (buildNodeType instanceof SuperviseBuildNodeType || buildNodeType instanceof ExtensibleBuildNodeType) : "Node Not Compatible With The Operation";
        SubNodeProperty subNodeProperty = (SubNodeProperty)object;
        Optional<? extends MiningResultType> optional = MetaDataHelper.findResultById(buildNodeType, subNodeProperty.getId());
        if (optional.isPresent()) {
            optional.get().setStatus((ModelStatusType)subNodeProperty.getValue());
        }
    }

    protected void handleRemoveTestDataSource(TestDataSource testDataSource) {
        testDataSource.setTestData(null);
        TestDataSource testDataSource2 = new TestDataSource();
        TestDataSource.SplitData splitData = new TestDataSource.SplitData();
        splitData.setTestPercent(50.0);
        testDataSource2.setSplitData(splitData);
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_OPTIONS_CHANGED, testDataSource2);
    }

    public void swapDataSources() {
        TestDataSource testDataSource;
        BuildDataSource buildDataSource;
        SuperviseBuildNodeType superviseBuildNodeType;
        BuildNodeType buildNodeType = this.getBuildNodeType();
        assert (buildNodeType instanceof SuperviseBuildNodeType || buildNodeType instanceof ExtensibleBuildNodeType) : "Build Node Not Compatible With The Operation";
        if (buildNodeType instanceof SuperviseBuildNodeType) {
            superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
            buildDataSource = superviseBuildNodeType.getBuildDataSource();
            testDataSource = superviseBuildNodeType.getTestDataSource();
        } else {
            superviseBuildNodeType = (ExtensibleBuildNodeType)this.getData();
            buildDataSource = superviseBuildNodeType.getBuildDataSource();
            testDataSource = superviseBuildNodeType.getTestDataSource();
        }
        superviseBuildNodeType = MetaDataHelper.copyBuildDataSource(buildDataSource);
        TestDataSource testDataSource2 = MetaDataHelper.copyTestDataSource(testDataSource);
        TestDataSource.TestData testData = testDataSource2.getTestData();
        String string = superviseBuildNodeType.getSourceId();
        superviseBuildNodeType.setSourceId(testData.getSourceId());
        testData.setSourceId(string);
        if (NodeStatusType.COMPLETE.equals((Object)buildNodeType.getStatus()) || NodeStatusType.WARNING.equals((Object)buildNodeType.getStatus())) {
            this.setNodeReady();
        }
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, superviseBuildNodeType);
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_DATA, testDataSource2);
        List<GeneralLink> list = this.getModel().findLinksToNode((IlvSDMNode)this);
        for (GeneralLink generalLink : list) {
            if (((AbstractNode)generalLink.getFrom()).getMetadataId().equals(testData.getSourceId())) {
                odmrSDMUndoFilter.prepareUndo(generalLink, this.getContext(), "label", WorkflowEditorLrb.get("TEST_DATA_LINK_LABEL"));
                continue;
            }
            odmrSDMUndoFilter.prepareUndo(generalLink, this.getContext(), "label", WorkflowEditorLrb.get("BUILD_DATA_LINK_LABEL"));
        }
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (!bl) {
            return bl;
        }
        if (!(node instanceof AbstractDataNode) || node instanceof BuildTextNodeRef) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.handleBuildDataSourceConnected(node);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        List<GeneralLink> list;
        super.handleRemoveConnectionFrom(node);
        BuildNodeType buildNodeType = this.getBuildNodeType();
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        BuildDataSource buildDataSource = buildNodeType.getBuildDataSource();
        if (buildDataSource != null && buildDataSource.getSourceId().equals(node.getMetadataId()) && node.getMetadataId().equals(buildDataSource.getSourceId())) {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, null);
        }
        if ((list = this.getModel().findLinksToNode((IlvSDMNode)this)).size() == 1) {
            Node node2 = (Node)list.get(0).getFrom();
            this.handleBuildDataSourceConnected(node2);
        }
    }

    private void handleBuildDataSourceConnected(Node node) {
        BuildNodeType buildNodeType = this.getBuildNodeType();
        MiningAttributes miningAttributes = buildNodeType.getMiningAttributes();
        List list = miningAttributes.getMiningAttribute();
        Attributes attributes = ((DataProvider)((Object)node)).getAttributes();
        List list2 = attributes.getAttribute();
        BuildDataSource buildDataSource = buildNodeType.getBuildDataSource();
        if (buildDataSource == null) {
            buildDataSource = new BuildDataSource();
            buildDataSource.setSourceId(node.getMetadataId());
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, buildDataSource);
            if (list.size() == 0) {
                MiningAttributes miningAttributes2 = this.createMiningAttributesFrom(list2);
                miningAttributes2.setAutoSpec(miningAttributes.getAutoSpec());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), NODE_ATTRIBUTES, miningAttributes2);
                List<ModelType> list3 = MetaDataHelper.getModelsCollection(buildNodeType);
                for (ModelType modelType : list3) {
                    MiningAttributes miningAttributes3 = modelType.getInputMiningData().getMiningAttributes();
                    MiningAttributes miningAttributes4 = this.createMiningAttributesFrom(miningAttributes2.getMiningAttribute());
                    this.initMiningAttributeInputs(miningAttributes4, modelType);
                    ComplexProperty complexProperty = new ComplexProperty(MODEL_ATTRIBUTES, new SubNodeProperty(modelType.getId(), miningAttributes4));
                    complexProperty.setOldData(new SubNodeProperty(modelType.getId(), miningAttributes3));
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
                }
            }
        }
    }

    @Override
    public void refactor(Node node, boolean bl) {
        TestDataSource.BuildData buildData;
        TestDataSource testDataSource;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ++this.refactorInvokeCount;
        BuildNodeType buildNodeType = this.getBuildNodeType();
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        List<Object> list = new ArrayList();
        if (node != null) {
            list = node.getModel().findLinksToNode((IlvSDMNode)this);
            object4 = null;
            object3 = buildNodeType.getBuildDataSource();
            if (buildNodeType instanceof SuperviseBuildNodeType) {
                object4 = ((SuperviseBuildNodeType)buildNodeType).getTestDataSource();
            }
            if ((object2 = ((AbstractNode)node).getOldId()) != null && ((String)object2).equals(object3.getSourceId())) {
                object = MetaDataHelper.copyBuildDataSource((BuildDataSource)object3);
                object.setSourceId(node.getMetadataId());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, object);
                if (list.size() == 1 && object4 != null) {
                    testDataSource = new TestDataSource();
                    if (object4.getBuildData() != null) {
                        buildData = new TestDataSource.BuildData();
                        testDataSource.setBuildData(buildData);
                    } else if (object4.getSplitData() != null) {
                        buildData = new TestDataSource.SplitData();
                        buildData.setTestPercent(object4.getSplitData().getTestPercent());
                        buildData.setDataFormat(object4.getSplitData().getDataFormat());
                        testDataSource.setSplitData((TestDataSource.SplitData)buildData);
                    } else if (object4.getTestData() != null) {
                        buildData = new TestDataSource.TestData();
                        buildData.setSourceId(object4.getTestData().getSourceId());
                        testDataSource.setTestData((TestDataSource.TestData)buildData);
                    } else {
                        buildData = new TestDataSource.SplitData();
                        buildData.setTestPercent(50.0);
                        testDataSource.setSplitData((TestDataSource.SplitData)buildData);
                    }
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_DATA, testDataSource);
                }
            } else if (object4 != null && object2 != null && ((String)object2).equals(object4.getTestData().getSourceId())) {
                object = MetaDataHelper.copyTestDataSource((TestDataSource)object4);
                object.getTestData().setSourceId(node.getMetadataId());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_DATA, object);
                if (list.size() == 1 && object4 != null) {
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, null);
                }
            }
        } else {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, null);
            if (buildNodeType instanceof SuperviseBuildNodeType) {
                object4 = (SuperviseBuildNodeType)buildNodeType;
                object3 = object4.getTestDataSource();
                object2 = MetaDataHelper.copyTestDataSource((TestDataSource)object3);
                object2.setTestData(null);
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_DATA, object2);
            }
        }
        if (this.refactorInvokeCount == list.size() || list.size() == 0) {
            object4 = this.getOutputModels();
            object3 = WorkflowUtils.refactorModels(this.getContext(), (List<RefModelType>)object4, this.getModel(), bl);
            object2 = new HashMap();
            object = new HashMap();
            testDataSource = new HashMap();
            buildData = new HashMap();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            HashMap<String, ModelStatusType> hashMap3 = new HashMap<String, ModelStatusType>();
            HashMap<String, XMLGregorianCalendar> hashMap4 = new HashMap<String, XMLGregorianCalendar>();
            for (Map.Entry entry : object3.entrySet()) {
                String string = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelByName(buildNodeType, string);
                RefModelType refModelType = (RefModelType)entry.getValue();
                hashMap.put(modelType.getId(), modelType.getName());
                hashMap2.put(refModelType.getName(), modelType.getId());
                hashMap3.put(refModelType.getModelId(), modelType.getStatus());
                hashMap4.put(refModelType.getModelId(), modelType.getCreationDate());
                object2.put(modelType.getId(), refModelType.getName());
                object.put(refModelType.getName(), refModelType.getModelId());
                testDataSource.put(refModelType.getModelId(), ModelStatusType.READY);
                buildData.put(refModelType.getModelId(), null);
            }
            Object object5 = new ComplexProperty(MODEL_NAME, object2);
            ((ComplexProperty)object5).setOldData(hashMap);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), (ComplexProperty)object5);
            object5 = new ComplexProperty(MODEL_IDS, object);
            ((ComplexProperty)object5).setOldData(hashMap2);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), (ComplexProperty)object5);
            object5 = new ComplexProperty(MODEL_STATUSES, testDataSource);
            ((ComplexProperty)object5).setOldData(hashMap3);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), (ComplexProperty)object5);
            object5 = new ComplexProperty(MODEL_BUILD_DATES, buildData);
            ((ComplexProperty)object5).setOldData(hashMap4);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), (ComplexProperty)object5);
            this.refactorChildModelReferences((Map<String, RefModelType>)object3, bl);
        }
    }

    public void refactorChildModelReferences(Map<String, RefModelType> map) throws Exception {
        this.refactorChildModelReferences(map, false);
    }

    public void refactorChildModelReferences(Map<String, RefModelType> map, boolean bl) {
        List<AbstractNode> list = this.findChildNodes();
        for (AbstractNode abstractNode : list) {
            if (abstractNode instanceof ModelConsumer) {
                ((ModelConsumer)((Object)abstractNode)).refactorModelReferences(this, map, bl);
            }
            abstractNode.refactor(this, bl);
        }
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        BuildNodeType buildNodeType = this.getBuildNodeType();
        if (!map.isEmpty()) {
            AttributeType attributeType;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            AttributeType attributeType2;
            MiningAttributeType miningAttributeType;
            Object object5;
            Object object6;
            String string;
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            if (this instanceof SupervisedBuildNode) {
                BuildDataSource buildDataSource = buildNodeType.getBuildDataSource();
                string = buildDataSource.getSourceId();
                object6 = ((AbstractNode)node).getOldId();
                object5 = this.findBuildDataNode(this.getModel());
                if (object5 != node && object6 != null && !string.equals(object6)) {
                    return;
                }
            }
            boolean bl = false;
            string = MetaDataHelper.copyMiningAttributes(buildNodeType.getMiningAttributes());
            object6 = string.getMiningAttribute();
            object5 = object6.iterator();
            while (object5.hasNext()) {
                miningAttributeType = (MiningAttributeType)object5.next();
                attributeType2 = map.get(miningAttributeType.getName());
                if (attributeType2 == null) continue;
                bl = true;
                miningAttributeType.setName(attributeType2.getName());
                miningAttributeType.setDataType(attributeType2.getDataType());
                miningAttributeType.setDataTypeQualifier(attributeType2.getDataTypeQualifier());
            }
            if (bl) {
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), NODE_ATTRIBUTES, string);
            }
            boolean bl2 = false;
            miningAttributeType = buildNodeType.getTextAttributes();
            if (miningAttributeType != null) {
                attributeType2 = (TransformedAttributesType)MetaDataHelper.copyMetadataObject(miningAttributeType);
                object4 = attributeType2.getMapTextTransformedSource();
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (MapTextTransformedSourceType)object3.next();
                    object = map.get(object2.getKey().getName());
                    if (object == null) continue;
                    bl2 = true;
                    object2.getKey().setName(object.getName());
                    object2.getKey().setSource(object.getName());
                    object2.getKey().setDataType(object.getDataType());
                }
                if (bl2) {
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEXT_ATTRIBUTES, attributeType2);
                }
            }
            boolean bl3 = false;
            object4 = MetaDataHelper.copyCaseAttributes(buildNodeType.getCaseAttributes());
            object3 = object4.getAttribute();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (AttributeType)object2.next();
                attributeType = map.get(object.getName());
                if (attributeType == null) continue;
                bl3 = true;
                object.setName(attributeType.getName());
                object.setDataType(attributeType.getDataType());
                object.setDataTypeQualifier(attributeType.getDataTypeQualifier());
            }
            if (bl3) {
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), CASE_ATTRIBUTES, object4);
            }
            object2 = MetaDataHelper.getModelsCollection(buildNodeType);
            object = object2.iterator();
            while (object.hasNext()) {
                attributeType = (ModelType)object.next();
                boolean bl4 = false;
                if (attributeType instanceof AprioriModelType) continue;
                MiningAttributes miningAttributes = MetaDataHelper.copyMiningAttributes(attributeType.getInputMiningData().getMiningAttributes());
                MiningAttributes miningAttributes2 = MetaDataHelper.copyMiningAttributes(attributeType.getInputMiningData().getMiningAttributes());
                List list = miningAttributes2.getMiningAttribute();
                for (MiningAttributeType miningAttributeType2 : list) {
                    AttributeType attributeType3 = map.get(miningAttributeType2.getName());
                    if (attributeType3 == null) continue;
                    bl4 = true;
                    miningAttributeType2.setName(attributeType3.getName());
                    miningAttributeType2.setDataType(attributeType3.getDataType());
                    miningAttributeType2.setDataTypeQualifier(attributeType3.getDataTypeQualifier());
                }
                if (!bl4) continue;
                ComplexProperty complexProperty = new ComplexProperty(MODEL_ATTRIBUTES, new SubNodeProperty(attributeType.getId(), miningAttributes2));
                complexProperty.setOldData(new SubNodeProperty(attributeType.getId(), miningAttributes));
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
            }
        }
    }

    protected abstract boolean validateImpl(boolean var1, boolean var2);

    public boolean validateAfterEdit() {
        return this.validateImpl(true, false);
    }

    @Override
    public boolean validate(boolean bl) {
        Object object;
        AttributeType attributeType;
        Object object2;
        Object object3;
        MiningAttributeType miningAttributeType2;
        Object object42;
        boolean bl2 = super.validate(bl);
        MiningAttributes miningAttributes = this.getBuildNodeType().getMiningAttributes();
        List list = miningAttributes.getMiningAttribute();
        ArrayList<MiningAttributeType> arrayList = new ArrayList<MiningAttributeType>(list.size());
        ArrayList<MiningAttributeType> arrayList2 = new ArrayList<MiningAttributeType>(list.size());
        TransformedAttributesType transformedAttributesType = (TransformedAttributesType)MetaDataHelper.copyMetadataObject(this.getBuildNodeType().getTextAttributes());
        for (Object object42 : list) {
            miningAttributeType2 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(object42);
            arrayList.add(miningAttributeType2);
            object3 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(object42);
            arrayList2.add((MiningAttributeType)object3);
        }
        HashMap hashMap = new HashMap();
        for (MiningAttributeType miningAttributeType2 : arrayList) {
            hashMap.put(miningAttributeType2.getName(), miningAttributeType2);
        }
        object42 = this.findBuildDataNode(this.getModel());
        if (object42 == null) {
            this.validateDisconnectedNode(arrayList, miningAttributes.getAutoSpec(), transformedAttributesType);
            return false;
        }
        miningAttributeType2 = ((DataProvider)object42).getAttributes();
        object3 = miningAttributeType2.getAttribute();
        boolean bl3 = false;
        Iterator iterator = arrayList.iterator();
        block2: while (iterator.hasNext()) {
            MapTextTransformedSourceType mapTextTransformedSourceType;
            Iterator iterator2;
            object2 = (MiningAttributeType)iterator.next();
            attributeType = this.findCompatibleAttribute((AttributeType)object2, (List<? extends AttributeType>)object3);
            if (null == attributeType) {
                iterator.remove();
                hashMap.remove(object2.getName());
                bl3 = true;
                if (transformedAttributesType == null) continue;
                object = transformedAttributesType.getMapTextTransformedSource();
                iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    mapTextTransformedSourceType = (MapTextTransformedSourceType)iterator2.next();
                    if (!mapTextTransformedSourceType.getKey().getName().equals(object2.getName())) continue;
                    object.remove(mapTextTransformedSourceType);
                    continue block2;
                }
                continue;
            }
            if (!object2.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
            object2.setStatus(AttributeStatus.VALID);
            bl3 = true;
            if (transformedAttributesType == null) continue;
            object = transformedAttributesType.getMapTextTransformedSource();
            iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                mapTextTransformedSourceType = (MapTextTransformedSourceType)iterator2.next();
                if (!mapTextTransformedSourceType.getKey().getName().equals(object2.getName())) continue;
                mapTextTransformedSourceType.getKey().setStatus(AttributeStatus.VALID);
                continue block2;
            }
        }
        object2 = object3.iterator();
        while (object2.hasNext()) {
            attributeType = (AttributeType)object2.next();
            object = (MiningAttributeType)hashMap.get(attributeType.getName());
            if (object != null) continue;
            arrayList.add(MetaDataHelper.createMiningAttributeFrom(attributeType));
        }
        if (!bl2 || bl3 || arrayList2.size() != arrayList.size()) {
            object2 = (OdmrSDMUndoFilter)this.getUndoFilter();
            attributeType = new MiningAttributes();
            attributeType.getMiningAttribute().addAll(arrayList);
            attributeType.setAutoSpec(miningAttributes.getAutoSpec());
            ((OdmrSDMUndoFilter)((Object)object2)).prepareUndo(this, this.getContext(), NODE_ATTRIBUTES, attributeType);
            if (transformedAttributesType != null) {
                ((OdmrSDMUndoFilter)((Object)object2)).prepareUndo(this, this.getContext(), TEXT_ATTRIBUTES, transformedAttributesType);
            }
        }
        if (!this.validateCaseAttributes((List<AttributeType>)object3)) {
            bl2 = false;
        }
        if (!this.validatePartitionColumns((List<AttributeType>)object3)) {
            bl2 = false;
        }
        return bl2;
    }

    private void validateDisconnectedNode(List<MiningAttributeType> list, AutoSpecType autoSpecType, TransformedAttributesType transformedAttributesType) {
        MiningAttributes miningAttributes2;
        this.addMessage("BUILD_NO_BUILD_DATA", MessageEnumType.WARNING, new String[0]);
        for (MiningAttributeType object2 : list) {
            object2.setStatus(AttributeStatus.INVALID);
        }
        if (transformedAttributesType != null) {
            for (MiningAttributes miningAttributes2 : transformedAttributesType.getMapTextTransformedSource()) {
                miningAttributes2.getKey().setStatus(AttributeStatus.VALID);
            }
        }
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        miningAttributes2 = new MiningAttributes();
        miningAttributes2.getMiningAttribute().addAll(list);
        miningAttributes2.setAutoSpec(autoSpecType);
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), NODE_ATTRIBUTES, miningAttributes2);
        if (transformedAttributesType != null) {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEXT_ATTRIBUTES, transformedAttributesType);
        }
        this.validateCaseAttributes(null);
        this.validatePartitionColumns(null);
    }

    public boolean validateModels(List<? extends ModelType> list) {
        boolean bl = true;
        MiningAttributes miningAttributes = this.getBuildNodeType().getMiningAttributes();
        List list2 = miningAttributes.getMiningAttribute();
        HashMap<String, MiningAttributeType> hashMap = new HashMap<String, MiningAttributeType>();
        for (MiningAttributeType miningAttributeType : list2) {
            hashMap.put(miningAttributeType.getName(), miningAttributeType);
        }
        for (ModelType modelType : list) {
            Object object;
            Object object2;
            Object object32;
            boolean bl2 = false;
            boolean bl3 = false;
            MiningAttributes miningAttributes2 = modelType.getInputMiningData().getMiningAttributes();
            if (miningAttributes2 == null) {
                bl = false;
                continue;
            }
            MiningAttributes miningAttributes3 = MetaDataHelper.copyMiningAttributes(miningAttributes2);
            List list3 = miningAttributes3.getMiningAttribute();
            HashMap<String, MiningAttributeType> hashMap2 = new HashMap<String, MiningAttributeType>();
            AttributeType attributeType = this.getTargetAttribute();
            for (Object object32 : list3) {
                hashMap2.put(object32.getName(), (MiningAttributeType)object32);
            }
            if (list3 != null && !list3.isEmpty()) {
                bl = false;
                for (Object object32 : list3) {
                    if (!"Yes".equals(object32.getInput()) || attributeType != null && object32.getName().equals(attributeType.getName())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.addMessage("BUILD_INVALID_MODEL_MISSING_INPUT", MessageEnumType.INCOMPLETE, modelType.getName());
                    continue;
                }
            }
            for (Object object32 : list2) {
                object2 = (MiningAttributeType)hashMap2.get(object32.getName());
                if (null == object2) {
                    object = (MiningAttributeType)MetaDataHelper.copyMetadataObject(object32);
                    object.setInput(((MiningAttributeType)hashMap.get(object32.getName())).getInput());
                    list3.add(object);
                    bl3 = true;
                    continue;
                }
                if (!object32.getDataType().equals(object2.getDataType()) || object32.getStatus().equals((Object)AttributeStatus.INVALID)) {
                    if (MetaDataHelper.isAutomatic(modelType)) continue;
                    object2.setStatus(AttributeStatus.INVALID);
                    bl2 = true;
                    bl3 = true;
                    continue;
                }
                if (object32.getAlias() == null || !object32.getAlias().equals(object2.getAlias())) continue;
                object2.setAlias(object32.getAlias());
                bl3 = true;
            }
            Iterator iterator = list3.iterator();
            object32 = this.findBuildDataNode(this.getModel());
            while (iterator.hasNext()) {
                object2 = (MiningAttributeType)iterator.next();
                if (object32 == null) {
                    object2.setStatus(AttributeStatus.INVALID);
                    bl3 = true;
                    continue;
                }
                object = (MiningAttributeType)hashMap.get(object2.getName());
                if (null == object) {
                    iterator.remove();
                    bl3 = true;
                    continue;
                }
                if (!object2.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
                object2.setStatus(AttributeStatus.VALID);
                bl3 = true;
            }
            if (bl2) {
                bl = false;
                this.addMessage("BUILD_INVALID_MODEL", MessageEnumType.WARNING, modelType.getName());
            }
            if (!bl3) continue;
            object2 = (OdmrSDMUndoFilter)this.getUndoFilter();
            object = new ComplexProperty(MODEL_ATTRIBUTES, new SubNodeProperty(modelType.getId(), miningAttributes3));
            ((ComplexProperty)object).setOldData(new SubNodeProperty(modelType.getId(), miningAttributes2));
            ((OdmrSDMUndoFilter)((Object)object2)).prepareUndo(this, this.getContext(), (ComplexProperty)object);
        }
        return bl;
    }

    public String getStackSQLExpression(SQLContext sQLContext, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        AbstractDataNode abstractDataNode = this.findBuildDataNode(this.getModel());
        String string2 = abstractDataNode.getInputSQL(true, false);
        stringBuilder.append(string2 + ",\n");
        String string3 = StringUtils.addDoubleQuotes((String)("N$" + abstractDataNode.getMetadataId()));
        String string4 = StringUtils.addDoubleQuotes((String)StringUtils.trimDoubleQuotes((String)sQLContext.getName()));
        stringBuilder.append(this.getNodeNameForSQLExpression(true) + " as (SELECT (\n" + string + "\n) " + string4 + " FROM " + string3 + ")\n");
        stringBuilder.append("SELECT * FROM " + this.getNodeNameForSQLExpression(true));
        stringBuilder.insert(0, "WITH ");
        return stringBuilder.toString();
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        String string;
        Object[] objectArray;
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        stringBuffer.setLength(0);
        BuildNodeType buildNodeType = this.getBuildNodeType();
        if (buildNodeType.getCaseAttributes() != null && !buildNodeType.getCaseAttributes().getAttribute().isEmpty() && buildNodeType.getCaseAttributes().getAttribute().size() == 1) {
            objectArray = ((AttributeType)buildNodeType.getCaseAttributes().getAttribute().get(0)).getName();
            Object object = ((AttributeType)buildNodeType.getCaseAttributes().getAttribute().get(0)).getDataType();
            if (!DatabaseMetadataUtils.isCaseIdDataTypeSupported(version, DatabaseMetadataUtils.getJSONDataType((String)object, string = ((AttributeType)buildNodeType.getCaseAttributes().getAttribute().get(0)).getDataTypeQualifier()))) {
                Object[] objectArray2 = new Object[]{objectArray, DatabaseMetadataUtils.getJSONDataType((String)object, string)};
                stringBuffer.append(MessageFormat.format(CodeGenLrb.get("VALIDATE_CASEID_DATA_TYPE_NOT_SUPPORTED"), objectArray2));
                return false;
            }
        }
        if (!DbVersionHelper.isDB121Up((Version)version)) {
            for (Object object : buildNodeType.getMiningAttributes().getMiningAttribute()) {
                if (!"Yes".equals(object.getInput())) continue;
                string = object.getName();
                if (!object.getMiningType().equals("Text") && !object.getMiningType().equals("TextCustom")) continue;
                Object[] objectArray3 = new Object[]{string, object.getMiningType()};
                stringBuffer.append(MessageFormat.format(CodeGenLrb.get("VALIDATE_ATTR_MINING_TYPE_NOT_SUPPORTED"), objectArray3));
                return false;
            }
        }
        if (!DbVersionHelper.isDB122Up((Version)version) && buildNodeType.getPartitionExpressions() != null && !buildNodeType.getPartitionExpressions().getPartitionExpression().isEmpty()) {
            objectArray = new Object[]{buildNodeType.getName()};
            stringBuffer.append(MessageFormat.format(CodeGenLrb.get("VALIDATE_PARTITION_MODELS_NOT_SUPPORTED"), objectArray));
            return false;
        }
        return true;
    }

    @Override
    public void setNodeReady() {
        super.setNodeReady();
        BuildNodeType buildNodeType = this.getBuildNodeType();
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        for (ModelType modelType : list) {
            if (!modelType.getStatus().equals((Object)ModelStatusType.COMPLETE)) continue;
            ComplexProperty complexProperty = new ComplexProperty(MODEL_STATUS, new SubNodeProperty(modelType.getId(), ModelStatusType.READY));
            complexProperty.setOldData(new SubNodeProperty(modelType.getId(), modelType.getStatus()));
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
        }
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        String string2 = this.generateBuildNodeCode(context, string);
        String string3 = this.generateModelsCode(context, parameterizedSourceDefinitions);
        String string4 = CodeTemplate.updateBodyTemplate(string2, "<BUILD_MODELS>", string3);
        return string4;
    }

    private String generateBuildNodeCode(Context context, String string) {
        Object object5;
        Object object2;
        BuildNodeType buildNodeType = this.getBuildNodeType();
        String string2 = buildNodeType.getBuildDataSource().getSourceId();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.isSupervisedBuildNode();
        boolean bl2 = true;
        Object object3 = null;
        String string3 = null;
        String string4 = "";
        if (bl) {
            string4 = "WHERE LENGTH(TRIM('||v_target||')) IS NOT NULL";
        }
        String string5 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        CaseAttributes caseAttributes = buildNodeType.getCaseAttributes();
        if (caseAttributes != null && !caseAttributes.getAttribute().isEmpty()) {
            if (this instanceof AssociationBuildNode) {
                object2 = (AssociationBuildNodeType)buildNodeType;
                stringBuilder.setLength(0);
                stringBuilder.append(StringUtils.addDoubleQuotes((String)object2.getItemID().getName()));
                if (object2.getItemValue() != null) {
                    stringBuilder.append(",\n        ");
                    stringBuilder.append(StringUtils.addDoubleQuotes((String)object2.getItemValue().getName()));
                }
                if (buildNodeType.getPartitionExpressions() != null) {
                    for (Object object4 : buildNodeType.getPartitionExpressions().getPartitionExpression()) {
                        stringBuilder.append(",\n        ");
                        stringBuilder.append(StringUtils.addDoubleQuotes((String)object4.getPartitionAttribute().getName()));
                    }
                }
                stringBuilder.append(this.getAsociationAggregates((AssociationBuildNodeType)object2));
                if (caseAttributes.getAttribute().size() > 1) {
                    object5 = new StringBuilder();
                    for (AttributeType attributeType : caseAttributes.getAttribute()) {
                        if (((StringBuilder)object5).length() > 0) {
                            ((StringBuilder)object5).append(", ");
                        }
                        ((StringBuilder)object5).append(StringUtils.addDoubleQuotes((String)attributeType.getName()));
                    }
                    string3 = this.generateCaseIdColumn(context);
                    object3 = "  _START_CHECK_SQL_SIZE_ \n  v_sql := \n    'CREATE VIEW '||v_input_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n       SELECT RANK() OVER (ORDER BY <CASEID_LIST>) \"'||v_caseid||'\", \n        <ATTR_LIST> \n       FROM '||getInputSource('" + string2 + "')||' \n    )'; \n  execSQL(v_sql); \n  _END_CHECK_SQL_SIZE_ \n";
                    object3 = StringUtils.getReplacedString((String)object3, (String)"<PARALLEL_HINT>", (String)string5);
                    object3 = StringUtils.getReplacedString((String)object3, (String)"<CASEID_LIST>", (String)((StringBuilder)object5).toString());
                    object3 = StringUtils.getReplacedString((String)object3, (String)"<ATTR_LIST>", (String)stringBuilder.toString());
                    bl2 = true;
                }
            } else {
                string3 = ((AttributeType)caseAttributes.getAttribute().get(0)).getName();
                stringBuilder.setLength(0);
                for (Object object5 : buildNodeType.getMiningAttributes().getMiningAttribute()) {
                    if (!"Yes".equalsIgnoreCase(object5.getInput()) && !"Maybe".equalsIgnoreCase(object5.getInput()) || object5.getName().equals(string3)) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",\n        ");
                    }
                    stringBuilder.append(StringUtils.addDoubleQuotes((String)object5.getName()));
                }
            }
            if (caseAttributes.getAttribute().size() == 1) {
                string3 = ((AttributeType)caseAttributes.getAttribute().get(0)).getName();
                object3 = "  _START_CHECK_SQL_SIZE_ \n  v_sql := \n    'CREATE VIEW '||v_input_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT \"'||v_caseid||'\", \n        <ATTR_LIST> \n      FROM '||getInputSource('" + string2 + "')||' <FILTER_NULLS_SPACES> \n    )'; \n  execSQL(v_sql); \n  _END_CHECK_SQL_SIZE_ \n";
                object3 = StringUtils.getReplacedString((String)object3, (String)"<PARALLEL_HINT>", (String)string5);
                object3 = StringUtils.getReplacedString((String)object3, (String)"<ATTR_LIST>", (String)stringBuilder.toString());
                object3 = StringUtils.getReplacedString((String)object3, (String)"<FILTER_NULLS_SPACES>", (String)string4);
                bl2 = true;
            }
        } else {
            string3 = this.generateCaseIdColumn(context);
            stringBuilder.setLength(0);
            try {
                for (Object object5 : buildNodeType.getMiningAttributes().getMiningAttribute()) {
                    if (!"Yes".equalsIgnoreCase(object5.getInput()) && !"Maybe".equalsIgnoreCase(object5.getInput())) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",\n        ");
                    }
                    stringBuilder.append(StringUtils.addDoubleQuotes((String)object5.getName()));
                }
                if (bl) {
                    object2 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
                    object5 = new StringBuilder();
                    for (MiningAttributeType miningAttributeType : buildNodeType.getMiningAttributes().getMiningAttribute()) {
                        if (!"Yes".equalsIgnoreCase(miningAttributeType.getInput()) && !"Maybe".equalsIgnoreCase(miningAttributeType.getInput())) continue;
                        if (miningAttributeType.getDataType().equalsIgnoreCase("CLOB") || miningAttributeType.getDataType().equalsIgnoreCase("NCLOB")) {
                            if (((StringBuilder)object5).length() > 0) {
                                ((StringBuilder)object5).append(",\n        ");
                            }
                            ((StringBuilder)object5).append("LOB(" + StringUtils.addDoubleQuotes((String)miningAttributeType.getName()) + ") STORE AS BASICFILE");
                            continue;
                        }
                        if (miningAttributeType.getDataType().contains("NESTED")) {
                            if (((StringBuilder)object5).length() > 0) {
                                ((StringBuilder)object5).append(",\n        ");
                            }
                            ((StringBuilder)object5).append("NESTED TABLE " + StringUtils.addDoubleQuotes((String)miningAttributeType.getName()) + " STORE AS '||generateUniqueName||'");
                            continue;
                        }
                        if (!miningAttributeType.getDataType().equalsIgnoreCase("XMLTYPE")) continue;
                        if (((StringBuilder)object5).length() > 0) {
                            ((StringBuilder)object5).append(",\n        ");
                        }
                        ((StringBuilder)object5).append("XMLTYPE COLUMN " + StringUtils.addDoubleQuotes((String)miningAttributeType.getName()) + " STORE AS BASICFILE CLOB");
                    }
                    object3 = "  _START_CHECK_SQL_SIZE_ \n  v_sql := \n    'CREATE TABLE '||v_input_data||' \n        <STORAGE_CLAUSE> <TABLE_PARALLEL_HINT> COMPRESS \n    AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT ROWNUM \"'||v_caseid||'\", \n        <ATTR_LIST> \n      FROM '||getInputSource('" + string2 + "')||' <FILTER_NULLS_SPACES> \n    )'; \n  execSQL(v_sql); \n  _END_CHECK_SQL_SIZE_ \n";
                    object3 = StringUtils.getReplacedString((String)object3, (String)"<STORAGE_CLAUSE>", (String)((StringBuilder)object5).toString());
                    object3 = StringUtils.getReplacedString((String)object3, (String)"<TABLE_PARALLEL_HINT>", (String)object2);
                    object3 = StringUtils.getReplacedString((String)object3, (String)"<PARALLEL_HINT>", (String)string5);
                    object3 = StringUtils.getReplacedString((String)object3, (String)"<ATTR_LIST>", (String)stringBuilder.toString());
                    object3 = StringUtils.getReplacedString((String)object3, (String)"<FILTER_NULLS_SPACES>", (String)string4);
                    bl2 = false;
                } else {
                    object3 = "  _START_CHECK_SQL_SIZE_ \n  v_sql := \n    'CREATE VIEW '||v_input_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT ROWNUM \"'||v_caseid||'\", \n        <ATTR_LIST> \n      FROM '||getInputSource('" + string2 + "')||' <FILTER_NULLS_SPACES>\n    )'; \n  execSQL(v_sql); \n  _END_CHECK_SQL_SIZE_ \n";
                    object3 = StringUtils.getReplacedString((String)object3, (String)"<PARALLEL_HINT>", (String)string5);
                    object3 = StringUtils.getReplacedString((String)object3, (String)"<ATTR_LIST>", (String)stringBuilder.toString());
                    object3 = StringUtils.getReplacedString((String)object3, (String)"<FILTER_NULLS_SPACES>", (String)string4);
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        object3 = (String)object3 + "  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_input_data, '" + (bl2 ? "VIEW" : "TABLE") + "', NULL, 'Input Data'); \n";
        object2 = this.generateTextSettingsCode();
        object5 = CodeTemplate.updateBodyTemplate(string, "<CASEID>", string3);
        object5 = CodeTemplate.updateBodyTemplate((String)object5, "<INPUT_DATA>", (String)object3);
        object5 = CodeTemplate.updateBodyTemplate((String)object5, "<SOURCE_NODE_ID>", string2);
        object5 = CodeTemplate.updateBodyTemplate((String)object5, "<BUILD_TEXT_SETTING>", (String)object2);
        return object5;
    }

    public boolean isSupervisedBuildNode() {
        if (this instanceof ClassificationBuildNode || this instanceof RegressionBuildNode) {
            return true;
        }
        MiningFunctionType miningFunctionType = this.getMiningFunctionType();
        if (miningFunctionType == null) {
            return false;
        }
        return AbstractBuildNode.isSupervisedFunction(miningFunctionType);
    }

    private String getAsociationAggregates(AssociationBuildNodeType associationBuildNodeType) {
        ASSOAGGREGATES aSSOAGGREGATES;
        StringBuilder stringBuilder = new StringBuilder();
        if (DbVersionHelper.isDB122Up((Version)this.dbVersion) && (aSSOAGGREGATES = associationBuildNodeType.getASSOAGGREGATES()) != null && aSSOAGGREGATES.getAttribute() != null && aSSOAGGREGATES.getAttribute().size() > 0) {
            for (int i = 0; i < aSSOAGGREGATES.getAttribute().size(); ++i) {
                stringBuilder.append(",\n        ");
                stringBuilder.append(StringUtils.addDoubleQuotes((String)((AttributeType)aSSOAGGREGATES.getAttribute().get(i)).getName()));
            }
        }
        return stringBuilder.toString();
    }

    private String generateCaseIdColumn(Context context) {
        String string = null;
        try {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
            string = DatabaseMetadataUtils.createUniqueTempTableName("ODMR$", connectionFolder);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        return string;
    }

    private String generateTextSettingsCode() {
        Object object4;
        List list;
        List list2;
        Object object2;
        Object object32;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        BuildNodeType buildNodeType = this.getBuildNodeType();
        for (Object object32 : buildNodeType.getMiningAttributes().getMiningAttribute()) {
            if (!"Yes".equals(object32.getInput()) && !"Force".equals(object32.getInput())) continue;
            if (object32.getMiningType().equals("Text")) {
                bl = true;
            }
            if (object32.getMiningType().equals("TextCustom")) {
                arrayList.add(object32.getName());
            }
            if (!object32.getDataType().equals("BFILE") && !object32.getDataType().equals("BLOB")) continue;
            bl2 = true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            boolean bl3;
            BuildNodeType.TextSettings textSettings = buildNodeType.getTextSettings();
            String string = textSettings.getTransformType();
            if ("Token".equals(string)) {
                object2 = textSettings.getToken().getToken().getMaxNumberAllDocs();
                object32 = textSettings.getToken().getToken().getStoplistId();
                list2 = textSettings.getToken().getToken().getLanguages().getLanguage();
                list = textSettings.getToken().getToken().getLexer().getSettings().getAttribute();
            } else {
                object2 = textSettings.getTheme().getToken().getMaxNumberAllDocs();
                object32 = textSettings.getTheme().getToken().getStoplistId();
                list2 = textSettings.getTheme().getToken().getLanguages().getLanguage();
                list = textSettings.getTheme().getToken().getLexer().getSettings().getAttribute();
            }
            boolean bl4 = false;
            for (Object object4 : list) {
                if (!"index_stems".equals(object4.getName())) continue;
                bl4 = true;
                break;
            }
            stringBuilder.append("  v_policy_name := generateUniqueName; \n");
            stringBuilder.append("  v_lexer_name := generateUniqueName; \n");
            if (bl2) {
                stringBuilder.append("  v_auto_filter_name := (SUBSTR(v_lexer_name, 1, 28)||'_F'); \n");
            }
            boolean bl5 = bl3 = list2.size() > 1 || bl4;
            if (bl3) {
                stringBuilder.append("  ctx_ddl.create_preference(v_lexer_name, 'AUTO_LEXER'); \n");
            } else if ("TRADITIONAL CHINESE".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName()) || "SIMPLIFIED CHINESE".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName())) {
                stringBuilder.append("  ctx_ddl.create_preference(v_lexer_name, 'CHINESE_LEXER'); \n");
            } else if ("JAPANESE".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName())) {
                stringBuilder.append("  ctx_ddl.create_preference(v_lexer_name, 'JAPANESE_LEXER'); \n");
            } else if ("KOREAN".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName())) {
                stringBuilder.append("  ctx_ddl.create_preference(v_lexer_name, 'KOREAN_MORPH_LEXER'); \n");
            } else {
                stringBuilder.append("  ctx_ddl.create_preference(v_lexer_name, 'BASIC_LEXER'); \n");
            }
            stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_lexer_name, 'LEXER', 'Policy='||v_policy_name, 'Lexer'); \n");
            if (bl2) {
                stringBuilder.append("  ctx_ddl.create_preference(v_auto_filter_name, 'AUTO_FILTER'); \n");
                stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_auto_filter_name, 'AUTOFILTER', 'Policy='||v_policy_name, 'Auto Filter'); \n");
            }
            for (Object object5 : list) {
                if ("index_stems".equals(object5.getName())) {
                    if (bl3) {
                        stringBuilder.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object5.getName() + "', 'YES'); \n");
                        continue;
                    }
                    stringBuilder.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object5.getName() + "', '" + ((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName() + "'); \n");
                    continue;
                }
                if ("String".equals(object5.getType())) {
                    stringBuilder.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object5.getName() + "', '" + object5.getValueString() + "'); \n");
                    continue;
                }
                stringBuilder.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object5.getName() + "', " + object5.getValueNumber() + "); \n");
            }
            if (object32 != null) {
                stringBuilder.append("  v_stoplist_name := generateUniqueName; \n");
                if (bl3) {
                    stringBuilder.append("  ctx_ddl.create_stoplist(v_stoplist_name, 'MULTI_STOPLIST'); \n");
                } else {
                    stringBuilder.append("  ctx_ddl.create_stoplist(v_stoplist_name, 'BASIC_STOPLIST'); \n");
                }
                object4 = new HashMap();
                for (TransformationTokenType.Token.Languages.Language language : list2) {
                    object4.put(language.getName().toUpperCase(), Boolean.TRUE);
                }
                stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_stoplist_name, 'STOPLIST', 'Policy='||v_policy_name, 'Stoplist'); \n");
                for (TransformationTokenType.Token.Languages.Language language : buildNodeType.getStoplists().getStoplist()) {
                    if (!language.getId().equals(object32)) continue;
                    for (Object object6 : language.getStopTokens().getToken()) {
                        if (!object4.containsKey(object6.getLanguage().toUpperCase()) && !"ALL".equals(object6.getLanguage().toUpperCase())) continue;
                        if ("Token".equals(string) && "Word".equals(object6.getType())) {
                            if (bl3) {
                                stringBuilder.append("  ctx_ddl.add_stopword(v_stoplist_name, '" + StringUtils.escapeSingleQuotesForSQL((String)object6.getItem()) + "', '" + object6.getLanguage() + "'); \n");
                            } else {
                                stringBuilder.append("  ctx_ddl.add_stopword(v_stoplist_name, '" + StringUtils.escapeSingleQuotesForSQL((String)object6.getItem()) + "'); \n");
                            }
                        }
                        if (!"Theme".equals(string) || !"Theme".equals(object6.getType())) continue;
                        stringBuilder.append("  ctx_ddl.add_stoptheme(v_stoplist_name, '" + StringUtils.escapeSingleQuotesForSQL((String)object6.getItem()) + "'); \n");
                    }
                }
                if (bl2) {
                    stringBuilder.append("  ctx_ddl.create_policy(policy_name => v_policy_name, filter => v_auto_filter_name, lexer => v_lexer_name, stoplist => v_stoplist_name); \n");
                } else {
                    stringBuilder.append("  ctx_ddl.create_policy(policy_name => v_policy_name, lexer => v_lexer_name, stoplist => v_stoplist_name); \n");
                }
            } else if (bl2) {
                stringBuilder.append("  ctx_ddl.create_policy(policy_name => v_policy_name, filter => v_auto_filter_name, lexer => v_lexer_name); \n");
            } else {
                stringBuilder.append("  ctx_ddl.create_policy(policy_name => v_policy_name, lexer => v_lexer_name); \n");
            }
            stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_policy_name, 'POLICY', NULL, 'Policy'); \n");
        }
        for (String string : arrayList) {
            bl2 = false;
            for (MapTextTransformedSourceType mapTextTransformedSourceType : buildNodeType.getTextAttributes().getMapTextTransformedSource()) {
                boolean bl6;
                Object object72;
                if (!mapTextTransformedSourceType.getKey().getName().equals(string)) continue;
                object4 = mapTextTransformedSourceType.getKey().getTransformationElement();
                if (mapTextTransformedSourceType.getKey().getDataType().equals("BFILE") || mapTextTransformedSourceType.getKey().getDataType().equals("BLOB")) {
                    bl2 = true;
                }
                if (object4.getToken() != null) {
                    object2 = object4.getToken().getToken().getMaxNumberAllDocs();
                    object32 = object4.getToken().getToken().getStoplistId();
                    list2 = object4.getToken().getToken().getLanguages().getLanguage();
                    list = object4.getToken().getToken().getLexer().getSettings().getAttribute();
                } else {
                    object2 = object4.getTheme().getToken().getMaxNumberAllDocs();
                    object32 = object4.getTheme().getToken().getStoplistId();
                    list2 = object4.getTheme().getToken().getLanguages().getLanguage();
                    list = object4.getTheme().getToken().getLexer().getSettings().getAttribute();
                }
                boolean bl7 = false;
                for (Object object72 : list) {
                    if (!"index_stems".equals(object72.getName())) continue;
                    bl7 = true;
                    break;
                }
                stringBuilder.append("  v_policy_name := generateUniqueName; \n");
                stringBuilder.append("  v_lexer_name := generateUniqueName; \n");
                if (bl2) {
                    stringBuilder.append("  v_auto_filter_name := (SUBSTR(v_lexer_name, 1, 28)||'_F'); \n");
                }
                boolean bl8 = bl6 = list2.size() > 1 || bl7;
                if (bl6) {
                    stringBuilder.append("  ctx_ddl.create_preference(v_lexer_name, 'AUTO_LEXER'); \n");
                } else if ("TRADITIONAL CHINESE".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName()) || "SIMPLIFIED CHINESE".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName())) {
                    stringBuilder.append("  ctx_ddl.create_preference(v_lexer_name, 'CHINESE_LEXER'); \n");
                } else if ("JAPANESE".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName())) {
                    stringBuilder.append("  ctx_ddl.create_preference(v_lexer_name, 'JAPANESE_LEXER'); \n");
                } else if ("KOREAN".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName())) {
                    stringBuilder.append("  ctx_ddl.create_preference(v_lexer_name, 'KOREAN_MORPH_LEXER'); \n");
                } else {
                    stringBuilder.append("  ctx_ddl.create_preference(v_lexer_name, 'BASIC_LEXER'); \n");
                }
                stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_lexer_name, 'LEXER', 'Policy='||v_policy_name, 'Lexer'); \n");
                if (bl2) {
                    stringBuilder.append("  ctx_ddl.create_preference(v_auto_filter_name, 'AUTO_FILTER'); \n");
                    stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_auto_filter_name, 'AUTOFILTER', 'Policy='||v_policy_name, 'Auto Filter'); \n");
                }
                object72 = list.iterator();
                while (object72.hasNext()) {
                    Object object6;
                    object6 = (LexerType.Settings.Attribute)object72.next();
                    if ("index_stems".equals(object6.getName())) {
                        if (bl6) {
                            stringBuilder.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object6.getName() + "', 'YES'); \n");
                            continue;
                        }
                        stringBuilder.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object6.getName() + "', '" + ((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName() + "'); \n");
                        continue;
                    }
                    if ("String".equals(object6.getType())) {
                        stringBuilder.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object6.getName() + "', '" + object6.getValueString() + "'); \n");
                        continue;
                    }
                    stringBuilder.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object6.getName() + "', " + object6.getValueNumber() + "); \n");
                }
                if (object32 != null) {
                    stringBuilder.append("  v_stoplist_name := generateUniqueName; \n");
                    if (bl6) {
                        stringBuilder.append("  ctx_ddl.create_stoplist(v_stoplist_name, 'MULTI_STOPLIST'); \n");
                    } else {
                        stringBuilder.append("  ctx_ddl.create_stoplist(v_stoplist_name, 'BASIC_STOPLIST'); \n");
                    }
                    object72 = new HashMap();
                    for (TransformationTokenType.Token.Languages.Language language : list2) {
                        object72.put(language.getName().toUpperCase(), Boolean.TRUE);
                    }
                    stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_stoplist_name, 'STOPLIST', 'Policy='||v_policy_name, 'Stoplist'); \n");
                    for (TransformationTokenType.Token.Languages.Language language : buildNodeType.getStoplists().getStoplist()) {
                        if (!language.getId().equals(object32)) continue;
                        for (StoplistType.StopTokens.Token token : language.getStopTokens().getToken()) {
                            if (!object72.containsKey(token.getLanguage().toUpperCase()) && !"ALL".equals(token.getLanguage().toUpperCase())) continue;
                            if (object4.getToken() != null && "Word".equals(token.getType())) {
                                if (bl6) {
                                    stringBuilder.append("  ctx_ddl.add_stopword(v_stoplist_name, '" + StringUtils.escapeSingleQuotesForSQL((String)token.getItem()) + "', '" + token.getLanguage() + "'); \n");
                                } else {
                                    stringBuilder.append("  ctx_ddl.add_stopword(v_stoplist_name, '" + StringUtils.escapeSingleQuotesForSQL((String)token.getItem()) + "'); \n");
                                }
                            }
                            if (object4.getToken() != null || !"Theme".equals(token.getType())) continue;
                            stringBuilder.append("  ctx_ddl.add_stoptheme(v_stoplist_name, '" + StringUtils.escapeSingleQuotesForSQL((String)token.getItem()) + "'); \n");
                        }
                    }
                    if (bl2) {
                        stringBuilder.append("  ctx_ddl.create_policy(policy_name => v_policy_name, filter => v_auto_filter_name, lexer => v_lexer_name, stoplist => v_stoplist_name); \n");
                    } else {
                        stringBuilder.append("  ctx_ddl.create_policy(policy_name => v_policy_name, lexer => v_lexer_name, stoplist => v_stoplist_name); \n");
                    }
                } else if (bl2) {
                    stringBuilder.append("  ctx_ddl.create_policy(policy_name => v_policy_name, filter => v_auto_filter_name, lexer => v_lexer_name); \n");
                } else {
                    stringBuilder.append("  ctx_ddl.create_policy(policy_name => v_policy_name, lexer => v_lexer_name); \n");
                }
                stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_policy_name, 'POLICY', 'Column=" + string + "', 'Policy'); \n");
            }
        }
        return stringBuilder.toString();
    }

    private String generateModelsCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = CodeTemplate.getInstance().getTemplate(this.getModelTemplatePath());
        for (ModelType modelType : this.getModels()) {
            String string2 = this.generateModelCode(string, modelType, context, parameterizedSourceDefinitions);
            stringBuilder.append(string2);
        }
        String string3 = CodeTemplate.updateBodyTemplate(stringBuilder.toString(), "<MINING_FUNCTION>", this.getCodeGenerationMiningFunction());
        return string3;
    }

    protected String getModelTemplatePath() {
        return "workflow_generic_build_model.sql";
    }

    protected String generateModelCode(String string, ModelType modelType, Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions) {
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        String string2 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        MiningAttributes miningAttributes = modelType.getInputMiningData().getMiningAttributes();
        List list = miningAttributes == null ? Collections.emptyList() : miningAttributes.getMiningAttribute();
        String string3 = this.getDataUsageAttributesCode(list, version);
        String string4 = this.generateAttributeTransformationsCode(modelType, this.getTargetAttribute(), version);
        String string5 = this.generateModelBuildSettingsCode(modelType, version);
        String string6 = modelType.getName();
        parameterizedSourceDefinitions.addParameterizedSourceDefinition(this, this.schemaName, string6, DatabaseObjectType.MODEL);
        String string7 = parameterizedSourceDefinitions.getParmNameWithAmpersand(this, this.schemaName, string6, DatabaseObjectType.MODEL);
        String string8 = MiningAlgorithms.getModelTypeAlgorithm(modelType);
        Map<String, String> map = this.getAdditionalModelCodeTemplateReplacements(context, modelType);
        string = this.makeReplacementsInTemplate(string, map);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("<PARALLEL_HINT>", string2);
        hashMap.put("<DATA_USAGE_ATTRIBUTES>", string3);
        hashMap.put("<DATA_USAGE_TRANSFORMATIONS>", string4);
        hashMap.put("<BUILD_SETTING>", string5);
        hashMap.put("<MODEL_NAME_PARAM>", string7);
        hashMap.put("<BUILD_MODEL_ID>", modelType.getId());
        hashMap.put("<BUILD_MODEL_TYPE>", string8);
        string = this.makeReplacementsInTemplate(string, hashMap);
        return string;
    }

    protected String getDataUsageAttributesCode(List<MiningAttributeType> list, Version version) {
        String string = "";
        if (list != null) {
            string = list.stream().filter(miningAttributeType -> "Yes".equals(miningAttributeType.getInput())).map(miningAttributeType -> String.format("%s%s", "        ", StringUtils.addDoubleQuotes((String)miningAttributeType.getName()))).collect(Collectors.joining(Strings.COMMA_NEW_LINE));
        }
        return string;
    }

    protected String generateAttributeTransformationsCode(ModelType modelType, AttributeType attributeType, Version version) {
        assert (modelType != null && modelType.getInputMiningData() != null && modelType.getInputMiningData().getMiningAttributes() != null);
        BuildNodeType buildNodeType = this.getBuildNodeType();
        StringBuilder stringBuilder = new StringBuilder();
        MiningAttributes miningAttributes = modelType.getInputMiningData().getMiningAttributes();
        List list = miningAttributes.getMiningAttribute();
        if (!list.isEmpty()) {
            String string = null;
            if (attributeType != null) {
                string = attributeType.getName();
            }
            stringBuilder.append("  v_xlst := dbms_data_mining_transform.TRANSFORM_LIST(); \n");
            for (MiningAttributeType miningAttributeType : list) {
                if (!"Yes".equals(miningAttributeType.getInput()) && !"Force".equals(miningAttributeType.getInput())) continue;
                boolean bl = false;
                String string2 = null;
                String string3 = miningAttributeType.getDataType();
                String string4 = miningAttributeType.getMiningType();
                string2 = DbVersionHelper.isDB11202Up((Version)version) ? StringUtils.addDoubleQuotes((String)miningAttributeType.getName()) : StringUtils.escapeSingleQuotesForSQL((String)miningAttributeType.getName());
                String string5 = null;
                Object object = string2;
                String string6 = string2;
                StringBuilder stringBuilder2 = new StringBuilder();
                if ("No".equals(miningAttributeType.getAutoPrep())) {
                    stringBuilder2.append("NOPREP");
                    if (("DM_NESTED_NUMERICALS".equals(string3) || "DM_NESTED_CATEGORICALS".equals(string3) || "DM_NESTED_BINARY_DOUBLES".equals(string3) || "DM_NESTED_BINARY_FLOATS".equals(string3)) && DbVersionHelper.isDB11203Up((Version)version)) {
                        string2 = null;
                        string5 = StringUtils.escapeSingleQuotesForSQL((String)miningAttributeType.getName());
                        object = "value";
                        string6 = "value";
                    }
                    bl = true;
                }
                if (string == null || !string.equals(miningAttributeType.getName())) {
                    if ("NUMBER".equals(string3) && "Categorical".equals(string4)) {
                        object = "TO_CHAR(" + StringUtils.addDoubleQuotes((String)miningAttributeType.getName()) + ")";
                        string6 = null;
                        bl = true;
                    }
                    if (DbVersionHelper.isDB121Up((Version)version) && ("NVARCHAR2".equals(string3) || "NCHAR".equals(string3) || "VARCHAR2".equals(string3) || "CHAR".equals(string3)) && "Categorical".equals(string4)) {
                        object = "SUBSTRB(" + StringUtils.addDoubleQuotes((String)miningAttributeType.getName()) + ", 1, 4000)";
                        string6 = null;
                        bl = true;
                    }
                    if ("Force".equals(miningAttributeType.getInput())) {
                        if (stringBuilder2.length() > 0) {
                            stringBuilder2.append(",");
                        }
                        stringBuilder2.append("FORCE_IN");
                        bl = true;
                    }
                    if ("Text".equals(string4)) {
                        Object object2;
                        if (stringBuilder2.length() > 0) {
                            stringBuilder2.append(",");
                        }
                        Object object3 = null;
                        var22_22 = "NORMAL";
                        var23_23 = buildNodeType.getTextSettings().getTransformType();
                        if ("Token".equals(var23_23)) {
                            object2 = buildNodeType.getTextSettings().getToken().getToken().getMaxNumberAllDocs();
                            object3 = buildNodeType.getTextSettings().getToken().getToken().getMinNumberAllDocs();
                            var21_21 = buildNodeType.getTextSettings().getToken().getToken().getLexer().getSettings().getAttribute();
                            var24_24 = var21_21.iterator();
                            while (var24_24.hasNext()) {
                                var25_25 = (LexerType.Settings.Attribute)var24_24.next();
                                if (!"index_stems".equals(var25_25.getName())) continue;
                                var22_22 = "STEM";
                                break;
                            }
                        } else {
                            object2 = buildNodeType.getTextSettings().getTheme().getToken().getMaxNumberAllDocs();
                            object3 = buildNodeType.getTextSettings().getTheme().getToken().getMinNumberAllDocs();
                            var22_22 = "THEME";
                        }
                        stringBuilder2.append("TEXT(POLICY_NAME:'||getTextPolicy('" + buildNodeType.getId() + "')||')(MAX_FEATURES:" + ((BigInteger)object2).intValue() + ")");
                        if (object3 != null) {
                            stringBuilder2.append("(MIN_DOCUMENTS:" + ((BigInteger)object3).intValue() + ")");
                        }
                        stringBuilder2.append("(TOKEN_TYPE:" + (String)var22_22 + ")");
                        bl = true;
                    } else if ("TextCustom".equals(string4)) {
                        if (stringBuilder2.length() > 0) {
                            stringBuilder2.append(",");
                        }
                        for (Object object3 : buildNodeType.getTextAttributes().getMapTextTransformedSource()) {
                            var22_22 = null;
                            var24_24 = "NORMAL";
                            if (!object3.getKey().getName().equals(miningAttributeType.getName())) continue;
                            var25_25 = object3.getKey().getTransformationElement();
                            if (var25_25.getToken() != null) {
                                var21_21 = var25_25.getToken().getToken().getMaxNumberAllDocs();
                                var22_22 = var25_25.getToken().getToken().getMinNumberAllDocs();
                                var23_23 = var25_25.getToken().getToken().getLexer().getSettings().getAttribute();
                                Iterator iterator = var23_23.iterator();
                                while (iterator.hasNext()) {
                                    LexerType.Settings.Attribute attribute = (LexerType.Settings.Attribute)iterator.next();
                                    if (!"index_stems".equals(attribute.getName())) continue;
                                    var24_24 = "STEM";
                                    break;
                                }
                            } else {
                                var21_21 = var25_25.getTheme().getToken().getMaxNumberAllDocs();
                                var22_22 = var25_25.getToken().getToken().getMinNumberAllDocs();
                                var24_24 = "THEME";
                            }
                            stringBuilder2.append("TEXT(POLICY_NAME:'||getTextPolicy('" + this.getBuildNodeType().getId() + "', '" + miningAttributeType.getName() + "')||')(MAX_FEATURES:" + ((BigInteger)var21_21).intValue() + ")");
                            if (var22_22 != null) {
                                stringBuilder2.append("(MIN_DOCUMENTS:" + ((BigInteger)var22_22).intValue() + ")");
                            }
                            stringBuilder2.append("(TOKEN_TYPE:\"+tokenType+\")");
                            bl = true;
                            break;
                        }
                    }
                }
                if (!bl) continue;
                stringBuilder.append("  DBMS_DATA_MINING_TRANSFORM.SET_TRANSFORM(v_xlst, ");
                stringBuilder.append(string2 == null ? "NULL" : StringUtils.addSingleQuotes((String)string2));
                stringBuilder.append(", ");
                stringBuilder.append(string5 == null ? "NULL" : StringUtils.addSingleQuotes((String)string5));
                stringBuilder.append(", ");
                stringBuilder.append(StringUtils.addSingleQuotes((String)object));
                stringBuilder.append(", ");
                stringBuilder.append(string6 == null ? "NULL" : StringUtils.addSingleQuotes((String)string6));
                stringBuilder.append(", ");
                stringBuilder.append(stringBuilder2.length() == 0 ? "NULL" : StringUtils.addSingleQuotes((String)stringBuilder2.toString()));
                stringBuilder.append("); \n");
            }
        }
        return stringBuilder.toString();
    }

    private String generateModelBuildSettingsCode(ModelType modelType, Version version) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  execSQL('CREATE TABLE '||v_build_setting||' (SETTING_NAME VARCHAR2(30), SETTING_VALUE VARCHAR2(130))'); \n");
        stringBuilder.append(this.generateSpecificModelSettingsCode(modelType, version));
        List list = Collections.emptyList();
        InputMiningData inputMiningData = modelType.getInputMiningData();
        if (inputMiningData != null && (object = inputMiningData.getMiningAttributes()) != null) {
            list = object.getMiningAttribute();
        }
        object = this.generateAutoDataPreparationCode(list);
        stringBuilder.append((String)object);
        String string = this.generateCommonBuildSettingsCode();
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    protected abstract String generateSpecificModelSettingsCode(ModelType var1, Version var2);

    protected String generateAutoDataPreparationCode(List<MiningAttributeType> list) {
        boolean bl = this.isDataAutoPreparationOn(list);
        if (bl) {
            return "  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.PREP_AUTO||''', '''||DBMS_DATA_MINING.PREP_AUTO_ON||''')'); \n";
        }
        return "  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.PREP_AUTO||''', '''||DBMS_DATA_MINING.PREP_AUTO_OFF||''')'); \n";
    }

    protected boolean isDataAutoPreparationOn(List<MiningAttributeType> list) {
        boolean bl = false;
        if (list != null) {
            return list.stream().anyMatch(miningAttributeType -> ("Yes".equals(miningAttributeType.getInput()) || "Force".equals(miningAttributeType.getInput())) && !"No".equals(miningAttributeType.getAutoPrep()));
        }
        return bl;
    }

    private String generateCommonBuildSettingsCode() {
        int n;
        BuildNodeType buildNodeType = this.getBuildNodeType();
        StringBuilder stringBuilder = new StringBuilder();
        String string = MetaDataHelper.getQuotedPartitionKey(buildNodeType.getPartitionExpressions());
        if (StringUtils.isNotEmpty((String)string)) {
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_PARTITION_COLUMNS||''', ''" + string + "'')'); \n");
            n = buildNodeType.getMaxNumPartitions().intValue();
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES (''ODMS_MAX_PARTITIONS'', ''" + n + "'')'); \n");
        }
        if (DbVersionHelper.isDB122Up((Version)this.dbVersion)) {
            if (buildNodeType.isODMSSAMPLING()) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES (''ODMS_SAMPLING'', ''ODM_SAMPLING_ENABLE'')'); \n");
            } else {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES (''ODMS_SAMPLING'', ''ODMS_SAMPLING_DISABLE'')'); \n");
            }
            if (buildNodeType.getODMSSAMPLESIZE() != null) {
                n = buildNodeType.getODMSSAMPLESIZE().intValue();
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES (''ODMS_SAMPLE_SIZE'', ''" + n + "'')'); \n");
            }
            if (StringUtils.isNotEmpty((String)buildNodeType.getODMSPARTITIONBUILDTYPE())) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES (''ODMS_PARTITION_BUILD_TYPE'', ''" + buildNodeType.getODMSPARTITIONBUILDTYPE() + "'')'); \n");
            }
        }
        return stringBuilder.toString();
    }

    public abstract Map<String, String> getAdditionalModelCodeTemplateReplacements(Context var1, ModelType var2);

    protected String makeReplacementsInTemplate(String string, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string = CodeTemplate.updateBodyTemplate(string, entry.getKey(), entry.getValue());
        }
        return string;
    }

    protected String getCodeGenerationMiningFunction() {
        return String.format("DBMS_DATA_MINING.%s", this.getMiningFunctionType());
    }

    protected String generateInsertModelSettingCode(String string, Object object) {
        if (StringUtils.isEmpty((String)string) || object == null) {
            return "";
        }
        String string2 = object.toString();
        if (object instanceof String) {
            string2 = StringUtils.addSingleQuotes((String)string2);
            string2 = StringUtils.addSingleQuotes((String)string2);
        }
        return String.format("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.%s||''', %s)'); %n", string, string2);
    }

    public static StoplistType findDefaultStoplist(BuildNodeType.Stoplists stoplists, String string) {
        StoplistType stoplistType = null;
        if (string != null) {
            for (StoplistType stoplistType2 : stoplists.getStoplist()) {
                if (!"Default".equals(stoplistType2.getName())) continue;
                stoplistType = stoplistType2;
                break;
            }
        }
        return stoplistType;
    }

    public static String findStoplistId(BuildNodeType.Stoplists stoplists, String string) {
        StoplistType stoplistType = AbstractBuildNode.findStoplistWithName(stoplists, string);
        return stoplistType != null ? stoplistType.getId() : null;
    }

    public static StoplistType findStoplistWithName(BuildNodeType.Stoplists stoplists, String string) {
        StoplistType stoplistType = null;
        if (string != null) {
            for (StoplistType stoplistType2 : stoplists.getStoplist()) {
                if (!string.equals(stoplistType2.getName())) continue;
                stoplistType = stoplistType2;
            }
        }
        return stoplistType;
    }

    public static int getStoplistNextId(BuildNodeType.Stoplists stoplists) {
        int n = 0;
        for (StoplistType stoplistType : stoplists.getStoplist()) {
            int n2 = Integer.parseInt(stoplistType.getId());
            if (n >= n2) continue;
            n = n2;
        }
        return ++n;
    }

    public static List<String> stoplistCheckLanguagesUsed(String string, BuildNodeType buildNodeType, StoplistType stoplistType, String string2, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        AbstractTextNode.stoplistCheckLanguagesUsed(string, buildNodeType.getTextAttributes(), stoplistType, string2, list, arrayList);
        return arrayList;
    }

    private static void getDefaultTextAttributes(ModelType modelType, TextAttributes textAttributes) {
        MiningAttributes miningAttributes = modelType.getInputMiningData().getMiningAttributes();
        if (miningAttributes != null) {
            for (MiningAttributeType miningAttributeType : miningAttributes.getMiningAttribute()) {
                if (!"Text".equals(miningAttributeType.getMiningType())) continue;
                TextAttribute textAttribute = new TextAttribute(modelType.getName(), miningAttributeType.getName());
                textAttributes.addTextAttribute(textAttribute);
            }
        }
    }

    public static void copyTextSettingsFromBuildText(BuildTextNodeType buildTextNodeType, TextTransformationOutputAttributeType textTransformationOutputAttributeType, BuildNodeType buildNodeType, MiningAttributeType miningAttributeType, boolean bl, boolean bl2) {
        block54: {
            ClassificationBuildNodeType classificationBuildNodeType;
            Object object14;
            Object object22;
            block59: {
                block58: {
                    Object object3;
                    Object object4;
                    block57: {
                        block56: {
                            Object object5;
                            Object object6;
                            block55: {
                                Object object7;
                                block53: {
                                    Object object8;
                                    Object object92;
                                    Object object10;
                                    Object object11;
                                    Object object122;
                                    String string = null;
                                    Object object13 = null;
                                    StoplistType stoplistType = null;
                                    StoplistType stoplistType2 = null;
                                    TransformationTokenType transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getToken();
                                    string = transformationTokenType != null ? transformationTokenType.getToken().getStoplistId() : textTransformationOutputAttributeType.getTransformationElement().getTheme().getToken().getStoplistId();
                                    if (string != null) {
                                        for (Object object122 : buildTextNodeType.getStoplists().getStoplist()) {
                                            if (!object122.getId().equals(string)) continue;
                                            stoplistType = object122;
                                            break;
                                        }
                                        for (Object object122 : buildNodeType.getStoplists().getStoplist()) {
                                            if (!object122.getName().equals(stoplistType.getName())) continue;
                                            object13 = object122.getId();
                                            stoplistType2 = object122;
                                            break;
                                        }
                                    }
                                    if (stoplistType != null) {
                                        if (stoplistType.getName().equals("Default")) {
                                            if (bl) {
                                                object11 = (StoplistType)MetaDataHelper.copyMetadataObject(stoplistType);
                                                object11.setDBName(stoplistType2.getDBName());
                                                buildNodeType.getStoplists().getStoplist().remove(stoplistType2);
                                                buildNodeType.getStoplists().getStoplist().add(object11);
                                            }
                                        } else if (stoplistType2 != null) {
                                            if (bl2) {
                                                object11 = (StoplistType)MetaDataHelper.copyMetadataObject(stoplistType);
                                                object11.setId(stoplistType2.getId());
                                                object11.setDBName(stoplistType2.getDBName());
                                                buildNodeType.getStoplists().getStoplist().remove(stoplistType2);
                                                buildNodeType.getStoplists().getStoplist().add(object11);
                                            }
                                        } else {
                                            object13 = "" + AbstractBuildNode.getStoplistNextId(buildNodeType.getStoplists());
                                            object11 = (StoplistType)MetaDataHelper.copyMetadataObject(stoplistType);
                                            object11.setId((String)object13);
                                            object11.setDBName("");
                                            buildNodeType.getStoplists().getStoplist().add(object11);
                                        }
                                    }
                                    object11 = null;
                                    object122 = null;
                                    String string2 = null;
                                    boolean bl3 = false;
                                    TextTransformationType textTransformationType = null;
                                    for (Object object22 : buildNodeType.getTextAttributes().getMapTextTransformedSource()) {
                                        object14 = object22.getKey();
                                        if (!object14.getName().equals(miningAttributeType.getName())) continue;
                                        textTransformationType = object14.getTransformationElement();
                                        if (textTransformationType.getToken() != null) {
                                            object11 = textTransformationType.getToken().getToken().getStoplistId();
                                            object122 = textTransformationType.getToken().getToken().getPolicy();
                                            string2 = textTransformationType.getToken().getToken().getLexer().getName();
                                        } else {
                                            object11 = textTransformationType.getTheme().getToken().getStoplistId();
                                            object122 = textTransformationType.getTheme().getToken().getPolicy();
                                            string2 = textTransformationType.getTheme().getToken().getLexer().getName();
                                        }
                                        object22.setKey((TextTransformationOutputAttributeType)MetaDataHelper.copyMetadataObject(textTransformationOutputAttributeType));
                                        object14 = object22.getKey();
                                        object14.setName(object14.getSource());
                                        textTransformationType = object14.getTransformationElement();
                                        if (textTransformationType.getToken() != null) {
                                            textTransformationType.getToken().getToken().setStoplistId((String)(object13 != null ? object13 : object11));
                                            textTransformationType.getToken().getToken().setPolicy((String)object122);
                                            textTransformationType.getToken().getToken().getLexer().setName(string2);
                                        } else {
                                            textTransformationType.getTheme().getToken().setStoplistId((String)(object13 != null ? object13 : object11));
                                            textTransformationType.getTheme().getToken().setPolicy((String)object122);
                                            textTransformationType.getTheme().getToken().getLexer().setName(string2);
                                        }
                                        bl3 = true;
                                        break;
                                    }
                                    if (!bl3) {
                                        MapTextTransformedSourceType mapTextTransformedSourceType = new MapTextTransformedSourceType();
                                        mapTextTransformedSourceType.setKey((TextTransformationOutputAttributeType)MetaDataHelper.copyMetadataObject(textTransformationOutputAttributeType));
                                        buildNodeType.getTextAttributes().getMapTextTransformedSource().add(mapTextTransformedSourceType);
                                        object22 = mapTextTransformedSourceType.getKey();
                                        object22.setName(object22.getSource());
                                        textTransformationType = object22.getTransformationElement();
                                        if (textTransformationType.getToken() != null) {
                                            textTransformationType.getToken().getToken().setStoplistId((String)object13);
                                            textTransformationType.getToken().getToken().setPolicy("");
                                            textTransformationType.getToken().getToken().setFeatureTable(null);
                                            textTransformationType.getToken().getToken().setStatisticTable(null);
                                            textTransformationType.getToken().getToken().getLexer().setName("");
                                        } else {
                                            textTransformationType.getTheme().getToken().setStoplistId((String)object13);
                                            textTransformationType.getTheme().getToken().setPolicy("");
                                            textTransformationType.getTheme().getToken().setFeatureTable(null);
                                            textTransformationType.getTheme().getToken().setStatisticTable(null);
                                            textTransformationType.getTheme().getToken().getLexer().setName("");
                                        }
                                    }
                                    if (textTransformationType.getToken() != null) {
                                        textTransformationType.getToken().getToken().setFrequency("IDF");
                                    } else {
                                        boolean bl4 = false;
                                        for (Object object14 : textTransformationType.getTheme().getToken().getLexer().getSettings().getAttribute()) {
                                            if (!"index_themes".equals(object14.getName())) continue;
                                            bl4 = true;
                                            break;
                                        }
                                        if (!bl4) {
                                            object22 = new LexerType.Settings.Attribute();
                                            object22.setName("index_themes");
                                            object22.setType("String");
                                            object22.setValueString("YES");
                                            textTransformationType.getTheme().getToken().getLexer().getSettings().getAttribute().add(object22);
                                        }
                                        textTransformationType.getTheme().getToken().setFrequency("IDF");
                                    }
                                    for (Object object22 : buildNodeType.getMiningAttributes().getMiningAttribute()) {
                                        if (!object22.getName().equals(miningAttributeType.getName())) continue;
                                        object22.setMiningType("TextCustom");
                                        break;
                                    }
                                    if (!(buildNodeType instanceof ClassificationBuildNodeType)) break block53;
                                    classificationBuildNodeType = (ClassificationBuildNodeType)buildNodeType;
                                    object22 = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
                                    object14 = object22.iterator();
                                    block5: while (object14.hasNext()) {
                                        object10 = (ModelType)object14.next();
                                        for (Object object92 : object10.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                            if (!object92.getName().equals(miningAttributeType.getName())) continue;
                                            object92.setMiningType("TextCustom");
                                            continue block5;
                                        }
                                    }
                                    object14 = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
                                    object10 = object14.iterator();
                                    block7: while (object10.hasNext()) {
                                        object8 = (ModelType)object10.next();
                                        for (Object object15 : object8.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                            if (!object15.getName().equals(miningAttributeType.getName())) continue;
                                            object15.setMiningType("TextCustom");
                                            continue block7;
                                        }
                                    }
                                    object10 = classificationBuildNodeType.getModels().getDecisionTreeModel();
                                    object8 = object10.iterator();
                                    block9: while (object8.hasNext()) {
                                        object92 = (ModelType)object8.next();
                                        for (Object object16 : object92.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                            if (!object16.getName().equals(miningAttributeType.getName())) continue;
                                            object16.setMiningType("TextCustom");
                                            continue block9;
                                        }
                                    }
                                    object8 = classificationBuildNodeType.getModels().getNaiveBayesModel();
                                    object92 = object8.iterator();
                                    block11: while (object92.hasNext()) {
                                        Object object15;
                                        object15 = (ModelType)object92.next();
                                        for (MiningAttributeType miningAttributeType2 : object15.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                            if (!miningAttributeType2.getName().equals(miningAttributeType.getName())) continue;
                                            miningAttributeType2.setMiningType("TextCustom");
                                            continue block11;
                                        }
                                    }
                                    break block54;
                                }
                                if (!(buildNodeType instanceof RegressionBuildNodeType)) break block55;
                                classificationBuildNodeType = (RegressionBuildNodeType)buildNodeType;
                                object22 = classificationBuildNodeType.getModels().getRGeneralizedLinearModel();
                                object14 = object22.iterator();
                                block13: while (object14.hasNext()) {
                                    object7 = (ModelType)object14.next();
                                    for (Object object17 : object7.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                        if (!object17.getName().equals(miningAttributeType.getName())) continue;
                                        object17.setMiningType("TextCustom");
                                        continue block13;
                                    }
                                }
                                object14 = classificationBuildNodeType.getModels().getRSupportVectorMachineModel();
                                object7 = object14.iterator();
                                block15: while (object7.hasNext()) {
                                    ModelType modelType = (ModelType)object7.next();
                                    for (MiningAttributeType miningAttributeType3 : modelType.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                        if (!miningAttributeType3.getName().equals(miningAttributeType.getName())) continue;
                                        miningAttributeType3.setMiningType("TextCustom");
                                        continue block15;
                                    }
                                }
                                break block54;
                            }
                            if (!(buildNodeType instanceof ClusteringBuildNodeType)) break block56;
                            classificationBuildNodeType = (ClusteringBuildNodeType)buildNodeType;
                            object22 = classificationBuildNodeType.getModels().getExpectationMaximizationModel();
                            object14 = object22.iterator();
                            block17: while (object14.hasNext()) {
                                object6 = (ModelType)object14.next();
                                for (Object object18 : object6.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                    if (!object18.getName().equals(miningAttributeType.getName())) continue;
                                    object18.setMiningType("TextCustom");
                                    continue block17;
                                }
                            }
                            object14 = classificationBuildNodeType.getModels().getKMeansModel();
                            object6 = object14.iterator();
                            block19: while (object6.hasNext()) {
                                object5 = (ModelType)object6.next();
                                for (Object object19 : object5.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                    if (!object19.getName().equals(miningAttributeType.getName())) continue;
                                    object19.setMiningType("TextCustom");
                                    continue block19;
                                }
                            }
                            object6 = classificationBuildNodeType.getModels().getOClusterModel();
                            object5 = object6.iterator();
                            block21: while (object5.hasNext()) {
                                Object object18;
                                object18 = (ModelType)object5.next();
                                for (MiningAttributeType miningAttributeType4 : object18.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                    if (!miningAttributeType4.getName().equals(miningAttributeType.getName())) continue;
                                    miningAttributeType4.setMiningType("TextCustom");
                                    continue block21;
                                }
                            }
                            break block54;
                        }
                        if (!(buildNodeType instanceof AssociationBuildNodeType)) break block57;
                        classificationBuildNodeType = (AssociationBuildNodeType)buildNodeType;
                        object22 = classificationBuildNodeType.getModels().getAprioriModel();
                        object14 = object22.iterator();
                        block23: while (object14.hasNext()) {
                            ModelType modelType = (ModelType)object14.next();
                            for (MiningAttributeType miningAttributeType5 : modelType.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                if (!miningAttributeType5.getName().equals(miningAttributeType.getName())) continue;
                                miningAttributeType5.setMiningType("TextCustom");
                                continue block23;
                            }
                        }
                        break block54;
                    }
                    if (!(buildNodeType instanceof FeatureExtractionBuildNodeType)) break block58;
                    classificationBuildNodeType = (FeatureExtractionBuildNodeType)buildNodeType;
                    object22 = classificationBuildNodeType.getModels().getNonNegativeMatrixFactorModel();
                    object14 = object22.iterator();
                    block25: while (object14.hasNext()) {
                        object4 = (ModelType)object14.next();
                        for (Object object20 : object4.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                            if (!object20.getName().equals(miningAttributeType.getName())) continue;
                            object20.setMiningType("TextCustom");
                            continue block25;
                        }
                    }
                    object14 = classificationBuildNodeType.getModels().getPCAModel();
                    object4 = object14.iterator();
                    block27: while (object4.hasNext()) {
                        object3 = (ModelType)object4.next();
                        for (Object object21 : object3.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                            if (!object21.getName().equals(miningAttributeType.getName())) continue;
                            object21.setMiningType("TextCustom");
                            continue block27;
                        }
                    }
                    object4 = classificationBuildNodeType.getModels().getSVDModel();
                    object3 = object4.iterator();
                    block29: while (object3.hasNext()) {
                        Object object20;
                        object20 = (ModelType)object3.next();
                        for (MiningAttributeType miningAttributeType6 : object20.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                            if (!miningAttributeType6.getName().equals(miningAttributeType.getName())) continue;
                            miningAttributeType6.setMiningType("TextCustom");
                            continue block29;
                        }
                    }
                    break block54;
                }
                if (!(buildNodeType instanceof AnomalyDetectionBuildNodeType)) break block59;
                classificationBuildNodeType = (AnomalyDetectionBuildNodeType)buildNodeType;
                object22 = classificationBuildNodeType.getModels().getAnomalyDetectionModel();
                object14 = object22.iterator();
                block31: while (object14.hasNext()) {
                    ModelType modelType = (ModelType)object14.next();
                    for (MiningAttributeType miningAttributeType7 : modelType.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                        if (!miningAttributeType7.getName().equals(miningAttributeType.getName())) continue;
                        miningAttributeType7.setMiningType("TextCustom");
                        continue block31;
                    }
                }
                break block54;
            }
            if (!(buildNodeType instanceof ExplicitFeatureExtractionBuildNodeType)) break block54;
            classificationBuildNodeType = (ExplicitFeatureExtractionBuildNodeType)buildNodeType;
            object22 = classificationBuildNodeType.getModels().getExplicitSemanticAnalysisModel();
            object14 = object22.iterator();
            block33: while (object14.hasNext()) {
                ModelType modelType = (ModelType)object14.next();
                for (MiningAttributeType miningAttributeType8 : modelType.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                    if (!miningAttributeType8.getName().equals(miningAttributeType.getName())) continue;
                    miningAttributeType8.setMiningType("TextCustom");
                    continue block33;
                }
            }
        }
    }

    public static List<TextAttribute> getDefaultTextAttributes(BuildNodeType buildNodeType) {
        TextAttributes textAttributes;
        block17: {
            block23: {
                block22: {
                    block21: {
                        Object object;
                        Object object22;
                        block20: {
                            block19: {
                                Object object3;
                                Object object42;
                                block18: {
                                    Object object52;
                                    block16: {
                                        Object object6;
                                        Object object7;
                                        Object object82;
                                        textAttributes = new TextAttributes();
                                        if (!(buildNodeType instanceof ClassificationBuildNodeType)) break block16;
                                        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)buildNodeType;
                                        List list = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
                                        for (Object object82 : list) {
                                            AbstractBuildNode.getDefaultTextAttributes((ModelType)object82, textAttributes);
                                        }
                                        List list2 = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
                                        object82 = list2.iterator();
                                        while (object82.hasNext()) {
                                            object7 = (ModelType)object82.next();
                                            AbstractBuildNode.getDefaultTextAttributes((ModelType)object7, textAttributes);
                                        }
                                        object82 = classificationBuildNodeType.getModels().getDecisionTreeModel();
                                        object7 = object82.iterator();
                                        while (object7.hasNext()) {
                                            object6 = (ModelType)object7.next();
                                            AbstractBuildNode.getDefaultTextAttributes((ModelType)object6, textAttributes);
                                        }
                                        object7 = classificationBuildNodeType.getModels().getNaiveBayesModel();
                                        object6 = object7.iterator();
                                        while (object6.hasNext()) {
                                            ModelType modelType = (ModelType)object6.next();
                                            AbstractBuildNode.getDefaultTextAttributes(modelType, textAttributes);
                                        }
                                        break block17;
                                    }
                                    if (!(buildNodeType instanceof RegressionBuildNodeType)) break block18;
                                    RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)buildNodeType;
                                    List list = regressionBuildNodeType.getModels().getRGeneralizedLinearModel();
                                    for (Object object52 : list) {
                                        AbstractBuildNode.getDefaultTextAttributes((ModelType)object52, textAttributes);
                                    }
                                    List list3 = regressionBuildNodeType.getModels().getRSupportVectorMachineModel();
                                    object52 = list3.iterator();
                                    while (object52.hasNext()) {
                                        ModelType modelType = (ModelType)object52.next();
                                        AbstractBuildNode.getDefaultTextAttributes(modelType, textAttributes);
                                    }
                                    break block17;
                                }
                                if (!(buildNodeType instanceof ClusteringBuildNodeType)) break block19;
                                ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)buildNodeType;
                                List list = clusteringBuildNodeType.getModels().getExpectationMaximizationModel();
                                for (Object object42 : list) {
                                    AbstractBuildNode.getDefaultTextAttributes((ModelType)object42, textAttributes);
                                }
                                List list4 = clusteringBuildNodeType.getModels().getKMeansModel();
                                object42 = list4.iterator();
                                while (object42.hasNext()) {
                                    object3 = (ModelType)object42.next();
                                    AbstractBuildNode.getDefaultTextAttributes((ModelType)object3, textAttributes);
                                }
                                object42 = clusteringBuildNodeType.getModels().getOClusterModel();
                                object3 = object42.iterator();
                                while (object3.hasNext()) {
                                    ModelType modelType = (ModelType)object3.next();
                                    AbstractBuildNode.getDefaultTextAttributes(modelType, textAttributes);
                                }
                                break block17;
                            }
                            if (!(buildNodeType instanceof AssociationBuildNodeType)) break block20;
                            AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)buildNodeType;
                            List list = associationBuildNodeType.getModels().getAprioriModel();
                            for (ModelType modelType : list) {
                                AbstractBuildNode.getDefaultTextAttributes(modelType, textAttributes);
                            }
                            break block17;
                        }
                        if (!(buildNodeType instanceof FeatureExtractionBuildNodeType)) break block21;
                        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)buildNodeType;
                        List list = featureExtractionBuildNodeType.getModels().getNonNegativeMatrixFactorModel();
                        for (Object object22 : list) {
                            AbstractBuildNode.getDefaultTextAttributes((ModelType)object22, textAttributes);
                        }
                        List list5 = featureExtractionBuildNodeType.getModels().getPCAModel();
                        object22 = list5.iterator();
                        while (object22.hasNext()) {
                            object = (ModelType)object22.next();
                            AbstractBuildNode.getDefaultTextAttributes((ModelType)object, textAttributes);
                        }
                        object22 = featureExtractionBuildNodeType.getModels().getSVDModel();
                        object = object22.iterator();
                        while (object.hasNext()) {
                            ModelType modelType = (ModelType)object.next();
                            AbstractBuildNode.getDefaultTextAttributes(modelType, textAttributes);
                        }
                        break block17;
                    }
                    if (!(buildNodeType instanceof AnomalyDetectionBuildNodeType)) break block22;
                    AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)buildNodeType;
                    List list = anomalyDetectionBuildNodeType.getModels().getAnomalyDetectionModel();
                    for (ModelType modelType : list) {
                        AbstractBuildNode.getDefaultTextAttributes(modelType, textAttributes);
                    }
                    break block17;
                }
                if (!(buildNodeType instanceof ExplicitFeatureExtractionBuildNodeType)) break block23;
                ExplicitFeatureExtractionBuildNodeType explicitFeatureExtractionBuildNodeType = (ExplicitFeatureExtractionBuildNodeType)buildNodeType;
                List list = explicitFeatureExtractionBuildNodeType.getModels().getExplicitSemanticAnalysisModel();
                for (ModelType modelType : list) {
                    AbstractBuildNode.getDefaultTextAttributes(modelType, textAttributes);
                }
                break block17;
            }
            if (!(buildNodeType instanceof RBuildNodeType)) break block17;
            RBuildNodeType rBuildNodeType = (RBuildNodeType)buildNodeType;
            List list = rBuildNodeType.getModels().getRModel();
            for (ModelType modelType : list) {
                AbstractBuildNode.getDefaultTextAttributes(modelType, textAttributes);
            }
        }
        return textAttributes.getTextAttributes();
    }

    public static boolean isSupervisedFunction(MiningFunctionType miningFunctionType) {
        switch (miningFunctionType) {
            case CLASSIFICATION: 
            case REGRESSION: {
                return true;
            }
        }
        return false;
    }
}

