/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.CustomPIPopupListener;
import oracle.dmt.dataminer.controls.DataMinerCombBox;
import oracle.dmt.dataminer.controls.ToolTipComboBoxRenderer;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.CaseEditRecord;
import oracle.dmt.dataminer.workflow.dialog.build.TargetEditRecord;
import oracle.dmt.dataminer.workflow.inspect.ClassificationBuildPIComponentGUI;
import oracle.dmt.dataminer.workflow.inspect.ClassificationBuildPIComponentHelper;
import oracle.dmt.dataminer.workflow.inspect.ModelBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;

public class ClassificationBuildPIComponentTargetPanel
extends JPanel
implements ClassificationBuildPIComponentGUI {
    private static final Logger theLogger = Logger.getLogger(ClassificationBuildPIComponentTargetPanel.class.getName());
    private DataMinerCombBox jCaseCombo;
    private DataMinerCombBox jCmbTarget;
    private JLabel jLblCaseIds;
    private JLabel jLblTarget;
    private JLabel statusCaseIcon;
    private JLabel statusTargetIcon;
    private WorkflowNodePropertyProxyModel _model;
    private TargetEditRecord targetEdits;
    private CaseEditRecord caseEdits;
    private List<ModelType> _models;
    private List<ClassificationResultType> _classResults;
    private boolean _clearSearchState = true;

    public ClassificationBuildPIComponentTargetPanel(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this._classResults = MetaDataHelper.getClassificationResultsCollection(abstractBuildNode);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jLblTarget = new JLabel();
        this.jCmbTarget = new DataMinerCombBox();
        this.jLblCaseIds = new JLabel();
        this.jCaseCombo = new DataMinerCombBox();
        this.statusTargetIcon = new JLabel();
        this.statusCaseIcon = new JLabel();
        this.jLblTarget.setText("Target:");
        this.jLblTarget.setMinimumSize(new Dimension(80, 14));
        this.jLblTarget.setPreferredSize(new Dimension(80, 20));
        this.jCmbTarget.setModel(new DefaultComboBoxModel<String>(new String[]{"GENDER", "AFFINITY_CARD"}));
        this.jCmbTarget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationBuildPIComponentTargetPanel.this.jCmbTargetActionPerformed(actionEvent);
            }
        });
        this.jLblCaseIds.setText("Case IDs:");
        this.jCaseCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.statusTargetIcon.setText("warningIcon");
        this.statusCaseIcon.setText("warningIcon");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblTarget, -2, -1, -2).addComponent(this.jLblCaseIds)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCaseCombo, -2, 190, -2).addComponent(this.jCmbTarget, -2, 190, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusTargetIcon).addComponent(this.statusCaseIcon)).addContainerGap(47, Short.MAX_VALUE)));
        groupLayout.linkSize(0, this.jLblCaseIds, this.jLblTarget);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCmbTarget, -2, -1, -2).addComponent(this.statusTargetIcon)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCaseCombo, -2, -1, -2).addComponent(this.jLblCaseIds).addComponent(this.statusCaseIcon))).addComponent(this.jLblTarget, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jLblCaseIds, this.jLblTarget);
        groupLayout.linkSize(1, this.jCaseCombo, this.jCmbTarget);
    }

    private void jCmbTargetActionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public boolean getClearState() {
        return this._clearSearchState;
    }

    @Override
    public void setClearState(boolean bl) {
        this._clearSearchState = bl;
    }

    @Override
    public JPanel getGUIComponent() {
        return this;
    }

    @Override
    public boolean isWritable() {
        return ClassificationBuildPIComponentHelper.isWritable((PropertyModel)this._model);
    }

    @Override
    public AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        return ClassificationBuildPIComponentHelper.getTargetNode(propertyModel);
    }

    @Override
    public Context getContext(PropertyModel propertyModel) {
        return ClassificationBuildPIComponentHelper.getContext(propertyModel);
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLblTarget, (Component)this.jCmbTarget, (String)(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET") + ":"));
        ResourceUtils.resLabel((JLabel)this.jLblCaseIds, (Component)this.jCaseCombo, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_CASE_IDS"));
        this.jLblCaseIds.setHorizontalTextPosition(2);
        this.jLblTarget.setHorizontalTextPosition(2);
        this.statusTargetIcon.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusTargetIcon.setText("");
        this.statusTargetIcon.setToolTipText(PropertyLrb.get("PI_ATTRIBUTES_TARGET_INVALID"));
        this.statusCaseIcon.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusCaseIcon.setText("");
        this.statusCaseIcon.setToolTipText(PropertyLrb.get("PI_ATTRIBUTES_CASEID_INVALID"));
        this.initIconResources();
    }

    public void initUI(PropertyModel propertyModel) {
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        boolean bl = this.isWritable();
        this.jCmbTarget.setEnabled(bl);
        this.jCaseCombo.setEnabled(bl);
        BuildNodeType buildNodeType = (BuildNodeType)abstractBuildNode.getData();
        List list = buildNodeType.getMiningAttributes().getMiningAttribute();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        if (buildNodeType instanceof SuperviseBuildNodeType) {
            this.initTargetAttrUI((SuperviseBuildNodeType)buildNodeType, list);
        } else {
            this.remove(this.jCmbTarget);
            this.remove(this.jLblTarget);
            this.statusCaseIcon.setVisible(false);
            this.remove(this.statusCaseIcon);
            this.statusTargetIcon.setVisible(false);
            this.remove(this.statusTargetIcon);
        }
        this.loadCaseIdUI(buildNodeType);
        this.jCaseCombo.addPopupMenuListener(new CustomPIPopupListener(){

            @Override
            public void updatePropertyModel(Object object) {
                if (!ClassificationBuildPIComponentTargetPanel.this.isWritable()) {
                    return;
                }
                if (object instanceof CaseIdItem) {
                    CaseIdItem caseIdItem = (CaseIdItem)object;
                    AttributeType attributeType = caseIdItem.item;
                    ClassificationBuildPIComponentTargetPanel.this.caseEdits.getCaseAttributes().getAttribute().clear();
                    ClassificationBuildPIComponentTargetPanel.this.caseEdits.getCaseAttributes().getAttribute().add(attributeType);
                    ClassificationBuildPIComponentTargetPanel.this.setValue(ClassificationBuildPIComponentTargetPanel.this.caseEdits);
                } else {
                    ClassificationBuildPIComponentTargetPanel.this.caseEdits.getCaseAttributes().getAttribute().clear();
                    ClassificationBuildPIComponentTargetPanel.this.setValue(ClassificationBuildPIComponentTargetPanel.this.caseEdits);
                }
            }
        });
    }

    public void reloadUI(PropertyModel propertyModel) {
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        BuildNodeType buildNodeType = (BuildNodeType)abstractBuildNode.getData();
        List list = buildNodeType.getMiningAttributes().getMiningAttribute();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        if (buildNodeType instanceof SuperviseBuildNodeType) {
            this.reloadTargetAttrUI((SuperviseBuildNodeType)buildNodeType, list);
        }
        this.loadCaseIdUI(buildNodeType);
    }

    private void initIconResources() {
    }

    private void reloadTargetAttrUI(SuperviseBuildNodeType superviseBuildNodeType, List<MiningAttributeType> list) {
        this.jCmbTarget.removeAllItems();
        for (MiningAttributeType miningAttributeType : list) {
            try {
                if (!DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this.getContext((PropertyModel)this._model), miningAttributeType.getDataType())) continue;
                this.jCmbTarget.addItem(new TargetItem(miningAttributeType));
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                return;
            }
        }
        AttributeType attributeType = superviseBuildNodeType.getTargetAttribute();
        if (attributeType == null) {
            this.jCmbTarget.insertItemAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET_START_VALUE"), 0);
            this.jCmbTarget.setSelectedIndex(0);
            this.statusTargetIcon.setVisible(true);
        } else if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
            this.jCmbTarget.setEditable(true);
            this.jCmbTarget.setSelectedItem(new TargetItem(attributeType));
            this.jCmbTarget.setEditable(false);
            this.statusTargetIcon.setVisible(true);
        } else {
            this.jCmbTarget.setSelectedItem(new TargetItem(attributeType));
            this.statusTargetIcon.setVisible(false);
        }
    }

    private void loadCaseIdUI(BuildNodeType buildNodeType) {
        Object object;
        AttributeType attributeType3;
        AttributeType attributeType2;
        Object object2;
        List list = buildNodeType.getMiningAttributes().getMiningAttribute();
        if (this.caseEdits == null) {
            this.caseEdits = new CaseEditRecord(new CaseAttributes());
        } else {
            object2 = this.caseEdits.getCaseAttributes();
            if (object2 != null && (attributeType2 = this.caseEdits.getCaseAttributes().getAttribute()) != null) {
                attributeType2.clear();
            }
        }
        object2 = buildNodeType.getCaseAttributes().getAttribute();
        attributeType2 = object2.iterator();
        while (attributeType2.hasNext()) {
            attributeType3 = (AttributeType)attributeType2.next();
            object = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType3);
            this.caseEdits.getCaseAttributes().getAttribute().add(object);
        }
        this.jCaseCombo.removeAllItems();
        this.jCaseCombo.addItem(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID_NONE"));
        for (AttributeType attributeType3 : list) {
            if (!DatabaseMetadataUtils.isCaseIdDataTypeSupported(this.getContext((PropertyModel)this._model), attributeType3.getDataType())) continue;
            this.jCaseCombo.addItem(new CaseIdItem((MiningAttributeType)attributeType3));
        }
        attributeType2 = null;
        if (object2.size() != 0) {
            attributeType2 = (AttributeType)object2.get(0);
        } else {
            this.jCaseCombo.setSelectedIndex(0);
        }
        this.jCaseCombo.setRenderer(new ToolTipComboBoxRenderer());
        if (attributeType2 != null && attributeType2.getStatus().equals((Object)AttributeStatus.VALID)) {
            boolean bl = false;
            for (int i = 0; i < this.jCaseCombo.getItemCount(); ++i) {
                if (!(this.jCaseCombo.getItemAt(i) instanceof CaseIdItem)) continue;
                CaseIdItem caseIdItem = (CaseIdItem)this.jCaseCombo.getItemAt(i);
                if (!attributeType2.getName().equals(caseIdItem.item.getName()) || !attributeType2.getDataType().equals(caseIdItem.item.getDataType())) continue;
                this.jCaseCombo.setSelectedIndex(i);
                bl = true;
            }
            if (!bl) {
                theLogger.log(Level.WARNING, "Could not find the case id value event though it is valid");
            } else {
                this.statusCaseIcon.setVisible(false);
            }
        } else if (attributeType2 != null && attributeType2.getStatus().equals((Object)AttributeStatus.INVALID)) {
            attributeType3 = MetaDataHelper.createMiningAttributeFrom(attributeType2);
            object = new CaseIdItem((MiningAttributeType)attributeType3);
            this.jCaseCombo.setEditable(true);
            this.jCaseCombo.setSelectedItem(object);
            this.jCaseCombo.setEditable(false);
            this.statusCaseIcon.setText("");
            this.statusCaseIcon.setVisible(true);
            this.statusCaseIcon.setToolTipText(PropertyLrb.get("PI_ATTRIBUTES_CASEID_INVALID"));
        } else if (attributeType2 == null) {
            this.statusCaseIcon.setText(BuildEditorLrb.get("BUILD_NODE_CASE_ID_WARN"));
            this.statusCaseIcon.setVisible(true);
        }
    }

    private void initTargetAttrUI(SuperviseBuildNodeType superviseBuildNodeType, List<MiningAttributeType> list) {
        this.jCmbTarget.removeAllItems();
        for (MiningAttributeType miningAttributeType : list) {
            try {
                if (!DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this.getContext((PropertyModel)this._model), miningAttributeType.getDataType())) continue;
                this.jCmbTarget.addItem(new TargetItem(miningAttributeType));
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                return;
            }
        }
        this.jCmbTarget.setRenderer(new ToolTipComboBoxRenderer());
        AttributeType attributeType = superviseBuildNodeType.getTargetAttribute();
        if (attributeType == null) {
            this.jCmbTarget.insertItemAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET_START_VALUE"), 0);
            this.jCmbTarget.setSelectedIndex(0);
            this.statusTargetIcon.setVisible(true);
        } else if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
            this.jCmbTarget.insertItemAt(new TargetItem(attributeType), 0);
            this.jCmbTarget.setSelectedIndex(0);
            this.statusTargetIcon.setVisible(true);
        } else {
            this.jCmbTarget.setSelectedItem(new TargetItem(attributeType));
            this.statusTargetIcon.setVisible(false);
        }
        this.jCmbTarget.addPopupMenuListener(new CustomPIPopupListener(){

            @Override
            public void updatePropertyModel(Object object) {
                if (!ClassificationBuildPIComponentTargetPanel.this.isWritable()) {
                    return;
                }
                if (object instanceof TargetItem) {
                    TargetItem targetItem = (TargetItem)object;
                    AttributeType attributeType = targetItem.item;
                    if (ClassificationBuildPIComponentTargetPanel.this.targetEdits == null) {
                        ClassificationBuildPIComponentTargetPanel.this.targetEdits = new TargetEditRecord();
                    } else {
                        TargetItem targetItem2 = new TargetItem(ClassificationBuildPIComponentTargetPanel.this.targetEdits.getTargetAttribute());
                        if (targetItem2.equals(targetItem)) {
                            return;
                        }
                    }
                    ClassificationBuildPIComponentTargetPanel.this.targetEdits.setTargetAttribute((AttributeType)MetaDataHelper.copyMetadataObject(attributeType));
                    if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        ClassificationBuildPIComponentTargetPanel.this.statusTargetIcon.setVisible(true);
                    } else {
                        ClassificationBuildPIComponentTargetPanel.this.statusTargetIcon.setVisible(false);
                    }
                    if (ClassificationBuildPIComponentTargetPanel.this.jCmbTarget.getItemAt(0) instanceof String) {
                        ClassificationBuildPIComponentTargetPanel.this.jCmbTarget.removeItemAt(0);
                    }
                    ClassificationBuildPIComponentTargetPanel.this.setValue(ClassificationBuildPIComponentTargetPanel.this.targetEdits);
                }
            }
        });
    }

    private void setValue(TargetEditRecord targetEditRecord) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        if (targetEditRecord != null) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TARGET.index), null, new ComplexProperty("targetAttribute", targetEditRecord.getTargetAttribute()), null, null));
            ArrayList<ModelType> arrayList2 = new ArrayList<ModelType>();
            arrayList2.addAll(this._models);
            arrayList.addAll(this.prepareStatusReady(arrayList2));
            ModelBuildNodePropertyModel.updateTargetModelAttributes((BuildNodeType)((SuperviseBuildNodeType)abstractBuildNode.getData()), arrayList, ModelBuildNodePropertyModel.MINING_ATTRIBUTE_SETTINGS.index, targetEditRecord.getTargetAttribute());
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setValue(CaseEditRecord caseEditRecord) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        ClassificationBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap, hashMap2);
        if (caseEditRecord != null && hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            CaseAttributes caseAttributes = new CaseAttributes();
            caseAttributes.getAttribute().addAll(caseEditRecord.getCaseAttributes().getAttribute());
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.CASE_IDS.index), null, new ComplexProperty("caseAttributes", caseAttributes), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.MODELS_RERUN.index), null, new ComplexProperty("modelsRerun", hashMap), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
            BuildNodeType buildNodeType = (BuildNodeType)abstractBuildNode.getData();
            ModelBuildNodePropertyModel.updateCaseIdModelAttributes(buildNodeType, arrayList, ModelBuildNodePropertyModel.MINING_ATTRIBUTE_SETTINGS.index, caseAttributes);
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void updateWorkFlow() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            WorkflowNode workflowNode = workflowEditor.getWorkflowNode();
            Node node = workflowEditor.getSelectedDiagramNode();
            if (node != null) {
                workflowEditor.setSelected(workflowNode.getEngine(), node);
            }
        }
    }

    private List<Property> prepareStatusReady(List<ModelType> list) {
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        for (ModelType object2 : list) {
            hashMap.put(object2.getId(), ModelStatusType.READY);
        }
        HashMap hashMap2 = new HashMap();
        for (ClassificationResultType classificationResultType : this._classResults) {
            if (null == hashMap.get(classificationResultType.getModelId())) continue;
            hashMap2.put(classificationResultType.getModelId(), ModelStatusType.READY);
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        if (list != null && !list.isEmpty()) {
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.MODELS_RERUN.index), null, new ComplexProperty("modelsRerun", hashMap), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
        }
        return arrayList;
    }

    public void resetModelSettingsTable(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models.clear();
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this._classResults.clear();
        this._classResults = MetaDataHelper.getClassificationResultsCollection(abstractBuildNode);
        this.reloadUI(propertyModel);
    }

    private static class TargetItem {
        AttributeType item = new AttributeType();

        TargetItem(MiningAttributeType miningAttributeType) {
            this.item.setAlias(miningAttributeType.getAlias());
            this.item.setDataType(miningAttributeType.getDataType());
            this.item.setName(miningAttributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)miningAttributeType.getStatus().value()));
        }

        TargetItem(AttributeType attributeType) {
            this.item.setAlias(attributeType.getAlias());
            this.item.setDataType(attributeType.getDataType());
            this.item.setName(attributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)attributeType.getStatus().value()));
        }

        public boolean equals(Object object) {
            if (object instanceof TargetItem) {
                TargetItem targetItem = (TargetItem)object;
                if (!this.isEqual(targetItem.item.getAlias(), this.item.getAlias())) {
                    return false;
                }
                if (!this.isEqual(targetItem.item.getName(), this.item.getName())) {
                    return false;
                }
                if (!this.isEqual(targetItem.item.getDataType(), this.item.getDataType())) {
                    return false;
                }
                return this.isEqual(targetItem.item.getStatus().value(), this.item.getStatus().value());
            }
            return false;
        }

        public int hashCode() {
            int n = 5;
            n = 37 * n + (this.item != null ? this.item.hashCode() : 0);
            return n;
        }

        private boolean isEqual(String string, String string2) {
            if (string == null && string2 == null) {
                return true;
            }
            if (string != null && string2 != null) {
                return string.equals(string2);
            }
            return false;
        }

        public String toString() {
            return this.item.getName();
        }
    }

    private static class CaseIdItem {
        AttributeType item = new AttributeType();

        CaseIdItem(MiningAttributeType miningAttributeType) {
            this.item.setAlias(miningAttributeType.getAlias());
            this.item.setDataType(miningAttributeType.getDataType());
            this.item.setName(miningAttributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)miningAttributeType.getStatus().value()));
        }

        public String toString() {
            return this.item.getName();
        }
    }
}

