/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inmemoryparallelquery;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableAdapter;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.inmemoryparallelquery.ViewPerformanceDataProvider;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQueryPreferences;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQuerySettingPanel;
import oracle.ide.controls.JMultiLineLabel;

public class ViewDataPerformancePanel
extends JPanel
implements DataminerGUIPanel,
DialogDisplayable,
ViewPerformanceDataProvider {
    public static final String VIEW_KEY = ViewDataPerformancePanel.class.getName();
    public static final String SYSTEM_DETERMINED = "System Determined";
    private ParallelQueryPreferences PQPref;
    private String title;
    private JMultiLineLabel jCompressionDescription = new JMultiLineLabel();
    private JMultiLineLabel jPriorityDescription = new JMultiLineLabel();
    private static Hashtable<Integer, JLabel> compressionLabels = new Hashtable();
    private static Hashtable<String, Integer> compressionLabelsToValues = new Hashtable();
    private static Hashtable<Integer, JLabel> priorityValuesToLabels;
    private static Hashtable<String, Integer> priorityLabelsToValues;
    private ParallelQuerySettingPanel DOPPanel;
    private JCheckBox cbInMemory;
    private JCheckBox cbParallel;
    private JPanel jInMemoryPanel;
    private JScrollPane jScrollPanelCompressionExplanation;
    private JScrollPane jScrollPanelPriorityExplanation;
    private JSeparator jSeparator1;
    private JSlider jSliderCompression;
    private JSlider jSliderPriority;

    @Override
    public void setInMemoryValues(String string, String string2) {
        Integer n = compressionLabelsToValues.get(string);
        this.jSliderCompression.setValue(n);
        Integer n2 = priorityLabelsToValues.get(string2);
        this.jSliderPriority.setValue(n2);
    }

    public ViewDataPerformancePanel(String string) {
        this.initComponents();
        this.title = string;
        this.PQPref = ParallelQueryPreferences.getInstance();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.DOPPanel = new ParallelQuerySettingPanel();
        this.cbParallel = new JCheckBox();
        this.jInMemoryPanel = new JPanel();
        this.jSliderCompression = new JSlider();
        this.jScrollPanelCompressionExplanation = new JScrollPane();
        this.jSliderPriority = new JSlider();
        this.jScrollPanelPriorityExplanation = new JScrollPane();
        this.jSeparator1 = new JSeparator();
        this.cbInMemory = new JCheckBox();
        this.DOPPanel.setPreferredSize(new Dimension(300, 150));
        this.cbParallel.setText("Parallel Query On");
        this.jSliderCompression.setMajorTickSpacing(20);
        this.jSliderCompression.setPaintLabels(true);
        this.jSliderCompression.setSnapToTicks(true);
        this.jSliderCompression.setBorder(BorderFactory.createTitledBorder("Compression Method"));
        this.jScrollPanelCompressionExplanation.setBorder(null);
        this.jSliderPriority.setMajorTickSpacing(20);
        this.jSliderPriority.setMaximum(80);
        this.jSliderPriority.setPaintLabels(true);
        this.jSliderPriority.setSnapToTicks(true);
        this.jSliderPriority.setBorder(BorderFactory.createTitledBorder("Priority Level"));
        this.jScrollPanelPriorityExplanation.setBorder(null);
        GroupLayout groupLayout = new GroupLayout(this.jInMemoryPanel);
        this.jInMemoryPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(34, 34, 34).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPanelCompressionExplanation).addComponent(this.jSliderCompression, GroupLayout.Alignment.LEADING, -1, 585, Short.MAX_VALUE).addComponent(this.jScrollPanelPriorityExplanation).addComponent(this.jSliderPriority, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGap(27, 27, 27)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jSliderCompression, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPanelCompressionExplanation, -1, 53, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderPriority, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPanelPriorityExplanation, -1, 65, Short.MAX_VALUE).addContainerGap()));
        this.cbInMemory.setText("In Memory Columnar On");
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.DOPPanel, -1, 646, Short.MAX_VALUE).addComponent(this.jInMemoryPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.cbParallel, -1, -1, Short.MAX_VALUE))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jSeparator1).addGap(19, 19, 19)).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.cbInMemory, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGap(4, 4, 4).addComponent(this.cbParallel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DOPPanel, -2, 108, -2).addGap(9, 9, 9).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbInMemory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jInMemoryPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        this.cbParallel.setText(DataLrb.get("DATA_VIEWER_PARALLEL_CHECK"));
        this.cbParallel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewDataPerformancePanel.this.DOPPanel.enableControls(ViewDataPerformancePanel.this.cbParallel.isSelected());
            }
        });
        this.cbInMemory.setText(WorkflowEditorLrb.get("INMEMORY_PARALLEL_CHECK"));
        this.jSliderCompression.setBorder(BorderFactory.createTitledBorder(WorkflowEditorLrb.get("INMEMORY_PARALLEL_COMPRESSION_METHOD")));
        this.jSliderPriority.setBorder(BorderFactory.createTitledBorder(WorkflowEditorLrb.get("INMEMORY_PARALLEL_PRIORITY_LEVEL")));
        this.jSliderCompression.setLabelTable(compressionLabels);
        this.setDefaultCompressionSliderValue();
        this.jSliderPriority.setLabelTable(priorityValuesToLabels);
        this.setDefaultPrioritySliderValue();
        this.jSliderCompression.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ViewDataPerformancePanel.this.setCompressionDescrition();
            }
        });
        this.jSliderPriority.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ViewDataPerformancePanel.this.setPriorityDescritption();
            }
        });
    }

    private void setPriorityDescritption() {
        Integer n = this.jSliderPriority.getValue();
        JLabel jLabel = priorityValuesToLabels.get(n);
        if (jLabel != null) {
            String string = jLabel.getText();
            String string2 = MessageFormat.format(WorkflowEditorLrb.get("INMEMORY_PRIORITY_SELECTION_EXPLANATION"), string);
            this.loadDescription(this.jPriorityDescription, this.jScrollPanelPriorityExplanation, string2);
        }
    }

    private void setCompressionDescrition() {
        Integer n = this.jSliderCompression.getValue();
        JLabel jLabel = compressionLabels.get(n);
        if (jLabel != null) {
            String string = jLabel.getText();
            String string2 = MessageFormat.format(WorkflowEditorLrb.get("INMEMORY_COMPRESSION_SELECTION_EXPLANATION"), string);
            this.loadDescription(this.jCompressionDescription, this.jScrollPanelCompressionExplanation, string2);
        }
    }

    private void setDefaultCompressionSliderValue() {
        this.jSliderCompression.setValue(40);
    }

    private void setDefaultPrioritySliderValue() {
        this.jSliderPriority.setValue(0);
    }

    @Override
    public void initUI() {
        this.setPriorityDescritption();
        this.setCompressionDescrition();
    }

    @Override
    public void setInMemoryDefaults() {
        String string = MessageFormat.format(WorkflowEditorLrb.get("INMEMORY_COMPRESSION_SELECTION_EXPLANATION"), MetaDataHelper.defaultInMmemoryCompressionHuman());
        this.loadDescription(this.jCompressionDescription, this.jScrollPanelCompressionExplanation, string);
        String string2 = MessageFormat.format(WorkflowEditorLrb.get("INMEMORY_PRIORITY_SELECTION_EXPLANATION"), MetaDataHelper.defaultInMmemoryPriorityHuman());
        this.loadDescription(this.jPriorityDescription, this.jScrollPanelPriorityExplanation, string2);
        this.setInMemoryEnable(false);
        this.setSliderDefaults();
    }

    protected void loadDescription(JMultiLineLabel jMultiLineLabel, JScrollPane jScrollPane, String string) {
        jMultiLineLabel.setText(string);
        jScrollPane.getViewport().add((Component)jMultiLineLabel);
    }

    public boolean isParallelEnable() {
        return this.cbParallel.isSelected();
    }

    public boolean isInMemoryEnable() {
        return this.cbInMemory.isSelected();
    }

    public boolean isSystemDetermined() {
        return this.DOPPanel.isSystemDetermined();
    }

    public String getDegreeValue() {
        return this.DOPPanel.getDegreeValue();
    }

    @Override
    public void setParallelEnable(boolean bl) {
        this.cbParallel.setSelected(bl);
    }

    @Override
    public void setInMemoryEnable(boolean bl) {
        this.cbInMemory.setSelected(bl);
    }

    @Override
    public void setSystemDetermined() {
        this.DOPPanel.setSystemDetermined();
    }

    public void setSliderDefaults() {
        this.setDefaultCompressionSliderValue();
        this.setDefaultPrioritySliderValue();
    }

    @Override
    public void setDegreeValue(int n) {
        this.DOPPanel.setDegreeValue(n);
    }

    public ParallelQueryPreferences getPQPreferences() {
        return this.PQPref;
    }

    public String getCompressionMethod() {
        Integer n = this.jSliderCompression.getValue();
        JLabel jLabel = compressionLabels.get(n);
        String string = jLabel.getText();
        return string;
    }

    public String getPriorityLevel() {
        Integer n = this.jSliderPriority.getValue();
        JLabel jLabel = priorityValuesToLabels.get(n);
        String string = jLabel.getText();
        return string;
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableAdapter(){

            @Override
            public String getTitle() {
                return ViewDataPerformancePanel.this.title;
            }

            @Override
            public String getHelpTopic() {
                return "performance_settings_edit";
            }

            @Override
            public JComponent getContent() {
                return ViewDataPerformancePanel.this;
            }
        };
    }

    static {
        compressionLabels.put(0, new JLabel(MetaDataHelper.inMmemoryCompressionCovertToHuman("INMEMORY NO MEMCOMPRESS")));
        compressionLabels.put(20, new JLabel(MetaDataHelper.inMmemoryCompressionCovertToHuman("INMEMORY MEMCOMPRESS FOR DML")));
        compressionLabels.put(40, new JLabel(MetaDataHelper.inMmemoryCompressionCovertToHuman("INMEMORY MEMCOMPRESS FOR QUERY LOW")));
        compressionLabels.put(60, new JLabel(MetaDataHelper.inMmemoryCompressionCovertToHuman("INMEMORY MEMCOMPRESS FOR QUERY HIGH")));
        compressionLabels.put(80, new JLabel(MetaDataHelper.inMmemoryCompressionCovertToHuman("INMEMORY MEMCOMPRESS FOR CAPACITY LOW")));
        compressionLabels.put(100, new JLabel(MetaDataHelper.inMmemoryCompressionCovertToHuman("INMEMORY MEMCOMPRESS FOR CAPACITY HIGH")));
        compressionLabelsToValues.put(MetaDataHelper.inMmemoryCompressionCovertToHuman("INMEMORY NO MEMCOMPRESS"), 0);
        compressionLabelsToValues.put(MetaDataHelper.inMmemoryCompressionCovertToHuman("INMEMORY MEMCOMPRESS FOR DML"), 20);
        compressionLabelsToValues.put(MetaDataHelper.inMmemoryCompressionCovertToHuman("INMEMORY MEMCOMPRESS FOR QUERY LOW"), 40);
        compressionLabelsToValues.put(MetaDataHelper.inMmemoryCompressionCovertToHuman("INMEMORY MEMCOMPRESS FOR QUERY HIGH"), 60);
        compressionLabelsToValues.put(MetaDataHelper.inMmemoryCompressionCovertToHuman("INMEMORY MEMCOMPRESS FOR CAPACITY LOW"), 80);
        compressionLabelsToValues.put(MetaDataHelper.inMmemoryCompressionCovertToHuman("INMEMORY MEMCOMPRESS FOR CAPACITY HIGH"), 100);
        priorityValuesToLabels = new Hashtable();
        priorityLabelsToValues = new Hashtable();
        priorityValuesToLabels.put(0, new JLabel(MetaDataHelper.inMmemoryPriorityCovertToHuman("PRIORITY NONE")));
        priorityValuesToLabels.put(20, new JLabel(MetaDataHelper.inMmemoryPriorityCovertToHuman("PRIORITY LOW")));
        priorityValuesToLabels.put(40, new JLabel(MetaDataHelper.inMmemoryPriorityCovertToHuman("PRIORITY MEDIUM")));
        priorityValuesToLabels.put(60, new JLabel(MetaDataHelper.inMmemoryPriorityCovertToHuman("PRIORITY HIGH")));
        priorityValuesToLabels.put(80, new JLabel(MetaDataHelper.inMmemoryPriorityCovertToHuman("PRIORITY CRITICAL")));
        priorityLabelsToValues.put(MetaDataHelper.inMmemoryPriorityCovertToHuman("PRIORITY NONE"), 0);
        priorityLabelsToValues.put(MetaDataHelper.inMmemoryPriorityCovertToHuman("PRIORITY LOW"), 20);
        priorityLabelsToValues.put(MetaDataHelper.inMmemoryPriorityCovertToHuman("PRIORITY MEDIUM"), 40);
        priorityLabelsToValues.put(MetaDataHelper.inMmemoryPriorityCovertToHuman("PRIORITY HIGH"), 60);
        priorityLabelsToValues.put(MetaDataHelper.inMmemoryPriorityCovertToHuman("PRIORITY CRITICAL"), 80);
    }
}

