/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic.prediction;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerCombBox;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.MiningTypeUIHelper;
import oracle.dmt.dataminer.controls.ToolTipComboBoxRenderer;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.models.ModelHeuristicRules;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyOutputPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodeEditorState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.MininigTypeChangeEvent;
import oracle.dmt.dataminer.workflow.dialog.dynamic.MininigTypeComboBoxModel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.MininigTypeComboBoxSelectionListener;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.AddTargetsPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionCustomCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionEditorState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionOutputsTableModel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.TargetsGenericTable;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.DynamicPredictionNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicNodeBaseSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicPredictionNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionAttributesType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class PredictionEditorPanel
extends DynamicEditorPanel<DynamicPredictionNode>
implements DataConsumerPanel {
    Map<String, ModelHeuristicRules> modelRules;
    private JPanel jBottomPanel;
    private JLabel jCaseIdLabel;
    private JComboBox<String> jComboBoxCaseId;
    private JLabel jLabelCaseId;
    private JTabbedPane jMainTabPamel;
    private ComponentWithTitlebar<JComponent> jPredictionOutputsComponent;
    private JPanel jPredictionTab;
    private JSplitPane jSplitPaneTargets;
    private ComponentWithTitlebar<JComponent> jTargetsComponent;
    private JPanel jTopPanel;
    private TargetsGenericTable jTargetsTable = new TargetsGenericTable();
    private JButton addTargetBtn;
    private JButton removeTargetBtn;
    private DataMinerTable jPredictionOutputsTable = new DataMinerTable();
    private JButton resetPredOutputBtn;
    private JButton addPredOutputBtn;
    private JButton removePredOutputBtn;
    private JButton editPredOutputBtn;
    private PredictionEditorState state;
    private DynamicPredictionNodeType cachedNodeData;

    public PredictionEditorPanel(Context context, DynamicPredictionNode dynamicPredictionNode, Map<String, ModelHeuristicRules> map) {
        super(context, dynamicPredictionNode);
        this.cachedNodeData = (DynamicPredictionNodeType)MetaDataHelper.copyMetadataObject(dynamicPredictionNode.getData());
        this.state = new PredictionEditorState(context, dynamicPredictionNode, this.cachedNodeData);
        this.modelRules = map;
        this.initComponents();
        this.createPartitionTab(this.jMainTabPamel, this.state);
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jMainTabPamel = new JTabbedPane();
        this.jPredictionTab = new JPanel();
        this.jLabelCaseId = new JLabel();
        this.jComboBoxCaseId = new DataMinerCombBox<String>();
        this.jSplitPaneTargets = new JSplitPane();
        this.jTopPanel = new JPanel();
        this.jTargetsComponent = new ComponentWithTitlebar();
        this.jBottomPanel = new JPanel();
        this.jPredictionOutputsComponent = new ComponentWithTitlebar();
        this.jCaseIdLabel = new JLabel();
        this.jLabelCaseId.setText("Case ID:");
        this.jSplitPaneTargets.setDividerLocation(220);
        this.jSplitPaneTargets.setOrientation(0);
        GroupLayout groupLayout = new GroupLayout(this.jTopPanel);
        this.jTopPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 551, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jTargetsComponent, -1, 531, Short.MAX_VALUE).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 219, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jTargetsComponent, -1, 197, Short.MAX_VALUE).addContainerGap())));
        this.jSplitPaneTargets.setTopComponent(this.jTopPanel);
        GroupLayout groupLayout2 = new GroupLayout(this.jBottomPanel);
        this.jBottomPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 551, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.jPredictionOutputsComponent, -1, 531, Short.MAX_VALUE).addContainerGap())));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 215, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.jPredictionOutputsComponent, -1, 193, Short.MAX_VALUE).addContainerGap())));
        this.jSplitPaneTargets.setRightComponent(this.jBottomPanel);
        this.jCaseIdLabel.setHorizontalAlignment(2);
        this.jCaseIdLabel.setHorizontalTextPosition(2);
        GroupLayout groupLayout3 = new GroupLayout(this.jPredictionTab);
        this.jPredictionTab.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jLabelCaseId, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxCaseId, -2, 121, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCaseIdLabel, -2, 23, -2).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jSplitPaneTargets));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCaseId).addComponent(this.jComboBoxCaseId, -2, -1, -2)).addComponent(this.jCaseIdLabel, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSplitPaneTargets)));
        this.jMainTabPamel.addTab("Prediction", this.jPredictionTab);
        GroupLayout groupLayout4 = new GroupLayout(this);
        this.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMainTabPamel));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMainTabPamel));
    }

    @Override
    protected DynamicNodeBaseSettingsType getOriginalDynamicNodeBaseSettings() {
        return this.cachedNodeData.getDynamicNodeBaseSettings();
    }

    @Override
    protected JLabel getCaseIDLabel() {
        return this.jCaseIdLabel;
    }

    @Override
    protected String getFirstTabTitle() {
        return PredictionLrb.get("PREDICTION_EDITOR_TAB_TITLE");
    }

    @Override
    protected JComboBox getCaseIDCombo() {
        return this.jComboBoxCaseId;
    }

    @Override
    public void initUI() {
        ResourceUtils.resLabel((JLabel)this.jLabelCaseId, this.jComboBoxCaseId, (String)PredictionLrb.get("PREDICTION_EDITOR_PANEL_CASE_ID"));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.jTargetsTable));
        this.jTargetsComponent.setComponent((JComponent)jScrollPane);
        this.jTargetsComponent.setLabel(new JLabel(PredictionLrb.get("PREDICTION_EDITOR_PANEL_TARGETS_TITLE")));
        ControlBar controlBar = new ControlBar();
        this.addTargetBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addTargetBtn.setToolTipText(PredictionLrb.get("PREDICTION_EDITOR_TOOLTIP_ADD_TARGET"));
        this.addTargetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PredictionEditorPanel.this.handleAddTargets();
            }
        });
        controlBar.add((Component)this.addTargetBtn);
        this.removeTargetBtn = new JButton(DynamicNodeEditorState.getRemoveIcon());
        this.removeTargetBtn.setToolTipText(PredictionLrb.get("PREDICTION_EDITOR_TOOLTIP_REMOVE_TARGET"));
        this.removeTargetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PredictionEditorPanel.this.removeSelectedTargets();
            }
        });
        controlBar.add((Component)this.removeTargetBtn);
        this.jTargetsComponent.setControlBar(controlBar);
        this.jTargetsTable.setFillsViewportHeight(true);
        this.addTargetBtn.setEnabled(true);
        this.removeTargetBtn.setEnabled(false);
        JScrollPane jScrollPane2 = new JScrollPane((Component)((Object)this.jPredictionOutputsTable));
        this.jPredictionOutputsComponent.setComponent((JComponent)jScrollPane2);
        this.jPredictionOutputsComponent.setLabel(new JLabel(PredictionLrb.get("PREDICTION_EDITOR_PANEL_PREDICTION_OUTPUT_TITLE")));
        ControlBar controlBar2 = new ControlBar();
        this.resetPredOutputBtn = new JButton("Reset");
        this.resetPredOutputBtn.setToolTipText(PredictionLrb.get("PREDICTION_EDITOR_TOOLTIP_RESET_PREDICTION_OUTPUT"));
        this.resetPredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PredictionEditorPanel.this.resetSelectedTargets();
            }
        });
        controlBar2.add((Component)this.resetPredOutputBtn);
        this.addPredOutputBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addPredOutputBtn.setToolTipText(PredictionLrb.get("PREDICTION_EDITOR_TOOLTIP_ADD_PREDICTION_OUTPUT"));
        this.addPredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PredictionEditorPanel.this.hanldeAddPredictionOutput();
            }
        });
        controlBar2.add((Component)this.addPredOutputBtn);
        this.removePredOutputBtn = new JButton(DynamicNodeEditorState.getRemoveIcon());
        this.removePredOutputBtn.setToolTipText(PredictionLrb.get("PREDICTION_EDITOR_TOOLTIP_REMOVE_PREDICTION_OUTPUT"));
        this.removePredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PredictionEditorPanel.this.removeSelectedPredictionOutputs();
            }
        });
        controlBar2.add((Component)this.removePredOutputBtn);
        this.editPredOutputBtn = new JButton(DynamicNodeEditorState.getEditIcon());
        this.editPredOutputBtn.setToolTipText(PredictionLrb.get("PREDICTION_EDITOR_TOOLTIP_EDIT_PREDICTION_OUTPUT"));
        this.editPredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PredictionEditorPanel.this.hanldeEditPredictionOutput();
            }
        });
        controlBar2.add((Component)this.editPredOutputBtn);
        this.jPredictionOutputsComponent.setControlBar(controlBar2);
        this.jPredictionOutputsTable.setFillsViewportHeight(true);
        this.addPredOutputBtn.setEnabled(false);
        this.removePredOutputBtn.setEnabled(false);
        this.editPredOutputBtn.setEnabled(false);
        this.resetPredOutputBtn.setEnabled(false);
        this.updateCaseIDs();
        this.jComboBoxCaseId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)PredictionEditorPanel.this.jComboBoxCaseId.getSelectedItem();
                PredictionEditorPanel.this.setSelectedCaseAttribute(string);
            }
        });
        this.jComboBoxCaseId.setRenderer(new ToolTipComboBoxRenderer());
        this.setupPredictionTargetsTable();
        this.setupPredictionOutputTable();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = PredictionEditorPanel.this.jPredictionOutputsTable.getSelectedRowInModel();
                if (n != -1 && mouseEvent.getClickCount() == 2) {
                    PredictionEditorPanel.this.hanldeEditPredictionOutput();
                }
            }
        };
        this.jPredictionOutputsTable.addMouseListener(mouseAdapter);
        this.createTabs(this.state, this.jMainTabPamel, this.modelRules);
        super.initUI();
    }

    private void setupPredictionTargetsTable() {
        this.jTargetsTable.setModel((TableModel)((Object)this.state.getTableModelPredictionTargets()));
        this.jTargetsTable.setShowGrid(true);
        this.jTargetsTable.setSorted(true);
        this.jTargetsTable.setSortColumn(0, true);
        this.jTargetsTable.getSelectionModel().addListSelectionListener(new TargetSelectionHandler());
        TableColumn tableColumn = this.jTargetsTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new CustomCellRenderer());
        TableColumn tableColumn2 = this.jTargetsTable.getColumnModel().getColumn(2);
        tableColumn2.setCellRenderer(MiningTypeUIHelper.createMiningTypeRenderer());
        PredictionMininigTypeComboBoxModel predictionMininigTypeComboBoxModel = new PredictionMininigTypeComboBoxModel(DynamicApplyHelper.getMiningTypes());
        predictionMininigTypeComboBoxModel.addVetoableSelectionListener(new MininigTypeComboBoxSelectionListener(){

            @Override
            public boolean selectionChanged(MininigTypeChangeEvent mininigTypeChangeEvent) {
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)PredictionLrb.get("PREDICTION_NODE_RESET_WARNING_TYPE_CHANGE"), (String)PredictionLrb.get("PREDICTION_NODE_RESET_WARNING_TITLE"), null)) {
                    return false;
                }
                int[] nArray = PredictionEditorPanel.this.jTargetsTable.getSelectedRowsInModel();
                if (nArray == null || nArray.length != 1) {
                    return false;
                }
                List list = PredictionEditorPanel.this.state.getTableModelPredictionTargets().getSrcData();
                MiningAttributeType miningAttributeType = (MiningAttributeType)list.get(nArray[0]);
                String string = mininigTypeChangeEvent.getNewValue().toString();
                MiningAttributeType miningAttributeType2 = PredictionEditorPanel.this.state.findTargetAttribute(miningAttributeType.getName());
                miningAttributeType2.setMiningType(ServerConstants.MiningType.toSchema((String)string));
                PredictionEditorPanel.this.updateMiningType();
                return true;
            }
        });
        JComboBox<String> jComboBox = new JComboBox<String>(predictionMininigTypeComboBoxModel);
        jComboBox.setRenderer(MiningTypeUIHelper.createMiningTypeComboRenderer());
        tableColumn2.setCellEditor(new DefaultCellEditor(jComboBox));
    }

    private void setupPredictionOutputTable() {
        this.jPredictionOutputsTable.setModel((TableModel)((Object)this.state.getTableModelPredictionOutputs()));
        this.jPredictionOutputsTable.setShowGrid(true);
        this.jPredictionOutputsTable.setSorted(true);
        this.jPredictionOutputsTable.setSortColumn(PredictionOutputsTableModel.TARGET, true);
        this.jPredictionOutputsTable.getSelectionModel().addListSelectionListener(new PredictionOutputsSelectionHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doWork() {
        if (this.state.isApplyOutputColumnListEmpty()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)PredictionLrb.get("PREDICTION_EDITOR_PANEL_ERROR_NOPREDICTIONS"), (String)PredictionLrb.get("PREDICTION_EDITOR_PANEL_ERROR_ERROR_TITLE"), null);
            return false;
        }
        if (this.isInputAttributesListEmpty()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DynamicNodesLrb.get("EDITOR_PANEL_ERROR_NO_INPUTS"), (String)PredictionLrb.get("PREDICTION_EDITOR_PANEL_ERROR_ERROR_TITLE"), null);
            return false;
        }
        DynamicPredictionNode dynamicPredictionNode = (DynamicPredictionNode)this.getData();
        CommandProcessor.getInstance().beginTrans(PredictionLrb.get("PREDICTION_NODE_PROPERTIES_TRANSACTION_NAME"));
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = (DynamicNodeBaseSettingsType)MetaDataHelper.copyMetadataObject(this.getOriginalDynamicNodeBaseSettings());
            hashMap.put("DynamicNodeBaseSettingsType", dynamicNodeBaseSettingsType);
            PredictionAttributesType predictionAttributesType = (PredictionAttributesType)MetaDataHelper.copyMetadataObject(this.cachedNodeData.getPredictionAttributes());
            hashMap.put("PredictionAttributesType", predictionAttributesType);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property("PREDICTION_NODE_INPUT_COLUMNS", null, hashMap, null, null));
            arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)dynamicPredictionNode.getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(dynamicPredictionNode, this._context, arrayList);
            dynamicPredictionNode.validateSimple(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PredictionLrb.get("PREDICTION_NODE_PROPERTIES_DIALOG_FAILURE_TITLE"), (String)PredictionLrb.get("PREDICTION_NODE_PROPERTIES_DIALOG_FAILURE_MSG"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
        return true;
    }

    private void handleAddTargets() {
        AddTargetsPanel addTargetsPanel = new AddTargetsPanel(this.getContext(), this.state.getNode(), this.getOriginalDynamicNodeBaseSettings().getMiningAttributes(), this.state.getTargetAttributes(), this.state.getCaseAttributes(), this.state.getPartitionExpressions());
        if (addTargetsPanel.showAsDialog(this) && addTargetsPanel.isDirty()) {
            List<MiningAttributeType> list = addTargetsPanel.getSelectedAttrsCache();
            List<MiningAttributeType> list2 = this.state.getListOfTargetsToRemove(list);
            this.state.removeTargetsFromList(list2);
            List<MiningAttributeType> list3 = this.state.getListOfTargetsToAdd(list);
            for (AttributeType attributeType : list3) {
                MiningAttributeType miningAttributeType = this.state.getMapInputMiningAttributes().get(attributeType.getName());
                this.state.getTargetAttributes().getMiningAttribute().add(miningAttributeType);
            }
            this.state.updatePredictionTargetsModel();
            this.setupPredictionTargetsTable();
            this.state.removeUnusedPredictionTargets(list2);
            List<DynamicApplyOutputColumnType> list4 = this.state.generateDefaultPredictionOutputs(list3);
            this.state.addPredictionTargets(list4);
            this.setupPredictionOutputTable();
            this.state.updateAutoSupplementalList();
            this.updateCaseIDs();
            this.jOutputHostPanel.updateAutoSupplementalList();
        }
    }

    private void removeSelectedTargets() {
        int[] nArray = this.jTargetsTable.getSelectedRowsInModel();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        List list = this.state.getTableModelPredictionTargets().getSrcData();
        ArrayList<MiningAttributeType> arrayList = new ArrayList<MiningAttributeType>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add((MiningAttributeType)list.get(nArray[i]));
        }
        this.state.removeTargetsFromList(arrayList);
        this.setupPredictionTargetsTable();
        this.state.removeUnusedPredictionTargets(arrayList);
        this.setupPredictionOutputTable();
        this.state.updateAutoSupplementalList();
        this.updateCaseIDs();
        this.jOutputHostPanel.updateAutoSupplementalList();
    }

    private void removeSelectedPredictionOutputs() {
        int[] nArray = this.jPredictionOutputsTable.getSelectedRowsInModel();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        Vector vector = this.state.getTableModelPredictionOutputs().getDataVector();
        ArrayList<DynamicApplyOutputColumnType> arrayList = new ArrayList<DynamicApplyOutputColumnType>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add((DynamicApplyOutputColumnType)vector.get(nArray[i]));
        }
        this.state.removePredictionOutputColumnsFromList(arrayList);
        this.setupPredictionOutputTable();
    }

    private void resetSelectedTargets() {
        int[] nArray = this.jTargetsTable.getSelectedRowsInModel();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        List list = this.state.getTableModelPredictionTargets().getSrcData();
        ArrayList<MiningAttributeType> arrayList = new ArrayList<MiningAttributeType>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add((MiningAttributeType)list.get(nArray[i]));
        }
        List<DynamicApplyOutputColumnType> list2 = this.state.getResetList(arrayList);
        if (!list2.isEmpty() && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)PredictionLrb.get("PREDICTION_NODE_RESET_WARNING"), (String)PredictionLrb.get("PREDICTION_NODE_RESET_WARNING_TITLE"), null)) {
            return;
        }
        this.state.resetPredictionTargets(arrayList, list2);
        this.setupPredictionOutputTable();
    }

    private void updateMiningType() {
        int[] nArray = this.jTargetsTable.getSelectedRowsInModel();
        if (nArray == null || nArray.length != 1) {
            return;
        }
        List list = this.state.getTableModelPredictionTargets().getSrcData();
        ArrayList<MiningAttributeType> arrayList = new ArrayList<MiningAttributeType>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add((MiningAttributeType)list.get(nArray[i]));
        }
        List<DynamicApplyOutputColumnType> list2 = this.state.getResetList(arrayList);
        this.state.resetPredictionTargets(arrayList, list2);
        this.setupPredictionOutputTable();
    }

    private void hanldeAddPredictionOutput() {
        int[] nArray = this.jTargetsTable.getSelectedRowsInModel();
        if (nArray == null || nArray.length != 1) {
            return;
        }
        List list = this.state.getTableModelPredictionTargets().getSrcData();
        MiningAttributeType miningAttributeType = (MiningAttributeType)list.get(nArray[0]);
        String string = DynamicNodesLrb.get("DYNAMIC_PREDICTION_APPLY_OUTPUT_ADD_DIALOG_TITLE");
        DynamicApplyOutputPanel dynamicApplyOutputPanel = new DynamicApplyOutputPanel(string, this.getContext(), this.state, miningAttributeType);
        DialogHelper dialogHelper = new DialogHelper(dynamicApplyOutputPanel);
        if (dialogHelper.showAsDialog(this)) {
            DynamicApplyOutputColumnType dynamicApplyOutputColumnType = dynamicApplyOutputPanel.getApplyOutputColumn();
            this.state.addPredictionTarget(dynamicApplyOutputColumnType);
            this.setupPredictionOutputTable();
        }
    }

    private void hanldeEditPredictionOutput() {
        Object object2;
        int[] nArray = this.jPredictionOutputsTable.getSelectedRowsInModel();
        if (nArray == null || nArray.length != 1) {
            return;
        }
        Vector vector = this.state.getTableModelPredictionOutputs().getDataVector();
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType = (DynamicApplyOutputColumnType)vector.get(nArray[0]);
        String string = DynamicNodesLrb.get("DYNAMIC_PREDICTION_APPLY_OUTPUT_EDIT_DIALOG_TITLE");
        String string2 = dynamicApplyOutputColumnType.getTargetAttributeName();
        MiningAttributeType miningAttributeType = null;
        for (Object object2 : this.state.getTargetAttributes().getMiningAttribute()) {
            if (!string2.equals(object2.getName())) continue;
            miningAttributeType = object2;
            break;
        }
        assert (miningAttributeType != null);
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType2 = (DynamicApplyOutputColumnType)MetaDataHelper.copyMetadataObject(dynamicApplyOutputColumnType);
        object2 = new DynamicApplyOutputPanel(string, this.getContext(), this.state, dynamicApplyOutputColumnType2, miningAttributeType);
        DialogHelper dialogHelper = new DialogHelper((DialogDisplayable)object2);
        if (dialogHelper.showAsDialog(this)) {
            DynamicApplyOutputColumnType dynamicApplyOutputColumnType3 = ((DynamicApplyOutputPanel)object2).getApplyOutputColumn();
            this.state.replacePredictionTarget(dynamicApplyOutputColumnType, dynamicApplyOutputColumnType3);
            this.setupPredictionOutputTable();
        }
    }

    @Override
    public DynamicNodeEditorState getState() {
        return this.state;
    }

    class TargetSelectionHandler
    implements ListSelectionListener {
        TargetSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            int[] nArray = PredictionEditorPanel.this.jTargetsTable.getSelectedRowsInModel();
            boolean bl = nArray != null && nArray.length > 0;
            List list = PredictionEditorPanel.this.state.getTableModelPredictionTargets().getSrcData();
            boolean bl2 = false;
            for (n = 0; n < nArray.length; ++n) {
                MiningAttributeType miningAttributeType = (MiningAttributeType)list.get(nArray[n]);
                if (miningAttributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl2 = true;
                break;
            }
            PredictionEditorPanel.this.removeTargetBtn.setEnabled(bl);
            PredictionEditorPanel.this.resetPredOutputBtn.setEnabled(!bl2 && bl);
            n = nArray != null && nArray.length == 1 ? 1 : 0;
            PredictionEditorPanel.this.addPredOutputBtn.setEnabled(!bl2 && n != 0);
        }
    }

    private class CustomCellRenderer
    extends PredictionCustomCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Icon getValidIcon() {
            return OracleIcons.getIcon((String)"attribute.png");
        }

        @Override
        public Icon getInvalidIcon() {
            return OracleIcons.getIcon((String)"warning.png");
        }

        @Override
        public MiningAttributeType getTargetAttribute(String string) {
            return PredictionEditorPanel.this.state.findTargetAttribute(string);
        }
    }

    class PredictionMininigTypeComboBoxModel
    extends MininigTypeComboBoxModel<String> {
        public PredictionMininigTypeComboBoxModel(String[] stringArray) {
            super(stringArray);
        }

        @Override
        public Object getSelectedItem() {
            int n = PredictionEditorPanel.this.jTargetsTable.getSelectedRowInModel();
            if (n == -1) {
                return null;
            }
            List list = PredictionEditorPanel.this.state.getTableModelPredictionTargets().getSrcData();
            MiningAttributeType miningAttributeType = (MiningAttributeType)list.get(n);
            return ServerConstants.MiningType.toHuman((String)miningAttributeType.getMiningType());
        }
    }

    class PredictionOutputsSelectionHandler
    implements ListSelectionListener {
        PredictionOutputsSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = PredictionEditorPanel.this.jPredictionOutputsTable.getSelectedRowsInModel();
            PredictionEditorPanel.this.removePredOutputBtn.setEnabled(nArray != null && nArray.length > 0);
            PredictionEditorPanel.this.editPredOutputBtn.setEnabled(nArray != null && nArray.length == 1);
        }
    }
}

