/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.AttributeNameCellRenderer;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.SimpleSearchListener;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.AddSupplementalPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodeEditorState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.OutputDataTableModel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionLrb;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;

public class OuputColumnsPanel
extends AbstractPanel<AbstractTransformNode>
implements DataConsumerPanel {
    boolean allAutomatic = false;
    private DynamicNodeEditorState _state;
    private List<MiningAttributeType> _targetAttributeList;
    private MiningAttributes _miningAttributes;
    private SupplementalAttributesType _supAttributes;
    private OutputDataTableModel outputDataTblModel;
    private JToggleButton autoBtn;
    private JButton addBtn;
    private JButton removeBtn;
    private DataMinerTablePanel dataMinerTablePanel;

    public OuputColumnsPanel(Context context, DynamicNodeEditorState dynamicNodeEditorState) {
        super(context, dynamicNodeEditorState.getNode());
        this._state = dynamicNodeEditorState;
        this._targetAttributeList = this._state.getTargetAttributeList();
        this._miningAttributes = this._state.getMiningAttributes();
        this._supAttributes = (SupplementalAttributesType)MetaDataHelper.copyMetadataObject(this._state.getSupplementalAttributes());
        this.allAutomatic = this._state.isOutputAutomatic();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.dataMinerTablePanel, -1, 528, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.dataMinerTablePanel, -1, 463, Short.MAX_VALUE).addContainerGap()));
    }

    public List<MiningAttributeType> getTargetAttributeList() {
        return this._targetAttributeList;
    }

    public CaseAttributes getCaseAttributes() {
        return this._state.getCaseAttributes();
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this.dataMinerTablePanel.setTitle(DynamicNodesLrb.get("BUILD_DATA_OUTPUT_LBL"));
        this.installDataUsageActions();
        this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                OuputColumnsPanel.this.handleUsageSelectionChanged();
            }
        });
        this.setupOutputTable();
        if (this.allAutomatic) {
            this.autoBtn.setToolTipText(DynamicNodesLrb.get("BUILD_DATA_USAGE_SET_TO_AUTO"));
        } else {
            this.autoBtn.setToolTipText(DynamicNodesLrb.get("BUILD_DATA_USAGE_SET_TO_MANUAL"));
        }
        this.autoBtn.setSelected(this.allAutomatic);
    }

    private void setupOutputTable() {
        CaseAttributes caseAttributes;
        List list;
        this.outputDataTblModel = new OutputDataTableModel(this._supAttributes);
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)this.outputDataTblModel));
        this.dataMinerTablePanel.getTable().setSorted(true);
        TableColumn tableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
        List<MiningAttributeType> list2 = this.getTargetAttributeList();
        if (list2 != null) {
            attributeNameCellRenderer.setTargetNames(list2);
        }
        if ((list = (caseAttributes = this.getCaseAttributes()).getAttribute()).size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (AttributeType attributeType : list) {
                arrayList.add(attributeType.getName());
            }
            attributeNameCellRenderer.setKeyNames(arrayList);
        }
    }

    private void handleUsageSelectionChanged() {
        if (this.allAutomatic) {
            this.removeBtn.setEnabled(false);
            return;
        }
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        boolean bl = nArray != null && nArray.length > 0;
        this.removeBtn.setEnabled(bl);
    }

    private void installDataUsageActions() {
        this.autoBtn = new JToggleButton(DynamicNodesLrb.get("BUILD_DATA_USAGE_AUTOMATIC"), DataMinerIcons.get(Icons.AUTO_USAGE));
        this.autoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                boolean bl2 = bl = !OuputColumnsPanel.this.allAutomatic && jToggleButton.isSelected();
                if (bl && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DynamicNodesLrb.get("SUPPLEMENTAL_SETTINGS_WARNING"), (String)DynamicNodesLrb.get("SUPPLEMENTAL_SETTINGS_WARNING_TITLE"), null)) {
                    jToggleButton.doClick();
                    return;
                }
                OuputColumnsPanel.this.setAutoUsage(jToggleButton.isSelected());
                if (bl) {
                    OuputColumnsPanel.this.updateAutoSupplementalList();
                }
            }
        });
        this.addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addBtn.setToolTipText(PredictionLrb.get("PREDICTION_EDITOR_TOOLTIP_ADD_TARGET"));
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OuputColumnsPanel.this.handleAddSupplementalColumns();
            }
        });
        this.addBtn.setEnabled(!this.allAutomatic);
        this.removeBtn = new JButton(DynamicNodeEditorState.getRemoveIcon());
        this.removeBtn.setToolTipText(PredictionLrb.get("PREDICTION_EDITOR_TOOLTIP_REMOVE_TARGET"));
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OuputColumnsPanel.this.removeSupplementalColumns();
            }
        });
        this.removeBtn.setEnabled(!this.allAutomatic);
        this.dataMinerTablePanel.addControlBarComponents(this.autoBtn);
        this.dataMinerTablePanel.addControlBarComponents(this.addBtn, this.removeBtn);
        this.configureSearchField();
    }

    public void updateAutoSupplementalList() {
        if (!this._supAttributes.getAutoSpec().equals((Object)AutoSpecType.YES)) {
            return;
        }
        List list = this._supAttributes.getAttribute();
        list.clear();
        list.addAll(this.getTargetAttributeList());
        list.addAll(this.getCaseAttributes().getAttribute());
        for (PartitionExpressionType partitionExpressionType : this._state.getPartitionExpressions().getPartitionExpression()) {
            list.add(partitionExpressionType.getPartitionAttribute());
        }
        this._state.setSupplementalAttributes(this._supAttributes);
        this.setupOutputTable();
    }

    private void setAutoUsage(boolean bl) {
        this.allAutomatic = bl;
        this._supAttributes.setAutoSpec(bl ? AutoSpecType.YES : AutoSpecType.NO);
        if (bl) {
            this.autoBtn.setToolTipText(DynamicNodesLrb.get("BUILD_DATA_USAGE_SET_TO_AUTO"));
        } else {
            this.autoBtn.setToolTipText(DynamicNodesLrb.get("BUILD_DATA_USAGE_SET_TO_MANUAL"));
        }
        this.addBtn.setEnabled(!this.allAutomatic);
        this.handleUsageSelectionChanged();
        this.updateUI();
    }

    private void configureSearchField() {
        RowFilter<OutputDataTableModel, Integer> rowFilter = new RowFilter<OutputDataTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends OutputDataTableModel, ? extends Integer> entry) {
                boolean bl = false;
                Integer n = entry.getIdentifier();
                OutputDataTableModel outputDataTableModel = entry.getModel();
                AttributeType attributeType = outputDataTableModel.getRowData(n);
                String string = OuputColumnsPanel.this.dataMinerTablePanel.getSearchField().getText();
                if (string != null && attributeType.getName().toLowerCase().contains(string.toLowerCase())) {
                    bl = true;
                }
                return bl;
            }
        };
        SimpleSearchListener simpleSearchListener = new SimpleSearchListener((GenericTable)this.dataMinerTablePanel.getTable(), rowFilter, 0);
        this.dataMinerTablePanel.getSearchField().addSearchListener((SearchListener)simpleSearchListener);
    }

    private void handleAddSupplementalColumns() {
        ArrayList<MiningAttributeType> arrayList = new ArrayList<MiningAttributeType>();
        List list = this._state.getPartitionExpressions().getPartitionExpression();
        HashMap<String, MiningAttributeType> hashMap = new HashMap<String, MiningAttributeType>();
        for (Object object : list) {
            MiningAttributeType miningAttributeType = MetaDataHelper.createMiningAttributeFrom(object.getPartitionAttribute());
            arrayList.add(miningAttributeType);
            hashMap.put(miningAttributeType.getName(), miningAttributeType);
        }
        for (Object object : this._miningAttributes.getMiningAttribute()) {
            if (null != hashMap.get(object.getName())) continue;
            arrayList.add((MiningAttributeType)object);
        }
        AddSupplementalPanel addSupplementalPanel = new AddSupplementalPanel(this.getContext(), this._state.getNode(), arrayList, this._supAttributes);
        if (addSupplementalPanel.showAsDialog(this) && addSupplementalPanel.isDirty()) {
            this._supAttributes.getAttribute().clear();
            for (MiningAttributeType miningAttributeType : addSupplementalPanel.getSelectedAttrsCache()) {
                AttributeType attributeType = MetaDataHelper.createAttributeFrom(miningAttributeType);
                this._supAttributes.getAttribute().add(attributeType);
            }
            this._state.setSupplementalAttributes(this._supAttributes);
            this.outputDataTblModel.refresh();
            this.setupOutputTable();
        }
    }

    @Override
    public boolean doWork() {
        this._state.setSupplementalAttributes(this._supAttributes);
        return true;
    }

    private void removeSupplementalColumns() {
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        OutputDataTableModel outputDataTableModel = (OutputDataTableModel)((Object)this.dataMinerTablePanel.getTable().getModel());
        Vector vector = outputDataTableModel.getDataVector();
        Vector<AttributeType> vector2 = new Vector<AttributeType>();
        for (int n : nArray) {
            AttributeType attributeType2 = (AttributeType)vector.get(n);
            vector2.add(attributeType2);
        }
        Object object = new ArrayList();
        block1: for (AttributeType attributeType : vector2) {
            for (AttributeType attributeType2 : this._supAttributes.getAttribute()) {
                if (!attributeType2.getName().equals(attributeType.getName())) continue;
                object.add(attributeType2);
                continue block1;
            }
        }
        if (!object.isEmpty()) {
            this._supAttributes.getAttribute().removeAll((Collection<?>)object);
        }
        outputDataTableModel.removeAttributes(vector2);
    }
}

