/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.Document;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.buildText.AddStopwordsPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingThemePanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingTokenPanel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.applyText.WorkflowApplyTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.buildText.WorkflowBuildTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.text.WorkflowTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;

public class StoplistDetailsPanel
extends DialogDisplayer<AbstractTextNode>
implements SearchListener {
    private static final int SHOW_STOPWORDS = Ide.findOrCreateCmdID((String)"oracle.dataminer.workflow.dialog.buildText.showWords");
    private static final int SHOW_STOPTHEMES = Ide.findOrCreateCmdID((String)"oracle.dataminer.workflow.dialog.buildText.showThemes");
    private JPanel _parent;
    private StoplistType _stoplist;
    private ArrayList<String> _stoplists = null;
    private PropertyModel _propertyModel;
    private boolean _isEdit;
    private boolean _dirty;
    private StopwordTableModel _stopwordModels;
    private GenericTable _stopwordTable = new DataMinerTable();
    private SearchField _searchField;
    private String _searchText;
    private transient SearchCategory _searchCategory;
    private JButton _stopwordRemoveBtn;
    private JButton _stopwordAddBtn;
    private ToggleToolButton _showWords;
    private ToggleToolButton _showThemes;
    private boolean _bShowWords;
    private boolean _bShowThemes;
    private boolean _isTokenTransType;
    private transient RowFilter<StopwordTableModel, Integer> _tokenFilter;
    private ComponentWithTitlebar<JComponent> StopwordComponentWithTitlebar;
    private JLabel jLanguageLabel;
    private JLabel jLanguageValueLabel;
    private JLabel jStoplistLabel;
    private JTextField jStoplistTextField;
    private String[] _stopwordColumnNames = new String[]{DialogsLrb.get("STOPLIST_COLUMN_NAME"), DialogsLrb.get("STOPLIST_COLUMN_TYPE"), DialogsLrb.get("STOPLIST_COLUMN_LANGUAGE")};
    private int[] _stopwordColumnWidths = new int[]{180, 100, 100};
    private static final int STOPWORD_NAME = 0;
    private static final int STOPWORD_TYPE = 1;
    private static final int STOPWORD_LANGUAGE = 2;
    private static final int STOPWORD_COLUMN_COUNT = 3;

    public StoplistDetailsPanel(PropertyModel propertyModel, JPanel jPanel, StoplistType stoplistType, boolean bl) {
        super((Context)null, null);
        assert (propertyModel != null) : "PropertyModel for TextNode node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.init((AbstractTextNode)this._data, propertyModel, jPanel, stoplistType, bl);
    }

    public StoplistDetailsPanel(Context context, AbstractTextNode abstractTextNode, JPanel jPanel, StoplistType stoplistType, boolean bl) {
        super(context, abstractTextNode);
        assert (context != null) : "Context must not be null.";
        assert (abstractTextNode != null) : "TextNode node must not be null.";
        this.init(abstractTextNode, null, jPanel, stoplistType, bl);
    }

    private void init(AbstractTextNode abstractTextNode, PropertyModel propertyModel, JPanel jPanel, StoplistType stoplistType, boolean bl) {
        this._propertyModel = propertyModel;
        this._parent = jPanel;
        if (jPanel instanceof TextTransColumnSettingTokenPanel) {
            this._isTokenTransType = true;
            this._bShowWords = true;
        } else if (jPanel instanceof TextTransColumnSettingThemePanel) {
            this._isTokenTransType = false;
            this._bShowThemes = true;
        }
        this._stoplist = (StoplistType)MetaDataHelper.copyMetadataObject(stoplistType);
        this._isEdit = bl;
        this._dirty = false;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jStoplistLabel, (Component)this.jStoplistTextField, (String)DialogsLrb.get("BUILDTEXT_STOPLIST"));
        ResourceUtils.resLabel((JLabel)this.jLanguageLabel, (Component)this.jLanguageValueLabel, (String)DialogsLrb.get("ADD_STOPWORD_LANGUAGE"));
    }

    @Override
    public void initUI() {
        this.jStoplistTextField.setText(this._stoplist.getName());
        this.jStoplistTextField.setEditable(this._isEdit && !ServerConstants.StoplistLanguage.isDefault((String)ServerConstants.StoplistLanguage.toSchema((String)this._stoplist.getName())));
        this._stopwordModels = new StopwordTableModel(this._stoplist, !this._isEdit);
        JScrollPane jScrollPane = new JScrollPane((Component)this._stopwordTable);
        this.StopwordComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        ControlBar controlBar = new ControlBar();
        this.StopwordComponentWithTitlebar.setControlBar(controlBar);
        this.installStopwordItemFilterActions(controlBar);
        this._stopwordTable.setModel((TableModel)((Object)this._stopwordModels));
        this._stopwordTable.setResizeColumnOnDoubleClick(true);
        this._stopwordTable.getSelectionModel().setSelectionMode(2);
        this._stopwordTable.setAutoResizeMode(0);
        this._stopwordTable.setSelectionMode(2);
        this._stopwordTable.setColumnSelectorAvailable(true);
        this._stopwordTable.setShowToolTips(true);
        this._stopwordTable.setUpdateSelectionOnSort(true);
        this._stopwordTable.setRowSelectionAllowed(true);
        if (this._isEdit) {
            TableColumn tableColumn = this._stopwordTable.getColumnModel().getColumn(0);
            StopwordEditor stopwordEditor = new StopwordEditor();
            stopwordEditor.setDocument(new TextFieldLimit(4000));
            tableColumn.setCellEditor(stopwordEditor);
        }
        this._tokenFilter = new RowFilter<StopwordTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends StopwordTableModel, ? extends Integer> entry) {
                String string;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = StoplistDetailsPanel.this._searchText != null && StoplistDetailsPanel.this._searchCategory != null;
                Integer n = entry.getIdentifier();
                StopwordTableModel stopwordTableModel = entry.getModel();
                String string2 = (String)stopwordTableModel.getValueAt(n, 1);
                if (StoplistDetailsPanel.this._bShowWords && ServerConstants.StopTokenType.isWord((String)string2) || StoplistDetailsPanel.this._bShowThemes && ServerConstants.StopTokenType.isTheme((String)string2)) {
                    bl2 = true;
                }
                String string3 = string = StoplistDetailsPanel.this._searchText != null ? StoplistDetailsPanel.this._searchText.toLowerCase() : null;
                if (bl2 && bl3 && StoplistDetailsPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("STOPLIST_COLUMN_NAME"))) {
                    String string4 = (String)stopwordTableModel.getValueAt(n, 0);
                    if (string4.toLowerCase().startsWith(string)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && StoplistDetailsPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("STOPLIST_COLUMN_TYPE"))) {
                    String string5 = (String)stopwordTableModel.getValueAt(n, 1);
                    if (string5.toLowerCase().startsWith(string)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && StoplistDetailsPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("STOPLIST_COLUMN_LANGUAGE"))) {
                    String string6 = (String)stopwordTableModel.getValueAt(n, 2);
                    if (string6.toLowerCase().startsWith(string)) {
                        bl = true;
                    }
                } else if (bl2) {
                    bl = true;
                }
                return bl;
            }
        };
        this.configureSorting();
        int n = 0;
        for (Object object : (StopwordEditor)this._stopwordColumnWidths) {
            this._stopwordTable.getColumnModel().getColumn(n++).setPreferredWidth((int)object);
        }
        this._stopwordTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                StoplistDetailsPanel.this.enableControls();
            }
        });
        this.enableControls();
    }

    private void installStopwordItemFilterActions(ControlBar controlBar) {
        SearchCategory[] searchCategoryArray;
        IdeAction ideAction = IdeAction.get((int)SHOW_STOPWORDS);
        this._showWords = new ToggleToolButton((ToggleAction)ideAction);
        this._showWords.setIcon(OracleIcons.getIcon((String)"text.png"));
        this._showWords.setToolTipText(DialogsLrb.get("STOPLIST_SHOW_STOPWORDS_TIP"));
        controlBar.add((Component)this._showWords);
        this._showWords.setSelected(this._bShowWords);
        this._showWords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToggleToolButton toggleToolButton = (ToggleToolButton)actionEvent.getSource();
                StoplistDetailsPanel.this._bShowWords = toggleToolButton.isSelected();
                StoplistDetailsPanel.this.configureSorting();
            }
        });
        IdeAction ideAction2 = IdeAction.get((int)SHOW_STOPTHEMES);
        this._showThemes = new ToggleToolButton((ToggleAction)ideAction2);
        this._showThemes.setIcon(OracleIcons.getIcon((String)"catalog.png"));
        this._showThemes.setToolTipText(DialogsLrb.get("STOPLIST_SHOW_STOPTHEMES_TIP"));
        controlBar.add((Component)this._showThemes);
        controlBar.addSeparator();
        this._showThemes.setSelected(this._bShowThemes);
        this._showThemes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToggleToolButton toggleToolButton = (ToggleToolButton)actionEvent.getSource();
                StoplistDetailsPanel.this._bShowThemes = toggleToolButton.isSelected();
                StoplistDetailsPanel.this.configureSorting();
            }
        });
        this._stopwordRemoveBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._stopwordRemoveBtn.setToolTipText(DialogsLrb.get("STOPLIST_DELETE_STOPWORD_TOOLTIP"));
        this._stopwordRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = StoplistDetailsPanel.this._stopwordTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    StoplistDetailsPanel.this._stopwordModels.removeSelectedRows(nArray);
                    StoplistDetailsPanel.this.resetNiceTableModel(StoplistDetailsPanel.this._stopwordModels);
                    StoplistDetailsPanel.this.enableControls();
                }
            }
        });
        controlBar.add((Component)this._stopwordRemoveBtn);
        this._stopwordAddBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._stopwordAddBtn.setToolTipText(DialogsLrb.get("STOPLIST_ADD_STOPWORD_TOOLTIP"));
        this._stopwordAddBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoplistDetailsPanel.this.processAdd();
            }
        });
        controlBar.add((Component)this._stopwordAddBtn);
        this._searchField = new SearchField(SearchField.Style.FILTER);
        this._searchField.setPreferredSize(new Dimension(200, 10));
        for (SearchCategory searchCategory : searchCategoryArray = new SearchCategory[]{new SearchCategory(DialogsLrb.get("STOPLIST_COLUMN_NAME")), new SearchCategory(DialogsLrb.get("STOPLIST_COLUMN_TYPE")), new SearchCategory(DialogsLrb.get("STOPLIST_COLUMN_LANGUAGE"))}) {
            this._searchField.addCategory(searchCategory);
        }
        controlBar.add((Component)this._searchField);
        this._searchField.addSearchListener((SearchListener)this);
    }

    private void resetNiceTableModel(StopwordTableModel stopwordTableModel) {
        stopwordTableModel.fireTableDataChanged();
        this._stopwordTable.clearSelection();
        this._stopwordTable.updateUI();
        this.configureSorting();
    }

    public void configureSorting() {
        TableRowSorter<StopwordTableModel> tableRowSorter = (TableRowSorter<StopwordTableModel>)this._stopwordTable.getRowSorter();
        if (tableRowSorter == null) {
            tableRowSorter = new TableRowSorter<StopwordTableModel>(this._stopwordModels);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
            arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            tableRowSorter.setSortKeys(arrayList);
            tableRowSorter.setSortsOnUpdates(true);
        }
        tableRowSorter.setRowFilter(this._tokenFilter);
        this._stopwordTable.setRowSorter(tableRowSorter);
    }

    public void searchPerformed(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._stopwordTable.scrollToSelection();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._stopwordTable.scrollToSelection();
    }

    private void processAdd() {
        AddStopwordsPanel addStopwordsPanel = new AddStopwordsPanel(this.getContext(), null, this, this._stoplist);
        if (addStopwordsPanel.showAsDialog(this) && addStopwordsPanel.isDirty()) {
            this._dirty = true;
            this._stoplist = addStopwordsPanel.getStoplist();
            this._stopwordModels.resetModel(this._stoplist);
            this.resetNiceTableModel(this._stopwordModels);
            AbstractTextNode.updateStoplistTypeAndLanguage(this._stoplist);
            this.enableControls();
        }
    }

    private void enableControls() {
        String string = null;
        string = this._stoplist.getType().equals("Basic") ? ServerConstants.StoplistLanguage.toHuman((String)this._stoplist.getLanguage()) : ServerConstants.StoplistLanguage.toHuman((String)"Multi");
        this.jLanguageValueLabel.setText(string);
        this._stopwordAddBtn.setEnabled(this._isEdit);
        int[] nArray = this._stopwordTable.getSelectedRowsInModel();
        this._stopwordRemoveBtn.setEnabled(this._isEdit && nArray.length > 0);
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        Context context = null;
        if (propertyModel instanceof WorkflowTextNodePropertyProxyModel) {
            WorkflowTextNodePropertyProxyModel workflowTextNodePropertyProxyModel = (WorkflowTextNodePropertyProxyModel)propertyModel;
            context = workflowTextNodePropertyProxyModel.getSelectionContext();
        } else if (propertyModel instanceof WorkflowBuildTextNodePropertyProxyModel) {
            WorkflowBuildTextNodePropertyProxyModel workflowBuildTextNodePropertyProxyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
            context = workflowBuildTextNodePropertyProxyModel.getSelectionContext();
        } else if (propertyModel instanceof WorkflowApplyTextNodePropertyProxyModel) {
            WorkflowApplyTextNodePropertyProxyModel workflowApplyTextNodePropertyProxyModel = (WorkflowApplyTextNodePropertyProxyModel)propertyModel;
            context = workflowApplyTextNodePropertyProxyModel.getSelectionContext();
        }
        return context;
    }

    private AbstractTextNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        Context context = this.getContext(propertyModel);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        return (AbstractTextNode)workflowNodeInspectorElement.getNode();
    }

    private void updateNode() {
        String string = this.jStoplistTextField.getText();
        this._stoplist.setName(string);
    }

    public boolean isTokenTransformType() {
        return this._isTokenTransType;
    }

    public boolean isThemeTransformType() {
        return !this._isTokenTransType;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    private boolean isNameUnique(String string, String string2, List<String> list) {
        if (list == null) {
            return true;
        }
        for (String string3 : list) {
            if (string.equals(string3) || !string3.equals(string2)) continue;
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_DUPLICATE_STOPLIST"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        return true;
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        if (this._isEdit) {
            String string = this.jStoplistTextField.getText().trim();
            if (string == null || string.length() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_WIZ_NAME_EMPTY"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                bl = false;
            } else {
                if (!this.isNameUnique(this._stoplist.getName(), string, this._stoplists)) {
                    return false;
                }
                if (!AttributeNameValidator.isNameLengthValidInDB(this._context, string, false)) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_WIZ_NAME_TOO_LONG"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    bl = false;
                }
            }
            if (bl) {
                if (!this._stoplist.getName().equals(string)) {
                    this._dirty = true;
                }
                if (this._dirty) {
                    this.updateNode();
                }
            }
        }
        return bl;
    }

    private void initComponents() {
        this.jStoplistLabel = new JLabel();
        this.jStoplistTextField = new JTextField();
        this.jLanguageLabel = new JLabel();
        this.jLanguageValueLabel = new JLabel();
        this.StopwordComponentWithTitlebar = new ComponentWithTitlebar();
        this.jStoplistLabel.setText("Stoplist:");
        this.jStoplistTextField.setText("jTextField1");
        this.jLanguageLabel.setText("Language:");
        this.jLanguageValueLabel.setText("jLabel3");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.StopwordComponentWithTitlebar, -1, 458, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLanguageLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jStoplistLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLanguageValueLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jStoplistTextField, -1, 213, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jStoplistLabel).addComponent(this.jStoplistTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLanguageLabel).addComponent(this.jLanguageValueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.StopwordComponentWithTitlebar, -1, 301, Short.MAX_VALUE).addContainerGap()));
    }

    public StoplistType getStoplist() {
        return this._stoplist;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("STOPLIST_DETAILS_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "stoplist_details";
    }

    @Override
    protected int getDialogButtonMask() {
        if (this._isEdit) {
            return 7;
        }
        return 20;
    }

    private class StopwordTableModel
    extends SimpleBaseTableModel {
        private StoplistType _stoplist;
        private boolean _readOnly = false;

        public StopwordTableModel(StoplistType stoplistType, boolean bl) {
            this._stoplist = stoplistType;
            this.setColumnIdentifiers(StoplistDetailsPanel.this._stopwordColumnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
            this._readOnly = bl;
        }

        public void resetModel(StoplistType stoplistType) {
            this._stoplist = stoplistType;
        }

        public int getRowCount() {
            if (this._stoplist == null || this._stoplist.getStopTokens() == null) {
                return 0;
            }
            return this._stoplist.getStopTokens().getToken().size();
        }

        public boolean isCellEditable(int n, int n2) {
            if (this._readOnly) {
                return false;
            }
            return n2 == 0;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (this._stoplist.getStopTokens() == null || this._stoplist.getStopTokens().getToken().size() == 0) {
                return null;
            }
            StoplistType.StopTokens.Token token = (StoplistType.StopTokens.Token)this._stoplist.getStopTokens().getToken().get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = token.getItem();
                    break;
                }
                case 1: {
                    string = ServerConstants.StopTokenType.toHuman((String)token.getType());
                    break;
                }
                case 2: {
                    string = ServerConstants.StoplistLanguage.toHuman((String)token.getLanguage());
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            StoplistType.StopTokens.Token token = (StoplistType.StopTokens.Token)this._stoplist.getStopTokens().getToken().get(n);
            switch (n2) {
                case 0: {
                    String string = null;
                    if (object != null) {
                        string = ((String)object).trim();
                    }
                    if (!this.validateStopwords(n, string, token.getLanguage(), token.getType(), this._stoplist.getStopTokens().getToken())) {
                        return;
                    }
                    StoplistDetailsPanel.this._dirty = true;
                    token.setItem(string);
                    break;
                }
                default: {
                    assert (false) : "Invalid option";
                    break;
                }
            }
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<StoplistType.StopTokens.Token> vector = new Vector<StoplistType.StopTokens.Token>();
            StoplistType.StopTokens.Token token = null;
            for (int i = 0; i < nArray.length; ++i) {
                token = (StoplistType.StopTokens.Token)this._stoplist.getStopTokens().getToken().get(nArray[i]);
                vector.add(token);
            }
            this._stoplist.getStopTokens().getToken().removeAll(vector);
            this.setRowCount(this._stoplist.getStopTokens().getToken().size());
            AbstractTextNode.updateStoplistTypeAndLanguage(this._stoplist);
            StoplistDetailsPanel.this._dirty = true;
        }

        private boolean validateStopwords(int n, String string, String string2, String string3, List<StoplistType.StopTokens.Token> list) {
            boolean bl = true;
            int n2 = 0;
            if (string == null || string.length() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_STOPWORD_EMPTY"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            for (StoplistType.StopTokens.Token token : list) {
                String string4 = string2 + ":" + string3 + ":" + string;
                String string5 = token.getLanguage() + ":" + token.getType() + ":" + token.getItem();
                if (n != n2 && string4.compareTo(string5) == 0) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_DUPLICATE_STOPWORD"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            }
            return bl;
        }
    }

    private static class StopwordEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JTextField _textField = new JTextField();

        public StopwordEditor() {
            this._textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof String) {
                String string = (String)object;
                this._textField.setText(string);
            } else if (object == null) {
                this._textField.setText("");
            }
            return this._textField;
        }

        @Override
        public Object getCellEditorValue() {
            return this._textField.getText();
        }

        public void setDocument(Document document) {
            this._textField.setDocument(document);
        }
    }
}

