/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableAdapter;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.workflow.RefreshWFInputNodeRecord;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;

public class RefreshWFInputResultPanel
extends JPanel
implements DialogDisplayable {
    private List<RefreshWFInputNodeRecord> nodes;
    private JLabel lblTitle;
    private DataMinerTablePanel tablePanel;

    public RefreshWFInputResultPanel(List<RefreshWFInputNodeRecord> list) {
        this.initComponents();
        this.nodes = list;
        this.initUI();
    }

    private void initUI() {
        this.lblTitle.setText(WorkflowEditorLrb.get("REFRESH_WF_DATA_DEFINITION_DIALOG_LBL"));
        NodeTableModel nodeTableModel = new NodeTableModel(this.nodes);
        this.tablePanel.setup((TableModel)((Object)nodeTableModel), null, 0, false);
    }

    private void initComponents() {
        this.lblTitle = new JLabel();
        this.tablePanel = new DataMinerTablePanel();
        this.lblTitle.setText("The following nodes were updated:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.lblTitle).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.tablePanel, -1, 427, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.lblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePanel, -1, 129, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableAdapter(){

            @Override
            public String getTitle() {
                return WorkflowEditorLrb.get("REFRESH_WF_DATA_DEFINITION");
            }

            @Override
            public String getHelpTopic() {
                return null;
            }

            @Override
            public JComponent getContent() {
                return RefreshWFInputResultPanel.this;
            }

            @Override
            public int getButtonMask() {
                return 16;
            }
        };
    }

    public static class NodeTableModel
    extends ODMrTableModel<RefreshWFInputNodeRecord> {
        private static final int NAME = 0;
        private static final int NODE_TYPE = 1;
        private static final String[] _columns = new String[]{WorkflowEditorLrb.get("REFRESH_WF_RESULTS_PANEL_NODE_NAME"), WorkflowEditorLrb.get("REFRESH_WF_RESULTS_PANEL_NODE_TYPE")};

        public NodeTableModel(List<RefreshWFInputNodeRecord> list) {
            super(_columns, list);
        }

        public String getValueAt(int n, int n2) {
            String string = "";
            RefreshWFInputNodeRecord refreshWFInputNodeRecord = (RefreshWFInputNodeRecord)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    string = refreshWFInputNodeRecord.getName();
                    break;
                }
                case 1: {
                    string = refreshWFInputNodeRecord.getNodeType();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }
    }
}

