/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.net.DMURLFileSystemHelper;
import oracle.dmt.dataminer.repository.WorkflowProject;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.ide.Ide;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.javatools.dialogs.MessageDialog;

public class ConnectionFolderFilter
extends BaseDeferredFilter {
    private static final Logger theLogger = Logger.getLogger(ConnectionFolderFilter.class.getName());

    @Override
    protected List<Element> loadChildrenImpl(TNode tNode) throws Exception {
        ConnectionFolder connectionFolder = (ConnectionFolder)tNode.getData();
        if (!ConfigUtils.isValidUserConnection(connectionFolder.getConnectionName()).booleanValue()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.critical((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("SYSDBA_CONN_NOT_ALLOWED"), (String)DataminerNavigatorLrb.get("SYSDBA_CONN_NOT_ALLOWED_TITLE"), null);
                }
            });
            throw new InterruptedException("Connection does not meet requirements and cannot be opened");
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        connectionFolder.open();
        if (!connectionFolder.checkConnection()) {
            throw new InterruptedException("Connection does not meet requirements and cannot be opened");
        }
        Set<WorkflowProject> set = WorkflowProject.getProjects(connectionFolder);
        for (WorkflowProject workflowProject : set) {
            ProjectFolder projectFolder = ConnectionFolderFilter.getProjectFolder(connectionFolder.getURL().getPath() + "/" + workflowProject.getName(), true);
            projectFolder.setRepositoryData(workflowProject);
            projectFolder.setId(workflowProject.getId());
            projectFolder.setParent(this.getOwner());
            arrayList.add((Element)projectFolder);
            connectionFolder.add((Element)projectFolder, false);
        }
        connectionFolder.markDirty(false);
        return arrayList;
    }

    public static ProjectFolder getProjectFolder(String string, boolean bl) {
        ProjectFolder projectFolder = null;
        try {
            URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)string);
            projectFolder = bl ? (ProjectFolder)NodeFactory.findOrCreate(ProjectFolder.class, (URL)uRL) : (ProjectFolder)NodeFactory.find((URL)uRL);
        }
        catch (Exception exception) {
            theLogger.log(Level.FINEST, exception.getMessage());
        }
        return projectFolder;
    }
}

