/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.features;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SortOrder;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.editors.FindValueCellEditor;
import oracle.dmt.dataminer.core.dal.sql.queries.StringSearchQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.common.SearchFeatureIdQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.common.SearchFeatureItemQuery;
import oracle.dmt.dataminer.core.model.common.build.Column;
import oracle.dmt.dataminer.core.model.common.build.ColumnFilter;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.core.model.fe.common.FeatureItemSet;
import oracle.dmt.dataminer.filter.FilterLrb;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.features.ESAFeatureFilterTableModel;
import oracle.dmt.dataminer.mviewer.features.FeatureLrb;
import oracle.dmt.dataminer.mviewer.features.FeatureViewerState;
import oracle.dmt.dataminer.partition.PartitionsLrb;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.editor.Editor;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Version;

public class FeatureFilterPanel
extends JPanel
implements DataminerGUIPanel {
    private static int MIN_EXPANDED = 210;
    private static Dimension DIM_EXPANDED = new Dimension(0, MIN_EXPANDED);
    private static int MIN_COLLAPSED = 40;
    private static Dimension DIM_COLLAPSED = new Dimension(0, MIN_COLLAPSED);
    private boolean isFilterVisible;
    private boolean hasFiltering;
    private boolean showSorting;
    private boolean hasError;
    private List<MiningAttributeType> inputAttributes;
    private ESAFeatureFilterTableModel tableModel;
    private PropertyChangeSupport propertyChangeSupport;
    private FindValueCellEditor findCellEditor;
    private FeatureViewerState state;
    private List<Column> availableColumns;
    private SearchFeatureItemQuery featureItemQuery;
    private SearchFeatureIdQuery featureIdQuery;
    private JButton deleteFilter;
    private JButton addFilter;
    private Editor editor;
    private JRadioButton ascendingRadioButton;
    private JPanel containerPanel;
    private JRadioButton descendingRadioButton;
    private JLabel errorLabel;
    private JLabel fetchLabel;
    private JSpinner fetchSpinner;
    private JPanel filterPanel;
    private DataMinerTablePanel filterTablePanel;
    private JLabel infoLabel;
    private JPanel infoPanel;
    private JSpinner itemSpinner;
    private JLabel itemsLabel;
    private JLabel jLabel1;
    private JRadioButton matchAllRadioButton;
    private JRadioButton matchAnyRadioButton;
    private ButtonGroup matchGroup;
    private ModelViewerPartitionToolbar partitionToolbar;
    private JButton queryButton;
    private JPanel resultPanel;
    private DataMinerTablePanel resultsTablePanel;
    private JPanel setupPanel;
    private JButton showButton;
    private ButtonGroup sortGroup;
    private JLabel sortLabel;
    private JSplitPane splitPane;

    public FeatureFilterPanel(FeatureViewerState featureViewerState, Editor editor) {
        assert (featureViewerState != null) : "State cannot be null";
        this.state = featureViewerState;
        this.editor = editor;
        this.inputAttributes = new ArrayList<MiningAttributeType>();
        this.availableColumns = new ArrayList<Column>();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.initializeQueryObjects();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initializeQueryObjects() {
        Class<? extends ModelType> clazz = this.state.getModelTypeClass();
        ModelDescriptor modelDescriptor = new ModelDescriptor(this.state.getUserName(), this.state.getModelName());
        Version version = this.state.getDbVersion();
        this.featureIdQuery = new SearchFeatureIdQuery(version, clazz, modelDescriptor);
        this.featureItemQuery = new SearchFeatureItemQuery(version, clazz, modelDescriptor, null);
    }

    private void initComponents() {
        this.sortGroup = new ButtonGroup();
        this.matchGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.setupPanel = new JPanel();
        this.fetchLabel = new JLabel();
        this.fetchSpinner = new JSpinner();
        this.ascendingRadioButton = new JRadioButton();
        this.descendingRadioButton = new JRadioButton();
        this.queryButton = new JButton();
        this.showButton = new JButton();
        this.splitPane = new JSplitPane();
        this.containerPanel = new JPanel();
        this.infoPanel = new JPanel();
        this.infoLabel = new JLabel();
        this.filterPanel = new JPanel();
        this.matchAllRadioButton = new JRadioButton();
        this.matchAnyRadioButton = new JRadioButton();
        this.filterTablePanel = new DataMinerTablePanel();
        this.errorLabel = new JLabel();
        this.resultPanel = new JPanel();
        this.resultsTablePanel = new DataMinerTablePanel();
        this.sortLabel = new JLabel();
        this.partitionToolbar = new ModelViewerPartitionToolbar();
        this.itemSpinner = new JSpinner();
        this.itemsLabel = new JLabel();
        this.jLabel1.setText("jLabel1");
        this.setLayout(new BoxLayout(this, 1));
        this.fetchLabel.setText("Fetch Size:");
        this.sortGroup.add(this.ascendingRadioButton);
        this.ascendingRadioButton.setSelected(true);
        this.ascendingRadioButton.setText("Ascending Order");
        this.sortGroup.add(this.descendingRadioButton);
        this.descendingRadioButton.setText("Descending Order");
        this.queryButton.setText("Query");
        this.showButton.setText("Less");
        this.splitPane.setBorder(null);
        this.splitPane.setDividerLocation(260);
        this.splitPane.setOrientation(0);
        this.splitPane.setMinimumSize(new Dimension(100, 205));
        this.containerPanel.setMinimumSize(new Dimension(100, 50));
        this.infoPanel.setMinimumSize(new Dimension(740, 45));
        this.infoPanel.setPreferredSize(new Dimension(77, 40));
        this.infoLabel.setText("Active Filter");
        GroupLayout groupLayout = new GroupLayout(this.infoPanel);
        this.infoPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.infoLabel).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.infoLabel).addContainerGap()));
        this.filterPanel.setMinimumSize(new Dimension(741, 140));
        this.filterPanel.setPreferredSize(new Dimension(721, 140));
        this.matchGroup.add(this.matchAllRadioButton);
        this.matchAllRadioButton.setSelected(true);
        this.matchAllRadioButton.setText("Match All");
        this.matchGroup.add(this.matchAnyRadioButton);
        this.matchAnyRadioButton.setText("Match Any");
        this.errorLabel.setHorizontalAlignment(4);
        this.errorLabel.setText("A Filter Definition is Incomplete");
        GroupLayout groupLayout2 = new GroupLayout(this.filterPanel);
        this.filterPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.matchAllRadioButton).addGap(18, 18, 18).addComponent(this.matchAnyRadioButton)).addComponent(this.filterTablePanel, -1, -1, Short.MAX_VALUE).addComponent(this.errorLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.matchAllRadioButton).addComponent(this.matchAnyRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.filterTablePanel, -1, 153, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.errorLabel).addGap(5, 5, 5)));
        GroupLayout groupLayout3 = new GroupLayout(this.containerPanel);
        this.containerPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.infoPanel, -1, 743, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.filterPanel, -1, 754, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.infoPanel, -2, 34, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterPanel, -1, 220, Short.MAX_VALUE)));
        this.splitPane.setLeftComponent(this.containerPanel);
        GroupLayout groupLayout4 = new GroupLayout(this.resultPanel);
        this.resultPanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 754, Short.MAX_VALUE).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.resultsTablePanel, -2, 0, Short.MAX_VALUE).addContainerGap())));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 136, Short.MAX_VALUE).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.resultsTablePanel, -2, 0, Short.MAX_VALUE).addContainerGap())));
        this.splitPane.setRightComponent(this.resultPanel);
        this.sortLabel.setText("Sorting Order:");
        this.itemsLabel.setText("Items Per Feature");
        GroupLayout groupLayout5 = new GroupLayout(this.setupPanel);
        this.setupPanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addComponent(this.sortLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ascendingRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descendingRadioButton)).addComponent(this.partitionToolbar, -2, 458, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fetchLabel, GroupLayout.Alignment.TRAILING).addComponent(this.itemsLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.fetchSpinner, -1, 60, Short.MAX_VALUE).addComponent(this.itemSpinner)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.showButton, -1, -1, Short.MAX_VALUE).addComponent(this.queryButton, -1, 100, Short.MAX_VALUE)).addContainerGap()).addComponent(this.splitPane, -1, -1, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fetchLabel).addComponent(this.fetchSpinner, -2, -1, -2).addComponent(this.queryButton).addComponent(this.ascendingRadioButton).addComponent(this.descendingRadioButton).addComponent(this.sortLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showButton).addComponent(this.itemSpinner, -2, -1, -2).addComponent(this.itemsLabel)).addComponent(this.partitionToolbar, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.splitPane, -1, -1, Short.MAX_VALUE)));
        this.add(this.setupPanel);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.errorLabel, null, (String)"");
        ResourceUtils.resButton((AbstractButton)this.matchAllRadioButton, (String)CommonLrb.get("MATCH_ALL"));
        ResourceUtils.resButton((AbstractButton)this.matchAnyRadioButton, (String)CommonLrb.get("MATCH_ANY"));
        ResourceUtils.resLabel((JLabel)this.infoLabel, null, (String)CommonLrb.get("MSG_FILTER_NO_FILTER"));
        ResourceUtils.resLabel((JLabel)this.fetchLabel, (Component)this.fetchSpinner, (String)CoefficientsLrb.get("FETCH_SIZE"));
        this.fetchLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FETCH_SIZE"));
        this.fetchLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FETCH_SIZE_ADA"));
        this.fetchSpinner.setToolTipText(FeatureLrb.get("FETCH_SIZE_ADA") + "\n" + CoefficientsLrb.get("FETCH_SIZE_RANGE"));
        this.fetchSpinner.setModel(new SpinnerNumberModel(2000, 1, Integer.MAX_VALUE, 1000));
        ResourceUtils.resSpinner((JLabel)this.itemsLabel, (JSpinner)this.itemSpinner, (String)FeatureLrb.get("ITEM_SET_SIZE"));
        this.itemsLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FETCH_SIZE"));
        this.itemsLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FETCH_SIZE_ADA"));
        this.itemSpinner.setToolTipText(FeatureLrb.get("FETCH_SIZE_ADA") + "\n" + CoefficientsLrb.get("FETCH_SIZE_RANGE"));
        this.itemSpinner.setModel(new SpinnerNumberModel(50, 1, Integer.MAX_VALUE, 5));
        ResourceUtils.resButton((AbstractButton)this.ascendingRadioButton, (String)CommonLrb.get("ASCENDING"));
        ResourceUtils.resButton((AbstractButton)this.descendingRadioButton, (String)CommonLrb.get("DESCENDING"));
        ResourceUtils.resButton((AbstractButton)this.queryButton, (String)CommonLrb.get("QUERY"));
        this.queryButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        ResourceUtils.resButton((AbstractButton)this.showButton, (String)CommonLrb.get("MORE"));
        this.showButton.setIcon(DataMinerIcons.get(Icons.EXPAND));
        this.showButton.getAccessibleContext().setAccessibleName(CommonLrb.get("MORE"));
        this.showButton.setHorizontalTextPosition(10);
    }

    @Override
    public void initUI() {
        this.initializeContainers();
        this.partitionToolbar.setVisible(false);
    }

    private void initializeContainers() {
        this.containerPanel.setBorder(BorderFactory.createTitledBorder(FilterLrb.get("FILTER")));
        this.splitPane.setDividerLocation(MIN_COLLAPSED + 20);
        this.splitPane.setEnabled(false);
        this.initializeSplitUpperSection();
        this.initializeSplitLowerPanel();
        this.infoPanel.setVisible(true);
        this.filterPanel.setVisible(false);
    }

    private void initializeSplitUpperSection() {
        this.setPreferredConfiguration();
        this.initializeFilterTable();
        this.initializeFilterTableToolbar();
        this.addListeners();
    }

    private void setPreferredConfiguration() {
        if (SortOrder.ASCENDING.equals((Object)this.state.getFeatureSortDirection())) {
            this.ascendingRadioButton.setSelected(true);
        } else {
            this.descendingRadioButton.setSelected(true);
        }
        this.itemSpinner.setValue(this.state.getItemFetchSize());
    }

    private void initializeFilterTable() {
        this.state.getFeatureFilterTableModel().addTableModelListener(new FilterTableModelListener());
        this.filterTablePanel.setup((TableModel)((Object)this.state.getFeatureFilterTableModel()), FilterLrb.get("FILTER"), -1);
        this.filterTablePanel.removeSearchField();
        DataMinerTable dataMinerTable = this.filterTablePanel.getTable();
        dataMinerTable.autoSizeColumnsToFit();
        dataMinerTable.setRowSorter(null);
        dataMinerTable.setAutoResizeMode(4);
        dataMinerTable.getSelectionModel().addListSelectionListener(new FilterTableSelectionListener());
        TableColumnModel tableColumnModel = dataMinerTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellEditor(new FeatureCellEditor());
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(new OperatorCellEditor());
        tableColumn = tableColumnModel.getColumn(2);
        this.findCellEditor = new FindValueCellEditor(this.state.getContext(), (StringSearchQuery)this.featureIdQuery, true);
        tableColumn.setCellEditor(this.findCellEditor);
    }

    private void initializeFilterTableToolbar() {
        this.addFilter = new JButton();
        this.addFilter.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.addFilter.addActionListener(new AddFilterActionListener());
        this.addFilter.setEnabled(false);
        this.deleteFilter = new JButton();
        this.deleteFilter.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.deleteFilter.addActionListener(new DeleteFilterActionListener());
        this.deleteFilter.setEnabled(false);
        this.filterTablePanel.addControlBarComponents(this.addFilter, this.deleteFilter);
    }

    private void addListeners() {
        this.fetchSpinner.addChangeListener(new FetchSizeChangeListener());
        this.itemSpinner.addChangeListener(new ItemSetSizeChangeListener());
        this.ascendingRadioButton.addChangeListener(new FeatureSortDirectionChangeListener());
        this.matchAllRadioButton.addChangeListener(new MatchTypeChangeListener());
        this.showButton.addActionListener(new ShowFiltersActionListener());
        this.state.getFeatureFilterTableModel().addTableModelListener(new FilterTableModelListener());
    }

    private void initializeSplitLowerPanel() {
        DataMinerTable dataMinerTable = this.resultsTablePanel.getTable();
        dataMinerTable.setFixedColumns(1, 250);
        this.resultsTablePanel.setup((TableModel)((Object)this.state.getFeatureItemsTableModel()), "", -1, true);
        dataMinerTable.setSelectionMode(0);
        dataMinerTable.setNoEntryInstructionText(FeatureLrb.get("NO_FILTERS_DEFINED"));
        dataMinerTable.autoSizeColumnsToFit();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void loadPartitionToolbar() {
        this.partitionToolbar.load(this.editor);
    }

    public void afterLoad() {
        this.sortStateFeatureItemSets();
        this.resultsTablePanel.getTable().autoSizeColumnsToFit();
    }

    private void sortStateFeatureItemSets() {
        List list = this.state.getFeatureItemsTableModel().getSrcData();
        Collections.sort(list, (featureItemSet, featureItemSet2) -> {
            if (this.descendingRadioButton.isSelected()) {
                FeatureItemSet featureItemSet3 = featureItemSet;
                featureItemSet = featureItemSet2;
                featureItemSet2 = featureItemSet3;
            }
            return featureItemSet.getFeatureId().compareTo(featureItemSet2.getFeatureId());
        });
    }

    public void addQueryListener(ActionListener actionListener) {
        this.queryButton.addActionListener(actionListener);
    }

    public void addListSelectionListenerToFeatureGrid(ListSelectionListener listSelectionListener) {
        this.resultsTablePanel.getTable().getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void enableFilters() {
        if (this.filterTablePanel.getTable().isEditing()) {
            this.filterTablePanel.getTable().getCellEditor().cancelCellEditing();
        }
        this.availableColumns.clear();
        this.availableColumns.add(new Column(FeatureLrb.get("FEATURE_ID_TAG"), "VARCHAR2", ""));
        this.inputAttributes.clear();
        this.inputAttributes.addAll(this.state.getInputAttributes().stream().filter(miningAttributeType -> "Yes".equals(miningAttributeType.getInput())).collect(Collectors.toList()));
        this.availableColumns.addAll(this.inputAttributes.stream().filter(miningAttributeType -> this.state.getAvailableAttributeNames().contains(miningAttributeType.getName())).sorted((miningAttributeType, miningAttributeType2) -> miningAttributeType.getName().compareTo(miningAttributeType2.getName())).map(miningAttributeType -> new Column(miningAttributeType.getName(), miningAttributeType.getDataType(), "")).collect(Collectors.toList()));
        this.addFilter.setEnabled(true);
    }

    public void updateRenderingQueriesPartitionId(String string) {
        this.featureIdQuery.setPartitionId(string);
        this.featureItemQuery.setPartitionId(string);
    }

    public String getPartitionId() {
        PartitionVO partitionVO = this.partitionToolbar.getPartitionVO();
        String string = partitionVO == null ? null : partitionVO.getPartitionID();
        return string;
    }

    public FeatureItemSet getSelectedFeature() {
        int n = this.resultsTablePanel.getTable().getSelectedRowInModel();
        FeatureItemSet featureItemSet = n < 0 ? null : (FeatureItemSet)this.state.getFeatureItemsTableModel().getRow(n);
        return featureItemSet;
    }

    public DataMinerTable getResultTable() {
        return this.resultsTablePanel.getTable();
    }

    public DataMinerTable getFilterTable() {
        return this.filterTablePanel.getTable();
    }

    private class FilterTableModelListener
    implements TableModelListener {
        private FilterTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (this.nameColumnChanged(tableModelEvent)) {
                this.checkDataTypeChange(tableModelEvent);
            }
            if (this.needsValidation(tableModelEvent.getType())) {
                this.validateRules();
            }
        }

        private void validateRules() {
            List list = FeatureFilterPanel.this.state.getFeatureFilterTableModel().getSrcData();
            boolean bl = true;
            if (list.isEmpty()) {
                this.enableTagCloudFilter(false, false);
            } else {
                int n = 0;
                for (ColumnFilter columnFilter : list) {
                    if (columnFilter.isEmpty()) {
                        ++n;
                        continue;
                    }
                    if (columnFilter.isComplete()) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    this.enableTagCloudFilter(n != list.size(), false);
                } else {
                    this.enableTagCloudFilter(FeatureFilterPanel.this.hasFiltering, true);
                }
            }
            if (bl) {
                FeatureFilterPanel.this.errorLabel.setText("");
                FeatureFilterPanel.this.errorLabel.setIcon(null);
            } else {
                FeatureFilterPanel.this.errorLabel.setText(CommonLrb.get("MSG_FILTER_ERROR"));
                FeatureFilterPanel.this.errorLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
            }
            FeatureFilterPanel.this.queryButton.setEnabled(bl);
        }

        private void enableTagCloudFilter(boolean bl, boolean bl2) {
            boolean bl3 = FeatureFilterPanel.this.hasFiltering && !FeatureFilterPanel.this.hasError;
            boolean bl4 = bl && !bl2;
            FeatureFilterPanel.this.hasFiltering = bl;
            FeatureFilterPanel.this.hasError = bl2;
            FeatureFilterPanel.this.propertyChangeSupport.firePropertyChange("FILTER_CLOUD", bl3, bl4);
        }

        private boolean nameColumnChanged(TableModelEvent tableModelEvent) {
            return tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == 0;
        }

        private void checkDataTypeChange(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getFirstRow();
            DataMinerTable dataMinerTable = FeatureFilterPanel.this.filterTablePanel.getTable();
            Column column = (Column)((JTable)((Object)dataMinerTable)).getValueAt(n, 0);
            if (column == null) {
                return;
            }
            if (FeatureLrb.get("FEATURE_ID_TAG").equals(column.getColumnName())) {
                FeatureFilterPanel.this.findCellEditor.setQuery((StringSearchQuery)FeatureFilterPanel.this.featureIdQuery);
            } else {
                FeatureFilterPanel.this.featureItemQuery.setColumn(column.getColumnName());
                FeatureFilterPanel.this.findCellEditor.setQuery((StringSearchQuery)FeatureFilterPanel.this.featureItemQuery);
            }
            FeatureFilterPanel.this.findCellEditor.clearFindPanel();
            ((JTable)((Object)dataMinerTable)).setValueAt("", n, 2);
            ColumnFilter.Operator operator = (ColumnFilter.Operator)((JTable)((Object)dataMinerTable)).getValueAt(n, 1);
            if (this.areDataTypesDifferent(column, operator)) {
                if (column.isStringDataType()) {
                    ((JTable)((Object)dataMinerTable)).setValueAt(ColumnFilter.Operator.STARTS, n, 1);
                } else {
                    ((JTable)((Object)dataMinerTable)).setValueAt(ColumnFilter.Operator.EXIST, n, 1);
                }
            }
        }

        private boolean areDataTypesDifferent(Column column, ColumnFilter.Operator operator) {
            if (column.isStringDataType()) {
                return !operator.isStringOperator();
            }
            return !operator.isNumberOperator();
        }

        private boolean needsValidation(int n) {
            return n == 0 || n == -1 || n == 1;
        }
    }

    private class FilterTableSelectionListener
    implements ListSelectionListener {
        private FilterTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            DataMinerTable dataMinerTable = FeatureFilterPanel.this.filterTablePanel.getTable();
            int n = ((DefaultListSelectionModel)listSelectionEvent.getSource()).getLeadSelectionIndex();
            if (n >= 0 && n < ((JTable)((Object)dataMinerTable)).getRowCount()) {
                Column column = (Column)((JTable)((Object)dataMinerTable)).getValueAt(n, 0);
                if (column == null) {
                    return;
                }
                if (FeatureLrb.get("FEATURE_ID_TAG").equals(column.getColumnName())) {
                    FeatureFilterPanel.this.findCellEditor.setQuery((StringSearchQuery)FeatureFilterPanel.this.featureIdQuery);
                } else {
                    FeatureFilterPanel.this.featureItemQuery.setColumn(column.getColumnName());
                    FeatureFilterPanel.this.findCellEditor.setQuery((StringSearchQuery)FeatureFilterPanel.this.featureItemQuery);
                }
                FeatureFilterPanel.this.findCellEditor.clearFindPanel();
            }
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            FeatureFilterPanel.this.deleteFilter.setEnabled(this.filterTableHasRows());
        }

        private boolean filterTableHasRows() {
            return FeatureFilterPanel.this.filterTablePanel.getTable().getRowCount() > 0;
        }
    }

    private class FeatureCellEditor
    extends DefaultCellEditor {
        private FeatureCellEditor() {
            super(new JComboBox());
            this.setClickCountToStart(2);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            assert (component instanceof JComboBox);
            JComboBox jComboBox = (JComboBox)component;
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
            FeatureFilterPanel.this.availableColumns.forEach(column -> defaultComboBoxModel.addElement(column));
            jComboBox.setModel(defaultComboBoxModel);
            return component;
        }
    }

    private static class OperatorCellEditor
    extends DefaultCellEditor {
        private static final DefaultComboBoxModel<ColumnFilter.Operator> NUMBER_MODEL = new DefaultComboBoxModel();
        private static final DefaultComboBoxModel<ColumnFilter.Operator> STRING_MODEL;

        private OperatorCellEditor() {
            super(new JComboBox());
            this.setClickCountToStart(2);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            assert (component instanceof JComboBox);
            JComboBox jComboBox = (JComboBox)component;
            Object object2 = jTable.getValueAt(n, 0);
            assert (object2 instanceof Column);
            Column column = (Column)object2;
            DefaultComboBoxModel<ColumnFilter.Operator> defaultComboBoxModel = column.isStringDataType() ? STRING_MODEL : NUMBER_MODEL;
            jComboBox.setModel(defaultComboBoxModel);
            return component;
        }

        static {
            NUMBER_MODEL.addElement(ColumnFilter.Operator.EXIST);
            STRING_MODEL = new DefaultComboBoxModel();
            STRING_MODEL.addElement(ColumnFilter.Operator.STARTS);
            STRING_MODEL.addElement(ColumnFilter.Operator.CONTAINS);
            STRING_MODEL.addElement(ColumnFilter.Operator.EQUALS);
        }
    }

    private class AddFilterActionListener
    implements ActionListener {
        private AddFilterActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataMinerTable dataMinerTable = FeatureFilterPanel.this.filterTablePanel.getTable();
            FeatureFilterPanel.this.tableModel = FeatureFilterPanel.this.state.getFeatureFilterTableModel();
            ColumnFilter columnFilter = ColumnFilter.createEmptyFilter();
            columnFilter.setTargetColumn(FeatureFilterPanel.this.availableColumns.get(0));
            if (columnFilter.getTargetColumn().isStringDataType()) {
                columnFilter.setOperator(ColumnFilter.Operator.STARTS);
            } else {
                columnFilter.setOperator(ColumnFilter.Operator.EXIST);
            }
            FeatureFilterPanel.this.tableModel.addRow(columnFilter);
            int n = FeatureFilterPanel.this.tableModel.getRowCount() - 1;
            dataMinerTable.setRowSelectionInterval(n, n);
            dataMinerTable.editCellAt(n, 0);
            dataMinerTable.getEditorComponent().requestFocus();
        }
    }

    private class DeleteFilterActionListener
    implements ActionListener {
        DataMinerTable table;

        private DeleteFilterActionListener() {
            this.table = FeatureFilterPanel.this.filterTablePanel.getTable();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.table.removeEditor();
            this.deleteRows(this.getRowsToDelete());
        }

        private final void deleteRows(int[] nArray) {
            ArrayList<ColumnFilter> arrayList = new ArrayList<ColumnFilter>(nArray.length);
            for (int n : nArray) {
                arrayList.add((ColumnFilter)FeatureFilterPanel.this.tableModel.getSrcData().get(n));
            }
            FeatureFilterPanel.this.tableModel.removeRows(arrayList);
        }

        private final int[] getRowsToDelete() {
            int[] nArray = new int[]{};
            int n = this.table.getEditingRow();
            nArray = n >= 0 ? new int[]{n} : this.table.getSelectedRows();
            return nArray;
        }
    }

    private class FetchSizeChangeListener
    implements ChangeListener {
        private FetchSizeChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = FeatureFilterPanel.this.fetchSpinner.getValue();
            if (object == null || !(object instanceof Integer)) {
                return;
            }
            FeatureFilterPanel.this.state.setFeatureFetchSize((Integer)object);
        }
    }

    private class ItemSetSizeChangeListener
    implements ChangeListener {
        private ItemSetSizeChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            FeatureFilterPanel.this.state.setItemFetchSize((Integer)FeatureFilterPanel.this.itemSpinner.getValue());
        }
    }

    private class FeatureSortDirectionChangeListener
    implements ChangeListener {
        private FeatureSortDirectionChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            FeatureFilterPanel.this.state.setFeatureSortDirection(FeatureFilterPanel.this.ascendingRadioButton.isSelected() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
        }
    }

    private class MatchTypeChangeListener
    implements ChangeListener {
        private MatchTypeChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            FeatureFilterPanel.this.state.setFilterMatchType(FeatureFilterPanel.this.matchAllRadioButton.isSelected() ? ColumnFilter.Match.ALL : ColumnFilter.Match.ANY);
        }
    }

    private class ShowFiltersActionListener
    implements ActionListener {
        private ShowFiltersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.toogleFilter();
        }

        private void toogleFilter() {
            boolean bl = FeatureFilterPanel.this.isFilterVisible = !FeatureFilterPanel.this.isFilterVisible;
            if (FeatureFilterPanel.this.isFilterVisible) {
                ResourceUtils.resButton((AbstractButton)FeatureFilterPanel.this.showButton, (String)ControlsLrb.get("FILTER_HIDE"));
                FeatureFilterPanel.this.showButton.setText(CommonLrb.get("LESS"));
                FeatureFilterPanel.this.showButton.setIcon(DataMinerIcons.get(Icons.COLLAPSE));
                FeatureFilterPanel.this.showButton.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_HIDE"));
                FeatureFilterPanel.this.showButton.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_HIDE_ADA"));
                FeatureFilterPanel.this.splitPane.setEnabled(true);
                FeatureFilterPanel.this.splitPane.setDividerLocation(MIN_EXPANDED);
                FeatureFilterPanel.this.containerPanel.setMinimumSize(DIM_EXPANDED);
            } else {
                ResourceUtils.resButton((AbstractButton)FeatureFilterPanel.this.showButton, (String)ControlsLrb.get("FILTER_MORE"));
                FeatureFilterPanel.this.showButton.setText(CommonLrb.get("MORE"));
                FeatureFilterPanel.this.showButton.setIcon(DataMinerIcons.get(Icons.EXPAND));
                FeatureFilterPanel.this.showButton.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_MORE"));
                FeatureFilterPanel.this.showButton.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_MORE_ADA"));
                FeatureFilterPanel.this.splitPane.setEnabled(false);
                FeatureFilterPanel.this.splitPane.setDividerLocation(MIN_COLLAPSED + 20);
                FeatureFilterPanel.this.containerPanel.setMinimumSize(DIM_COLLAPSED);
            }
            FeatureFilterPanel.this.showButton.setHorizontalTextPosition(10);
            this.displayFilterSortingPanels();
            if (FeatureFilterPanel.this.hasError) {
                ResourceUtils.resLabel((JLabel)FeatureFilterPanel.this.infoLabel, null, (String)PartitionsLrb.get("FILTER_COLAPSED_ERROR"));
                FeatureFilterPanel.this.infoLabel.setIcon(DataMinerIcons.get(Icons.ERROR_STATUS));
            } else if (FeatureFilterPanel.this.hasFiltering) {
                String string = FeatureFilterPanel.this.showSorting ? PartitionsLrb.get("FILTER_SORTING_COLAPSED_ACTIVE") : PartitionsLrb.get("FILTER_COLAPSED_ACTIVE");
                ResourceUtils.resLabel((JLabel)FeatureFilterPanel.this.infoLabel, null, (String)string);
                FeatureFilterPanel.this.infoLabel.setIcon(OracleIcons.getIcon((String)"filter.png"));
            } else {
                ResourceUtils.resLabel((JLabel)FeatureFilterPanel.this.infoLabel, null, (String)PartitionsLrb.get("FILTER_NONE"));
                FeatureFilterPanel.this.infoLabel.setIcon(null);
            }
            FeatureFilterPanel.this.containerPanel.invalidate();
        }

        private void displayFilterSortingPanels() {
            FeatureFilterPanel.this.infoPanel.setVisible(!FeatureFilterPanel.this.isFilterVisible);
            FeatureFilterPanel.this.filterPanel.setVisible(FeatureFilterPanel.this.isFilterVisible);
        }
    }
}

