/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableAdapter;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;

public class DataMinerShuttlePanel
extends JPanel
implements DialogDisplayable {
    private boolean dirty;
    private String title;
    private String helpTopic;
    private DataMinerTablePanel availableTablePanel;
    private JButton removeAllButton;
    private JButton removeButton;
    private JButton selectAllButton;
    private JButton selectButton;
    private DataMinerTablePanel selectedTablePanel;

    public DataMinerShuttlePanel() {
        this(null, null, null, null);
    }

    public DataMinerShuttlePanel(String string, String string2, ShuttleData shuttleData, ShuttleData shuttleData2) {
        this.title = string;
        this.helpTopic = string2;
        this.initComponents();
        this.initIcons();
        this.initListeners();
        if (shuttleData != null && shuttleData2 != null) {
            this.setData(shuttleData, shuttleData2);
        }
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableAdapter(){

            @Override
            public String getTitle() {
                return DataMinerShuttlePanel.this.title;
            }

            @Override
            public String getHelpTopic() {
                return DataMinerShuttlePanel.this.helpTopic;
            }

            @Override
            public JComponent getContent() {
                return DataMinerShuttlePanel.this;
            }

            @Override
            public int getButtonMask() {
                if (DataMinerShuttlePanel.this.helpTopic == null) {
                    return 3;
                }
                return super.getButtonMask();
            }
        };
    }

    private void moveDoubleClickItem(int n) {
        if (n == 0) {
            this.moveItems(this.availableTablePanel.getTable(), this.selectedTablePanel.getTable(), false);
        } else {
            this.moveItems(this.selectedTablePanel.getTable(), this.availableTablePanel.getTable(), false);
        }
    }

    public void setData(ShuttleData shuttleData, ShuttleData shuttleData2) {
        this.availableTablePanel.setup((TableModel)((Object)shuttleData.getTableModel()), shuttleData.getTableTitle(), 0, true);
        this.selectedTablePanel.setup((TableModel)((Object)shuttleData2.getTableModel()), shuttleData2.getTableTitle(), 0, true);
        for (Map.Entry<Integer, TableCellRenderer> entry : shuttleData.getTableRenderer().entrySet()) {
            this.availableTablePanel.getTable().getColumnModel().getColumn(entry.getKey()).setCellRenderer(entry.getValue());
        }
        for (Map.Entry<Integer, TableCellRenderer> entry : shuttleData2.getTableRenderer().entrySet()) {
            this.selectedTablePanel.getTable().getColumnModel().getColumn(entry.getKey()).setCellRenderer(entry.getValue());
        }
    }

    public List getSelected() {
        return ((ODMrTableModel)((Object)this.selectedTablePanel.getTable().getModel())).getSrcData();
    }

    private void initListeners() {
        this.availableTablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DataMinerShuttlePanel.this.moveDoubleClickItem(0);
                }
            }
        });
        this.selectedTablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DataMinerShuttlePanel.this.moveDoubleClickItem(1);
                }
            }
        });
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int[] nArray = genericTable.getSelectedRowsInModel();
        List list = ((ODMrTableModel)((Object)genericTable.getModel())).getSrcData();
        ArrayList arrayList = new ArrayList();
        if (!bl) {
            for (var7_7 = 0; var7_7 < nArray.length; ++var7_7) {
                arrayList.add(list.get(nArray[var7_7]));
            }
        } else {
            for (var7_7 = 0; var7_7 < list.size(); ++var7_7) {
                arrayList.add(list.get(var7_7));
            }
        }
        ((ODMrTableModel)((Object)genericTable.getModel())).removeRows(arrayList);
        List list2 = ((ODMrTableModel)((Object)genericTable2.getModel())).getSrcData();
        list2.addAll(arrayList);
        ((ODMrTableModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((ODMrTableModel)((Object)genericTable.getModel())).setRowCount(list.size());
        int[] nArray2 = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = list2.indexOf(arrayList.get(i));
            assert (n != -1) : "Unexpected state - added item should be present and must have an index";
            nArray2[i] = n;
        }
        genericTable2.setSelectedRowsInModel(nArray2);
    }

    private void initIcons() {
        this.selectButton.setText("");
        this.selectAllButton.setText("");
        this.removeButton.setText("");
        this.removeAllButton.setText("");
        this.selectButton.setIcon(OracleIcons.getIcon((String)"shuttle_right.png"));
        this.selectAllButton.setIcon(OracleIcons.getIcon((String)"shuttle_rightall.png"));
        this.removeButton.setIcon(OracleIcons.getIcon((String)"shuttle_left.png"));
        this.removeAllButton.setIcon(OracleIcons.getIcon((String)"shuttle_leftall.png"));
    }

    private void initComponents() {
        this.availableTablePanel = new DataMinerTablePanel();
        this.selectedTablePanel = new DataMinerTablePanel();
        this.selectButton = new JButton();
        this.selectAllButton = new JButton();
        this.removeButton = new JButton();
        this.removeAllButton = new JButton();
        this.setPreferredSize(new Dimension(625, 295));
        this.selectButton.setText(">");
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataMinerShuttlePanel.this.selectButtonActionPerformed(actionEvent);
            }
        });
        this.selectAllButton.setText(">>");
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataMinerShuttlePanel.this.selectAllButtonActionPerformed(actionEvent);
            }
        });
        this.removeButton.setText("<");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataMinerShuttlePanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        this.removeAllButton.setText("<<");
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataMinerShuttlePanel.this.removeAllButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.availableTablePanel, -1, 274, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectButton, -2, 65, -2).addComponent(this.selectAllButton, -2, 65, -2).addComponent(this.removeButton, -2, 65, -2)).addComponent(this.removeAllButton, -2, 65, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectedTablePanel, -1, 274, Short.MAX_VALUE).addGap(0, 0, 0)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(77, 77, 77).addComponent(this.selectButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeAllButton).addContainerGap(-1, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectedTablePanel, -1, 273, Short.MAX_VALUE).addComponent(this.availableTablePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    private void selectButtonActionPerformed(ActionEvent actionEvent) {
        this.moveItems(this.availableTablePanel.getTable(), this.selectedTablePanel.getTable(), false);
    }

    private void selectAllButtonActionPerformed(ActionEvent actionEvent) {
        this.moveItems(this.availableTablePanel.getTable(), this.selectedTablePanel.getTable(), true);
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        this.moveItems(this.selectedTablePanel.getTable(), this.availableTablePanel.getTable(), false);
    }

    private void removeAllButtonActionPerformed(ActionEvent actionEvent) {
        this.moveItems(this.selectedTablePanel.getTable(), this.availableTablePanel.getTable(), true);
    }

    public static class ShuttleData {
        private String tableTitle;
        private ODMrTableModel tableModel;
        private Map<Integer, TableCellRenderer> tableRenderer;

        public ShuttleData(String string, ODMrTableModel oDMrTableModel, Map<Integer, TableCellRenderer> map) {
            this.tableTitle = string;
            this.tableModel = oDMrTableModel;
            this.tableRenderer = map;
        }

        public ShuttleData(String string, ODMrTableModel oDMrTableModel) {
            this(string, oDMrTableModel, new HashMap<Integer, TableCellRenderer>());
        }

        public String getTableTitle() {
            return this.tableTitle;
        }

        public ODMrTableModel getTableModel() {
            return this.tableModel;
        }

        public Map<Integer, TableCellRenderer> getTableRenderer() {
            return this.tableRenderer;
        }
    }
}

