/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.dmt.dataminer.controls.PeerTreeSelectionModel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.checktree.TriStateNode;
import oracle.javatools.ui.treetable.AbstractTreeTableModel;
import oracle.javatools.ui.treetable.JFastTreeTable;
import oracle.javatools.ui.treetable.TreeTableModel;

public class BaseTreeTable
extends JFastTreeTable
implements ActionListener {
    protected static Icon closedIcon;
    protected static Icon openIcon;
    protected static Color textSelectionColor;
    protected static Color textNonSelectionColor;
    private boolean _bPeerSelection = false;
    private boolean _checkBoxesEnabled = false;
    private boolean _showGrid = false;
    protected JPopupMenu _popup = null;

    public void setCheckBoxesEnabled(boolean bl) {
        this._checkBoxesEnabled = bl;
    }

    public BaseTreeTable(TreeTableModel treeTableModel) {
        super(treeTableModel);
        this.setDragEnabled(false);
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    public void setShowGrid(boolean bl) {
        this._showGrid = bl;
        super.setShowGrid(bl);
    }

    public BaseTreeTable(TreeTableModel treeTableModel, boolean bl) {
        this(treeTableModel);
        this._bPeerSelection = bl;
        if (bl) {
            this.setPeerTreeSelectionMode();
        }
    }

    public void setCustomPeerSelectionModel(PeerTreeSelectionModel peerTreeSelectionModel) {
        this._bPeerSelection = true;
        this.tree.setSelectionModel((TreeSelectionModel)peerTreeSelectionModel);
        this.setSelectionModel(peerTreeSelectionModel.getListSelectionModel());
    }

    private void setPeerTreeSelectionMode() {
        PeerTreeSelectionModel peerTreeSelectionModel = new PeerTreeSelectionModel((JTree)this.tree);
        this.tree.setSelectionModel((TreeSelectionModel)peerTreeSelectionModel);
        this.setSelectionModel(peerTreeSelectionModel.getListSelectionModel());
    }

    public void setSingleSelectionMode() {
        this.getTree().getSelectionModel().setSelectionMode(1);
        this.setSelectionMode(0);
    }

    public void setMultiSelectionMode() {
        this.getTree().getSelectionModel().setSelectionMode(4);
        this.setSelectionMode(2);
    }

    public void expandAll(boolean bl) {
        JTree jTree = this.getTree();
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        this.expandAll(jTree, new TreePath(treeNode), bl);
    }

    public ArrayList getLeafNodes() {
        return this.getNodes(true);
    }

    public ArrayList getAllNodes() {
        return this.getNodes(false);
    }

    public List<TriStateNode> getChildNodes() {
        ArrayList<TriStateNode> arrayList = null;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null || 0 == treePathArray.length) {
            return arrayList;
        }
        arrayList = new ArrayList<TriStateNode>();
        TreeModel treeModel = this.tree.getModel();
        TriStateNode[] triStateNodeArray = new TriStateNode[treePathArray.length];
        for (int i = 0; i < treePathArray.length; ++i) {
            triStateNodeArray[i] = (TriStateNode)treePathArray[i].getLastPathComponent();
            this.getChildren(treeModel, triStateNodeArray[i], arrayList, false);
        }
        return arrayList;
    }

    public Map<String, TriStateNode> getDistinctChildNodes(TreePath[] treePathArray) {
        HashMap<String, TriStateNode> hashMap = null;
        if (treePathArray == null || 0 == treePathArray.length) {
            return hashMap;
        }
        hashMap = new HashMap<String, TriStateNode>();
        TreeModel treeModel = this.tree.getModel();
        TriStateNode[] triStateNodeArray = new TriStateNode[treePathArray.length];
        for (int i = 0; i < treePathArray.length; ++i) {
            triStateNodeArray[i] = (TriStateNode)treePathArray[i].getLastPathComponent();
            this.getDistinctChildren(treeModel, triStateNodeArray[i], hashMap, false);
        }
        return hashMap;
    }

    private ArrayList getNodes(boolean bl) {
        ArrayList arrayList = null;
        TreeModel treeModel = this.tree.getModel();
        if (treeModel != null) {
            Object object = treeModel.getRoot();
            arrayList = new ArrayList();
            this.getChildren(treeModel, object, arrayList, bl);
        }
        return arrayList;
    }

    public void selectNodes(boolean bl) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        TreePath treePath = this.getTree().getSelectionPath();
        if (treePath != null) {
            TreePath[] treePathArray = this.tree.getSelectionPaths();
            ArrayList<TriStateNode> arrayList2 = new ArrayList<TriStateNode>();
            for (int i = 0; i < treePathArray.length; ++i) {
                TriStateNode triStateNode = (TriStateNode)treePathArray[i].getLastPathComponent();
                triStateNode.setNodeState(bl ? TriStateNode.NodeState.YES : TriStateNode.NodeState.NO);
                arrayList2.add(triStateNode);
            }
            this.propageSpaceKeyRelease(treePathArray, arrayList2, bl);
        }
        this.updateTreeModel(arrayList);
    }

    protected void getChildren(TreeModel treeModel, Object object, ArrayList arrayList, boolean bl) {
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = treeModel.getChild(object, i);
            if (treeModel.isLeaf(object2)) {
                arrayList.add(object2);
                continue;
            }
            if (!bl) {
                arrayList.add(object2);
            }
            this.getChildren(treeModel, object2, arrayList, bl);
        }
    }

    protected void getDistinctChildren(TreeModel treeModel, TriStateNode triStateNode, Map<String, TriStateNode> map, boolean bl) {
        int n = treeModel.getChildCount(triStateNode);
        for (int i = 0; i < n; ++i) {
            TriStateNode triStateNode2 = (TriStateNode)treeModel.getChild(triStateNode, i);
            String string = this.getFullPath(triStateNode2);
            if (null == map.get(string)) {
                map.put(string, triStateNode2);
            }
            if (treeModel.isLeaf(triStateNode2)) continue;
            this.getDistinctChildren(treeModel, triStateNode2, map, bl);
        }
    }

    private String getFullPath(TriStateNode triStateNode) {
        if (triStateNode == null) {
            return "";
        }
        TriStateNode triStateNode2 = (TriStateNode)this.tree.getModel().getRoot();
        StringBuilder stringBuilder = new StringBuilder(triStateNode.getLabel());
        stringBuilder.append(".");
        for (TriStateNode triStateNode3 = (TriStateNode)triStateNode.getParent(); triStateNode3 != null && triStateNode2 != triStateNode3; triStateNode3 = (TriStateNode)triStateNode3.getParent()) {
            stringBuilder.append(triStateNode3.getLabel());
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public void expandAll(JTree jTree, TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandAll(jTree, treePath2, bl);
            }
        }
        if (bl) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    public void setRootInvisible() {
        this.getTree().setRootVisible(false);
        this.getTree().setShowsRootHandles(true);
        this.addMouseListener(new TreeMouseAdapter());
    }

    public void createPopupMenu() {
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this._popup = jPopupMenu;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void enableCheckBoxes() {
        assert (!this._bPeerSelection) : "Conflicting selection models.";
        this._checkBoxesEnabled = true;
        this.setCheckboxCellRenderer();
        this.setCheckboxCellEditor();
        this.getTree().getSelectionModel().setSelectionMode(1);
        this.getTree().setEditable(true);
        this.setSelectionMode(0);
    }

    protected void setCheckboxCellRenderer() {
        this.getTree().setCellRenderer(new CheckboxCellRenderer());
    }

    protected void setCheckboxCellEditor() {
        this.getTree().setCellEditor(new CheckboxCellEditor());
    }

    public void paint(Graphics graphics) {
        if (this._checkBoxesEnabled || this._showGrid) {
            super.paintUnoptimized(graphics);
        } else {
            super.paint(graphics);
        }
    }

    protected void processMultipleSelection(TreePath[] treePathArray, CheckboxCellEditor checkboxCellEditor) {
        ArrayList<TriStateNode> arrayList = new ArrayList<TriStateNode>();
        for (int i = 0; i < treePathArray.length; ++i) {
            TriStateNode triStateNode = (TriStateNode)treePathArray[i].getLastPathComponent();
            arrayList.add(triStateNode);
        }
        checkboxCellEditor.setPressedMultipleNodes(arrayList);
        this.propageSpaceKeyRelease(treePathArray, arrayList, checkboxCellEditor);
        this.updateUI();
    }

    private void propageSpaceKeyRelease(TreePath[] treePathArray, List<TriStateNode> list, CheckboxCellEditor checkboxCellEditor) {
        Boolean bl = (Boolean)checkboxCellEditor.getCellEditorValue();
        this.propageSpaceKeyRelease(treePathArray, list, bl);
    }

    private void propageSpaceKeyRelease(TreePath[] treePathArray, List<TriStateNode> list, Boolean bl) {
        Object object;
        Iterator iterator;
        Object object2;
        TriStateNode triStateNode2;
        HashMap<Object, TriStateNode> hashMap = new HashMap<Object, TriStateNode>();
        if (!list.isEmpty()) {
            for (TriStateNode triStateNode2 : list) {
                object2 = this.getFullPath(triStateNode2);
                if (null != hashMap.get(object2)) continue;
                hashMap.put(object2, triStateNode2);
            }
        }
        Map<String, TriStateNode> map = this.getDistinctChildNodes(treePathArray);
        triStateNode2 = new ArrayList();
        if (!map.isEmpty()) {
            triStateNode2.addAll(map.values());
        }
        object2 = new ArrayList();
        TreePath[] treePathArray2 = treePathArray;
        HashMap<String, TriStateNode> hashMap2 = new HashMap<String, TriStateNode>();
        if (treePathArray2 != null) {
            iterator = (TreeNode)this.tree.getModel().getRoot();
            for (int i = 0; i < treePathArray2.length; ++i) {
                object = (TriStateNode)treePathArray2[i].getLastPathComponent();
                String string = this.getFullPath((TriStateNode)object);
                while (!object.equals(iterator)) {
                    if (null == hashMap2.get(string)) {
                        object2.add(object);
                        hashMap2.put(string, (TriStateNode)object);
                    }
                    object = (TriStateNode)object.getParent();
                }
            }
        }
        if (triStateNode2.size() > 0) {
            this.setChildrenNodeState((List<TriStateNode>)triStateNode2, bl != false ? TriStateNode.NodeState.YES : TriStateNode.NodeState.NO);
            for (TriStateNode triStateNode3 : triStateNode2) {
                object = this.getFullPath(triStateNode3);
                if (null != hashMap.get(object)) continue;
                hashMap.put(object, triStateNode3);
            }
        }
        if (object2.size() > 0) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                TriStateNode triStateNode4 = (TriStateNode)iterator.next();
                object = this.getFullPath(triStateNode4);
                if (null != hashMap.get(object)) continue;
                hashMap.put(object, triStateNode4);
            }
        }
        this.updateTreeModel(new ArrayList<TreeNode>(hashMap.values()));
    }

    protected boolean processTreeKey(KeyEvent keyEvent) {
        if (!this._checkBoxesEnabled) {
            return super.processTreeKey(keyEvent);
        }
        TreePath treePath = this.getTree().getSelectionPath();
        if (treePath != null && !this.isEditing()) {
            int n;
            TreePath[] treePathArray = this.tree.getSelectionPaths();
            this.getTree().startEditingAtPath(treePath);
            if (!keyEvent.isConsumed() && (keyEvent.getID() == 401 || keyEvent.getID() == 402) && this.isVisible() && (n = keyEvent.getKeyCode()) == 32) {
                CheckboxCellEditor checkboxCellEditor = (CheckboxCellEditor)this.getTree().getCellEditor();
                if (keyEvent.getID() == 401) {
                    checkboxCellEditor.setPressed();
                } else if (keyEvent.getID() == 402) {
                    checkboxCellEditor.setReleased();
                    this.processMultipleSelection(treePathArray, checkboxCellEditor);
                }
                keyEvent.consume();
                if (treePathArray != null) {
                    this.getTree().addSelectionPaths(treePathArray);
                }
                return true;
            }
            if (treePathArray != null) {
                this.getTree().addSelectionPaths(treePathArray);
            }
        }
        return super.processTreeKey(keyEvent);
    }

    private boolean isTheTreeColumn(int n) {
        boolean bl;
        if (n < 0) {
            return false;
        }
        boolean bl2 = bl = this.getColumnModel().getColumn(n).getModelIndex() == this.treeColumnModelIndex;
        assert (bl == (this.getColumnClass(n) == TreeTableModel.class));
        return bl;
    }

    public boolean getScrollableTracksViewportHeight() {
        Container container = this.getParent();
        if (!(container instanceof JViewport)) {
            return false;
        }
        return this.getPreferredSize().height < container.getHeight();
    }

    protected void enablePopupItems() {
    }

    protected void selectionChanged(MouseEvent mouseEvent) {
    }

    protected void mousePressedNonTreeColumn(int n) {
    }

    public void setChildrenNodeState(List<TriStateNode> list, TriStateNode.NodeState nodeState) {
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).setNodeState(nodeState);
        }
    }

    public void updateTreeModel(List<TreeNode> list) {
        JTree jTree = this.getTree();
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        AbstractTreeTableModel abstractTreeTableModel = (AbstractTreeTableModel)jTree.getModel();
        abstractTreeTableModel.valueForPathChanged(new TreePath(treeNode), list);
    }

    public TreePath getPathForLocation(int n, int n2) {
        Rectangle rectangle;
        JTree jTree = this.getTree();
        TreePath treePath = jTree.getClosestPathForLocation(n, n2);
        if (treePath != null && (rectangle = jTree.getPathBounds(treePath)) != null && n >= rectangle.x && n2 >= rectangle.y && n2 < rectangle.y + rectangle.height) {
            return treePath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardEventToTree(MouseEvent mouseEvent) {
        int n;
        JTree jTree = this.getTree();
        int n2 = this.getTreeColumn();
        int n3 = this.getCellRect((int)0, (int)n2, (boolean)true).x;
        int n4 = mouseEvent.getX() - n3;
        TreePath treePath = this.getPathForLocation(n4, n = mouseEvent.getY());
        if (treePath == null && mouseEvent.getClickCount() == 1) {
            this.add(jTree);
            try {
                jTree.dispatchEvent(new MouseEvent(jTree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n4, n, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                jTree.dispatchEvent(new MouseEvent(jTree, 502, mouseEvent.getWhen(), mouseEvent.getModifiers(), n4, n, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
            }
            finally {
                this.remove(jTree);
            }
        }
    }

    protected class TreeMouseAdapter
    extends MouseAdapter {
        private Component _activeComponent = null;

        protected TreeMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            TreePath treePath;
            boolean bl;
            this.maybeShowPopup(mouseEvent);
            if (!BaseTreeTable.this._checkBoxesEnabled) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            int n = BaseTreeTable.this.getSelectedColumn();
            if (!BaseTreeTable.this.isTheTreeColumn(n)) {
                BaseTreeTable.this.mousePressedNonTreeColumn(n);
                return;
            }
            boolean bl2 = bl = (mouseEvent.getModifiers() & 0xB) == 0;
            if (bl && (treePath = BaseTreeTable.this.getTree().getSelectionPath()) != null && !BaseTreeTable.this.isEditing()) {
                TreePath[] treePathArray = BaseTreeTable.this.tree.getSelectionPaths();
                BaseTreeTable.this.getTree().startEditingAtPath(treePath);
                CheckboxCellEditor checkboxCellEditor = (CheckboxCellEditor)BaseTreeTable.this.getTree().getCellEditor();
                Point point = SwingUtilities.convertPoint(BaseTreeTable.this.getTree(), mouseEvent.getPoint(), checkboxCellEditor);
                this._activeComponent = SwingUtilities.getDeepestComponentAt(checkboxCellEditor, point.x, point.y);
                if (this._activeComponent instanceof JCheckBox) {
                    checkboxCellEditor.setPressed();
                }
                if (treePathArray != null) {
                    BaseTreeTable.this.getTree().addSelectionPaths(treePathArray);
                }
            }
        }

        protected void mouseReleasedNonTreeColumn(int n) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
            BaseTreeTable.this.selectionChanged(mouseEvent);
            if (!BaseTreeTable.this._checkBoxesEnabled) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            int n = BaseTreeTable.this.getSelectedColumn();
            if (!BaseTreeTable.this.isTheTreeColumn(n)) {
                this.mouseReleasedNonTreeColumn(n);
                return;
            }
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
            TreePath treePath = BaseTreeTable.this.getTree().getSelectionPath();
            if (treePath != null && !BaseTreeTable.this.isEditing()) {
                Object object;
                Object object2;
                TreePath[] treePathArray = BaseTreeTable.this.tree.getSelectionPaths();
                BaseTreeTable.this.getTree().startEditingAtPath(treePath);
                TriStateNode triStateNode = (TriStateNode)treePath.getLastPathComponent();
                arrayList.add((TreeNode)triStateNode);
                List<TriStateNode> list = BaseTreeTable.this.getChildNodes();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                TreePath[] treePathArray2 = BaseTreeTable.this.getTree().getSelectionPaths();
                if (treePathArray2 != null) {
                    for (int i = 0; i < treePathArray2.length; ++i) {
                        object2 = (TriStateNode)treePathArray2[i].getLastPathComponent();
                        object = (TreeNode)BaseTreeTable.this.tree.getModel().getRoot();
                        while (!object2.equals(object)) {
                            object2 = (TriStateNode)object2.getParent();
                            arrayList2.add(object2);
                        }
                    }
                }
                CheckboxCellEditor checkboxCellEditor = (CheckboxCellEditor)BaseTreeTable.this.getTree().getCellEditor();
                object2 = SwingUtilities.convertPoint(BaseTreeTable.this.getTree(), mouseEvent.getPoint(), checkboxCellEditor);
                object = SwingUtilities.getDeepestComponentAt(checkboxCellEditor, ((Point)object2).x, ((Point)object2).y);
                if (object != null && object instanceof JCheckBox) {
                    checkboxCellEditor.setReleased();
                    if (this._activeComponent != null && this._activeComponent.equals(object)) {
                        checkboxCellEditor.changeNodeState();
                        Boolean bl = (Boolean)checkboxCellEditor.getCellEditorValue();
                        if (list.size() > 0) {
                            BaseTreeTable.this.setChildrenNodeState(list, bl != false ? TriStateNode.NodeState.YES : TriStateNode.NodeState.NO);
                            for (TriStateNode triStateNode2 : list) {
                                arrayList.add((TreeNode)triStateNode2);
                            }
                        }
                        if (arrayList2.size() > 0) {
                            for (TriStateNode triStateNode2 : arrayList2) {
                                arrayList.add((TreeNode)triStateNode2);
                            }
                        }
                    }
                    BaseTreeTable.this.updateTreeModel(arrayList);
                }
                if (treePathArray != null) {
                    BaseTreeTable.this.getTree().addSelectionPaths(treePathArray);
                }
            }
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (BaseTreeTable.this._popup == null) {
                return;
            }
            BaseTreeTable.this.enablePopupItems();
            if (mouseEvent.isPopupTrigger()) {
                BaseTreeTable.this._popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    protected class CheckboxCellRenderer
    extends CheckboxIconLabel
    implements TreeCellRenderer {
        public CheckboxCellRenderer() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
            this.setFont(UIManager.getFont("Tree.font"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (object instanceof TriStateNode) {
                TriStateNode triStateNode = (TriStateNode)object;
                TriStateButtonModel triStateButtonModel = new TriStateButtonModel(triStateNode);
                this.checkbox.setModel(triStateButtonModel);
                this.label.setText(triStateNode.getLabel());
                this.label.setIcon(triStateNode.getIcon());
                this.label.isSelected = bl;
                if (triStateButtonModel.isArmed()) {
                    this.checkbox.getModel().setPressed(true);
                    this.checkbox.getModel().setArmed(true);
                }
            }
            return this;
        }
    }

    protected class CheckboxCellEditor
    extends CheckboxIconLabel
    implements TreeCellEditor {
        public CheckboxCellEditor() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
            this.setFont(UIManager.getFont("Tree.font"));
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            if (object instanceof TriStateNode) {
                TriStateNode triStateNode = (TriStateNode)object;
                this.checkbox.setModel(new TriStateButtonModel(triStateNode));
                this.label.setText(triStateNode.getLabel());
                if (this.isInvalidElement(object)) {
                    this.label.setIcon(this.getInvalidIcon());
                } else {
                    this.label.setIcon(this.getIcon(bl2, triStateNode.isLeaf()));
                }
                this.label.isSelected = true;
            }
            return this;
        }

        private Icon getIcon(boolean bl, boolean bl2) {
            Icon icon = null;
            if (!bl2) {
                icon = bl ? openIcon : closedIcon;
            }
            return icon;
        }

        protected boolean isInvalidElement(Object object) {
            return false;
        }

        private Icon getInvalidIcon() {
            return OracleIcons.getIcon((String)"warning.png");
        }

        @Override
        public Object getCellEditorValue() {
            return this.checkbox.isSelected();
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        }

        public void changeNodeState() {
            TriStateButtonModel triStateButtonModel = (TriStateButtonModel)this.checkbox.getModel();
            triStateButtonModel.changeNodeState();
        }

        public void setPressed() {
            ButtonModel buttonModel = this.checkbox.getModel();
            if (!buttonModel.isEnabled()) {
                return;
            }
            if (!buttonModel.isArmed()) {
                buttonModel.setArmed(true);
            }
            buttonModel.setPressed(true);
            if (!this.checkbox.hasFocus() && this.checkbox.isRequestFocusEnabled()) {
                this.checkbox.requestFocusInWindow();
            }
        }

        public void setReleased() {
            ButtonModel buttonModel = this.checkbox.getModel();
            buttonModel.setPressed(false);
            buttonModel.setArmed(false);
        }

        protected void setPressedMultipleNodes(List<TriStateNode> list) {
            TriStateButtonModel triStateButtonModel = (TriStateButtonModel)this.checkbox.getModel();
            triStateButtonModel.setPressedMultiple(list);
        }
    }

    class TriStateButtonModel
    extends JToggleButton.ToggleButtonModel {
        private TriStateNode _node;

        TriStateButtonModel(TriStateNode triStateNode) {
            this._node = triStateNode;
        }

        @Override
        public boolean isArmed() {
            return this._node.getNodeState() == TriStateNode.NodeState.PARTIAL;
        }

        @Override
        public boolean isRollover() {
            return this._node.getNodeState() == TriStateNode.NodeState.PARTIAL;
        }

        @Override
        public boolean isSelected() {
            return this._node.getNodeState() != TriStateNode.NodeState.NO;
        }

        public void changeNodeState() {
            switch (this._node.getNodeState()) {
                case NO: 
                case PARTIAL: {
                    this._node.setNodeState(TriStateNode.NodeState.YES);
                    break;
                }
                case YES: {
                    this._node.setNodeState(TriStateNode.NodeState.NO);
                }
            }
            this.fireStateChanged();
        }

        private void setPressedMultiple(List<TriStateNode> list) {
            int n;
            TreeModel treeModel = BaseTreeTable.this.tree.getModel();
            TriStateNode triStateNode = (TriStateNode)treeModel.getRoot();
            HashMap<String, TriStateNode> hashMap = new HashMap<String, TriStateNode>();
            for (n = 0; n < list.size(); ++n) {
                hashMap.put(BaseTreeTable.this.getFullPath(list.get(n)), list.get(n));
            }
            block5: for (n = 0; n < list.size(); ++n) {
                boolean bl = true;
                TriStateNode triStateNode2 = list.get(n);
                while (!triStateNode2.equals(triStateNode)) {
                    if (null == hashMap.get(BaseTreeTable.this.getFullPath(triStateNode2 = (TriStateNode)triStateNode2.getParent()))) continue;
                    bl = false;
                    break;
                }
                switch (list.get(n).getNodeState()) {
                    case NO: 
                    case PARTIAL: {
                        list.get(n).setNodeState(TriStateNode.NodeState.YES, bl, bl);
                        continue block5;
                    }
                    case YES: {
                        list.get(n).setNodeState(TriStateNode.NodeState.NO, bl, bl);
                    }
                }
            }
            this.fireStateChanged();
        }

        @Override
        public void setSelected(boolean bl) {
        }
    }

    protected class CheckboxIconLabel
    extends JPanel {
        protected JCheckBox checkbox = new JCheckBox();
        protected SelectableLabel label = new SelectableLabel();

        CheckboxIconLabel() {
            this.setLayout(new BorderLayout(2, 0));
            this.add((Component)this.checkbox, "West");
            this.add((Component)this.label, "Center");
        }

        protected class SelectableLabel
        extends JLabel {
            protected boolean isSelected = false;

            protected SelectableLabel() {
            }

            @Override
            public void paintComponent(Graphics graphics) {
                if (this.isSelected) {
                    this.setOpaque(false);
                    this.setForeground(UIManager.getColor("Tree.selectionForeground"));
                    graphics.setColor(UIManager.getColor("Tree.selectionBackground"));
                    Insets insets = this.getInsets();
                    Icon icon = this.getIcon();
                    int n = insets.left + (icon != null ? this.getIcon().getIconWidth() : 0) + (icon != null ? this.getIconTextGap() : 0) - 1;
                    graphics.fillRect(n, insets.top, this.getWidth() - n - insets.right + 2, this.getHeight() - insets.top - insets.bottom);
                } else {
                    this.setForeground(UIManager.getColor("Tree.foreground"));
                }
                super.paintComponent(graphics);
            }
        }
    }

    protected class CheckboxCellRendererHideShowCheckBox
    extends CheckboxCellRenderer {
        protected CheckboxCellRendererHideShowCheckBox() {
        }

        protected boolean isCheckBoxVisible(Object object) {
            return true;
        }

        protected boolean isInvalidElement(Object object) {
            return false;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (object instanceof TriStateNode) {
                Color color = null;
                color = bl ? textSelectionColor : textNonSelectionColor;
                this.label.setForeground(color);
                TriStateNode triStateNode = (TriStateNode)object;
                TriStateButtonModel triStateButtonModel = new TriStateButtonModel(triStateNode);
                this.checkbox.setModel(triStateButtonModel);
                this.label.setText(triStateNode.getLabel());
                if (this.isInvalidElement(object)) {
                    this.label.setIcon(this.getInvalidIcon());
                } else {
                    this.label.setIcon(this.getIcon(bl2, triStateNode.isLeaf()));
                }
                this.label.isSelected = bl;
                this.checkbox.setVisible(!this.isCheckBoxVisible(object));
                if (triStateButtonModel.isArmed()) {
                    this.checkbox.getModel().setPressed(true);
                    this.checkbox.getModel().setArmed(true);
                }
            }
            return this;
        }

        private Icon getIcon(boolean bl, boolean bl2) {
            Icon icon = null;
            if (!bl2) {
                icon = bl ? openIcon : closedIcon;
            }
            return icon;
        }

        private Icon getInvalidIcon() {
            return OracleIcons.getIcon((String)"warning.png");
        }
    }
}

