/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.breakpoint;

import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.debugger.BaseElement;
import oracle.jdevimpl.debugger.breakpoint.BreakpointMarkerAPI;
import oracle.jdevimpl.debugger.breakpoint.BreakpointRuntimeCallback;
import oracle.jdevimpl.debugger.breakpoint.BreakpointSettings;
import oracle.jdevimpl.debugger.breakpoint.SavedBreakpoints;
import oracle.jdevimpl.debugger.breakpoint.SourceIcon;
import oracle.jdevimpl.debugger.breakpoint.res.BreakpointArb;

public final class CoreBreakpoint
extends BaseElement
implements GutterColumnListener {
    public static final String PROPERTY_BREAKPOINT = "Breakpoint";
    private static BreakpointRuntimeCallback breakpointRuntimeCallback;
    private BreakpointSettings breakpointSettings;
    private SourceIcon sourceIcon;
    private boolean breakpointShowing;
    private boolean shallow;
    public static final int STATUS_DISABLED = 0;
    public static final int STATUS_ENABLED = 1;
    public static final int STATUS_UNVERIFIED = 2;
    public static final int STATUS_VERIFIED = 3;
    private boolean suspended = false;
    private static List[] activeBreakpoints;
    public static final Object GlobalBreakpointsKey;
    private static SavedBreakpoints savedBreakpoints;
    private static Map<Object, List<CoreBreakpoint>> allBreakpoints;
    private static int persistentBreakpointCount;

    public CoreBreakpoint(BreakpointSettings breakpointSettings) {
        this.breakpointSettings = breakpointSettings;
        this.init();
    }

    public CoreBreakpoint() {
        this.breakpointSettings = new BreakpointSettings();
        this.init();
    }

    public CoreBreakpoint(URL ownerURL, Project project, int type, URL nodeURL, String pkg, String file, int line) {
        if (type != 0) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        if (project != null) {
            this.breakpointSettings.setProjectURL(project.getURL());
        }
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setURL(nodeURL);
        this.breakpointSettings.setPkg(pkg);
        this.breakpointSettings.setFile(file);
        this.breakpointSettings.setLine(line);
        this.init();
    }

    public CoreBreakpoint(URL ownerURL, Project project, int type, String methodOrClassName) {
        if (type != 1 && type != 4) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        if (project != null) {
            this.breakpointSettings.setProjectURL(project.getURL());
        }
        this.breakpointSettings.setType(type);
        if (type == 1) {
            this.breakpointSettings.setMethod(methodOrClassName);
        } else {
            this.breakpointSettings.setClassName(methodOrClassName);
        }
        this.init();
    }

    public CoreBreakpoint(URL ownerURL, Project project, int type, URL nodeURL, String methodName, int offset) {
        if (type != 7) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        if (project != null) {
            this.breakpointSettings.setProjectURL(project.getURL());
        }
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setURL(nodeURL);
        this.breakpointSettings.setMethod(methodName);
        this.breakpointSettings.setOffset(offset);
        this.init();
    }

    public CoreBreakpoint(URL ownerURL, int type, String exception, boolean caught, boolean uncaught) {
        if (type != 2) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setException(exception);
        this.breakpointSettings.setCaught(caught);
        this.breakpointSettings.setUncaught(uncaught);
        this.init();
    }

    public CoreBreakpoint(URL ownerURL, int type) {
        if (type != 3) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        this.init();
    }

    public CoreBreakpoint(URL ownerURL, Project project, int type, URL url, int line) {
        if (type != 5) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        if (project != null) {
            this.breakpointSettings.setProjectURL(project.getURL());
        }
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setURL(url);
        this.breakpointSettings.setLine(line);
        this.init();
    }

    public CoreBreakpoint(URL ownerURL, Project project, int type, String className, String fieldName, boolean access, boolean modify) {
        if (type != 6) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        if (project != null) {
            this.breakpointSettings.setProjectURL(project.getURL());
        }
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setClassName(className);
        this.breakpointSettings.setFieldName(fieldName);
        this.breakpointSettings.setAccess(access);
        this.breakpointSettings.setModify(modify);
        this.init();
    }

    public CoreBreakpoint(URL ownerURL, int type, Map<String, String> properties) {
        if (type != 8) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        this.setProperties(properties);
        this.init();
    }

    public void setMarker(BreakpointMarkerAPI marker) {
        this.breakpointSettings.setMarker(marker);
    }

    public BreakpointMarkerAPI getMarker() {
        BreakpointMarkerAPI marker = this.breakpointSettings.getMarker();
        if (marker == null && breakpointRuntimeCallback != null) {
            marker = breakpointRuntimeCallback.getMarker(this);
            this.setMarker(marker);
        }
        return marker;
    }

    private void init() {
    }

    public BreakpointSettings getBreakpointSettings() {
        return this.breakpointSettings;
    }

    public void copyInto(CoreBreakpoint otherBp) {
        otherBp.breakpointSettings.copyToImpl(this.breakpointSettings);
    }

    public URL getOwnerURL() {
        return this.breakpointSettings.getOwnerURL();
    }

    public void setOwnerURL(URL ownerURL) {
        boolean iconWasShowing = this.hideBreakpointIcon();
        this.breakpointSettings.setOwnerURL(ownerURL);
        if (iconWasShowing) {
            this.showBreakpointIcon();
        }
    }

    public boolean isPersistent() {
        return this.breakpointSettings.isPersistent();
    }

    public int getType() {
        return this.breakpointSettings.getType();
    }

    public String getPackage() {
        return this.breakpointSettings.getPkg();
    }

    public String getFile() {
        return this.breakpointSettings.getFile();
    }

    public int getLine() {
        return this.breakpointSettings.getLine();
    }

    public void setPackageFileLine(String pkgArg, String fileArg, int lineArg) {
        this.setPackageFileLine(pkgArg, fileArg, lineArg, true);
    }

    private void setPackageFileLine(String pkgArg, String fileArg, int lineArg, boolean adjustIcon) {
        if (this.breakpointSettings.getType() != 0) {
            throw new Error("bad type");
        }
        boolean iconWasShowing = adjustIcon ? this.hideBreakpointIcon() : false;
        this.breakpointSettings.setPkg(pkgArg);
        this.breakpointSettings.setFile(fileArg);
        this.breakpointSettings.setLine(lineArg);
        if (adjustIcon && iconWasShowing) {
            this.showBreakpointIcon();
        }
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetPackageFileLine(this, pkgArg, fileArg, lineArg);
        }
    }

    public static void setBreakpointRuntimeCallback(BreakpointRuntimeCallback callback) {
        if (activeBreakpoints != null) {
            activeBreakpoints = null;
        }
        breakpointRuntimeCallback = callback;
    }

    public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
        int bpType = this.breakpointSettings.getType();
        if (bpType == 0) {
            if (this.haveValidNodeURL()) {
                return;
            }
            String pkg = this.breakpointSettings.getPkg();
            String file = this.breakpointSettings.getFile();
            this.setPackageFileLine(pkg, file, newLine, false);
            if (breakpointRuntimeCallback != null) {
                breakpointRuntimeCallback.afterMoveBreakpoint(this);
            }
        } else if (bpType == 5) {
            if (this.haveValidNodeURL()) {
                return;
            }
            URL url = this.breakpointSettings.getURL();
            this.setURLLine(url, newLine, false);
            if (breakpointRuntimeCallback != null) {
                breakpointRuntimeCallback.afterMoveBreakpoint(this);
            }
        } else if (bpType == 6 && this.hideBreakpointIcon()) {
            this.showBreakpointIcon();
        }
    }

    private boolean haveValidNodeURL() {
        URL nodeURL = this.breakpointSettings.getURL();
        return nodeURL != null && URLFileSystem.exists((URL)nodeURL);
    }

    public void markRemoved(GutterMark gutterMark, int deletedLine) {
        this.deleteBreakpoint();
        if (breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.updateBreakpointsWindow();
        }
    }

    public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
        this.deleteBreakpoint();
        if (breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.updateBreakpointsWindow();
        }
    }

    public String getMarkToolTip(GutterMark gutterMark, MouseEvent event) {
        return this.getShortLabel();
    }

    public String getMethod() {
        return this.breakpointSettings.getMethod();
    }

    public void setMethod(String methodArg) {
        if (this.breakpointSettings.getType() != 1) {
            throw new Error("bad type");
        }
        this.breakpointSettings.setMethod(methodArg);
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetMethod(this, methodArg);
        }
    }

    public int getOffset() {
        return this.breakpointSettings.getOffset();
    }

    public void setMethodOffset(String methodArg, int offsetArg) {
        this.setMethodOffset(methodArg, offsetArg, true);
    }

    void setMethodOffset(String methodArg, int offsetArg, boolean adjustIcon) {
        if (this.breakpointSettings.getType() != 7) {
            throw new Error("bad type");
        }
        boolean iconWasShowing = adjustIcon ? this.hideBreakpointIcon() : false;
        this.breakpointSettings.setMethod(methodArg);
        this.breakpointSettings.setOffset(offsetArg);
        if (adjustIcon && iconWasShowing) {
            this.showBreakpointIcon();
        }
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetMethodOffset(this, methodArg, offsetArg);
        }
    }

    public String getException() {
        return this.breakpointSettings.getException();
    }

    public boolean isCaught() {
        return this.breakpointSettings.isCaught();
    }

    public boolean isUncaught() {
        return this.breakpointSettings.isUncaught();
    }

    public void setException(String exceptionArg, boolean caughtArg, boolean uncaughtArg) {
        if (this.breakpointSettings.getType() != 2) {
            throw new Error("bad type");
        }
        this.breakpointSettings.setException(exceptionArg);
        this.breakpointSettings.setCaught(caughtArg);
        this.breakpointSettings.setUncaught(uncaughtArg);
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetException(this, exceptionArg, caughtArg, uncaughtArg);
        }
    }

    public String getClassName() {
        return this.breakpointSettings.getClassName();
    }

    public void setClassName(String classNameArg) {
        if (this.breakpointSettings.getType() != 4) {
            throw new Error("bad type");
        }
        this.breakpointSettings.setClassName(classNameArg);
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetClassName(this, classNameArg);
        }
    }

    public URL getURL() {
        return this.breakpointSettings.getURL();
    }

    public URL getProjectURL() {
        return this.breakpointSettings.getProjectURL();
    }

    public void setURLLine(URL urlArg, int lineArg) {
        this.setURLLine(urlArg, lineArg, true);
    }

    private void setURLLine(URL urlArg, int lineArg, boolean adjustIcon) {
        if (this.breakpointSettings.getType() != 5) {
            throw new Error("bad type");
        }
        boolean iconWasShowing = adjustIcon ? this.hideBreakpointIcon() : false;
        this.breakpointSettings.setURL(urlArg);
        this.breakpointSettings.setLine(lineArg);
        if (adjustIcon && iconWasShowing) {
            this.showBreakpointIcon();
        }
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetURLLine(this, urlArg, lineArg);
        }
    }

    public String getFieldName() {
        return this.breakpointSettings.getFieldName();
    }

    public boolean isAccess() {
        return this.breakpointSettings.isAccess();
    }

    public boolean isModify() {
        return this.breakpointSettings.isModify();
    }

    public void setWatchpoint(String classNameArg, String fieldNameArg, boolean accessArg, boolean modifyArg) {
        if (this.breakpointSettings.getType() != 6) {
            throw new Error("bad type");
        }
        boolean iconWasShowing = this.hideBreakpointIcon();
        this.breakpointSettings.setClassName(classNameArg);
        this.breakpointSettings.setFieldName(fieldNameArg);
        this.breakpointSettings.setAccess(accessArg);
        this.breakpointSettings.setModify(modifyArg);
        if (iconWasShowing) {
            this.showBreakpointIcon();
        }
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetWatchpoint(this, classNameArg, fieldNameArg, accessArg, modifyArg);
        }
    }

    public boolean isEnabled() {
        return this.breakpointSettings.isEnabled();
    }

    public boolean isRuntimeEnabled() {
        if (breakpointRuntimeCallback != null) {
            return breakpointRuntimeCallback.isRuntimeEnabled(this);
        }
        return this.isEnabled();
    }

    public void setEnabled(boolean enabledArg) {
        this.breakpointSettings.setEnabled(enabledArg);
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetEnabled(this, enabledArg);
        }
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
        this.updateBreakpointIcon();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public String getGroupName() {
        return this.breakpointSettings.getGroupName();
    }

    public void setGroupName(String groupNameArg) {
        if (groupNameArg == null) {
            groupNameArg = "";
        }
        this.breakpointSettings.setGroupName(groupNameArg);
        String groupName = groupNameArg;
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetGroupName(this, groupName);
        }
    }

    public boolean isEditGroupName() {
        return this.breakpointSettings.isEditGroupName();
    }

    public void setEditGroupName(boolean isEditGroupName) {
        this.breakpointSettings.setEditGroupName(isEditGroupName);
    }

    public String getHiddenCondition() {
        return this.breakpointSettings.getHiddenCondition();
    }

    public void setHiddenCondition(String hiddenConditionArg) {
        if (hiddenConditionArg == null) {
            hiddenConditionArg = "";
        }
        this.breakpointSettings.setHiddenCondition(hiddenConditionArg.trim());
        this.propagateCondition();
    }

    public boolean hasCondition() {
        return this.getCondition().length() > 0 || this.getHiddenCondition().length() > 0;
    }

    public String getCondition() {
        return this.breakpointSettings.getCondition();
    }

    public void setCondition(String conditionArg) {
        if (conditionArg == null) {
            conditionArg = "";
        }
        this.breakpointSettings.setCondition(conditionArg.trim());
        this.propagateCondition();
    }

    private void propagateCondition() {
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetCondition(this);
        }
    }

    public boolean isEditCondition() {
        return this.breakpointSettings.isEditCondition();
    }

    public void setEditCondition(boolean isEditCondition) {
        this.breakpointSettings.setEditCondition(isEditCondition);
    }

    public String getThreadName() {
        return this.breakpointSettings.getThreadName();
    }

    public void setThreadName(String threadNameArg) {
        if (threadNameArg == null) {
            threadNameArg = "";
        }
        this.breakpointSettings.setThreadName(threadNameArg);
        String threadName = threadNameArg;
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetThreadName(this, threadName);
        }
    }

    public String getThreadNameNot() {
        return this.breakpointSettings.getThreadNameNot();
    }

    public void setThreadNameNot(String threadNameNotArg) {
        if (threadNameNotArg == null) {
            threadNameNotArg = "";
        }
        this.breakpointSettings.setThreadNameNot(threadNameNotArg);
        String threadNameNot = threadNameNotArg;
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetThreadNameNot(this, threadNameNot);
        }
    }

    public boolean isEditBreakForThreads() {
        return this.breakpointSettings.isEditBreakForThreads();
    }

    public void setEditBreakForThreads(boolean isEditBreakForThreads) {
        this.breakpointSettings.setEditBreakForThreads(isEditBreakForThreads);
    }

    public int getPassCount() {
        return this.breakpointSettings.getPassCount();
    }

    public void setPassCount(int passCountArg) {
        this.breakpointSettings.setPassCount(passCountArg);
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetPassCount(this, passCountArg);
        }
    }

    public boolean isEditPassCount() {
        return this.breakpointSettings.isEditPassCount();
    }

    public void setEditPassCount(boolean isEditPassCount) {
        this.breakpointSettings.setEditPassCount(isEditPassCount);
    }

    public boolean isActionHalt() {
        return this.breakpointSettings.isActionHalt();
    }

    public void setActionHalt(boolean actionHaltArg) {
        this.breakpointSettings.setActionHalt(actionHaltArg);
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetActionHalt(this, actionHaltArg);
        }
    }

    public boolean isActionBeep() {
        return this.breakpointSettings.isActionBeep();
    }

    public void setActionBeep(boolean actionBeepArg) {
        this.breakpointSettings.setActionBeep(actionBeepArg);
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetActionBeep(this);
        }
    }

    public boolean isActionLog() {
        return this.breakpointSettings.isActionLog();
    }

    public void setActionLog(boolean actionLogArg) {
        this.breakpointSettings.setActionLog(actionLogArg);
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetActionLog(this);
        }
    }

    public String getActionLogTag() {
        return this.breakpointSettings.getActionLogTag();
    }

    public void setActionLogTag(String actionLogTagArg) {
        if (actionLogTagArg == null) {
            actionLogTagArg = "";
        }
        this.breakpointSettings.setActionLogTag(actionLogTagArg);
    }

    public String getActionLogExpression() {
        return this.breakpointSettings.getActionLogExpr();
    }

    public void setActionLogExpression(String actionLogExprArg) {
        if (actionLogExprArg == null) {
            actionLogExprArg = "";
        }
        this.breakpointSettings.setActionLogExpr(actionLogExprArg);
    }

    public boolean isActionLogStack() {
        return this.breakpointSettings.isActionLogStack();
    }

    public void setActionLogStack(boolean actionLogStackArg) {
        this.breakpointSettings.setActionLogStack(actionLogStackArg);
    }

    public long getCreationTimestamp() {
        return this.breakpointSettings.getCreationTimestamp();
    }

    public String getAction() {
        String actionDisableOther;
        String actionEnableOther;
        Object action = "";
        String delimiter = "";
        if (this.breakpointSettings.isActionHalt()) {
            action = (String)action + delimiter + BreakpointArb.getString(0);
            delimiter = ", ";
        }
        if (this.breakpointSettings.isActionBeep()) {
            action = (String)action + delimiter + BreakpointArb.getString(1);
            delimiter = ", ";
        }
        if (this.breakpointSettings.isActionLog()) {
            action = (String)action + delimiter + BreakpointArb.getString(2);
            delimiter = ", ";
        }
        if ((actionEnableOther = this.breakpointSettings.getActionEnableOther()).length() > 0) {
            action = (String)action + delimiter + MessageFormat.format(BreakpointArb.getString(3), actionEnableOther);
            delimiter = ", ";
        }
        if ((actionDisableOther = this.breakpointSettings.getActionDisableOther()).length() > 0) {
            action = (String)action + delimiter + MessageFormat.format(BreakpointArb.getString(4), actionDisableOther);
        }
        return action;
    }

    public String getActionEnableOther() {
        return this.breakpointSettings.getActionEnableOther();
    }

    public void setActionEnableOther(String actionEnableOtherArg) {
        if (actionEnableOtherArg == null) {
            actionEnableOtherArg = "";
        }
        this.breakpointSettings.setActionEnableOther(actionEnableOtherArg);
        String actionEnableOther = actionEnableOtherArg;
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetActionEnableOther(this, actionEnableOther);
        }
    }

    public String getActionDisableOther() {
        return this.breakpointSettings.getActionDisableOther();
    }

    public void setActionDisableOther(String actionDisableOtherArg) {
        if (actionDisableOtherArg == null) {
            actionDisableOtherArg = "";
        }
        this.breakpointSettings.setActionDisableOther(actionDisableOtherArg);
        String actionDisableOther = actionDisableOtherArg;
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetActionDisableOther(this, actionDisableOther);
        }
    }

    public boolean isEditBreakpointHitActions() {
        return this.breakpointSettings.isEditBreakpointHitActions();
    }

    public void setEditBreakpointHitActions(boolean isEditBreakpointHitActions) {
        this.breakpointSettings.setEditBreakpointHitActions(isEditBreakpointHitActions);
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String[] keys = this.breakpointSettings.getPropertyKeys();
        String[] values = this.breakpointSettings.getPropertyValues();
        if (keys != null && values != null && keys.length == values.length) {
            for (int x = 0; x < keys.length; ++x) {
                properties.put(keys[x], values[x]);
            }
        }
        return properties;
    }

    public void setProperties(Map<String, String> newProperties) {
        Map<String, String> finalNewProperties;
        if (newProperties != null && !newProperties.isEmpty()) {
            String[] keys = newProperties.keySet().toArray(new String[newProperties.size()]);
            String[] values = newProperties.values().toArray(new String[newProperties.size()]);
            this.breakpointSettings.setPropertyKeys(keys);
            this.breakpointSettings.setPropertyValues(values);
        } else {
            this.breakpointSettings.setPropertyKeys(null);
            this.breakpointSettings.setPropertyValues(null);
        }
        Map<Object, Object> map = finalNewProperties = newProperties == null ? Collections.emptyMap() : newProperties;
        if (!this.shallow && breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterSetProperties(this, finalNewProperties);
        }
    }

    public String getCustomDescription() {
        return this.breakpointSettings.getCustomDescription();
    }

    public void setCustomDescription(String customDescription) {
        this.breakpointSettings.setCustomDescription(customDescription);
    }

    public String getCustomTypeString() {
        return this.breakpointSettings.getCustomTypeString();
    }

    public void setCustomTypeString(String customTypeString) {
        this.breakpointSettings.setCustomTypeString(customTypeString);
    }

    boolean isCustom() {
        return this.breakpointSettings.isCustom();
    }

    public String getDebuggerExtenderID() {
        return this.breakpointSettings.getDebuggerExtenderID();
    }

    public void setDebuggerExtenderID(String debuggerExtenderID) {
        this.breakpointSettings.setDebuggerExtenderID(debuggerExtenderID);
    }

    public void deleteBreakpoint() {
        if (!this.breakpointSettings.isPersistent()) {
            this.hideBreakpointIcon();
            if (breakpointRuntimeCallback != null) {
                breakpointRuntimeCallback.afterDeleteBreakpoint(this);
            }
            CoreBreakpoint.removeBreakpointFromOwner(this);
        }
    }

    public void setShallow(boolean shallow) {
        this.shallow = shallow;
    }

    public String getTypeString() {
        return this.breakpointSettings.getTypeString();
    }

    @Override
    public String getShortLabel() {
        return this.getTypeString() + " - " + this.getDescription();
    }

    @Override
    public Icon getIcon() {
        if (this.breakpointSettings.getType() == 6) {
            if (breakpointRuntimeCallback != null && breakpointRuntimeCallback.isRuntimeEnabled(this)) {
                if (this.suspended) {
                    return OracleIcons.getIcon((String)"debugger/enabledwatchpointsuspended.png");
                }
                return OracleIcons.getIcon((String)"debugger/enabledwatchpoint.gif");
            }
            if (this.suspended) {
                return OracleIcons.getIcon((String)"debugger/disabledwatchpointsuspended.png");
            }
            return OracleIcons.getIcon((String)"debugger/disabledwatchpoint.gif");
        }
        switch (this.getRuntimeStatus()) {
            case 0: {
                if (this.suspended) {
                    return OracleIcons.getIcon((String)"debugger/disabledbreakpointsuspended.png");
                }
                return OracleIcons.getIcon((String)"disabledbreakpoint.png");
            }
            case 1: 
            case 2: {
                if (this.suspended) {
                    return OracleIcons.getIcon((String)"debugger/unverifiedbreakpointsuspended.png");
                }
                return OracleIcons.getIcon((String)"unverifiedbreakpoint.png");
            }
            case 3: {
                if (this.suspended) {
                    return OracleIcons.getIcon((String)"debugger/unverifiedbreakpointsuspended.png");
                }
                return OracleIcons.getIcon((String)"verifiedbreakpoint.png");
            }
        }
        return null;
    }

    HighlightStyle getHighlightStyle() {
        if (this.suspended) {
            return SourceIcon.disabledBPStyle;
        }
        switch (this.getRuntimeStatus()) {
            case 0: {
                return SourceIcon.disabledBPStyle;
            }
            case 1: 
            case 2: 
            case 3: {
                return SourceIcon.enabledBPStyle;
            }
        }
        FeedbackManager.reportException((String)(this.breakpointSettings.getTypeString() + " has invalid return value from getRuntimeStatus:" + this.getRuntimeStatus()), (Throwable)new IllegalArgumentException());
        return SourceIcon.enabledBPStyle;
    }

    private int getRuntimeStatus() {
        if (breakpointRuntimeCallback != null) {
            return breakpointRuntimeCallback.getRuntimeStatus(this);
        }
        return this.isEnabled() ? 1 : 0;
    }

    private void makeSourceIcon(String pkg, String file, int line) {
        URL ownerURL = this.breakpointSettings.getOwnerURL();
        URL nullURL = null;
        if (ownerURL == null) {
            this.sourceIcon = new SourceIcon(nullURL, nullURL, pkg, file, line, null, this.getIcon(), this.getHighlightStyle(), 0, this);
        } else {
            String ext = URLFileSystem.getSuffix((URL)ownerURL).toLowerCase();
            if (ext.equals(".jpr")) {
                this.sourceIcon = new SourceIcon(nullURL, ownerURL, pkg, file, line, null, this.getIcon(), this.getHighlightStyle(), 0, this);
            } else if (ext.equals(".jws")) {
                this.sourceIcon = new SourceIcon(ownerURL, nullURL, pkg, file, line, null, this.getIcon(), this.getHighlightStyle(), 0, this);
            }
        }
    }

    private void makeSourceIcon(URL url, int line) {
        URL ownerURL = this.breakpointSettings.getOwnerURL();
        URL nullURL = null;
        if (ownerURL == null) {
            this.sourceIcon = new SourceIcon(nullURL, nullURL, url, line, null, this.getIcon(), this.getHighlightStyle(), 0, this);
        } else {
            String ext = URLFileSystem.getSuffix((URL)ownerURL).toLowerCase();
            if (ext.equals(".jpr")) {
                this.sourceIcon = new SourceIcon(nullURL, ownerURL, url, line, null, this.getIcon(), this.getHighlightStyle(), 0, this);
            } else if (ext.equals(".jws")) {
                this.sourceIcon = new SourceIcon(ownerURL, nullURL, url, line, null, this.getIcon(), this.getHighlightStyle(), 0, this);
            }
        }
    }

    private void makeSourceIcon(String className, String fieldName) {
        URL ownerURL = this.breakpointSettings.getOwnerURL();
        if (ownerURL == null) {
            this.sourceIcon = new SourceIcon((URL)null, (URL)null, className, fieldName, null, this.getIcon(), this.getHighlightStyle(), 1, this);
        } else {
            String ext = URLFileSystem.getSuffix((URL)ownerURL).toLowerCase();
            if (ext.equals(".jpr")) {
                this.sourceIcon = new SourceIcon((URL)null, ownerURL, className, fieldName, null, this.getIcon(), this.getHighlightStyle(), 1, this);
            } else if (ext.equals(".jws")) {
                this.sourceIcon = new SourceIcon(ownerURL, (URL)null, className, fieldName, null, this.getIcon(), this.getHighlightStyle(), 1, this);
            }
        }
    }

    private void makeSourceIcon(String fqMethod, int offset) {
        URL ownerURL = this.breakpointSettings.getOwnerURL();
        if (ownerURL == null) {
            this.sourceIcon = new SourceIcon((URL)null, (URL)null, fqMethod, offset, null, this.getIcon(), this.getHighlightStyle(), 0, this);
        } else {
            String ext = URLFileSystem.getSuffix((URL)ownerURL).toLowerCase();
            if (ext.equals(".jpr")) {
                this.sourceIcon = new SourceIcon((URL)null, ownerURL, fqMethod, offset, null, this.getIcon(), this.getHighlightStyle(), 0, this);
            } else if (ext.equals(".jws")) {
                this.sourceIcon = new SourceIcon(ownerURL, (URL)null, fqMethod, offset, null, this.getIcon(), this.getHighlightStyle(), 0, this);
            }
        }
    }

    public void showBreakpointIcon() {
        this.breakpointShowing = true;
        if (breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterShowBreakpointIcon(this);
        }
        int bpType = this.breakpointSettings.getType();
        switch (bpType) {
            case 0: {
                String pkg = this.breakpointSettings.getPkg();
                String file = this.breakpointSettings.getFile();
                int line = this.breakpointSettings.getLine();
                this.makeSourceIcon(pkg, file, line);
                break;
            }
            case 5: {
                URL url = this.breakpointSettings.getURL();
                int line = this.breakpointSettings.getLine();
                this.makeSourceIcon(url, line);
                break;
            }
            case 6: {
                String className = this.breakpointSettings.getClassName();
                String fieldName = this.breakpointSettings.getFieldName();
                this.makeSourceIcon(className, fieldName);
                break;
            }
            case 7: {
                String fqMethodName = this.breakpointSettings.getMethod();
                int offset = this.breakpointSettings.getOffset();
                this.makeSourceIcon(fqMethodName, offset);
                break;
            }
        }
    }

    public boolean matchesIconLocation(CodeEditor codeEditor, int line) {
        if (this.sourceIcon != null) {
            return this.sourceIcon.matchesIconLocation(codeEditor, line);
        }
        return false;
    }

    public boolean hideBreakpointIcon() {
        if (this.breakpointShowing) {
            if (breakpointRuntimeCallback != null) {
                breakpointRuntimeCallback.afterHideBreakpointIcon(this);
            }
            if (this.sourceIcon != null) {
                this.sourceIcon.hide();
                this.sourceIcon = null;
            }
            this.breakpointShowing = false;
            return true;
        }
        return false;
    }

    public void updateBreakpointIcon() {
        if (breakpointRuntimeCallback != null) {
            breakpointRuntimeCallback.afterUpdateBreakpointIcon(this);
        }
        if (this.sourceIcon != null) {
            this.sourceIcon.changeIcon(this.getIcon(), this.getHighlightStyle());
        }
    }

    public String getDescription() {
        if (this.breakpointSettings.getCustomDescription() != null) {
            return this.breakpointSettings.getCustomDescription();
        }
        Object desc = "";
        switch (this.breakpointSettings.getType()) {
            case 0: {
                String methodName;
                String pkg = this.breakpointSettings.getPkg();
                String file = this.breakpointSettings.getFile();
                if (Product.isRaptor() && file.endsWith(".pls")) {
                    file = file.substring(0, file.length() - 4);
                }
                int line = this.breakpointSettings.getLine();
                String string = methodName = breakpointRuntimeCallback != null ? breakpointRuntimeCallback.getMethodName(this) : null;
                if (methodName != null) {
                    desc = pkg + " " + file + " " + line + " [" + methodName + "]";
                    break;
                }
                desc = pkg + " " + file + " " + line;
                break;
            }
            case 1: {
                String method = this.breakpointSettings.getMethod();
                desc = method;
                break;
            }
            case 7: {
                String method = this.breakpointSettings.getMethod();
                int offset = this.breakpointSettings.getOffset();
                desc = method + " " + offset;
                break;
            }
            case 2: {
                String exception = this.breakpointSettings.getException();
                if (Product.isRaptor() && this.breakpointSettings.isPersistent() && exception.equals("java.lang.Exception")) {
                    desc = BreakpointArb.getString(5);
                    break;
                }
                boolean caught = this.breakpointSettings.isCaught();
                boolean uncaught = this.breakpointSettings.isUncaught();
                if (caught) {
                    if (uncaught) {
                        desc = BreakpointArb.format(10, exception);
                        break;
                    }
                    desc = BreakpointArb.format(8, exception);
                    break;
                }
                if (uncaught) {
                    desc = BreakpointArb.format(9, exception);
                    break;
                }
                desc = exception;
                break;
            }
            case 3: {
                desc = BreakpointArb.getString(6);
                break;
            }
            case 4: {
                String className = this.breakpointSettings.getClassName();
                desc = className;
                break;
            }
            case 5: {
                URL url = this.breakpointSettings.getURL();
                int line = this.breakpointSettings.getLine();
                desc = URLFileSystem.getPlatformPathName((URL)url) + " " + line;
                break;
            }
            case 6: {
                String classNameFieldName = this.breakpointSettings.getClassName() + " " + this.breakpointSettings.getFieldName();
                boolean access = this.breakpointSettings.isAccess();
                boolean modify = this.breakpointSettings.isModify();
                if (access) {
                    if (modify) {
                        desc = BreakpointArb.format(13, classNameFieldName);
                        break;
                    }
                    desc = BreakpointArb.format(11, classNameFieldName);
                    break;
                }
                if (modify) {
                    desc = BreakpointArb.format(12, classNameFieldName);
                    break;
                }
                desc = classNameFieldName;
                break;
            }
            case 8: {
                desc = BreakpointArb.getString(14);
            }
        }
        if (this.breakpointSettings.isPersistent()) {
            desc = BreakpointArb.format(7, desc);
        }
        return desc;
    }

    public String getStatusInfo() {
        Object s;
        Object object = s = this.breakpointSettings.isEnabled() ? BreakpointArb.getString(16) : BreakpointArb.getString(15);
        if (breakpointRuntimeCallback != null) {
            String activeStatus = null;
            switch (this.getRuntimeStatus()) {
                case 0: {
                    activeStatus = BreakpointArb.getString(15);
                    break;
                }
                case 1: {
                    activeStatus = BreakpointArb.getString(16);
                    break;
                }
                case 2: {
                    activeStatus = BreakpointArb.getString(17);
                    break;
                }
                case 3: {
                    activeStatus = BreakpointArb.getString(18);
                }
            }
            if (activeStatus != null && !activeStatus.equals(s)) {
                s = (String)s + " " + BreakpointArb.format(20, activeStatus);
            }
        }
        if (this.suspended) {
            s = (String)s + " " + BreakpointArb.getString(19);
        }
        return s;
    }

    public static Map<Object, List<CoreBreakpoint>> allBreakpoints() {
        return allBreakpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean breakpointsLoaded() {
        Map<Object, List<CoreBreakpoint>> map = allBreakpoints;
        synchronized (map) {
            return savedBreakpoints != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadBreakpoints() {
        Map<Object, List<CoreBreakpoint>> map = allBreakpoints;
        synchronized (map) {
            if (savedBreakpoints == null) {
                savedBreakpoints = new SavedBreakpoints();
                savedBreakpoints.load();
                ArrayList<BreakpointSettings> breakpoints = savedBreakpoints.getBreakpoints();
                int count = breakpoints.size();
                if (count == 0) {
                    CoreBreakpoint.createPersistentBreakpoints();
                } else {
                    for (int i = 0; i < count; ++i) {
                        BreakpointSettings breakpointSettings = (BreakpointSettings)breakpoints.get(i);
                        CoreBreakpoint bp = new CoreBreakpoint(breakpointSettings);
                        List<CoreBreakpoint> keyBreakpoints = CoreBreakpoint.getBreakpoints(bp.getOwnerURL());
                        keyBreakpoints.add(bp);
                    }
                }
            }
        }
        Node.addNodeListenerForTypeHierarchy(Node.class, (NodeListener)new BreakpointNodeListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CoreBreakpoint> getPersistentBreakpoints(Project project) {
        boolean hasJavaTechnologyScope = false;
        boolean hasAnyTechnologyScope = true;
        if (project != null) {
            TechnologyScopeConfiguration tsConfig = TechnologyScopeConfiguration.getInstance((PropertyStorage)project);
            TechnologyScope ts = tsConfig.getTechnologyScope();
            if (ts.getTechnologyKeys().length == 0) {
                hasAnyTechnologyScope = false;
            } else {
                for (String id : ts.getTechnologyKeys()) {
                    if (!"Java".equals(id)) continue;
                    hasJavaTechnologyScope = true;
                    break;
                }
            }
        } else {
            hasAnyTechnologyScope = false;
        }
        ArrayList<CoreBreakpoint> breakpoints = null;
        Map<Object, List<CoreBreakpoint>> map = allBreakpoints;
        synchronized (map) {
            if (allBreakpoints.get(GlobalBreakpointsKey) != null) {
                breakpoints = new ArrayList(allBreakpoints.get(GlobalBreakpointsKey));
            }
            if (breakpoints == null) {
                breakpoints = new ArrayList<CoreBreakpoint>();
                allBreakpoints.put(GlobalBreakpointsKey, breakpoints);
            } else if (hasAnyTechnologyScope) {
                Iterator bpi = breakpoints.iterator();
                while (bpi.hasNext()) {
                    CoreBreakpoint bp = (CoreBreakpoint)bpi.next();
                    if (!bp.breakpointSettings.isJavaSpecific() || hasJavaTechnologyScope) continue;
                    bpi.remove();
                }
            }
        }
        return breakpoints;
    }

    private static void createPersistentBreakpoints() {
        CoreBreakpoint bpUncaughtException = new CoreBreakpoint((URL)null, 2, "java.lang.Exception", false, true);
        CoreBreakpoint.initializePersistentOptions(bpUncaughtException);
        CoreBreakpoint.addBreakpointToOwner(bpUncaughtException);
        if (!Product.isRaptor()) {
            String osNameLower = System.getProperty("os.name").toLowerCase();
            if (osNameLower.indexOf("linux") != -1) {
                bpUncaughtException.setEnabled(false);
            }
            CoreBreakpoint bpAssertionError = new CoreBreakpoint(null, 2, "java.lang.AssertionError", false, true);
            CoreBreakpoint.initializePersistentOptions(bpAssertionError);
            CoreBreakpoint.addBreakpointToOwner(bpAssertionError);
            CoreBreakpoint bpDeadlock = new CoreBreakpoint(null, 3);
            CoreBreakpoint.initializePersistentOptions(bpDeadlock);
            CoreBreakpoint.addBreakpointToOwner(bpDeadlock);
            if (osNameLower.indexOf("sunos") != -1) {
                bpDeadlock.setEnabled(false);
            }
        }
    }

    private static void initializePersistentOptions(CoreBreakpoint bp) {
        bp.breakpointSettings.setPersistent(true);
        bp.breakpointSettings.setJavaSpecific(true);
        bp.breakpointSettings.setActionHalt(true);
        bp.breakpointSettings.setActionLog(true);
        bp.breakpointSettings.setActionLogTag("");
        bp.breakpointSettings.setActionLogExpr("");
        bp.breakpointSettings.setActionLogStack(false);
        bp.breakpointSettings.setActionEnableOther("");
        bp.breakpointSettings.setActionDisableOther("");
        bp.breakpointSettings.setCreationTimestamp(++persistentBreakpointCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBreakpoints() {
        if (savedBreakpoints != null) {
            ArrayList<BreakpointSettings> breakpoints = savedBreakpoints.getBreakpoints();
            breakpoints.clear();
            Map<Object, List<CoreBreakpoint>> map = allBreakpoints;
            synchronized (map) {
                for (Object key : allBreakpoints.keySet()) {
                    URL ownerURL;
                    boolean saveKeyBreakpoints = true;
                    if (key instanceof URL && !URLFileSystem.exists((URL)(ownerURL = (URL)key))) {
                        saveKeyBreakpoints = false;
                    }
                    if (!saveKeyBreakpoints) continue;
                    List<CoreBreakpoint> keyBreakpoints = allBreakpoints.get(key);
                    for (CoreBreakpoint bp : keyBreakpoints) {
                        BreakpointSettings breakpointSettings = bp.breakpointSettings;
                        breakpoints.add(breakpointSettings);
                    }
                }
            }
            savedBreakpoints.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CoreBreakpoint> getBreakpoints(URL ownerURL) {
        List<CoreBreakpoint> breakpoints;
        Object key = ownerURL == null ? GlobalBreakpointsKey : ownerURL;
        Map<Object, List<CoreBreakpoint>> map = allBreakpoints;
        synchronized (map) {
            breakpoints = allBreakpoints.get(key);
            if (breakpoints == null) {
                breakpoints = new ArrayList<CoreBreakpoint>();
                allBreakpoints.put(key, breakpoints);
            }
        }
        return breakpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void breakpointOwnerRenamed(UpdateMessage rename) {
        URL oldKey = RenameMessage.getOldURL((UpdateMessage)rename);
        Node renamedNode = RenameMessage.getRenamedNode((UpdateMessage)rename);
        if (renamedNode != null) {
            URL newKey = renamedNode.getURL();
            Map<Object, List<CoreBreakpoint>> map = allBreakpoints;
            synchronized (map) {
                List<CoreBreakpoint> breakpoints = allBreakpoints.remove(oldKey);
                if (breakpoints != null) {
                    for (CoreBreakpoint bp : breakpoints) {
                        bp.setOwnerURL(newKey);
                    }
                    allBreakpoints.put(newKey, breakpoints);
                }
            }
        }
    }

    public static List[] getBreakpoints(Workspace workspace, Project project) {
        if (!CoreBreakpoint.breakpointsLoaded()) {
            CoreBreakpoint.loadBreakpoints();
        }
        ArrayList<ArrayList<CoreBreakpoint>> breakpoints = new ArrayList<ArrayList<CoreBreakpoint>>();
        breakpoints.add(new ArrayList<CoreBreakpoint>(CoreBreakpoint.getPersistentBreakpoints(project)));
        if (workspace != null && workspace != Ide.getDefaultWorkspace()) {
            breakpoints.add(new ArrayList<CoreBreakpoint>(CoreBreakpoint.getBreakpoints(workspace.getURL())));
        }
        if (project != null && project != Ide.getDefaultProject()) {
            breakpoints.add(new ArrayList<CoreBreakpoint>(CoreBreakpoint.getBreakpoints(project.getURL())));
        }
        if (workspace == Ide.getDefaultWorkspace() && project == Ide.getDefaultProject()) {
            ArrayList<CoreBreakpoint> globalBreakpoints = new ArrayList<CoreBreakpoint>(CoreBreakpoint.getBreakpoints(null));
            Iterator iter = globalBreakpoints.iterator();
            while (iter.hasNext()) {
                CoreBreakpoint globalBP = (CoreBreakpoint)iter.next();
                if (!globalBP.isPersistent()) continue;
                iter.remove();
            }
            breakpoints.add(new ArrayList<CoreBreakpoint>(globalBreakpoints));
        }
        return breakpoints.toArray(new List[breakpoints.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CoreBreakpoint> getExtenderBreakpoints(String debuggerExtenderID) {
        ArrayList<CoreBreakpoint> breakpoints = new ArrayList<CoreBreakpoint>();
        Map<Object, List<CoreBreakpoint>> map = allBreakpoints;
        synchronized (map) {
            for (Object key : allBreakpoints.keySet()) {
                List<CoreBreakpoint> keyBreakpoints = allBreakpoints.get(key);
                for (CoreBreakpoint bp : keyBreakpoints) {
                    if (!debuggerExtenderID.equals(bp.getDebuggerExtenderID())) continue;
                    breakpoints.add(bp);
                }
            }
        }
        return breakpoints;
    }

    public static void removeBreakpointFromOwner(CoreBreakpoint bp) {
        URL ownerURL = bp.getOwnerURL();
        List<CoreBreakpoint> breakpoints = CoreBreakpoint.getBreakpoints(ownerURL);
        breakpoints.remove(bp);
    }

    public static void addBreakpointToOwner(CoreBreakpoint bp) {
        URL ownerURL = bp.getOwnerURL();
        List<CoreBreakpoint> breakpoints = CoreBreakpoint.getBreakpoints(ownerURL);
        breakpoints.add(bp);
    }

    public static void showBreakpointIcons(List[] breakpoints) {
        int length = breakpoints.length;
        for (int i = 0; i < length; ++i) {
            for (CoreBreakpoint bp : breakpoints[i]) {
                bp.showBreakpointIcon();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hideAllBreakpointIcons() {
        Map<Object, List<CoreBreakpoint>> map = allBreakpoints;
        synchronized (map) {
            for (Object key : allBreakpoints.keySet()) {
                List<CoreBreakpoint> keyBreakpoints = allBreakpoints.get(key);
                for (CoreBreakpoint bp : keyBreakpoints) {
                    bp.hideBreakpointIcon();
                }
            }
        }
    }

    public static void hideBreakpointIcons(List[] breakpoints) {
        int length = breakpoints.length;
        for (int i = 0; i < length; ++i) {
            for (CoreBreakpoint bp : breakpoints[i]) {
                bp.hideBreakpointIcon();
            }
        }
    }

    public static void updateBreakpointIcons(List[] breakpoints) {
        int length = breakpoints.length;
        for (int i = 0; i < length; ++i) {
            for (CoreBreakpoint bp : breakpoints[i]) {
                bp.updateBreakpointIcon();
            }
        }
    }

    public static void activeProjectChanged(Project activeProject, Workspace activeWorkspace) {
        if (breakpointRuntimeCallback == null) {
            if (activeBreakpoints != null) {
                CoreBreakpoint.hideBreakpointIcons(activeBreakpoints);
            }
            activeBreakpoints = CoreBreakpoint.getBreakpoints(activeWorkspace, activeProject);
            CoreBreakpoint.showBreakpointIcons(activeBreakpoints);
        }
    }

    static {
        GlobalBreakpointsKey = "217";
        allBreakpoints = new HashMap<Object, List<CoreBreakpoint>>();
        persistentBreakpointCount = 0;
    }

    private static final class BreakpointNodeListener
    extends NodeListener {
        private BreakpointNodeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
            Map<Object, List<CoreBreakpoint>> map = allBreakpoints;
            synchronized (map) {
                for (List<CoreBreakpoint> o : allBreakpoints.values()) {
                    for (CoreBreakpoint bp : o) {
                        if (bp.getType() != 5 || !URLFileSystem.equals((URL)oldURL, (URL)bp.getURL())) continue;
                        bp.setURLLine(newURL, bp.getLine());
                        if (breakpointRuntimeCallback == null) continue;
                        breakpointRuntimeCallback.afterRefactorBreakpoint(bp);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeDeleted(NodeEvent e) {
            Map<Object, List<CoreBreakpoint>> map = allBreakpoints;
            synchronized (map) {
                for (List<CoreBreakpoint> bpList : allBreakpoints.values()) {
                    for (CoreBreakpoint bp : bpList) {
                        if (bp.getType() != 5 || !URLFileSystem.equals((URL)e.getNodeURL(), (URL)bp.getURL())) continue;
                        bp.deleteBreakpoint();
                        if (breakpointRuntimeCallback == null) continue;
                        breakpointRuntimeCallback.updateBreakpointsWindow();
                    }
                }
            }
        }
    }
}

