/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeEditorGutterView;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.View;
import oracle.jdevimpl.runner.RunItemActions;
import oracle.jdevimpl.runner.RunItemController;
import oracle.jdevimpl.runner.extres.ExtensionResources;

public class DebuggerContextMenuListener
implements ContextMenuListener {
    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        if (context.getElement() == null && context.getNode() == null) {
            return;
        }
        View view = context.getView();
        if (view instanceof NavigatorWindow || view instanceof Editor) {
            DebuggerContextMenuListener.insertRunnableItems(popup, context);
        } else if (view instanceof CodeEditorGutterView) {
            this.insertGutterItems(popup, context);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void insertGutterItems(ContextMenu popup, Context context) {
        if (CodeEditorGutter.isMarkDroppingDown((Context)context)) {
            return;
        }
        IdeAction actionCodeEditorToggleBreakpoint = RunItemActions.getActionCodeEditorToggleBreakpoint();
        if (actionCodeEditorToggleBreakpoint != null) {
            RunItemController.getInstance().update(actionCodeEditorToggleBreakpoint, context);
            if (actionCodeEditorToggleBreakpoint.isEnabled()) {
                JMenuItem menuItem = popup.createMenuItem((ToggleAction)actionCodeEditorToggleBreakpoint, MenuConstants.WEIGHT_RUN_RUN_FILE);
                popup.add((Component)menuItem, 3.0f);
            }
        }
        IdeAction actionCodeEditorEnableBreakpoint = RunItemActions.getActionCodeEditorEnableBreakpoint();
        RunItemController.getInstance().update(actionCodeEditorEnableBreakpoint, context);
        if (actionCodeEditorEnableBreakpoint.isEnabled()) {
            JMenuItem menuItem = popup.createMenuItem((ToggleAction)actionCodeEditorEnableBreakpoint, MenuConstants.WEIGHT_RUN_RUN_FILE);
            popup.add((Component)menuItem, 3.0f);
        }
        IdeAction actionCodeEditorDisableBreakpoint = RunItemActions.getActionCodeEditorDisableBreakpoint();
        RunItemController.getInstance().update(actionCodeEditorDisableBreakpoint, context);
        if (actionCodeEditorDisableBreakpoint.isEnabled()) {
            JMenuItem menuItem = popup.createMenuItem((ToggleAction)actionCodeEditorDisableBreakpoint, MenuConstants.WEIGHT_RUN_RUN_FILE);
            popup.add((Component)menuItem, 3.0f);
        }
        IdeAction actionCodeEditorEditBreakpoint = RunItemActions.getActionCodeEditorEditBreakpoint();
        RunItemController.getInstance().update(actionCodeEditorEditBreakpoint, context);
        if (actionCodeEditorEditBreakpoint.isEnabled()) {
            JMenuItem menuItem = popup.createMenuItem((ToggleAction)actionCodeEditorEditBreakpoint, MenuConstants.WEIGHT_RUN_RUN_FILE);
            popup.add((Component)menuItem, 3.0f);
        }
        IdeAction actionCodeEditorToggleWatchpoint = RunItemActions.getActionCodeEditorToggleWatchpoint();
        RunItemController.getInstance().update(actionCodeEditorToggleWatchpoint, context);
        if (actionCodeEditorToggleWatchpoint.isEnabled()) {
            JMenuItem menuItem = popup.createMenuItem((ToggleAction)actionCodeEditorToggleWatchpoint, MenuConstants.WEIGHT_RUN_RUN_FILE);
            popup.add((Component)menuItem, 3.0f);
        }
    }

    public static void insertRunnableItems(ContextMenu popup, Context context) {
        IdeAction actionContextMenuDebug = RunItemActions.getActionContextMenuDebug();
        if (actionContextMenuDebug != null) {
            actionContextMenuDebug.putValue("UserData", (Object)context);
            RunItemController.getInstance().update(actionContextMenuDebug, context);
            if (actionContextMenuDebug.isEnabled()) {
                MnemonicSolver.MenuLabel mlabel;
                JMenuItem menuitemContextMenuDebug = popup.createMenuItem((ToggleAction)actionContextMenuDebug, MenuConstants.WEIGHT_RUN_RUN_FILE + 2.0f);
                popup.add((Component)menuitemContextMenuDebug, MenuConstants.SECTION_DEBUG_CTXT_MENU);
                MnemonicSolver solver = popup.getMnemonicSolver();
                if (solver != null && (mlabel = solver.findMenuLabel(menuitemContextMenuDebug)) != null) {
                    mlabel.setText(ExtensionResources.get("CONTEXTMENU_DEBUG_MENUITEM"));
                }
            } else {
                actionContextMenuDebug.putValue("UserData", null);
            }
        }
    }
}

