/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Color;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.ceditor.AbstractBrowseClickPlugin;
import oracle.ide.ceditor.CEditor;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorController;
import oracle.ide.ceditor.CodeEditorHook;
import oracle.ide.ceditor.CodeNavigationPoint;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.ceditor.options.CaretOptions;
import oracle.ide.ceditor.options.CaretOptionsPanel;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.ceditor.options.DisplayOptionsPanel;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.ceditor.options.EditorOptionsPanel;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.ceditor.options.FontSizeOptionsPanel;
import oracle.ide.ceditor.options.GutterOptionsPanel;
import oracle.ide.ceditor.options.SyntaxColorsOptions;
import oracle.ide.ceditor.options.SyntaxColorsOptionsPanel;
import oracle.ide.ceditor.options.UndoOptions;
import oracle.ide.ceditor.options.UndoOptionsPanel;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.IdeProperties;
import oracle.ide.model.TextNode;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.panels.Navigable;
import oracle.ide.util.MenuSpec;
import oracle.javatools.compare.view.ColorConstants;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.GuardedHighlightPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.util.Copyable;

public class CodeEditorAddin
extends EditorAddin {
    private MenuSpec menuSpec;

    public CodeEditorAddin() {
        CodeEditorHook hook = CodeEditorHook.get();
        hook.startListening();
    }

    static String getExtensionID() {
        return AddinManager.getAddinManager().getExtensionIDForAddin(CodeEditorAddin.class);
    }

    @Deprecated
    public Navigable getEditorNavigable() {
        return null;
    }

    private void registerKeystrokes() {
        EditorFactory.initialize();
    }

    private void registerNavigables() {
        Preferences prefs = Preferences.getPreferences();
        IdeSettings ideSettings = Ide.getSettings();
        ideSettings.putLegacyData("EditorOptions", (Copyable)EditorOptions.getInstance((PropertyStorage)prefs));
        ideSettings.putLegacyData("CaretOptions", (Copyable)CaretOptions.getInstance((PropertyStorage)prefs));
        ideSettings.putLegacyData("DisplayOptions", (Copyable)DisplayOptions.getInstance((PropertyStorage)prefs));
        ideSettings.putLegacyData("FontSizeOptions", (Copyable)FontSizeOptions.getInstance((PropertyStorage)prefs));
        ideSettings.putLegacyData("SyntaxColorsOptions", (Copyable)SyntaxColorsOptions.getInstance((PropertyStorage)prefs));
        ideSettings.putLegacyData("UndoOptions", (Copyable)UndoOptions.getInstance((PropertyStorage)prefs));
        EditorOptions editorOptions = EditorOptions.getInstance((PropertyStorage)prefs);
        EditorOptionsPanel.applyOptions(editorOptions);
        CaretOptions caretOptions = CaretOptions.getInstance((PropertyStorage)prefs);
        CaretOptionsPanel.applyOptions(caretOptions);
        DisplayOptions displayOptions = DisplayOptions.getInstance((PropertyStorage)prefs);
        DisplayOptionsPanel.applyOptions(displayOptions);
        GutterOptionsPanel.applyOptions(displayOptions);
        FontSizeOptions fontSizeOptions = FontSizeOptions.getInstance((PropertyStorage)prefs);
        FontSizeOptionsPanel.applyOptions(fontSizeOptions);
        SyntaxColorsOptions syntaxHighlightOptions = SyntaxColorsOptions.getInstance((PropertyStorage)prefs);
        SyntaxColorsOptionsPanel.applyOptions(syntaxHighlightOptions);
        UndoOptions undoOptions = UndoOptions.getInstance((PropertyStorage)prefs);
        UndoOptionsPanel.applyOptions(undoOptions);
    }

    public void initialize() {
        EditorManager editorMgr = EditorManager.getEditorManager();
        Class[] types = new Class[]{TextNode.class};
        editorMgr.register((EditorAddin)this, types);
        CodeEditorController.getDefaultController();
        NavigationManager navMgr = NavigationManager.getNavigationManager();
        if (navMgr != null) {
            navMgr.registerEditorNavigationPoint(CodeNavigationPoint.class, CodeEditor.class);
        }
        this.initializeOptions();
        ExitCommand.addShutdownHook((ShutdownHook)new ShutdownHook(){

            public boolean canShutdown() {
                return true;
            }

            public void shutdown() {
                BraceMatchingPlugin.shutdown();
            }
        });
    }

    private void initializeOptions() {
        this.registerNavigables();
        this.registerKeystrokes();
        IdeProperties properties = Ide.getIdeProperties();
        EditorProperties editorProperties = EditorProperties.getProperties();
        String keyRelease = properties.getProperty("ceditor.ConsumeKeyRelease", "true");
        try {
            boolean shouldEatKR = keyRelease.equals("true");
            editorProperties.putBooleanProperty("consume-key-release", shouldEatKR);
        }
        catch (RuntimeException shouldEatKR) {
            // empty catch block
        }
        String checkFragListAlloc = properties.getProperty("ceditor.CheckFragListAllocation", "false");
        boolean check = Boolean.valueOf(checkFragListAlloc);
        editorProperties.putBooleanProperty("check-fraglist-recycling", check);
        editorProperties.putBooleanProperty("toggle-comments-advance", true);
        String checkSameWidthFaces = System.getProperty("ceditor.CheckSameWidthFaces", "true");
        boolean checkFaces = Boolean.valueOf(checkSameWidthFaces);
        editorProperties.putBooleanProperty("check-same-width-faces", checkFaces);
        this.createHighlights();
    }

    public boolean isDefault() {
        return true;
    }

    public Class getEditorClass() {
        return CodeEditor.class;
    }

    public synchronized MenuSpec getMenuSpecification() {
        if (this.menuSpec == null) {
            String name = CEditorArb.getString(0);
            Integer mnemonic = CEditorArb.getInteger(1);
            this.menuSpec = new MenuSpec(name, mnemonic, CEditorArb.getInstance(), 2);
        }
        return this.menuSpec;
    }

    private void createHighlights() {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        HighlightStyle highlightStyle = registry.lookupStyle("code-highlight");
        if (highlightStyle == null) {
            highlightStyle = CodeEditor.createHighlightStyle("code-highlight", CEditor.get("HIGHLIGHT_CODE_HIGHLIGHT"), 75, Color.BLACK, new Color(255, 255, 181));
        }
        if ((highlightStyle = registry.lookupStyle("code-highlight-secondary")) == null) {
            highlightStyle = CodeEditor.createHighlightStyle("code-highlight-secondary", CEditor.get("HIGHLIGHT_CODE_HIGHLIGHT_SECONDARY"), 76, Color.BLACK, new Color(255, 200, 75));
        }
        BraceMatchingPlugin.registerHighlights();
        LineHighlightPlugin.registerHighlights();
        GuardedHighlightPlugin.registerHighlights();
        ColorConstants.registerHighlights();
        AbstractBrowseClickPlugin.registerHighlights();
    }
}

