/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import java.util.List;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SimpleSQLFragment;

public class WindowFunction
extends Function {
    private static final String OVER = "OVER";
    private static final String PARTITION_BY = "PARTITION BY";
    private static final String BETWEEN = "BETWEEN";
    private static final String AND = " AND ";
    private static final String UNBOUNDED = "UNBOUNDED";
    private static final String CURRENT_ROW = "CURRENT ROW";
    private static final String WITHIN_GROUP = "WITHIN GROUP";
    private static final String FROM_FIRST = "FROM FIRST";
    private static final String FROM_LAST = "FROM LAST";
    private static final String RESPECT_NULLS = "RESPECT NULLS";
    private static final String IGNORE_NULLS = "IGNORE NULLS";
    private static final String LISTAGG = "LISTAGG";

    public WindowFunction() {
        this((String)null);
    }

    public WindowFunction(String string) {
        super(string, (SQLFragment[])null, false);
        this.setSeparator(", ");
    }

    public void setFromPolicy(FromPolicy fromPolicy) {
        this.setProperty("fromPolicy", (Object)fromPolicy);
    }

    public FromPolicy getFromPolicy() {
        return (FromPolicy)((Object)this.getProperty("fromPolicy"));
    }

    public void setNullPolicy(NullPolicy nullPolicy) {
        this.setProperty("nullPolicy", (Object)nullPolicy);
    }

    public NullPolicy getNullPolicy() {
        return (NullPolicy)((Object)this.getProperty("nullPolicy"));
    }

    public void setPartitionBy(SQLFragment[] sQLFragmentArray) {
        this.getChildSupport("partitionBy").setChildArray(sQLFragmentArray);
    }

    public SQLFragment[] getPartitionBy() {
        return this.getChildSupport("partitionBy").getChildArray(SQLFragment.class);
    }

    public void setOrderBy(OrderByObject[] orderByObjectArray) {
        this.getChildSupport("orderBy").setChildArray(orderByObjectArray);
    }

    public OrderByObject[] getOrderBy() {
        return this.getChildSupport("orderBy").getChildArray(OrderByObject.class);
    }

    public void setClauseType(ClauseType clauseType) {
        this.setProperty("clauseType", (Object)clauseType);
    }

    public ClauseType getClauseType() {
        return (ClauseType)((Object)this.getProperty("clauseType"));
    }

    public void setBounds(SQLFragment[] sQLFragmentArray) {
        this.getChildSupport("bounds").setChildArray(sQLFragmentArray);
    }

    public SQLFragment[] getBounds() {
        return this.getChildSupport("bounds").getChildArray(SQLFragment.class);
    }

    @Override
    public String getSQLText() {
        String string = super.getSQLText();
        FromPolicy fromPolicy = this.getFromPolicy();
        NullPolicy nullPolicy = this.getNullPolicy();
        List list = this.getChildSupport("partitionBy").getChildList(false);
        List list2 = this.getChildSupport("orderBy").getChildList(false);
        List list3 = this.getChildSupport("bounds").getChildList(false);
        boolean bl = list != null && list.size() > 0;
        boolean bl2 = list2 != null && list2.size() > 0;
        boolean bl3 = list3 != null && list3.size() == 2;
        StringBuilder stringBuilder = new StringBuilder(string);
        if (fromPolicy != null) {
            if (fromPolicy == FromPolicy.FIRST) {
                stringBuilder.append(" ").append(FROM_FIRST);
            } else if (fromPolicy == FromPolicy.LAST) {
                stringBuilder.append(" ").append(FROM_LAST);
            }
        }
        if (nullPolicy != null) {
            if (nullPolicy == NullPolicy.RESPECT) {
                stringBuilder.append(" ").append(RESPECT_NULLS);
            } else if (nullPolicy == NullPolicy.IGNORE) {
                stringBuilder.append(" ").append(IGNORE_NULLS);
            }
        }
        if (bl || bl2) {
            if (LISTAGG.equals(this.getFunction())) {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append(WITHIN_GROUP).append(" ");
                stringBuilder2.append(this.surroundWithBrackets(this.buildOrderBy(list2, bl2), true));
                if (bl) {
                    stringBuilder2.append(" ").append(OVER).append(" ");
                    stringBuilder2.append(this.surroundWithBrackets(this.buildPartitionByText(list, bl), true));
                }
                stringBuilder.append(" ").append(stringBuilder2.toString());
            } else {
                StringBuilder stringBuilder3 = new StringBuilder();
                stringBuilder3.append(this.buildPartitionByText(list, bl));
                stringBuilder3.append(this.buildOrderBy(list2, bl2));
                ClauseType clauseType = this.getClauseType();
                if (clauseType != null) {
                    stringBuilder3.append(" ").append(clauseType.toString()).append(" ");
                    if (bl3) {
                        stringBuilder3.append(BETWEEN).append(" ");
                    }
                    stringBuilder3.append(this.argsToString(list3, false, AND, 0));
                }
                stringBuilder.append(" ").append(OVER);
                stringBuilder.append(this.surroundWithBrackets(stringBuilder3.toString()));
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private String buildOrderBy(Collection collection, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append(" ").append("ORDER BY").append(" ");
            stringBuilder.append(this.argsToString(collection, true, ", ", 0));
        }
        return stringBuilder.toString();
    }

    private String buildPartitionByText(Collection collection, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append(" ").append(PARTITION_BY).append(" ");
            stringBuilder.append(this.argsToString(collection, true, ", ", 0));
        }
        return stringBuilder.toString();
    }

    public static enum FromPolicy {
        FIRST,
        LAST;

    }

    public static enum NullPolicy {
        RESPECT,
        IGNORE;

    }

    public static enum ClauseType {
        ROWS,
        RANGE;

    }

    public static class WindowFunctionBound
    extends AbstractSQLFragment {
        public void setBoundExpr(SQLFragment[] sQLFragmentArray) {
            this.getChildSupport("boundExpr").setChildArray(sQLFragmentArray);
        }

        public SQLFragment[] getBoundExpr() {
            return this.getChildSupport("boundExpr").getChildArray(SQLFragment.class);
        }

        public void setBoundType(BoundType boundType) {
            this.setProperty("boundType", (Object)boundType);
        }

        public BoundType getBoundType() {
            return (BoundType)((Object)this.getProperty("boundType"));
        }

        @Override
        public String getSQLText() {
            List list = this.getChildSupport("boundExpr").getChildList(false);
            BoundType boundType = this.getBoundType();
            StringBuilder stringBuilder = new StringBuilder();
            if (list != null && list.size() > 0) {
                Object object2;
                boolean bl = false;
                for (Object object2 : list) {
                    bl = !(object2 instanceof SimpleSQLFragment);
                }
                object2 = this.argsToString(list, true, ", ", 0);
                if (bl) {
                    object2 = this.surroundWithBrackets((String)object2);
                }
                stringBuilder.append((String)object2);
                if (boundType != null) {
                    stringBuilder.append(" ").append(boundType.toString());
                }
            } else if (boundType != null) {
                if (boundType == BoundType.CURRENT_ROW) {
                    stringBuilder.append(WindowFunction.CURRENT_ROW);
                } else {
                    stringBuilder.append(WindowFunction.UNBOUNDED).append(" ");
                    stringBuilder.append(boundType.toString());
                }
            }
            String string = stringBuilder.toString();
            return string;
        }
    }

    public static enum BoundType {
        PRECEDING,
        FOLLOWING,
        CURRENT_ROW;

    }
}

