/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.extension;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.extension.DatabaseMatcher;
import oracle.javatools.db.extension.MatcherCache;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.util.deferred.Thunk;

public final class DBObjectRegistry {
    private MatcherCache.ClassCache<DBObjectValidator> m_validators = new MatcherCache.ClassCache();
    private MatcherCache.ClassCache<DBObjectBuilder> m_builders = new MatcherCache.ClassCache();
    private MatcherCache.ClassCache<DBObjectLister> m_lists = new MatcherCache.ClassCache();
    private MatcherCache.ClassCache<DDLGenerator> m_ddlgens = new MatcherCache.ClassCache();

    public Map<String, DBObjectValidator> getValidators(String string, int n, DBObjectProvider dBObjectProvider) {
        Map map = this.m_validators.getAllClasses(string, n);
        return this.instantiateClasses(map, dBObjectProvider, false);
    }

    public Map<String, DBObjectBuilder> getBuilders(String string, int n, DBObjectProvider dBObjectProvider) {
        Map map = this.m_builders.getAllClasses(string, n);
        return this.instantiateClasses(map, dBObjectProvider, false);
    }

    public Map<String, DBObjectLister> getListers(String string, int n, DBObjectProvider dBObjectProvider) {
        Map map = this.m_lists.getAllClasses(string, n);
        return this.instantiateClasses(map, dBObjectProvider, false);
    }

    public Map<String, DDLGenerator> getDDLGenerators(Database database) {
        return this.getDDLGenerators(database.getDatabaseType(), database.getDatabaseVersion(), database.getClass(), database);
    }

    public Map<String, DDLGenerator> getDDLGenerators(String string, int n, Class<? extends Database> clazz, DBObjectProvider dBObjectProvider) {
        Map map = this.m_ddlgens.getAllClasses(string, n);
        Map map2 = this.instantiateClasses(map, dBObjectProvider, true);
        Map map3 = this.instantiateClasses(map, new Class[]{Class.class, DBObjectProvider.class}, new Object[]{clazz, dBObjectProvider});
        for (Map.Entry entry : map2.entrySet()) {
            String string2 = entry.getKey();
            if (map3.containsKey(string2)) continue;
            map3.put(string2, (DDLGenerator)entry.getValue());
        }
        return map3;
    }

    private <T> Map<String, T> instantiateClasses(Map<String, Class<? extends T>> map, DBObjectProvider dBObjectProvider, boolean bl) {
        TreeMap treeMap = new TreeMap();
        if (map != null) {
            for (Map.Entry<String, Class<T>> entry : map.entrySet()) {
                Class<T> clazz = entry.getValue();
                try {
                    boolean bl2 = false;
                    Throwable throwable = null;
                    for (Constructor<?> constructor : clazz.getConstructors()) {
                        Class<?>[] classArray = constructor.getParameterTypes();
                        if (classArray == null || classArray.length != 1 || !DBObjectProvider.class.isAssignableFrom(classArray[0])) continue;
                        try {
                            bl2 = true;
                            throwable = null;
                            Object obj = constructor.newInstance(dBObjectProvider);
                            treeMap.put(entry.getKey(), obj);
                            break;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            throwable = invocationTargetException.getCause();
                        }
                        catch (Exception exception) {
                            throwable = exception;
                        }
                    }
                    if (!bl2) {
                        DBLog.getLogger(this).log(bl ? Level.FINE : Level.SEVERE, "Class {0} is missing constructor that takes a DBObjectProvider", new String[]{clazz.getName()});
                        continue;
                    }
                    if (throwable == null) continue;
                    DBLog.logStackTrace("Could not instaniate " + clazz.getName(), throwable);
                }
                catch (Exception exception) {
                    DBLog.logStackTrace("Could not process class:" + clazz.getName(), exception);
                }
            }
        }
        return treeMap;
    }

    private <T> Map<String, T> instantiateClasses(Map<String, Class<? extends T>> map, Class[] classArray, Object[] objectArray) {
        TreeMap<String, T> treeMap = new TreeMap<String, T>();
        if (map != null) {
            for (Map.Entry<String, Class<T>> entry : map.entrySet()) {
                Class<T> clazz = entry.getValue();
                try {
                    Constructor<T> constructor = clazz.getConstructor(classArray);
                    T t = constructor.newInstance(objectArray);
                    treeMap.put(entry.getKey(), t);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    DBLog.getLogger(this).log(Level.SEVERE, "Class {0} is missing constructor that takes param types: {1}", new String[]{clazz.getName(), Arrays.asList(classArray).toString()});
                }
                catch (Exception exception) {
                    DBLog.logStackTrace("Could not process class:" + clazz.getName(), exception instanceof InvocationTargetException ? exception.getCause() : exception);
                }
            }
        }
        return treeMap;
    }

    public void registerObject(String string, DatabaseMatcher databaseMatcher, Class<? extends DBObjectValidator> clazz, Class<? extends DBObjectBuilder> clazz2, Class<? extends DBObjectLister> clazz3, Class<? extends DDLGenerator> clazz4) {
        this.m_validators.putClass(string, clazz, databaseMatcher);
        this.m_builders.putClass(string, clazz2, databaseMatcher);
        this.m_lists.putClass(string, clazz3, databaseMatcher);
        this.m_ddlgens.putClass(string, clazz4, databaseMatcher);
    }

    public void registerObject(String string, DatabaseMatcher databaseMatcher, Thunk<Class<? extends DBObjectValidator>> thunk, Thunk<Class<? extends DBObjectBuilder>> thunk2, Thunk<Class<? extends DBObjectLister>> thunk3, Thunk<Class<? extends DDLGenerator>> thunk4) {
        this.m_validators.put(string, (DBObjectValidator)thunk, databaseMatcher);
        this.m_builders.put(string, (DBObjectBuilder)thunk2, databaseMatcher);
        this.m_lists.put(string, (DBObjectLister)thunk3, databaseMatcher);
        this.m_ddlgens.put(string, (DDLGenerator)thunk4, databaseMatcher);
    }

    public void registerClass(String string, Class<? extends DBObject> clazz) {
        if (string == null) {
            throw new IllegalArgumentException("object type must be defined");
        }
        if (!DBObject.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("object class must subclass DBObject");
        }
        Metadata.getInstance().registerObjectClass(string, clazz);
    }

    public void registerClass(String string, Thunk<Class<? extends DBObject>> thunk) {
        if (string == null) {
            throw new IllegalArgumentException("object type must be defined");
        }
        Metadata.getInstance().registerObjectClass(string, thunk);
    }

    public static synchronized DBObjectRegistry getInstance() {
        DBCore dBCore = DBCore.getInstance();
        DBObjectRegistry dBObjectRegistry = dBCore.get(DBObjectRegistry.class);
        if (dBObjectRegistry == null) {
            dBObjectRegistry = new DBObjectRegistry();
            dBCore.put(dBObjectRegistry);
        }
        return dBObjectRegistry;
    }

    public static boolean isActive() {
        DBCore dBCore = DBCore.getInstance();
        DBObjectRegistry dBObjectRegistry = dBCore.get(DBObjectRegistry.class);
        return dBObjectRegistry != null;
    }

    public static boolean isExtensionType(String string, String string2, int n) {
        boolean bl = false;
        if (DBObjectRegistry.isActive()) {
            Map map = DBObjectRegistry.getInstance().m_ddlgens.getAll(string2, n);
            bl = map != null && map.containsKey(string);
        }
        return bl;
    }
}

