/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Comparator;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.DBObjectIDComparator;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.ModelUtil;

public class DBObjectComparator<T extends DBObject>
implements Comparator<T> {
    private final Comparator<DBObject> m_delegate;
    private final DiffEngine m_engine;

    public DBObjectComparator() {
        this(null);
    }

    DBObjectComparator(DiffEngine diffEngine) {
        this.m_engine = diffEngine;
        this.m_delegate = DBUtil.getNameComparator();
    }

    @Override
    public int compare(T t, T t2) {
        int n;
        if (t == t2) {
            n = 0;
        } else if (t == null || t2 == null) {
            n = t2 == null ? -10 : 10;
        } else if (TemporaryObjectID.getOriginalObject(t) == t2 || TemporaryObjectID.getOriginalObject(t2) == t) {
            n = 0;
        } else {
            DBObjectID dBObjectID = t.getID();
            DBObjectID dBObjectID2 = t2.getID();
            if (this.shouldTestByName((DBObject)t, dBObjectID) || this.shouldTestByName((DBObject)t2, dBObjectID2)) {
                n = this.m_delegate.compare((DBObject)t, (DBObject)t2);
            } else {
                DBObjectIDComparator dBObjectIDComparator = null;
                if (this.m_engine != null) {
                    dBObjectIDComparator = this.m_engine.getComparator(DBObjectID.class);
                }
                if (dBObjectIDComparator == null) {
                    dBObjectIDComparator = new DBObjectIDComparator(false);
                }
                n = dBObjectIDComparator.compare((DBObjectID)dBObjectID, (DBObjectID)dBObjectID2);
            }
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof DBObjectComparator && ModelUtil.areEqual((Object)((DBObjectComparator)object).m_engine, (Object)this.m_engine);
    }

    private boolean shouldTestByName(DBObject dBObject, DBObjectID dBObjectID) {
        boolean bl = dBObjectID == null ? true : dBObjectID instanceof TemporaryObjectID && TemporaryObjectID.findOriginalObject((TemporaryObjectID)dBObjectID) == null && this.isDerived(dBObject);
        return bl;
    }

    private boolean isDerived(DBObject dBObject) {
        boolean bl = false;
        while (dBObject != null) {
            DBObject dBObject2 = dBObject.getParent();
            if (dBObject2 != null) {
                String string = DBUtil.getPropertyPath(dBObject2, dBObject);
                PropertyInfo propertyInfo = PropertyHelper.findPropertyInfo(dBObject2.getClass(), string, (Class<? extends DBObjectProvider>)null);
                if (propertyInfo == null) break;
                if (propertyInfo.isDerived()) {
                    bl = true;
                    break;
                }
            }
            dBObject = dBObject2;
        }
        return bl;
    }
}

