/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.patch;

import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public abstract class PatchAssistance {
    static final String DIFF_DATE_FORMAT = "EEE MMM dd HH:mm:ss yyyy";
    @CodeSharingSafe(value="StaticField")
    static final Locale DIFF_DATE_LOCALE = Locale.US;
    private static final String RFC_822_DATE_FORMAT = "dd MMM yyyy HH:mm:ss Z";
    @CodeSharingSafe(value="StaticField")
    private static final Locale RFC_822_DATE_LOCALE = Locale.US;
    private static final String ISO_8601_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss Z";
    @CodeSharingSafe(value="StaticField")
    private static final Locale ISO_8601_DATE_LOCALE = Locale.US;
    public static final String DEV_NULL = "/dev/null";
    private URL _root;

    public abstract boolean isRecognised(byte[] var1);

    public abstract Date getFromModificationTime();

    public abstract String getFromRevision();

    public abstract String toFile();

    public abstract String fromFile();

    public abstract Date getToModificationTime();

    public abstract String getToRevision();

    public abstract void process(String var1);

    public abstract boolean isNew();

    public abstract void fixUpFilenames();

    public abstract void updated(URL[] var1);

    public void setSelectedRoot(URL url) {
        this._root = url;
    }

    public boolean isNewEntry() {
        return false;
    }

    public boolean isCopy() {
        return false;
    }

    protected URL getRoot() {
        return this._root;
    }

    protected Date parseModificationTime(String modTime) {
        try {
            return new SimpleDateFormat(DIFF_DATE_FORMAT, DIFF_DATE_LOCALE).parse(modTime);
        }
        catch (ParseException parseException) {
            try {
                return new SimpleDateFormat(RFC_822_DATE_FORMAT, RFC_822_DATE_LOCALE).parse(modTime);
            }
            catch (ParseException parseException2) {
                try {
                    return new SimpleDateFormat(ISO_8601_DATE_FORMAT, ISO_8601_DATE_LOCALE).parse(modTime.replaceAll("\\.\\d+", ""));
                }
                catch (ParseException parseException3) {
                    return new Date(System.currentTimeMillis());
                }
            }
        }
    }
}

