/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.LambdaExpr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;
import oracle.javatools.parser.java.v2.model.SourceVariable;

public final class FormalsSym
extends TreeSym
implements SourceFormalParameterList {
    @Override
    public List<SourceVariable> getSourceParameters() {
        return this.getChildrenList(115);
    }

    public <T extends SourceVariable> List<T> getSourceParameterList() {
        return this.getChildrenList(115);
    }

    public List<JavaVariable> getParameters() {
        return this.getObjects((byte)115);
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 13: 
            case 28: 
            case 31: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected void linkChild(int index, Sym child, byte filter) {
        Sym parentSym = this.getParentSym();
        if (parentSym != null && parentSym.symKind == 83 && child != null && child.symKind == 31) {
            LambdaExpr lambdaExpr = (LambdaExpr)parentSym;
            if (((SourceLambdaParameter)((Object)child)).isInferredFormalParameter()) {
                if (lambdaExpr.hasFormalParameters() && !lambdaExpr.hasInferredFormalParameters()) {
                    FormalsSym.unsupported("Can't add an inferred formal lambda parameter when there are already typed parameters");
                }
            } else if (lambdaExpr.hasInferredFormalParameters()) {
                FormalsSym.unsupported("Can't add a typed formal lambda parameter when there are already inferred ones");
            }
            lambdaExpr.setParenthesizedParameters(true);
        }
        Sym actualChild = this.checkForLocalVariableTemplate(child);
        super.linkChild(index, actualChild, filter);
    }

    @Override
    protected void replaceChild(int index, Sym child, byte filter) {
        Sym actualChild = this.checkForLocalVariableTemplate(child);
        super.replaceChild(index, actualChild, filter);
    }

    @Override
    protected void unlinkChild(int index, byte filter) {
        super.unlinkChild(index, filter);
        Sym parentSym = this.getParentSym();
        if (parentSym != null && parentSym.symKind == 83) {
            LambdaExpr lambdaExpr = (LambdaExpr)parentSym;
            lambdaExpr.setParenthesizedParameters(true);
        }
    }

    private Sym checkForLocalVariableTemplate(Sym child) {
        if (child == null) {
            return null;
        }
        if (child.symKind == 17 && (child.symFormat & 2) != 0 && child.symParent == null) {
            LocalVariableSym variableSym = (LocalVariableSym)child;
            SymFactory factory = this.symFile.getSymFactory();
            FormalParameterSym parameterSym = (FormalParameterSym)factory.createFormalParameter(variableSym);
            return parameterSym;
        }
        return child;
    }

    @Override
    protected void linkChildTrigger(Sym added, byte filter) {
        switch (added.symKind) {
            case 17: {
                added.symKind = (byte)13;
            }
        }
        super.linkChildTrigger(added, filter);
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        super.compileImpl(compiler);
        if (!compiler.skipCompilations()) {
            compiler.compile(this);
        }
        return this;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    protected void print_signature(PrintWriter out, boolean parameterNames) {
        if (parameterNames) {
            this.print(out);
        } else {
            out.print('(');
            List<SourceVariable> things = this.getSourceParameters();
            int count = things.size();
            if (count > 0) {
                Iterator<SourceVariable> iterator = things.iterator();
                boolean needComma = false;
                while (iterator.hasNext()) {
                    if (needComma) {
                        out.print(", ");
                    }
                    Sym parameter = (Sym)((Object)iterator.next());
                    FormalsSym.print(parameter, out, 3);
                    needComma = true;
                }
            }
            out.print(')');
        }
    }
}

