/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickField;
import oracle.javatools.parser.java.v2.common.QuickHasType;
import oracle.javatools.parser.java.v2.common.QuickLocalVariable;
import oracle.javatools.parser.java.v2.common.QuickMethod;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.EnumConstantSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceRecordComponent;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.write.SourceComparator;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

public final class ClassBodySym
extends TreeSym
implements SourceClassBody {
    @Override
    public List<SourceMember> getSourceMembers() {
        return this.getChildrenList(104);
    }

    @Override
    public Collection<SourceMemberVariable> getSourceMemberVariables() {
        return this.getSyms((byte)117);
    }

    public SourceMemberVariable getSourceMemberVariable(String name) {
        for (SourceEnumConstant sourceEnumConstant : this.getSourceEnumConstants()) {
            EnumConstantSym constant = (EnumConstantSym)sourceEnumConstant;
            if (!name.equals(constant.getName())) continue;
            return constant;
        }
        for (SourceFieldVariable field : this.getSourceFieldVariables()) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    @Override
    public List<SourceEnumConstant> getSourceEnumConstants() {
        return this.getChildrenList(7);
    }

    @Override
    public List<SourceFieldDeclaration> getSourceFieldDeclarations() {
        return this.getChildrenList(9);
    }

    @Override
    public Collection<SourceFieldVariable> getSourceFieldVariables() {
        return this.getSyms((byte)118);
    }

    public SourceFieldVariable getSourceFieldVariable(String name) {
        for (SourceFieldVariable sourceFieldVariable : this.getSourceFieldVariables()) {
            FieldSym field = (FieldSym)sourceFieldVariable;
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    @Override
    public List<SourceMethod> getSourceMethods() {
        return this.getChildrenList(19);
    }

    public Collection<SourceMethod> getSourceMethods(String name) {
        ArrayList<SourceMethod> methods = new ArrayList<SourceMethod>();
        for (SourceMethod method : this.getSourceMethods()) {
            if (!name.equals(method.getName())) continue;
            methods.add(method);
        }
        return methods;
    }

    @Override
    public List<SourceMethod> getSourceConstructors() {
        return this.getChildrenList(6);
    }

    @Override
    public List<SourceClass> getSourceClasses() {
        return this.getChildrenList(3);
    }

    @Override
    public List<SourceClass> getSourceAnonymousClasses() {
        return Collections.unmodifiableList(CommonUtilities.getSourceAnonymousClasses(this));
    }

    @Override
    public List<SourceClass> getSourceLocalClasses() {
        return Collections.unmodifiableList(CommonUtilities.getSourceLocalClasses(this));
    }

    public SourceClass getSourceClass(String name) {
        for (SourceClass sourceClass : this.getSourceClasses()) {
            if (!name.equals(sourceClass.getName())) continue;
            return sourceClass;
        }
        return null;
    }

    @Override
    public List<SourceClassInitializer> getSourceInitializers() {
        return this.getChildrenList(5);
    }

    protected Collection<JavaMethod> getDeclaredConstructors() {
        List<JavaMethod> existingConstructors = this.getObjects((byte)6);
        Sym parentSym = this.getParentSym();
        if (parentSym == null || parentSym.symKind != 3) {
            return null;
        }
        ClassSym owningClass = (ClassSym)this.symParent;
        if (owningClass.isRecord()) {
            return this.addRecordConstructorToRecord(owningClass, existingConstructors);
        }
        if (!existingConstructors.isEmpty()) {
            return existingConstructors;
        }
        ArrayList<JavaMethod> constructorList = new ArrayList<JavaMethod>(1);
        QuickMethod defaultConstructor = this.getDefaultConstructor(owningClass);
        if (defaultConstructor != null) {
            constructorList.add(defaultConstructor);
        }
        return constructorList;
    }

    protected Collection<JavaMethod> getDeclaredMethods() {
        Collection<JavaMethod> methods = this.getObjects((byte)19);
        Sym parentSym = this.getParentSym();
        if (parentSym != null && parentSym.symKind == 3) {
            ClassSym sourceClass = (ClassSym)parentSym;
            switch (sourceClass.getClassKind()) {
                case INTERFACE: {
                    methods = this.addObjectMethodsToInterface(sourceClass, methods);
                    break;
                }
                case ENUM: {
                    methods = this.addEnumMethods(sourceClass, methods);
                    break;
                }
                case RECORD: {
                    methods = this.addRecordMethodsToRecord(sourceClass, methods);
                }
            }
        }
        return methods;
    }

    protected Collection<JavaField> getDeclaredFields() {
        Collection<JavaField> fields = this.getObjects((byte)118, 2);
        Sym parentSym = this.getParentSym();
        if (parentSym != null && parentSym.symKind == 3) {
            ClassSym type = (ClassSym)parentSym;
            if (type.isRecord()) {
                fields = this.addRecordFieldsToRecord(type, fields);
            } else if (type.isEnum()) {
                fields = this.addEnumFieldsToEnum(type, fields);
            }
        }
        return fields;
    }

    protected Collection<SourceClass> getDeclaredClasses() {
        return this.getObjects((byte)3);
    }

    protected Collection<JavaClass> getDeclaredAnonymousClasses() {
        return this.getCompiledObjects(this.getSourceAnonymousClasses());
    }

    protected Collection<JavaClass> getDeclaredLocalClasses() {
        return this.getCompiledObjects(this.getSourceLocalClasses());
    }

    private Collection<JavaClass> getCompiledObjects(List<SourceClass> sourceClasses) {
        ArrayList<JavaClass> declaredClasses = new ArrayList<JavaClass>();
        for (SourceClass sourceClass : sourceClasses) {
            JavaClass compiledObject = sourceClass.getCompiledObject();
            if (compiledObject == null) continue;
            declaredClasses.add(compiledObject);
        }
        return declaredClasses;
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 19: 
            case 44: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected int getTargetIndex(Sym target, byte filter) {
        int next;
        Sym firstSym;
        if (!target.isFilter((byte)105)) {
            return super.getTargetIndex(target, filter);
        }
        int i = this.indexOf((byte)105);
        if (i == -1) {
            return super.getTargetIndex(target, filter);
        }
        SourcePreferences preferences = this.symFile.getPreferences();
        Comparator<SourceElement> comparator = preferences != null ? preferences.getMemberComparator() : SourceComparator.memberComparator();
        if (comparator.compare(target, firstSym = this.getNthChild(i)) < 0) {
            return i;
        }
        while ((next = this.indexOf((byte)105, i + 1)) != -1) {
            Sym sym = this.getNthChild(next);
            if (comparator.compare(target, sym) < 0) {
                return i + 1;
            }
            i = next;
        }
        return super.getTargetIndex(target, filter);
    }

    @Override
    public void buildSelf() {
        super.buildSelf();
    }

    @Override
    protected void linkChildTrigger(Sym added, byte filter) {
        super.linkChildTrigger(added, filter);
        switch (added.symKind) {
            case 19: {
                this.clearMethodCache();
                break;
            }
            case 9: {
                this.clearFieldCache();
                break;
            }
            case 3: {
                this.clearClassCache();
            }
        }
    }

    @Override
    protected void unlinkChildTrigger(Sym removed, byte filter) {
        super.unlinkChildTrigger(removed, filter);
        switch (removed.symKind) {
            case 19: {
                this.clearMethodCache();
                break;
            }
            case 9: {
                this.clearFieldCache();
                break;
            }
            case 3: {
                this.clearClassCache();
            }
        }
    }

    private void clearMethodCache() {
        Sym parent = this.getParentSym();
        if (parent == null) {
            return;
        }
        parent.clearInternalBinding(18);
        parent.clearInternalBinding(19);
    }

    private void clearFieldCache() {
        Sym parent = this.getParentSym();
        if (parent != null) {
            parent.clearInternalBinding(20);
        }
    }

    private void clearClassCache() {
        Sym parent = this.getParentSym();
        if (parent != null) {
            this.clearInternalBinding(21);
        }
    }

    private QuickMethod getDefaultConstructor(ClassSym owningClass) {
        char access;
        if (owningClass.isInterface()) {
            return null;
        }
        if (owningClass.isEnum()) {
            access = '\u0002';
        } else {
            access = owningClass.symAccess;
            access = (char)(access & 7);
        }
        access = (char)(access | 0x1000);
        List<JavaVariable> parameters = null;
        JavaType outerClass = ClassBodySym.getOuterClassOfNonstaticInner(owningClass);
        if (outerClass != null) {
            QuickLocalVariable parameter = QuickLocalVariable.createLocalVariable(outerClass, "this$0");
            parameters = Arrays.asList(parameter);
        }
        return QuickMethod.createMethod(owningClass, access, null, "<init>", parameters, null);
    }

    private List<JavaMethod> addEnumMethods(ClassSym owningSym, Collection<JavaMethod> otherMethods) {
        char access = '\u1009';
        JavaType arrayOfOwning = ClassBodySym.createArrayType(this.symFile.getProvider(), owningSym, 1);
        QuickMethod valuesMethod = QuickMethod.createMethod(owningSym, access, arrayOfOwning, "values", null, null);
        ArrayList<JavaVariable> parameterList = new ArrayList<JavaVariable>();
        QuickHasType stringType = QuickHasType.createHasTypeByVMName(this.symFile, "java/lang/String");
        QuickLocalVariable nameParameter = QuickLocalVariable.createLocalVariable(stringType, "name");
        parameterList.add(nameParameter);
        QuickMethod valueOfMethod = QuickMethod.createMethod(owningSym, access, owningSym, "valueOf", parameterList, null);
        ArrayList<JavaMethod> methods = new ArrayList<JavaMethod>(otherMethods);
        methods.add(valuesMethod);
        methods.add(valueOfMethod);
        return methods;
    }

    private Collection<JavaMethod> addObjectMethodsToInterface(ClassSym owningInterface, Collection<JavaMethod> existingMethods) {
        JavaClass type;
        if (!owningInterface.getSourceInterfaces().isEmpty()) {
            return existingMethods;
        }
        JavaProvider provider = this.symFile.getProvider();
        JavaClass javaClass = type = provider == null ? null : provider.getClassByVMName("java/lang/Object");
        if (type == null) {
            return existingMethods;
        }
        ArrayList<JavaMethod> result = new ArrayList<JavaMethod>(existingMethods);
        Collection<JavaMethod> methods = type.getDeclaredMethods();
        block0: for (JavaMethod method : methods) {
            if (method.isConstructor() || !method.isPublic()) continue;
            String methodName = method.getName();
            JavaType[] types = method.getParameterTypes();
            for (JavaMethod existingMethod : existingMethods) {
                if (!methodName.equals(existingMethod.getName()) || !CommonUtilities.matchMethod(existingMethod, types)) continue;
                continue block0;
            }
            result.add(QuickMethod.createMethod(owningInterface, (char)(method.getModifiers() | 0x400 | 0x1000), method.getReturnType(), method.getName(), method.getParameters(), method.getExceptions()));
        }
        return result;
    }

    private Collection<JavaMethod> addRecordMethodsToRecord(ClassSym owningRecord, Collection<JavaMethod> existingMethods) {
        String name;
        if (!owningRecord.isRecord()) {
            return existingMethods;
        }
        ArrayList<JavaMethod> result = new ArrayList<JavaMethod>(existingMethods);
        block0: for (SourceRecordComponent component : owningRecord.getSourceRecordComponents()) {
            name = component.getName();
            for (JavaMethod existing : existingMethods) {
                if (!name.equals(existing.getName()) || !existing.getParameters().isEmpty()) continue;
                continue block0;
            }
            result.add(QuickMethod.createMethod(owningRecord, '\u1001', component.getResolvedType(), name, null, null));
        }
        block2: for (JavaMethod method : owningRecord.getSuperclass().getDeclaredMethods()) {
            if (method.isConstructor()) continue;
            name = method.getName();
            JavaType[] types = method.getParameterTypes();
            for (JavaMethod existing : existingMethods) {
                if (!name.equals(existing.getName()) || !CommonUtilities.matchMethod(existing, types)) continue;
                continue block2;
            }
            result.add(QuickMethod.createMethod(owningRecord, '\u1011', method.getResolvedType(), name, method.getParameters(), null));
        }
        return result;
    }

    private Collection<JavaMethod> addRecordConstructorToRecord(ClassSym owningRecord, Collection<JavaMethod> existingConstructors) {
        ArrayList<Object> result;
        if (!owningRecord.isRecord()) {
            return existingConstructors;
        }
        List<SourceRecordComponent> components = owningRecord.getSourceRecordComponents();
        if (!existingConstructors.isEmpty()) {
            JavaType[] recordFormalTypes = new JavaType[components.size()];
            for (int i = 0; i < components.size(); ++i) {
                recordFormalTypes[i] = components.get(i).getResolvedType();
            }
            for (JavaMethod existing : existingConstructors) {
                if (!CommonUtilities.matchMethod(existing, recordFormalTypes)) continue;
                return existingConstructors;
            }
            result = new ArrayList<JavaMethod>(existingConstructors);
        } else {
            result = new ArrayList(1);
        }
        char access = owningRecord.symAccess;
        access = (char)(access & 7);
        access = (char)(access | 0x1000);
        ArrayList<JavaVariable> parameters = new ArrayList<JavaVariable>(components.size());
        for (SourceRecordComponent component : components) {
            if (component.isVarargs()) {
                access = (char)(access | 0x80);
            }
            parameters.add(QuickLocalVariable.createLocalVariable(component, component.getName()));
        }
        result.add(QuickMethod.createMethod(owningRecord, access, null, "<init>", parameters, null));
        return result;
    }

    private Collection<JavaField> addRecordFieldsToRecord(ClassSym owningRecord, Collection<JavaField> existingFields) {
        ArrayList<JavaField> result = new ArrayList<JavaField>(existingFields);
        block0: for (SourceRecordComponent component : owningRecord.getSourceRecordComponents()) {
            String name = component.getName();
            for (JavaField existing : existingFields) {
                if (!name.equals(existing.getName())) continue;
                continue block0;
            }
            result.add(QuickField.createField((JavaClass)owningRecord, '\u1012', component.getResolvedType(), name));
        }
        return result;
    }

    private Collection<JavaField> addEnumFieldsToEnum(ClassSym owningEnum, Collection<JavaField> existingFields) {
        ArrayList<JavaField> result = new ArrayList<JavaField>();
        for (SourceEnumConstant constant : owningEnum.getSourceEnumConstants()) {
            result.add(constant);
        }
        block1: for (JavaField existing : existingFields) {
            String name = existing.getName();
            for (JavaField field : result) {
                if (!name.equals(field.getName())) continue;
                continue block1;
            }
            result.add(existing);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        if (compiler.skipCompilations()) {
            return super.compileImpl(compiler);
        }
        HashMap<ChildKind, List<Sym>> children = new HashMap<ChildKind, List<Sym>>();
        int count = this.getChildCount(458752);
        for (int i = 0; i < count; ++i) {
            Sym child = this.getNthChild(i);
            if (child == null) continue;
            ChildKind target = switch (child.symKind) {
                case 6 -> ChildKind.CONSTRUCTOR;
                case 9 -> {
                    if (child.isStatic()) {
                        if (child.isFinal()) {
                            yield ChildKind.STATIC_FINAL_FIELD;
                        }
                        yield ChildKind.STATIC_FIELD;
                    }
                    if (child.isFinal()) {
                        yield ChildKind.FINAL_FIELD;
                    }
                    yield ChildKind.FIELD;
                }
                case 5 -> {
                    if (child.isStatic()) {
                        yield ChildKind.STATIC_INITIALIZER;
                    }
                    yield ChildKind.INITIALIZER;
                }
                default -> ChildKind.OTHER;
            };
            ArrayList<Sym> mappedChildren = (ArrayList<Sym>)children.get((Object)target);
            if (mappedChildren == null) {
                mappedChildren = new ArrayList<Sym>();
                children.put(target, mappedChildren);
            }
            mappedChildren.add(child);
        }
        this.reorderConstructors((List)children.get((Object)ChildKind.CONSTRUCTOR));
        Sym parentSym = this.getParentSym();
        ClassSym classSym = null;
        if (parentSym != null && parentSym.symKind == 3) {
            classSym = (ClassSym)parentSym;
        }
        this.compile(ChildKind.STATIC_FINAL_FIELD, children, compiler);
        this.compile(ChildKind.STATIC_FIELD, children, compiler);
        this.compile(ChildKind.FINAL_FIELD, children, compiler);
        this.compile(ChildKind.FIELD, children, compiler);
        if (classSym != null) {
            compiler.startStaticInitializersFlowAnalysis(classSym);
        }
        try {
            this.compile(ChildKind.STATIC_INITIALIZER, children, compiler);
        }
        finally {
            if (classSym != null) {
                compiler.endStaticInitializersFlowAnalysis(classSym);
            }
        }
        this.compile(ChildKind.INITIALIZER, children, compiler);
        if (classSym != null) {
            compiler.startConstructorsFlowAnalysis(classSym);
        }
        try {
            this.compile(ChildKind.CONSTRUCTOR, children, compiler);
        }
        finally {
            if (classSym != null) {
                compiler.endConstructorsFlowAnalysis(classSym);
            }
        }
        this.compile(ChildKind.OTHER, children, compiler);
        return compiler.compile(this);
    }

    private void compile(ChildKind kind, Map<ChildKind, List<Sym>> children, CompilerDriver compiler) {
        List<Sym> syms = children.get((Object)kind);
        if (syms != null) {
            for (Sym sym : syms) {
                sym.compile(compiler);
            }
        }
    }

    private void reorderConstructors(List<Sym> constructors) {
        if (constructors == null) {
            return;
        }
        LinkedHashMap<Sym, SourceElement> map = new LinkedHashMap<Sym, SourceElement>();
        for (Sym constructor : constructors) {
            SourceMethod sourceMethod;
            SourceMethodCallExpression methodCall;
            JavaMethod javaMethod;
            SourceExpression expr;
            SourceElement firstStmt;
            List<SourceElement> codeElements;
            SourceBlock block = ((SourceMethod)((Object)constructor)).getBlock();
            if (block != null && (codeElements = block.getCodeElements()).size() != 0 && (firstStmt = codeElements.get(0)).getSymbolKind() == 55 && (expr = ((SourceExpressionStatement)firstStmt).getExpression()) != null && expr.getSymbolKind() == 73 && (javaMethod = (methodCall = (SourceMethodCallExpression)expr).getResolvedMethod()) != null && javaMethod.isConstructor() && ((JavaClass)javaMethod.getOwner()).getDescriptor().equals(((JavaClass)constructor.getOwner()).getDescriptor()) && (sourceMethod = javaMethod.getSourceElement()) != null) {
                map.put(constructor, sourceMethod);
                continue;
            }
            map.put(constructor, constructor);
        }
        constructors.clear();
        while (!map.isEmpty()) {
            int size = map.size();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getKey() != entry.getValue() && !constructors.contains(entry.getValue())) continue;
                constructors.add((Sym)entry.getKey());
                iterator.remove();
            }
            if (size != map.size()) continue;
            constructors.addAll(map.keySet());
            break;
        }
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    private static enum ChildKind {
        CONSTRUCTOR,
        FIELD,
        FINAL_FIELD,
        INITIALIZER,
        OTHER,
        STATIC_FIELD,
        STATIC_FINAL_FIELD,
        STATIC_INITIALIZER;

    }
}

