/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectBinding;
import oracle.javatools.parser.java.v2.internal.symbol.SwitchStatementGroupSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.InfixExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.DoStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ForStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.IfStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.Stmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.WhileStmt;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceSwitchElement;
import oracle.javatools.parser.java.v2.model.SourceSwitchStatementGroup;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.pattern.SourceBindingPattern;

public class BindingPatternSym
extends LocalVariableSym
implements SourceBindingPattern {
    private int[][] visible = null;

    @Override
    public boolean isVisible(int tokenIndex) {
        if (this.visible == null) {
            this.computeVariableVisibility();
        }
        for (int[] pair : this.visible) {
            if (tokenIndex < pair[0] || tokenIndex > pair[1]) continue;
            return true;
        }
        return false;
    }

    @Override
    public SourceExpression getInitializer() {
        Sym parent = this.getParentSym();
        if (parent.symKind != 70) {
            return null;
        }
        if (((InfixExpr)parent).getOperatorCode() != 23) {
            return null;
        }
        return ((InfixExpr)parent).getOperandAt(0);
    }

    @Override
    public SourceBindingPattern getSourceElement() {
        return this;
    }

    @Override
    protected boolean isValidAccess(char access) {
        int allowed = 16;
        return super.isValidAccess((char)(access & ~allowed));
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        return symKind == 27 || symKind == 20;
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        JavaElement result = super.compileImpl(compiler);
        if (!compiler.skipCompilations()) {
            compiler.declareBindingPatternFlowAnalysis(this, this.getInitializer());
        }
        return result;
    }

    private void computeVariableVisibility() {
        BlockSym enclosingBlock = this.getOwningBlockSym();
        this.visible = new int[0][];
        boolean negated = false;
        boolean trueBranch = true;
        boolean falseBranch = false;
        Sym lastExpression = this.getParentSym();
        Sym parent = lastExpression.getParentSym();
        while (parent instanceof Expr) {
            Expr e = (Expr)parent;
            block0 : switch (e.symKind) {
                case 81: {
                    break;
                }
                case 80: {
                    negated = !negated;
                    trueBranch = !trueBranch;
                    falseBranch = !falseBranch;
                    break;
                }
                case 70: {
                    switch (e.getOperatorCode()) {
                        case 3: {
                            int index = e.getOperands().indexOf(lastExpression);
                            if (index < 0) {
                                return;
                            }
                            int lastIndex = e.getOperandCount() - 1;
                            if (index >= lastIndex) break block0;
                            this.addRange(e.getNthOperandSym(index + 1), e.getNthOperandSym(lastIndex), enclosingBlock);
                            break;
                        }
                        case 43: {
                            int index = e.getOperands().indexOf(lastExpression);
                            if (index < 0) {
                                return;
                            }
                            int lastIndex = e.getOperandCount() - 1;
                            if (negated && index < lastIndex) {
                                this.addRange(e.getNthOperandSym(index + 1), e.getNthOperandSym(lastIndex), enclosingBlock);
                                break;
                            }
                            trueBranch = false;
                        }
                    }
                    break;
                }
                case 76: {
                    if (lastExpression != e.getOperandAt(0)) break;
                    Expr operand = e.getNthOperandSym(negated ? 2 : 1);
                    this.addRange(operand, enclosingBlock);
                }
            }
            lastExpression = e;
            parent = lastExpression.getParentSym();
        }
        switch (parent.symKind) {
            case 58: {
                BlockSym block;
                Sym statement;
                Stmt elseStatement;
                IfStmt ifStatement = (IfStmt)parent;
                Stmt thenStatement = (Stmt)ifStatement.getChild((byte)107);
                if (thenStatement == null || (elseStatement = (Stmt)ifStatement.getNthChild((byte)107, 1)) != null && (elseStatement = (Stmt)elseStatement.getSym((byte)107, new byte[0])) == null) break;
                if (negated) {
                    if (elseStatement != null) {
                        this.addRange(elseStatement, enclosingBlock);
                    }
                    statement = thenStatement;
                    if (thenStatement.symKind == 48) {
                        block = thenStatement.getBlockSym();
                        statement = block.getLastChild((byte)107);
                    }
                    switch (statement.symKind) {
                        case 49: 
                        case 51: 
                        case 59: 
                        case 62: {
                            this.addRange(ifStatement.symEnd + 1, enclosingBlock.symEnd, enclosingBlock);
                        }
                    }
                    break;
                }
                if (!trueBranch) break;
                this.addRange(thenStatement, enclosingBlock);
                if (elseStatement == null) break;
                statement = elseStatement;
                if (elseStatement.symKind == 48) {
                    block = elseStatement.getBlockSym();
                    statement = block.getLastChild((byte)107);
                }
                switch (statement.symKind) {
                    case 49: 
                    case 51: 
                    case 59: 
                    case 62: {
                        this.addRange(ifStatement.symEnd + 1, enclosingBlock.symEnd, enclosingBlock);
                    }
                }
                break;
            }
            case 64: {
                WhileStmt whileStatement = (WhileStmt)parent;
                Stmt statement = (Stmt)whileStatement.getNthChild(1);
                BlockSym block = statement.getBlockSym();
                if (negated) {
                    this.addRange(statement.symEnd + 1, enclosingBlock.symEnd, enclosingBlock);
                    break;
                }
                if (block != null) {
                    this.addRange(block, block);
                    break;
                }
                this.addRange(statement, enclosingBlock);
                break;
            }
            case 57: {
                ForStmt forStatement = (ForStmt)parent;
                Expr conditional = forStatement.getConditionalSym();
                if (conditional != lastExpression) break;
                BlockSym block = (BlockSym)forStatement.getSym((byte)48, 2);
                if (negated) {
                    this.addRange(forStatement.symEnd + 1, enclosingBlock.symEnd, enclosingBlock);
                    break;
                }
                ListExpr updates = forStatement.getUpdatesSym();
                if (updates != null) {
                    this.addRange(updates, enclosingBlock);
                }
                if (block != null) {
                    this.addRange(block, block);
                    break;
                }
                this.addRange(forStatement, enclosingBlock);
                break;
            }
            case 52: {
                DoStmt doStatement = (DoStmt)parent;
                Stmt statement = (Stmt)doStatement.getNthChild(0);
                if (!negated) break;
                this.addRange(statement.symEnd + 1, enclosingBlock.symEnd, enclosingBlock);
            }
        }
        SourceSwitchElement sse = null;
        Object block = enclosingBlock.getParent();
        if (block instanceof SourceSwitchElement) {
            SourceSwitchElement e;
            sse = e = (SourceSwitchElement)block;
        }
        if ((block = enclosingBlock.getParent().getParent()) instanceof SourceSwitchElement) {
            SourceSwitchElement e;
            sse = e = (SourceSwitchElement)block;
        }
        if (sse == null || sse.hasRules()) {
            return;
        }
        SwitchStatementGroupSym containingGroup = null;
        for (SourceSwitchStatementGroup group : sse.getStatementGroups()) {
            containingGroup = (SwitchStatementGroupSym)group;
            if (containingGroup.symEnd <= this.symStart) continue;
            break;
        }
        int lastIndex = containingGroup.symEnd;
        for (int[] pair : this.visible) {
            if (pair[0] > lastIndex) {
                pair[0] = lastIndex;
            }
            if (pair[1] <= lastIndex) continue;
            pair[1] = lastIndex;
        }
    }

    private void updateNestedBlock(BlockSym nestedBlock) {
        ObjectBinding binding = (ObjectBinding)nestedBlock.getInternalBinding(24);
        if (binding == null) {
            nestedBlock.setInternalBinding(new ObjectBinding<ArrayList<BindingPatternSym>>(24, new ArrayList<BindingPatternSym>(Collections.singletonList(this))));
        } else {
            ((List)binding.getObject()).add(this);
        }
        nestedBlock.clearLocalsCache();
    }

    void addRange(Sym sym, BlockSym block) {
        this.addRange(sym, sym, block);
    }

    void addRange(Sym startSym, Sym endSym, BlockSym block) {
        int start = startSym.symStart;
        int end = endSym.symEnd;
        this.addRange(start, end, block);
    }

    private void addRange(int start, int end, BlockSym block) {
        assert (block.symStart <= start) : " block start greater than pattern start";
        assert (block.symEnd >= start) : " block end less than pattern end";
        int length = this.visible.length;
        int[][] nArrayArray = new int[length + 1][];
        this.visible = nArrayArray;
        System.arraycopy(this.visible, 0, nArrayArray, 0, length);
        this.visible[length] = new int[]{start, end};
        this.updateNestedBlock(block);
    }
}

