/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.compiler.CallerContextImpl;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer1;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TypeArgumentSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ForStmt;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.util.Conversions;

abstract class CompilerLayer2
extends CompilerLayer1 {
    CompilerLayer2() {
    }

    protected abstract JavaType processInnerCreatorType(Expr var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaType resolve(TypeSym typeSym) {
        if (typeSym == null) {
            return null;
        }
        if ((typeSym.getObjectFlags() & 0x80) != 0) {
            return null;
        }
        char flags = typeSym.getObjectFlags();
        flags = (char)(flags | 0x80);
        typeSym.setObjectFlags(flags);
        try {
            JavaType javaType = this.resolveImpl(typeSym);
            return javaType;
        }
        finally {
            flags = typeSym.getObjectFlags();
            flags = (char)(flags & 0xFFFFFF7F);
            typeSym.setObjectFlags(flags);
        }
    }

    protected boolean isIterable(JavaType javaType) {
        return javaType != null && javaType.isInterface() && "java.lang.Iterable".equals(javaType.getRawName());
    }

    protected JavaType getEnhancedLoopElementType(ForStmt forStmt) {
        JavaType collectionType;
        JavaType elementType = null;
        Expr collectionSym = forStmt.getCollectionSym();
        if (collectionSym != null && (collectionType = collectionSym.getResolvedType()) != null) {
            if (collectionType.isArray()) {
                elementType = collectionType.getComponentType();
            } else {
                JavaType iterable = null;
                if (this.isIterable(collectionType)) {
                    iterable = collectionType;
                } else {
                    Set<JavaType> parents = collectionType.getHierarchy();
                    for (JavaType parent : parents) {
                        if (!this.isIterable(parent)) continue;
                        iterable = parent;
                        break;
                    }
                }
                if (iterable == null) {
                    this.error(collectionSym, (short)98);
                } else {
                    Collection<JavaType> actualTypeArguments = iterable.getActualTypeArguments();
                    if (actualTypeArguments.size() > 0) {
                        elementType = actualTypeArguments.iterator().next();
                    }
                    if (elementType == null) {
                        elementType = this.getPreloadedClass((byte)4);
                    }
                }
            }
        }
        return elementType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private JavaType resolveImpl(TypeSym typeSym) {
        result = null;
        isJdk10VarType = false;
        isJdk11LambdaVarType = false;
        token = typeSym.typeToken;
        if (96 <= token && token < 146) {
            result = PrimitiveType.PRIMITIVE_lookup[token - 96];
            if (result == null) {
                this.error(typeSym, (short)75, typeSym.getName());
                return null;
            }
        } else {
            name = typeSym.getName();
            if (name.length() == 0) {
                this.error(typeSym, (short)56);
                return null;
            }
            if (name.indexOf(46) > 0) {
                for (parent = typeSym.getParentSym(); parent != null; parent = parent.getParentSym()) {
                    if (parent.symKind != 3 || !name.equals((classSymParent = (ClassSym)parent).getRawName())) continue;
                    name = classSymParent.getName();
                    break;
                }
            }
            savedContext = this.getCompilerContext();
            try {
                context = this.newContext(typeSym);
                this.setCompilerContext(context);
                qualifyingTypeSym = typeSym.getTypeSym();
                qualifyingType = null;
                if (qualifyingTypeSym != null && (qualifyingType = qualifyingTypeSym.getResolvedType()) == null) {
                    var11_12 = null;
                    return var11_12;
                }
                v0 = isVarType = "var".equals(name) != false && null == qualifyingType;
                if (isVarType) {
                    parent = typeSym.getParentSym();
                    parentSymKind = parent.getSymbolKind();
                    if (this.jdkVersion.isGreaterThanOrEqualTo10() && (parentSymKind == 18 || parentSymKind == 17)) {
                        initializer = null;
                        if (parentSymKind == 18) {
                            locals = ((SourceLocalVariableDeclaration)parent).getVariables();
                            if (locals.size() == 1) {
                                grandParent = parent.getParentSym();
                                if (grandParent != null && grandParent.getSymbolKind() == 57 && ((SourceForStatement)grandParent).getForType() == 2) {
                                    result = this.getEnhancedLoopElementType((ForStmt)grandParent);
                                } else {
                                    initializer = locals.get(0).getInitializer();
                                }
                            }
                        } else if (parentSymKind == 17) {
                            grandParent = parent.getParentSym();
                            v1 = greatGrandParent = grandParent != null ? grandParent.getParentSym() : null;
                            if (greatGrandParent != null && greatGrandParent.getSymbolKind() == 57 && ((SourceForStatement)greatGrandParent).getForType() == 2) {
                                result = this.getEnhancedLoopElementType((ForStmt)greatGrandParent);
                            } else {
                                initializer = ((SourceLocalVariable)parent).getInitializer();
                            }
                        }
                        if (initializer != null) {
                            if (initializer != null && initializer.getExpressionCode() != 5) {
                                result = initializer.getResolvedType();
                            }
                            if (result != null && result.isPrimitive() && "null".equals(result.getRawName())) {
                                result = null;
                            }
                        }
                        if (result != null) {
                            isJdk10VarType = true;
                        }
                    } else if (this.jdkVersion.isGreaterThanOrEqualTo11() && parentSymKind == 31 && (result = this.getProvider().getClass("java.lang.Object")) != null) {
                        isJdk11LambdaVarType = true;
                    }
                }
                if (result == null) {
                    result = this.processType(qualifyingType, name);
                }
                if (result == null) {
                    this.error(typeSym, (short)75, name);
                    var12_15 = null;
                    return var12_15;
                }
                result.setQualifyingType(qualifyingType);
                if (!context.allowAccess(result)) {
                    this.error(typeSym, (short)63, result);
                    var12_15 = null;
                    return var12_15;
                }
            }
            finally {
                this.setCompilerContext(savedContext);
            }
        }
        if ((result = this.processTypeFilters(typeSym, result)) == null) {
            return null;
        }
        if (!isJdk10VarType && !isJdk11LambdaVarType) {
            if (typeSym.isGeneric()) {
                if (this.allowsTypeArguments(typeSym.getNameSym(), result)) {
                    arguments = typeSym.getTypeArguments();
                    savedContext = this.getCompilerContext();
                    try {
                        this.setCompilerContext(this.newContext(typeSym));
                        if (arguments.isEmpty()) {
                            result = CommonUtilities.createDiamondParameterizedType(this.provider, result);
                        }
                        resolvedTypeArguments = this.resolveTypeArguments(typeSym.getNameSym(), result, arguments);
                        if (resolvedTypeArguments == null || resolvedTypeArguments.length <= 0) ** GOTO lbl103
                        result = CommonUtilities.createParameterizedType(this.provider, result, resolvedTypeArguments);
                    }
                    finally {
                        this.setCompilerContext(savedContext);
                    }
                }
            } else if (result.hasTypeParameters()) {
                result = CommonUtilities.createTypeErasedClass(this.provider, result);
            }
        }
lbl103:
        // 9 sources

        if (result == null) {
            return null;
        }
        if (this.jdkVersion.isGreaterThanOrEqualTo8()) {
            sourceAnnotations = typeSym.getSourceAnnotations();
            if (sourceAnnotations.size() > 0) {
                annotations = new ArrayList<JavaAnnotation>(sourceAnnotations);
                result = CommonUtilities.createAnnotatedJavaType(result, annotations);
            } else if (result.getTypeAnnotations().size() > 0) {
                result = CommonUtilities.createAnnotatedJavaType(result, Collections.emptyList());
            }
        }
        arrayDimension = typeSym.getArrayDimension();
        dimensionTypeAnnotations = typeSym.getArrayDimensionsTypeAnnotations();
        if (!dimensionTypeAnnotations.isEmpty()) {
            javaTypeAnnotations = new ArrayList<List<JavaAnnotation>>();
            for (List<SourceAnnotation> dimensionTypeAnnotationList : dimensionTypeAnnotations) {
                annotationTypes = new ArrayList<SourceAnnotation>();
                for (SourceAnnotation dimensionTypeAnnotation : dimensionTypeAnnotationList) {
                    if (!CommonUtilities.isTypeUseAnnotation(dimensionTypeAnnotation, false)) continue;
                    annotationTypes.add(dimensionTypeAnnotation);
                }
                javaTypeAnnotations.add(annotationTypes);
            }
            return CommonUtilities.createArrayType(this.provider, result, arrayDimension, javaTypeAnnotations);
        }
        if (result.getElementKind() == 10 && arrayDimension > 0) {
            return CommonUtilities.createArrayType(this.provider, result, arrayDimension);
        }
        return this.provider.getArrayType(result, arrayDimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void compile(TypeSym typeSym) {
        List<SourceTypeArgument> arguments;
        assert (!this.skipCompilations());
        if (typeSym == null) {
            return;
        }
        JavaType type = typeSym.getResolvedType();
        if (type == null) {
            return;
        }
        if (typeSym.isGeneric() && !(arguments = typeSym.getTypeArguments()).isEmpty()) {
            CompilerContext savedContext = this.getCompilerContext();
            try {
                this.setCompilerContext(this.newContext(typeSym));
                if (type.isArray()) {
                    type = type.getBaseComponentType();
                }
                if (type != null) {
                    this.checkTypeArguments(type);
                }
            }
            finally {
                this.setCompilerContext(savedContext);
            }
        }
    }

    public final JavaType resolve(TypeArgumentSym sym) {
        byte bound = sym.argBound;
        if (bound != 3) {
            JavaType type;
            TypeSym typeSym = sym.getTypeSym();
            if (typeSym != null && (type = typeSym.getResolvedType()) != null) {
                type = CommonUtilities.createWildcardType(bound, type, this.provider);
                List<SourceAnnotation> sourceAnnotations = sym.getSourceAnnotations();
                if (sourceAnnotations.isEmpty()) {
                    return type;
                }
                ArrayList<JavaAnnotation> javaAnnotations = new ArrayList<JavaAnnotation>(sourceAnnotations);
                return CommonUtilities.createAnnotatedJavaType(type, javaAnnotations);
            }
            return null;
        }
        return CommonUtilities.createWildcardType((byte)3, null, this.provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaType resolveType(Sym cookie, String name) {
        if (name.indexOf(91) >= 0 || name.indexOf(60) >= 0) {
            if (cookie == null) {
                return null;
            }
            SymFactory symFactory = cookie.symFile.getSymFactory();
            TypeSym typeSym = (TypeSym)symFactory.createTypeFromText(name);
            if (typeSym == null) {
                return null;
            }
            CallerContextImpl callerContext = (CallerContextImpl)CallerContext.createContext(cookie, false);
            typeSym.setContext(callerContext);
            return typeSym.getResolvedType();
        }
        PrimitiveType primitive = PrimitiveType.lookupPrimitive(name);
        if (primitive != null) {
            return primitive;
        }
        CompilerContext savedContext = this.getCompilerContext();
        try {
            this.setCompilerContext(this.newContext(cookie));
            JavaType javaType = this.processType(null, name);
            return javaType;
        }
        finally {
            this.setCompilerContext(savedContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JavaType resolveType(Sym cookie, JavaType lhs, String name) {
        if (lhs == null) {
            return null;
        }
        CompilerContext savedContext = this.getCompilerContext();
        try {
            CompilerContext context = this.newContext(cookie);
            this.setCompilerContext(context);
            if (!context.allowAccess(lhs)) {
                JavaType javaType = (JavaType)this.error(context.symCookie, (short)63, lhs);
                return javaType;
            }
            JavaClass javaClass = context.findMemberType(lhs, name);
            return javaClass;
        }
        finally {
            this.setCompilerContext(savedContext);
        }
    }

    private JavaType processType(JavaType qualifyingType, String name) {
        if (qualifyingType == null) {
            int firstDot = name.indexOf(46);
            JavaType out = firstDot == -1 ? this.processSimpleType(name) : this.processQualifiedType(name);
            return out;
        }
        return this.processMemberType(qualifyingType, name);
    }

    protected boolean allowsTypeArguments(Sym errorCookie, JavaIsGeneric type) {
        Collection<JavaTypeVariable> parameters = type.getTypeParameters();
        int parameterCount = parameters.size();
        if (parameterCount == 0) {
            this.error(errorCookie, (short)66, type);
            return false;
        }
        return true;
    }

    protected JavaType[] resolveTypeArguments(Sym errorCookie, JavaIsGeneric type, Collection arguments) {
        int argumentCount;
        if (!this.allowsTypeArguments(errorCookie, type)) {
            return new JavaType[0];
        }
        Collection<JavaTypeVariable> parameters = type.getTypeParameters();
        int parameterCount = parameters.size();
        if (parameterCount != (argumentCount = arguments.size())) {
            this.error(null, (short)73, type);
            return new JavaType[0];
        }
        JavaType[] array = new JavaType[argumentCount];
        Iterator argumentIterator = arguments.iterator();
        int i = 0;
        while (argumentIterator.hasNext()) {
            TypeArgumentSym sym = (TypeArgumentSym)argumentIterator.next();
            array[i++] = sym.getResolvedType();
        }
        return array;
    }

    protected void checkTypeArguments(JavaIsGeneric type) {
        if (this.skipCompilations()) {
            return;
        }
        Collection<JavaType> arguments = type.getActualTypeArguments();
        if (arguments == null || arguments.isEmpty()) {
            return;
        }
        Collection<JavaTypeVariable> parameters = type.getTypeParameters();
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        try {
            boolean success = true;
            Iterator<JavaTypeVariable> pIterator = parameters.iterator();
            Iterator<JavaType> aIterator = arguments.iterator();
            while (pIterator.hasNext() && success) {
                JavaType parameter = pIterator.next();
                JavaType argument = aIterator.next();
                if (argument == null) {
                    return;
                }
                if (parameter != null && Conversions.applyMethodConversion(argument, parameter, false, null, this.jdkVersion)) continue;
                success = false;
            }
            if (success) {
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.error(null, (short)73, type);
    }

    private JavaType processTypeFilters(TypeSym typeSym, JavaType target) {
        if (this.skipCompilations()) {
            return target;
        }
        Sym parentSym = typeSym.getParentSym();
        if (parentSym == null) {
            return target;
        }
        if (target.isPrimitive() || target.isArray()) {
            switch (parentSym.symKind) {
                case 24: {
                    this.error(typeSym, (short)67, target);
                    break;
                }
                case 15: 
                case 22: {
                    this.error(typeSym, (short)58, target);
                }
            }
        } else {
            switch (parentSym.symKind) {
                case 24: {
                    JavaClass javaLangThrowable = this.getPreloadedClass((byte)7);
                    if (target.isSubtypeOf(javaLangThrowable)) break;
                    return (JavaType)this.error(typeSym, (short)67, target);
                }
                case 22: {
                    if (target.isInterface()) {
                        return (JavaType)this.error(typeSym, (short)46, target);
                    }
                    if (target.isEnum()) {
                        return (JavaType)this.error(typeSym, (short)44, target);
                    }
                    if (!Modifier.isFinal(target.getModifiers())) break;
                    return (JavaType)this.error(typeSym, (short)45, target);
                }
                case 15: {
                    if (target.isInterface()) break;
                    return (JavaType)this.error(typeSym, (short)47, target);
                }
            }
        }
        return target;
    }

    private JavaType processSimpleType(String name) {
        ClassCreatorExpr e;
        Expr lhs;
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return null;
        }
        Sym cookie = context.symCookie;
        Sym parent = cookie.getParentSym();
        if (parent != null && parent.symKind == 75 && (lhs = (e = (ClassCreatorExpr)parent).getLhsOperandSym()) != null) {
            return this.processInnerCreatorType(lhs, name);
        }
        Sym scope = context.cleanAndInitializeScope();
        boolean allowMemberClasses = true;
        while (scope != null) {
            switch (scope.symKind) {
                case 3: {
                    ClassSym classSym = (ClassSym)scope;
                    if (allowMemberClasses && context.findVisibleType(classSym, name)) {
                        return context.findMemberType(classSym, name);
                    }
                    JavaType found = context.findType(scope, name);
                    if (found != null) {
                        return found;
                    }
                    allowMemberClasses = true;
                    break;
                }
                case 15: 
                case 22: {
                    allowMemberClasses = false;
                }
                default: {
                    JavaType found = context.findType(scope, name);
                    if (found == null) break;
                    return found;
                }
            }
            scope = context.nextScope();
        }
        context.cleanScope();
        return this.findImportedType(name);
    }

    private JavaType processQualifiedType(String name) {
        int dot = name.indexOf(46);
        String firstName = name.substring(0, dot);
        JavaType firstType = this.processSimpleType(firstName);
        if (firstType == null) {
            return this.provider.getClass(name);
        }
        return this.processMemberType(firstType, name.substring(dot + 1));
    }

    private JavaType processMemberType(JavaType qualifyingType, String name) {
        JavaType currentType = qualifyingType;
        int previousDot = -1;
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return currentType;
        }
        while (currentType != null) {
            if (!context.allowAccess(currentType)) {
                return (JavaType)this.error(context.symCookie, (short)63, currentType);
            }
            int nextDot = name.indexOf(46, previousDot + 1);
            String nextTarget = nextDot == -1 ? name.substring(previousDot + 1) : name.substring(previousDot + 1, nextDot);
            currentType = context.findMemberType(currentType, nextTarget);
            if (nextDot == -1) break;
            previousDot = nextDot;
        }
        return currentType;
    }

    protected final JavaType findImportedType(String name) {
        JavaType importedType;
        Map<String, JavaType> currentCache;
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return null;
        }
        Sym cookie = context.symCookie;
        FileSym file = cookie != null ? cookie.symFile : null;
        Map<String, JavaType> map = currentCache = file != null ? file.getImportedTypesCache() : null;
        if (currentCache != null && (importedType = currentCache.get(name)) != null) {
            return importedType;
        }
        importedType = this.findImportedTypeImpl(name);
        if (importedType == null) {
            importedType = context.findImportedType(name);
        }
        if (importedType != null && currentCache != null) {
            currentCache.put(name, importedType);
        }
        return importedType;
    }

    private JavaType findImportedTypeImpl(String name) {
        JavaClass javaClass;
        JavaClass found;
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return null;
        }
        FileSym sourceFile = context.symCookie.symFile;
        List<SourceImport> importSyms = sourceFile.getSourceImports();
        for (ImportSym importSym : importSyms) {
            ArrayList<JavaHasType> arrayList;
            String fqname;
            int lastDot;
            String importedName;
            if (!importSym.isNarrow() || !(importedName = (lastDot = (fqname = importSym.getName()).lastIndexOf(46)) == -1 ? fqname : fqname.substring(lastDot + 1)).equals(name)) continue;
            importSym.setUsed();
            if (importSym.isInvalid()) {
                return null;
            }
            importSym.resolve();
            if (!importSym.isStatic()) {
                return (JavaType)importSym.getImportedElementAt(0);
            }
            JavaClass result = this.provider.getClass(fqname);
            if (result != null && (arrayList = importSym.getImportObj().importList) != null && !arrayList.contains(result)) {
                arrayList.add(result);
            }
            return result;
        }
        String string = sourceFile.getPackageName();
        if (string.length() > 0 ? (found = this.provider.getClass(string, name)) != null : (found = this.provider.getClass(name)) != null) {
            return found;
        }
        ImportSym foundImport = null;
        JavaClass alreadyFound = null;
        boolean javaLangSearched = false;
        HashSet<String> importKeys = new HashSet<String>();
        for (ImportSym importSym : importSyms) {
            if (importSym.isNarrow() || importSym.isInvalid()) continue;
            String importName = importSym.getName();
            if ("java.lang.*".equals(importName)) {
                javaLangSearched = true;
            }
            if (importKeys.contains(importName)) continue;
            importKeys.add(importName);
            String prefix = importName.substring(0, importName.length() - 2);
            JavaClass foundClass2 = this.provider.getClass(prefix, name);
            if (foundClass2 == null) continue;
            if (alreadyFound != null) {
                boolean foundClassCanAccess = context.allowAccess(foundClass2);
                boolean alreadyFoundCanAccess = context.allowAccess(alreadyFound);
                if (foundClassCanAccess && alreadyFoundCanAccess) {
                    this.error(importSym, (short)40, name);
                    continue;
                }
                if (!foundClassCanAccess) continue;
                alreadyFound = foundClass2;
                foundImport = importSym;
                continue;
            }
            alreadyFound = foundClass2;
            foundImport = importSym;
        }
        if (!javaLangSearched && (javaClass = this.provider.getClass("java.lang", name)) != null) {
            if (alreadyFound == null) {
                alreadyFound = javaClass;
            } else {
                this.error(foundImport, (short)40, name);
            }
        }
        if (foundImport != null) {
            foundImport.setUsed();
            ArrayList<JavaHasType> arrayList = foundImport.getImportObj().importList;
            if (arrayList != null && !arrayList.contains(alreadyFound)) {
                arrayList.add(alreadyFound);
            }
        }
        return alreadyFound;
    }
}

