/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

class LiveUnresolvedType
extends QuickUnresolvedType {
    private final JavaType thing;

    LiveUnresolvedType(JavaType thing) {
        this.thing = thing;
    }

    @Override
    public String getSimplifiedName() {
        return this.thing.getName();
    }

    @Override
    public String toString() {
        return this.thing.getQualifiedName();
    }

    @Override
    public int getArrayDimensions() {
        return this.thing.getArrayDimensions();
    }

    @Override
    public Collection<UnresolvedType> getTypeArguments() {
        Collection<JavaType> actualTypeArguments = this.thing.getActualTypeArguments();
        ArrayList<UnresolvedType> unresolvedTypeArgs = new ArrayList<UnresolvedType>(actualTypeArguments.size());
        for (JavaType actualTypeArg : actualTypeArguments) {
            unresolvedTypeArgs.add(actualTypeArg.getUnresolvedType());
        }
        return unresolvedTypeArgs;
    }

    @Override
    public Collection<JavaAnnotation> getTypeAnnotations() {
        return this.thing.getTypeAnnotations();
    }

    @Override
    public Collection<JavaAnnotation> getBoundTypeAnnotations() {
        if (this.thing instanceof JavaWildcardType) {
            JavaWildcardType wildcard = (JavaWildcardType)this.thing;
            Collection<JavaType> upperBounds = wildcard.getUpperBounds();
            if (!upperBounds.isEmpty()) {
                return upperBounds.iterator().next().getTypeAnnotations();
            }
            Collection<JavaType> lowerBounds = wildcard.getLowerBounds();
            if (!lowerBounds.isEmpty()) {
                return lowerBounds.iterator().next().getTypeAnnotations();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public UnresolvedType getQualifyingType() {
        JavaType qualifyingType = this.thing.getQualifyingType();
        return qualifyingType != null ? qualifyingType.getUnresolvedType() : null;
    }

    @Override
    public UnresolvedType getComponentType() {
        JavaType componentType = this.thing.getComponentType();
        return componentType != null ? componentType.getUnresolvedType() : null;
    }

    @Override
    public UnresolvedType getBaseComponentType() {
        JavaType baseComponentType = this.thing.getBaseComponentType();
        return baseComponentType != null ? baseComponentType.getUnresolvedType() : null;
    }
}

