/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.html;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.html.EmbeddedLexer;
import oracle.javatools.parser.html.HTMLTokens;

public class HTMLLexer
extends EmbeddedLexer
implements HTMLTokens {
    private int lastToken = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private boolean useLastToken = false;
    private boolean skipComments = false;
    private boolean recognizeScripts = false;
    private boolean recognizeStyles = false;
    private boolean recognizePHP = false;
    private int caretPosition = -1;

    public HTMLLexer() {
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public void setSkipComments(boolean skipComments) {
        this.skipComments = skipComments;
    }

    public void setRecognizeScripts(boolean recognizeScripts) {
        this.recognizeScripts = recognizeScripts;
    }

    public void setRecognizeStyles(boolean recognizeStyles) {
        this.recognizeStyles = recognizeStyles;
    }

    @Deprecated
    public void setRecognizePHP(boolean recognizePHP) {
        this.recognizePHP = recognizePHP;
    }

    public void setCaretPosition(int caretPosition) {
        this.caretPosition = caretPosition;
    }

    @Override
    public int lex(LexerToken lexedToken) {
        int endTextOffset;
        block37: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexedToken);
            }
            int startTextOffset = -1;
            endTextOffset = -1;
            this.lastToken = 0;
            try {
                block14: while (true) {
                    char c = this.textBuffer.getChar(this.currentPos++);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            if (startTextOffset == -1) {
                                startTextOffset = this.currentPos - 1;
                            }
                            endTextOffset = this.currentPos;
                            continue block14;
                        }
                    }
                    this.startOffset = this.currentPos - 1;
                    block4 : switch (c) {
                        case '<': {
                            this.lastToken = 11;
                            char nc = this.textBuffer.getChar(this.currentPos);
                            if (nc != '!' && nc != '-' && nc != '%' && nc != '?' && nc != '/' && !Character.isLetter(nc) && this.currentPos != this.caretPosition) {
                                if (startTextOffset == -1) {
                                    startTextOffset = this.currentPos - 1;
                                }
                                endTextOffset = this.currentPos;
                                break;
                            }
                            if (startTextOffset != -1) {
                                this.lastToken = 15;
                                --this.currentPos;
                                this.startOffset = startTextOffset;
                                break block37;
                            }
                            this.lastToken = 11;
                            if (this.textBuffer.getChar(this.currentPos) == '!') {
                                ++this.currentPos;
                                this.lastToken = 15;
                                if (this.textBuffer.getChar(this.currentPos) == '-' && this.textBuffer.getChar(this.currentPos + 1) == '-') {
                                    this.currentPos += 2;
                                    this.lastToken = 12;
                                    this.skipHTMLComment();
                                    if (this.skipComments) {
                                        this.lastToken = 0;
                                        break;
                                    }
                                } else if (!(this.textBuffer.getChar(this.currentPos) != 'D' && this.textBuffer.getChar(this.currentPos) != 'd' || this.textBuffer.getChar(this.currentPos + 1) != 'O' && this.textBuffer.getChar(this.currentPos + 1) != 'o' || this.textBuffer.getChar(this.currentPos + 2) != 'C' && this.textBuffer.getChar(this.currentPos + 2) != 'c' || this.textBuffer.getChar(this.currentPos + 3) != 'T' && this.textBuffer.getChar(this.currentPos + 3) != 't' || this.textBuffer.getChar(this.currentPos + 4) != 'Y' && this.textBuffer.getChar(this.currentPos + 4) != 'y' || this.textBuffer.getChar(this.currentPos + 5) != 'P' && this.textBuffer.getChar(this.currentPos + 5) != 'p' || this.textBuffer.getChar(this.currentPos + 6) != 'E' && this.textBuffer.getChar(this.currentPos + 6) != 'e')) {
                                    this.lastToken = 16;
                                    this.skipDocumentType();
                                }
                                break block37;
                            }
                            if (this.recognizePHP && this.textBuffer.getChar(this.currentPos) == '?') {
                                ++this.currentPos;
                                this.lastToken = 31;
                                this.skipPHPTag();
                                break block37;
                            }
                            if (this.recognizePHP && this.textBuffer.getChar(this.currentPos) == '%') {
                                ++this.currentPos;
                                this.lastToken = 32;
                                this.skipPHPASPTag();
                                break block37;
                            }
                            if (this.textBuffer.getChar(this.currentPos) == '?') {
                                ++this.currentPos;
                                this.lastToken = 17;
                                this.skipProcessingInstruction();
                                break block37;
                            }
                            if (this.recognizeJSP && this.textBuffer.getChar(this.currentPos) == '%') {
                                ++this.currentPos;
                                this.lastToken = 22;
                                c = this.textBuffer.getChar(this.currentPos);
                                switch (c) {
                                    case '@': {
                                        this.lastToken = 21;
                                        this.skipJSPDirective();
                                        break;
                                    }
                                    case '!': {
                                        this.lastToken = 23;
                                        this.skipJSPScriplet();
                                        break;
                                    }
                                    case '=': {
                                        this.lastToken = 24;
                                        this.skipJSPScriplet();
                                        break;
                                    }
                                    case '-': {
                                        if (this.textBuffer.getChar(this.currentPos + 1) == '-') {
                                            this.currentPos += 2;
                                            this.lastToken = 25;
                                            this.skipJSPComment();
                                            if (this.skipComments) {
                                                this.lastToken = 0;
                                                break block4;
                                            }
                                            break block37;
                                        }
                                    }
                                    default: {
                                        this.skipJSPScriplet();
                                        break;
                                    }
                                }
                                break block37;
                            }
                            this.skipHTMLTag();
                            if (this.recognizeScripts && this.isScriptStart(this.startOffset, this.currentPos)) {
                                this.lastToken = 13;
                                this.skipScriptChunk();
                            }
                            if (this.recognizeStyles && this.isStyleStart(this.startOffset, this.currentPos)) {
                                this.lastToken = 14;
                                this.skipStyleChunk();
                            }
                            break block37;
                        }
                        default: {
                            if (startTextOffset == -1) {
                                startTextOffset = this.currentPos - 1;
                            }
                            endTextOffset = this.currentPos;
                            break;
                        }
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken == 0) {
                    if (startTextOffset != -1) {
                        this.lastToken = 15;
                        this.startOffset = startTextOffset;
                    } else {
                        this.startOffset = this.currentPos;
                    }
                }
                if (!this.skipComments || this.lastToken != 12 && this.lastToken != 25) break block37;
                this.lastToken = 0;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = endTextOffset == -1 ? this.currentPos : endTextOffset;
        this.useLastToken = false;
        return this.fillLexerToken(lexedToken);
    }

    @Override
    public void backup() {
        this.useLastToken = true;
    }

    @Override
    public void setPosition(int offset) {
        super.setPosition(offset);
        this.useLastToken = false;
    }

    private void skipToEndTag() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '<' || this.textBuffer.getChar(this.currentPos) != '/' || ('a' > (c = this.textBuffer.getChar(this.currentPos + 1)) || c > 'z') && ('A' > c || c > 'Z')) {
        }
        this.skipHTMLTag();
    }

    private void skipScriptChunk() {
        while (this.textBuffer.getChar(this.currentPos) != '<' || this.textBuffer.getChar(this.currentPos + 1) != '/') {
            ++this.currentPos;
            this.skipHTMLTag();
        }
        this.skipEndTag();
    }

    private boolean isScriptStart(int startOffset, int endOffset) {
        char c;
        if (endOffset - startOffset < 8) {
            return false;
        }
        int current = startOffset;
        if ((c = this.textBuffer.getChar(current++)) != '<') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 's' && c != 'S') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 'c' && c != 'C') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 'r' && c != 'R') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 'i' && c != 'I') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 'p' && c != 'P') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 't' && c != 'T') {
            return false;
        }
        return (c = this.textBuffer.getChar(current++)) == '>' || Character.isWhitespace(c);
    }

    private boolean isScriptEnd(int startOffset, int endOffset) {
        char c;
        if (endOffset - startOffset < 9) {
            return false;
        }
        int current = startOffset;
        if ((c = this.textBuffer.getChar(current++)) != '<') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != '/') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 's' && c != 'S') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 'c' && c != 'C') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 'r' && c != 'R') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 'i' && c != 'I') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 'p' && c != 'P') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 't' && c != 'T') {
            return false;
        }
        return (c = this.textBuffer.getChar(current++)) == '>';
    }

    private void skipStyleChunk() {
        while (this.textBuffer.getChar(this.currentPos) != '<' || this.textBuffer.getChar(this.currentPos + 1) != '/') {
            ++this.currentPos;
            this.skipHTMLTag();
        }
        this.skipEndTag();
    }

    private void skipEndTag() {
        if (this.textBuffer.getChar(this.currentPos) == '<') {
            int c = 32;
            if (this.textBuffer.getChar(++this.currentPos) == '/') {
                while (97 <= (c = (int)this.textBuffer.getChar(++this.currentPos)) && c <= 122 || 65 <= c && c <= 90) {
                }
            }
            if (c == 62 || c == 60) {
                ++this.currentPos;
            }
        }
    }

    private boolean isStyleStart(int startOffset, int endOffset) {
        char c;
        if (endOffset - startOffset < 7) {
            return false;
        }
        int current = startOffset;
        if ((c = this.textBuffer.getChar(current++)) != '<') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 's' && c != 'S') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 't' && c != 'T') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 'y' && c != 'Y') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 'l' && c != 'L') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 'e' && c != 'E') {
            return false;
        }
        return (c = this.textBuffer.getChar(current++)) == '>' || Character.isWhitespace(c);
    }

    private boolean isStyleEnd(int startOffset, int endOffset) {
        char c;
        if (endOffset - startOffset < 8) {
            return false;
        }
        int current = startOffset;
        if ((c = this.textBuffer.getChar(current++)) != '<') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != '/') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 's' && c != 'S') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 't' && c != 'T') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 'y' && c != 'Y') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 'l' && c != 'L') {
            return false;
        }
        if ((c = this.textBuffer.getChar(current++)) != 'e' && c != 'E') {
            return false;
        }
        return (c = this.textBuffer.getChar(current++)) == '>';
    }

    private void skipHTMLComment() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '-' || this.textBuffer.getChar(this.currentPos) != '-' || this.textBuffer.getChar(this.currentPos + 1) != '>') {
        }
        this.currentPos += 2;
    }

    private void skipDocumentType() {
        this.currentPos += 7;
        char quote = '\u0000';
        boolean inBracket = false;
        block7: while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\"': 
                case '\'': {
                    if (quote != '\u0000') {
                        if (quote != c) continue block7;
                        quote = '\u0000';
                        continue block7;
                    }
                    quote = c;
                    continue block7;
                }
                case '[': {
                    if (quote != '\u0000') continue block7;
                    inBracket = true;
                    continue block7;
                }
                case ']': {
                    if (quote != '\u0000') continue block7;
                    inBracket = false;
                    continue block7;
                }
                case '>': {
                    if (quote != '\u0000' || inBracket) continue block7;
                    return;
                }
                case '<': {
                    if (inBracket) continue block7;
                    --this.currentPos;
                    return;
                }
            }
        }
    }

    private void skipProcessingInstruction() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '>') {
            if (c != '?' || this.textBuffer.getChar(this.currentPos) != '>') continue;
            ++this.currentPos;
            break;
        }
    }

    private void skipJSPComment() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '-' || this.textBuffer.getChar(this.currentPos) != '-' || this.textBuffer.getChar(this.currentPos + 1) != '%' || this.textBuffer.getChar(this.currentPos + 2) != '>') {
        }
        this.currentPos += 3;
    }

    private void skipJSPDirective() {
        char quote = '\u0000';
        while (true) {
            char c;
            if ((c = this.textBuffer.getChar(this.currentPos++)) == '\\') {
                ++this.currentPos;
                continue;
            }
            if (quote != '\u0000') {
                if (quote != c) continue;
                quote = '\u0000';
                continue;
            }
            if (c == '\"' || c == '\'') {
                quote = c;
                continue;
            }
            if (c == '%' && (c = this.textBuffer.getChar(this.currentPos)) == '>') break;
        }
        ++this.currentPos;
    }

    protected void skipPHPTag() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '?' || (c = this.textBuffer.getChar(this.currentPos)) != '>') {
        }
        ++this.currentPos;
    }

    protected void skipPHPASPTag() {
        this.skipJSPScriplet();
    }

    private int fillLexerToken(LexerToken lexedToken) {
        AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        outToken.setToken(this.lastToken);
        outToken.setStartOffset(this.startOffset);
        outToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static String tokenToString(int token) {
        switch (token) {
            case 11: {
                return "TK_HTML_TAG";
            }
            case 12: {
                return "TK_HTML_COMMENT";
            }
            case 15: {
                return "TK_HTML_TEXT";
            }
            case 16: {
                return "TK_HTML_DOCUMENT_TYPE";
            }
            case 17: {
                return "TK_HTML_PROCESSING_INSTRUCTION";
            }
            case 13: {
                return "TK_HTML_SCRIPT";
            }
            case 14: {
                return "TK_HTML_STYLE";
            }
            case 21: {
                return "TK_JSP_DIRECTIVE";
            }
            case 22: {
                return "TK_JSP_SCRIPLET";
            }
            case 23: {
                return "TK_JSP_DECLARATION";
            }
            case 24: {
                return "TK_JSP_EXPRESSION";
            }
            case 25: {
                return "TK_JSP_COMMENT";
            }
            case 31: {
                return "TK_PHP_TAG";
            }
            case 32: {
                return "TK_PHP_ASPTAG";
            }
        }
        return "**UNKNOWN**";
    }

    public static String tokenToText(int token) {
        switch (token) {
            case 11: {
                return "HTML Tag";
            }
            case 12: {
                return "HTML Comment";
            }
            case 15: {
                return "HTML Text";
            }
            case 16: {
                return "HTML Document Type";
            }
            case 17: {
                return "HTML Processing Instruction";
            }
            case 13: {
                return "HTML Script";
            }
            case 14: {
                return "HTML Style";
            }
            case 21: {
                return "JSP Directive";
            }
            case 22: {
                return "JSP Scriplet";
            }
            case 23: {
                return "JSP Declaration";
            }
            case 24: {
                return "JSP Expression";
            }
            case 25: {
                return "JSP Comment";
            }
            case 31: {
                return "PHP Tag";
            }
            case 32: {
                return "PHP ASP Tag";
            }
        }
        return "**UNKNOWN**";
    }
}

