/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.filesystem;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import oracle.javatools.util.PlatformUtils;

public final class PathImpl
implements Path {
    protected FileSystem fileSystem;
    private String path;
    private long creationTime;
    private long lastModifiedTime;
    private long lastAccessTime;
    private boolean isWindows;

    public PathImpl(FileSystem fileSystem, String first, String ... more) {
        int x;
        if (fileSystem == null || first == null) {
            throw new IllegalArgumentException("Null Arguments");
        }
        this.fileSystem = fileSystem;
        StringBuilder buf = new StringBuilder();
        buf.append(first.replace('\\', '/'));
        for (x = 0; more != null && x < more.length; ++x) {
            buf.append(more[x].replace('\\', '/'));
        }
        x = 0;
        while (x < buf.length()) {
            if (buf.charAt(x) == '/' && x < buf.length() - 1 && buf.charAt(x + 1) == '/') {
                buf.deleteCharAt(x);
                continue;
            }
            ++x;
        }
        this.path = buf.toString();
        this.lastModifiedTime = this.creationTime = System.currentTimeMillis();
        this.lastAccessTime = this.creationTime;
        this.isWindows = PlatformUtils.isWindows();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        if (this.isWindows) {
            if (this.path.length() > 2 && this.path.charAt(1) == ':' && this.path.charAt(2) == '/') {
                char c = Character.toLowerCase(this.path.charAt(0));
                return c >= 'a' && c <= 'z';
            }
            return false;
        }
        return this.path.startsWith("/");
    }

    @Override
    public PathImpl getRoot() {
        if (this.isAbsolute()) {
            return this.isWindows ? new PathImpl(this.fileSystem, this.path.substring(0, 3), new String[0]) : new PathImpl(this.fileSystem, "/", new String[0]);
        }
        return null;
    }

    @Override
    public PathImpl getFileName() {
        int index;
        if (this.getNameCount() <= 0) {
            return null;
        }
        String currentPath = this.path;
        if (this.isDirectory()) {
            currentPath = currentPath.substring(0, currentPath.length() - 1);
        }
        if ((index = currentPath.lastIndexOf(47)) < 0) {
            return new PathImpl(this.fileSystem, currentPath, new String[0]);
        }
        return new PathImpl(this.fileSystem, currentPath.substring(index + 1), new String[0]);
    }

    @Override
    public PathImpl getParent() {
        int index;
        if (this.getNameCount() <= 0) {
            return null;
        }
        String currentPath = this.path;
        if (this.isDirectory()) {
            currentPath = currentPath.substring(0, currentPath.length() - 1);
        }
        if ((index = currentPath.lastIndexOf(47)) < 0) {
            return null;
        }
        return new PathImpl(this.fileSystem, currentPath.substring(0, index + 1), new String[0]);
    }

    @Override
    public int getNameCount() {
        int count = 0;
        for (int x = 0; x < this.path.length(); ++x) {
            if (this.path.charAt(x) != '/') continue;
            ++count;
        }
        if (this.isAbsolute()) {
            --count;
        }
        if (this.isDirectory()) {
            --count;
        }
        return ++count;
    }

    @Override
    public PathImpl getName(int index) {
        if (index < 0 || index >= this.getNameCount()) {
            throw new IllegalArgumentException();
        }
        int begin = this.isWindows ? (this.isAbsolute() ? 3 : (this.path.startsWith("/") ? 1 : 0)) : (this.isAbsolute() ? 1 : 0);
        int end = this.path.indexOf(47, begin);
        while (index > 0) {
            begin = end + 1;
            end = this.path.indexOf(47, begin);
            --index;
        }
        return new PathImpl(this.fileSystem, end < 0 ? this.path.substring(begin) : this.path.substring(begin, end), new String[0]);
    }

    @Override
    public PathImpl subpath(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex >= endIndex || endIndex > this.getNameCount()) {
            throw new IllegalArgumentException();
        }
        int begin = this.isWindows ? (this.isAbsolute() ? 3 : (this.path.startsWith("/") ? 1 : 0)) : (this.isAbsolute() ? 1 : 0);
        int middle = begin;
        int end = -1;
        for (int index = 0; index < endIndex; ++index) {
            end = this.path.indexOf(47, middle);
            if (end > 0) {
                middle = end + 1;
            }
            if (index >= beginIndex) continue;
            begin = middle;
        }
        return new PathImpl(this.fileSystem, end < 0 ? this.path.substring(begin) : this.path.substring(begin, end + 1), new String[0]);
    }

    @Override
    public boolean startsWith(Path other) {
        String thisPath;
        if (!(other instanceof PathImpl)) {
            return false;
        }
        PathImpl otherBufferPath = (PathImpl)other;
        String otherPath = otherBufferPath.path;
        if (this.isWindows) {
            otherPath = otherPath.toLowerCase();
        }
        String string = thisPath = this.isWindows ? this.path.toLowerCase() : this.path;
        if (thisPath.startsWith(otherPath)) {
            if (otherBufferPath.isDirectory()) {
                return true;
            }
            if (thisPath.equals(otherPath)) {
                return true;
            }
            return thisPath.startsWith(otherPath + "/");
        }
        return false;
    }

    @Override
    public boolean startsWith(String other) {
        return this.startsWith(new PathImpl(this.fileSystem, other, new String[0]));
    }

    @Override
    public boolean endsWith(Path other) {
        String thisPath;
        if (!(other instanceof PathImpl)) {
            return false;
        }
        PathImpl otherBufferPath = (PathImpl)other;
        String otherPath = otherBufferPath.path;
        if (this.isWindows) {
            otherPath = otherPath.toLowerCase();
        }
        String string = thisPath = this.isWindows ? this.path.toLowerCase() : this.path;
        if (thisPath.endsWith(otherPath)) {
            if (otherPath.startsWith("/")) {
                return true;
            }
            if (thisPath.equals(otherPath)) {
                return true;
            }
            return thisPath.endsWith("/" + otherPath);
        }
        return false;
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(new PathImpl(this.fileSystem, other, new String[0]));
    }

    @Override
    public PathImpl normalize() {
        return this;
    }

    @Override
    public PathImpl resolve(Path other) {
        if (!(other instanceof PathImpl)) {
            return null;
        }
        if (other.isAbsolute()) {
            return (PathImpl)other;
        }
        if (!this.isDirectory()) {
            throw new IllegalStateException();
        }
        return new PathImpl(this.fileSystem, this.path + ((PathImpl)other).path, new String[0]);
    }

    @Override
    public PathImpl resolve(String other) {
        return this.resolve(new PathImpl(this.fileSystem, other, new String[0]));
    }

    @Override
    public PathImpl resolveSibling(Path other) {
        if (!(other instanceof PathImpl)) {
            return null;
        }
        if (other.isAbsolute()) {
            return (PathImpl)other;
        }
        PathImpl parent = this.getParent();
        if (parent == null) {
            return (PathImpl)other;
        }
        return new PathImpl(this.fileSystem, parent.path + ((PathImpl)other).path, new String[0]);
    }

    @Override
    public PathImpl resolveSibling(String other) {
        return this.resolveSibling(new PathImpl(this.fileSystem, other, new String[0]));
    }

    @Override
    public Path relativize(Path other) {
        if (!(other instanceof PathImpl)) {
            throw new IllegalArgumentException();
        }
        if (!this.isAbsolute() || !other.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        if (!this.isDirectory()) {
            throw new IllegalArgumentException();
        }
        if (other.startsWith(this)) {
            return new PathImpl(this.fileSystem, ((PathImpl)other).path.substring(this.path.length()), new String[0]);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public URI toUri() {
        try {
            PathImpl absolutePath = this.toAbsolutePath();
            String uriPath = absolutePath.toString();
            uriPath = uriPath.replace(" ", "%20");
            if (this.isWindows) {
                uriPath = uriPath.replace('\\', '/');
            }
            return new URI(this.fileSystem.provider().getScheme() + (this.isWindows ? ":/" : ":") + uriPath);
        }
        catch (URISyntaxException e) {
            throw new IOError(e);
        }
    }

    @Override
    public PathImpl toAbsolutePath() {
        Path root;
        if (this.isAbsolute()) {
            return this;
        }
        Iterable<Path> directories = this.fileSystem.getRootDirectories();
        Iterator<Path> iterator = directories.iterator();
        Path path = root = iterator.hasNext() ? iterator.next() : null;
        String rootPath = root == null ? (this.isWindows ? "C:\\" : "/") : ((PathImpl)root).path;
        return new PathImpl(this.fileSystem, rootPath, this.path);
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this.toAbsolutePath();
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Path> iterator() {
        int begin;
        ArrayList<PathImpl> paths = new ArrayList<PathImpl>(this.getNameCount());
        if (this.isWindows) {
            begin = this.isAbsolute() ? 3 : (this.path.startsWith("/") ? 1 : 0);
        } else {
            int n = begin = this.isAbsolute() ? 1 : 0;
        }
        while (begin < this.path.length()) {
            int end = this.path.indexOf(47, begin);
            if (end < 0) {
                paths.add(new PathImpl(this.fileSystem, this.path.substring(begin), new String[0]));
                break;
            }
            paths.add(new PathImpl(this.fileSystem, this.path.substring(begin, end), new String[0]));
            begin = end + 1;
        }
        return paths.iterator();
    }

    @Override
    public int compareTo(Path other) {
        if (!(other instanceof PathImpl)) {
            throw new ClassCastException();
        }
        PathImpl otherBufferPath = (PathImpl)other;
        if (!this.fileSystem.equals(otherBufferPath.fileSystem)) {
            throw new ClassCastException();
        }
        if (this.isWindows) {
            return this.path.toLowerCase().compareTo(((PathImpl)other).path.toLowerCase());
        }
        return this.path.compareTo(((PathImpl)other).path);
    }

    public boolean isDirectory() {
        return this.path.endsWith("/");
    }

    @Override
    public String toString() {
        return this.isWindows ? this.path.replace('/', '\\') : this.path;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PathImpl) {
            return this.compareTo((PathImpl)o) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.fileSystem.hashCode() * 31 + this.path.hashCode();
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public FileTime getLastModifiedTime() {
        return FileTime.from(this.lastModifiedTime, TimeUnit.MILLISECONDS);
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public FileTime getLastAccessTime() {
        return FileTime.from(this.lastAccessTime, TimeUnit.MILLISECONDS);
    }

    public FileTime getCreationTime() {
        return FileTime.from(this.creationTime, TimeUnit.MILLISECONDS);
    }
}

