/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.BaseCompareDifference;
import oracle.javatools.compare.algorithm.CompareModelExtension;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.util.deferred.Thunk;

public class BaseCompareModel
implements CompareModel {
    @CodeSharingSafe(value="StaticField")
    private static final List<Thunk<Class<? extends CompareModelExtension>>> _extensionClasses = new CopyOnWriteArrayList<Thunk<Class<? extends CompareModelExtension>>>();
    private CompareType _type = CompareType.TEXT;
    private final CompareContributor _firstContributor;
    private final CompareContributor _secondContributor;
    private final CompareContributor _ancestorContributor;
    private CompareDifference[] _differences;
    private Map<Class, Object> _extensionData = new HashMap<Class, Object>();

    public static final void registerModelExtension(Class<? extends CompareModelExtension> extensionClass) {
        BaseCompareModel.registerModelExtension(Thunk.directReference(extensionClass));
    }

    public static final void registerModelExtension(Thunk<Class<? extends CompareModelExtension>> extensionClass) {
        _extensionClasses.add(extensionClass);
    }

    public BaseCompareModel(BaseCompareModel scm, CompareDifference[] differences) {
        this(scm._firstContributor, scm._secondContributor, scm._ancestorContributor, differences);
        this._type = scm._type;
        this._extensionData = scm._extensionData;
    }

    public BaseCompareModel(CompareContributor first, CompareContributor second, CompareDifference[] differences) {
        this(first, second, null, differences);
    }

    public BaseCompareModel(CompareContributor first, CompareContributor second, CompareContributor ancestor, CompareDifference[] differences) {
        this._firstContributor = first;
        this._secondContributor = second;
        this._ancestorContributor = ancestor;
        this._differences = differences;
    }

    public BaseCompareModel createInstance(CompareDifference[] differences) {
        return new BaseCompareModel(this, differences);
    }

    @Override
    public void setType(CompareType type) {
        this._type = type;
    }

    @Override
    public CompareType getType() {
        return this._type;
    }

    @Override
    public CompareContributor getContributor(ContributorKind contrib) {
        if (contrib == ContributorKind.FIRST) {
            return this._firstContributor;
        }
        if (contrib == ContributorKind.SECOND) {
            return this._secondContributor;
        }
        if (contrib == ContributorKind.ANCESTOR) {
            return this._ancestorContributor;
        }
        throw new IllegalArgumentException("Unknown contributor kind: " + contrib);
    }

    @Override
    public CompareDifference[] getDifferences() {
        return this._differences;
    }

    @Override
    public int getDifferenceCount() {
        return this._differences.length;
    }

    @Override
    public int getConflictCount() {
        int n = 0;
        for (CompareDifference difference : this.getDifferences()) {
            if (!difference.isConflict()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getResolvedCount() {
        int n = 0;
        for (CompareDifference difference : this.getDifferences()) {
            if (!difference.isResolved()) continue;
            ++n;
        }
        return n;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this._differences.length; ++i) {
            str.append("CB");
            str.append(String.valueOf(i));
            str.append(": ");
            str.append(this._differences[i].toString());
            str.append("\n");
        }
        return str.toString();
    }

    @Override
    public int[] getDifferenceTypeCounts() {
        int[] count = new int[3];
        for (int i = 0; i < this.getDifferences().length; ++i) {
            BaseCompareDifference db = (BaseCompareDifference)this.getDifferences()[i];
            if (db.isAddition(ContributorKind.FIRST, ContributorKind.SECOND)) {
                count[0] = count[0] + 1;
            }
            if (db.isRemoval(ContributorKind.FIRST, ContributorKind.SECOND)) {
                count[1] = count[1] + 1;
            }
            if (!db.isChange(ContributorKind.FIRST, ContributorKind.SECOND)) continue;
            count[2] = count[2] + 1;
        }
        return count;
    }

    public void extend() {
        try {
            for (Thunk<Class<? extends CompareModelExtension>> extensionClass : _extensionClasses) {
                if (extensionClass == null) continue;
                CompareModelExtension extension = extensionClass.get().newInstance();
                extension.extend(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setExtensionData(Class keyClass, Object data) {
        this._extensionData.put(keyClass, data);
    }

    public Object getExtensionData(Class keyClass) {
        return this._extensionData.get(keyClass);
    }
}

