/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;

public class HttpURLFileSystemHelper
extends URLFileSystemHelper {
    private static final boolean USE_GET_FOR_LAST_MODIFIED = "GET".equals(System.getProperty("oracle.ide.net.http.lastmodified.method"));
    private static final int CONNECTION_TIMEOUT = HttpURLFileSystemHelper.getConnectionTimeoutFromProperty();
    private static Map<String, Set<String>> _unreachableHosts = new HashMap<String, Set<String>>();
    private String _requestMethod;
    private String _quickMethod;
    private static final int DEFAULT_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;

    private static int getConnectionTimeoutFromProperty() {
        Integer timeout = Integer.getInteger("oracle.ide.net.http.connection.timeout");
        return timeout == null || timeout < 0 ? 10000 : timeout;
    }

    public static int getConnectionTimeout() {
        return CONNECTION_TIMEOUT;
    }

    public HttpURLFileSystemHelper() {
        this("GET", USE_GET_FOR_LAST_MODIFIED ? "GET" : "HEAD");
    }

    protected HttpURLFileSystemHelper(String requestMethod, String quickMethod) {
        this._requestMethod = requestMethod;
        this._quickMethod = quickMethod;
    }

    @Override
    public String getSystemDisplayName(URL url) {
        if (URLFileSystem.isRoot(url)) {
            return URLFileSystem.getPlatformPathName(url);
        }
        return URLFileSystem.getFileName(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLength(URL url) {
        long l;
        if (HttpURLFileSystemHelper.isUnreachable(url)) {
            return -1L;
        }
        final URLConnection urlConnection = this.openConnection(url);
        try {
            l = this.trapInitialConnectionFailure(url, new IOCallable<Long>(){

                @Override
                public Long call() throws IOException {
                    return urlConnection.getContentLength();
                }
            });
        }
        catch (Throwable throwable) {
            try {
                try {
                    urlConnection.getInputStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (Exception e) {
                return -1L;
            }
        }
        try {
            urlConnection.getInputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lastModified(URL url) {
        long l;
        if (HttpURLFileSystemHelper.isUnreachable(url)) {
            return -1L;
        }
        final URLConnection urlConnection = this.openConnection(url);
        try {
            if (urlConnection instanceof HttpURLConnection) {
                HttpURLConnection httpCon = (HttpURLConnection)urlConnection;
                httpCon.setRequestMethod(this._quickMethod);
            }
            l = this.trapInitialConnectionFailure(url, new IOCallable<Long>(){

                @Override
                public Long call() throws IOException {
                    return urlConnection.getLastModified();
                }
            });
        }
        catch (Throwable throwable) {
            try {
                try {
                    urlConnection.getInputStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (Exception e) {
                return -1L;
            }
        }
        try {
            urlConnection.getInputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(URL url) {
        boolean result = false;
        if (!HttpURLFileSystemHelper.isUnreachable(url)) {
            InputStream in = null;
            URLConnection connection = null;
            try {
                connection = this.openConnection(url);
                if (connection instanceof HttpURLConnection) {
                    final HttpURLConnection httpCon = (HttpURLConnection)connection;
                    in = this.trapInitialConnectionFailure(url, new IOCallable<InputStream>(){

                        @Override
                        public InputStream call() throws IOException {
                            return httpCon.getInputStream();
                        }
                    });
                    int code = httpCon.getResponseCode();
                    result = code >= 100 & code < 400;
                    if (code == 200) {
                        String resolvedFile;
                        String requestedFile = URLFileSystem.getFileName(url);
                        result = requestedFile.equals(resolvedFile = URLFileSystem.getFileName(httpCon.getURL()));
                    }
                }
            }
            catch (IOException ex) {
                ex.toString();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    private <T> T trapInitialConnectionFailure(URL url, IOCallable<T> closure) throws IOException {
        long startTime = System.nanoTime();
        try {
            return closure.call();
        }
        catch (NoRouteToHostException nrex) {
            HttpURLFileSystemHelper.markUnreachable(url);
            throw nrex;
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (SocketTimeoutException ste) {
            HttpURLFileSystemHelper.markUnreachable(url);
            throw ste;
        }
        catch (IOException ioe) {
            String message = ioe.getMessage();
            if (message != null && (message.contains(" 502 ") || message.contains(" 504 ") || message.contains(" 599 ")) && startTime + (long)(CONNECTION_TIMEOUT * 1000000) < System.nanoTime()) {
                HttpURLFileSystemHelper.markUnreachable(url);
            }
            throw ioe;
        }
    }

    @Override
    public boolean canCreate(URL url) {
        boolean result = false;
        if (!HttpURLFileSystemHelper.isUnreachable(url)) {
            while (url != null) {
                if (this.exists(url)) {
                    result = this.canWrite(url);
                    break;
                }
                url = this.getParent(url);
            }
        }
        return result;
    }

    @Override
    public URL getParent(URL url) {
        URL parent = super.getParent(url);
        if (parent != null && parent.equals(url)) {
            parent = null;
        }
        return parent;
    }

    @Override
    public InputStream openInputStream(URL url) throws IOException {
        if (!HttpURLFileSystemHelper.isUnreachable(url)) {
            final URLConnection connection = this.openConnection(url);
            return this.trapInitialConnectionFailure(url, new IOCallable<InputStream>(){

                @Override
                public InputStream call() throws IOException {
                    return connection.getInputStream();
                }
            });
        }
        throw new IOException();
    }

    protected URLConnection openConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(CONNECTION_TIMEOUT);
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).setRequestMethod(this._requestMethod);
        }
        return connection;
    }

    private static synchronized Set<String> getUnreachableHosts(URL url) {
        String proxyString = HttpURLFileSystemHelper.getProxyString(url);
        Set<String> matchedProxyList = _unreachableHosts.get(proxyString);
        if (matchedProxyList == null) {
            matchedProxyList = new HashSet<String>();
            _unreachableHosts.put(proxyString, matchedProxyList);
        }
        return matchedProxyList;
    }

    public static synchronized boolean isUnreachable(URL url) {
        boolean result = HttpURLFileSystemHelper.getUnreachableHosts(url).contains(url.getHost());
        return result;
    }

    private static String getProxyString(URL url) {
        URI uri;
        try {
            uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort() == -1 ? ("https".equals(url.getProtocol()) ? 443 : 80) : url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        if (uri == null) {
            return "[InvalidURL]";
        }
        List<Proxy> proxies = ProxySelector.getDefault().select(uri);
        String proxyString = "[NONE]";
        if (proxies.size() > 0) {
            proxyString = proxies.toString();
        }
        return proxyString;
    }

    public static synchronized void markUnreachable(URL url) {
        HttpURLFileSystemHelper.getUnreachableHosts(url).add(url.getHost());
    }

    @Override
    protected int getPort(URL url) {
        int port = super.getPort(url);
        return port == -1 ? ("https".equals(url.getProtocol()) ? 443 : 80) : port;
    }

    static interface IOCallable<T>
    extends Callable<T> {
        @Override
        public T call() throws IOException;
    }
}

