/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ColorChooserDialog
extends JDialog {
    public static final String KEY_ESCAPE = "ESCAPE";
    private JColorChooser colorChooser = new JColorChooser();
    private Color result = null;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorChooserDialog.this.dispose();
        }
    };

    public ColorChooserDialog(Dialog owner, String Title, Color color) {
        super(owner);
        this.setTitle(Title);
        this.setDefaultCloseOperation(2);
        JPanel pnButtons = new JPanel();
        JButton bnOK = new JButton(new OKAction(Messages.getString("ColorChooserDialog.OK")));
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(new CancelAction(Messages.getString("ColorChooserDialog.Cancel")));
        bnCancel.setMnemonic(67);
        pnButtons.add(bnOK);
        pnButtons.add(bnCancel);
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.colorChooser.setColor(color);
        this.getContentPane().add((Component)this.colorChooser, "Center");
        this.getContentPane().add((Component)pnButtons, "South");
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        this.setResizable(false);
        this.setModal(true);
        CommonUtil.centerOnScreen(this);
    }

    public Color showDialog() {
        this.setVisible(true);
        return this.result;
    }

    private class OKAction
    extends AbstractAction {
        public OKAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorChooserDialog.this.result = ColorChooserDialog.this.colorChooser.getColor();
            ColorChooserDialog.this.dispose();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorChooserDialog.this.dispose();
        }
    }
}

